<?php
session_start();
include('menu.php');
require_once ("config/db.php");
require_once ("config/conexion.php");

// Verificación de sesión
if (!isset($_SESSION['user_login_status']) AND $_SESSION['user_login_status'] != 1) {
    header("location: login.php");
    exit;
}

// Validar Permisos de quien entra a esta pantalla (Permiso Laboral [P:21] o Accesos [P:22])
$sql_permisos = "select * from users where user_id='".$_SESSION['user_id']."'";
$rw_permisos = mysqli_query($con, $sql_permisos);
$rs_permisos = mysqli_fetch_array($rw_permisos);
$modulo_permisos = $rs_permisos["accesos"];
$a_permisos = explode(".", $modulo_permisos); 

if($a_permisos[22]==0){ // Permiso de Accesos [P:22]
    header("location:error.php");    
    exit;
}

// Datos de Sucursales
$sql_sucursal = "select * from sucursal ORDER BY tienda DESC ";
$rw_sucursal = mysqli_query($con, $sql_sucursal);
$rs_sucursal = mysqli_fetch_array($rw_sucursal);
$tienda_max = $rs_sucursal["tienda"];

// --- CARGAR NOMBRES REALES DE LAS TIENDAS ---
$nombres_tiendas = array();
$sql_names = mysqli_query($con, "SELECT tienda, nombre, nombre_stand FROM sucursal");
while ($row_n = mysqli_fetch_array($sql_names)) {
    $nombre_mostrar = !empty($row_n['nombre_stand']) ? $row_n['nombre_stand'] : $row_n['nombre'];
    $nombres_tiendas[$row_n['tienda']] = $nombre_mostrar;
}

$usuario = isset($_REQUEST['usuario']) ? $_REQUEST['usuario'] : '';
$mensaje = isset($_REQUEST['mensaje']) ? $_REQUEST['mensaje'] : '';

// Helper para marcar checkboxes
function checked($valor){ 
    return ($valor==1) ? "checked" : "";
} 
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Gestionar Accesos | SoundCrow</title>
    <link rel="icon" href="logo.ico">
    <link href="css/bootstrap.min.css" rel="stylesheet">
    <link href="fonts/css/font-awesome.min.css" rel="stylesheet">
    <link href="css/custom.min.css" rel="stylesheet">
    <link href="css/select/select2.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">

    <style>
        body { font-family: 'Poppins', sans-serif !important; background-color: #F0F2F5; color: #334155; }
        .sc-card { background: #ffffff; border-radius: 12px; box-shadow: 0 4px 20px rgba(0,0,0,0.05); border: none; overflow: hidden; margin-bottom: 25px; }
        .sc-header { background: linear-gradient(90deg, #0a2463 0%, #2473f2 100%); padding: 15px 25px; color: white; display: flex; align-items: center; justify-content: space-between; }
        .sc-title { margin: 0; font-size: 16px; font-weight: 700; text-transform: uppercase; }
        .sc-body { padding: 20px; }
        .sc-switch { position: relative; display: inline-block; width: 40px; height: 22px; vertical-align: middle; margin-right: 10px; }
        .sc-switch input { opacity: 0; width: 0; height: 0; }
        .slider { position: absolute; cursor: pointer; top: 0; left: 0; right: 0; bottom: 0; background-color: #cbd5e1; transition: .4s; border-radius: 34px; }
        .slider:before { position: absolute; content: ""; height: 16px; width: 16px; left: 3px; bottom: 3px; background-color: white; transition: .4s; border-radius: 50%; }
        input:checked + .slider { background-color: #10b981; }
        input:checked + .slider:before { transform: translateX(18px); }
        .permission-item { display: flex; align-items: center; margin-bottom: 8px; font-size: 13px; color: #475569; padding: 5px 0; border-bottom: 1px dashed #f1f5f9; }
        .permission-item:last-child { border-bottom: none; }
        .group-title { font-size: 14px; font-weight: 700; color: #0a2463; border-bottom: 2px solid #e2e8f0; padding-bottom: 8px; margin-bottom: 12px; text-transform: uppercase; letter-spacing: 0.5px; }
        .btn-search { background: #2473f2; color: white; border-radius: 30px; padding: 8px 25px; border:none; font-weight: 600; }
        .btn-save { background: #10b981; color: white; border-radius: 30px; padding: 12px 50px; border:none; font-weight: 700; font-size: 16px; box-shadow: 0 4px 10px rgba(16, 185, 129, 0.3); }
        .btn-save:hover { background: #059669; transform: translateY(-2px); }
        .select2-container .select2-selection--single { height: 40px !important; border: 1px solid #e2e8f0; border-radius: 8px; }
        .select2-container--default .select2-selection--single .select2-selection__rendered { line-height: 40px; }
        .select2-container--default .select2-selection--single .select2-selection__arrow { height: 40px; }
        .permiso-badge { font-size: 9px; color: #6366f1; font-weight: 800; background: rgba(99, 102, 241, 0.1); padding: 1px 4px; border-radius: 4px; margin-left: auto; border: 1px solid rgba(99, 102, 241, 0.2); }
    </style>
</head>

<body class="nav-md">
    <div class="container body">
        <div class="main_container">
            <div class="col-md-3 left_col">
                <div class="left_col scroll-view">
                    <div class="clearfix"></div>
                    <?php menu2(); menu1(); ?>
                </div>
            </div>

            <?php menu3(); ?>

            <div class="right_col" role="main">
                <div class="row">
                    <div class="col-md-12">
                        <div class="sc-card">
                            <div class="sc-header">
                                <h3 class="sc-title"><i class="fa fa-users"></i> Selección de Usuario</h3>
                            </div>
                            <div class="sc-body">
                                <form id="demo-form2" class="form-horizontal form-label-left" method="GET" action="acceso.php">
                                    <div class="row">
                                        <div class="col-md-8 col-sm-8 col-xs-12">
                                            <select class="select2_single form-control" tabindex="-1" id="usuario" name="usuario" required="required">
                                                <option value="">-- Selecciona Usuario --</option>
                                                <?php
                                                if($usuario<>""){ echo "<option selected value='$usuario'>$usuario</option>"; }
                                                $sql2="select * from users ORDER BY nombres ASC";
                                                $rs1=mysqli_query($con,$sql2);
                                                while($row3=mysqli_fetch_array($rs1)){
                                                    if($row3['nombres'] != $usuario){
                                                        echo "<option value='".$row3['nombres']."'>".$row3['nombres']."</option>";
                                                    }
                                                }
                                                ?>
                                            </select>
                                        </div>
                                        <div class="col-md-4 col-sm-4 col-xs-12">
                                            <button type="submit" class="btn btn-search btn-block">
                                                <i class="fa fa-search"></i> Cargar Permisos
                                            </button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>

                <?php if($usuario<>"") { 
                    $sql_user="select * from users WHERE nombres='$usuario'";
                    $rs_user=mysqli_query($con,$sql_user);
                    while($row_u=mysqli_fetch_array($rs_user)){
                        $accesos_u=$row_u["accesos"];
                        $a=explode(".",$accesos_u);
                    }
                ?>
                
                <form action="accesos1.php" method="POST" name="f1">
                    <input type="hidden" name="nombres" value="<?php echo $usuario;?>">
                    <input type="hidden" name="tienda" value="<?php echo $tienda_max;?>">

                    <?php if($mensaje<>""){ ?>
                    <div class="alert alert-success alert-dismissible" role="alert" style="border-radius:8px;">
                        <button type="button" class="close" data-dismiss="alert">&times;</button>
                        <strong><i class="fa fa-check-circle"></i></strong> <?php echo $mensaje;?>
                    </div>
                    <?php } ?>

                    <div class="row" style="margin-bottom: 20px;">
                        <div class="col-md-12 text-right">
                            <button type="button" onclick="seleccionar_todo()" class="btn btn-default btn-sm" style="border-radius:20px; font-weight:600;">Marcar Todo</button>
                            <button type="button" onclick="deseleccionar_todo()" class="btn btn-default btn-sm" style="border-radius:20px; font-weight:600;">Desmarcar Todo</button>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-4 col-sm-6 col-xs-12">
                            <div class="sc-card">
                                <div class="sc-body">
                                    <div class="group-title"><i class="fa fa-desktop"></i> Inicio & Sistema</div>
                                    <div class="permission-item"><label class="sc-switch"><input type="checkbox" name="a2" value="1" <?php echo checked($a[1]);?>><span class="slider"></span></label><span>Inicio <span class="permiso-badge">P:1</span></span></div>
                                    <div class="permission-item"><label class="sc-switch"><input type="checkbox" name="a24" value="1" <?php echo checked($a[23]);?>><span class="slider"></span></label><span>Empresa <span class="permiso-badge">P:23</span></span></div>
                                    <div class="permission-item"><label class="sc-switch"><input type="checkbox" name="a25" value="1" <?php echo checked($a[24]);?>><span class="slider"></span></label><span>Sucursales <span class="permiso-badge">P:24</span></span></div>
                                    <div class="permission-item"><label class="sc-switch"><input type="checkbox" name="a26" value="1" <?php echo checked($a[25]);?>><span class="slider"></span></label><span>Comprobantes <span class="permiso-badge">P:25</span></span></div>
                                    <div class="permission-item"><label class="sc-switch"><input type="checkbox" name="a27" value="1" <?php echo checked($a[26]);?>><span class="slider"></span></label><span>Configuración <span class="permiso-badge">P:26</span></span></div>
                                </div>
                            </div>

                            <div class="sc-card">
    <div class="sc-body">
        <div class="group-title"><i class="fa fa-building-o"></i> Acceso Sucursales</div>
        <?php
        // Consultamos todas las sucursales reales de la base de datos
        $sql_sucursales = mysqli_query($con, "SELECT tienda, nombre, nombre_stand FROM sucursal ORDER BY tienda ASC");
        while ($r_suc = mysqli_fetch_array($sql_sucursales)) {
            $id_tienda = $r_suc['tienda'];
            $nombre_tienda = (!empty($r_suc['nombre_stand'])) ? $r_suc['nombre_stand'] : $r_suc['nombre'];
            
            // Calculamos el índice exacto (Offset 43 para que tienda 1 sea a44)
            $idx = 43 + $id_tienda; 
        ?>
        <div class="permission-item">
            <label class="sc-switch">
                <input type="checkbox" name="a<?php echo $idx; ?>" value="1" <?php echo checked($a[$idx-1]); ?>>
                <span class="slider"></span>
            </label>
            <span style="font-weight: 500; color: #0a2463;"><?php echo $nombre_tienda; ?></span>
        </div>
        <?php } ?>
    </div>
</div>
                        </div>

                        <div class="col-md-4 col-sm-6 col-xs-12">
                            <div class="sc-card">
                                <div class="sc-body">
                                    <div class="group-title"><i class="fa fa-cubes"></i> Almacén & Productos</div>
                                    <div class="permission-item"><label class="sc-switch"><input type="checkbox" name="a3" value="1" <?php echo checked($a[2]);?>><span class="slider"></span></label><span>Nuevo Producto <span class="permiso-badge">P:2</span></span></div>
                                    <div class="permission-item"><label class="sc-switch"><input type="checkbox" name="a4" value="1" <?php echo checked($a[3]);?>><span class="slider"></span></label><span>Lista Productos <span class="permiso-badge">P:3</span></span></div>
                                    <div class="permission-item"><label class="sc-switch"><input type="checkbox" name="a5" value="1" <?php echo checked($a[4]);?>><span class="slider"></span></label><span>Categorías <span class="permiso-badge">P:4</span></span></div>
                                    <div class="permission-item"><label class="sc-switch"><input type="checkbox" name="a6" value="1" <?php echo checked($a[5]);?>><span class="slider"></span></label><span>Consulta Prod. <span class="permiso-badge">P:5</span></span></div>
                                    <div class="permission-item"><label class="sc-switch"><input type="checkbox" name="a7" value="1" <?php echo checked($a[6]);?>><span class="slider"></span></label><span>Kardex Stock <span class="permiso-badge">P:6</span></span></div>
                                    <div class="permission-item"><label class="sc-switch"><input type="checkbox" name="a28" value="1" <?php echo checked($a[27]);?>><span class="slider"></span></label><span>Historial de Caja <span class="permiso-badge">P:27</span></span></div>
                                </div>
                            </div>

                            <div class="sc-card">
                                <div class="sc-body">
                                    <div class="group-title"><i class="fa fa-exchange"></i> Movimientos</div>
                                    <div class="permission-item"><label class="sc-switch"><input type="checkbox" name="a16" value="1" <?php echo checked($a[15]);?>><span class="slider"></span></label><span>Traslados <span class="permiso-badge">P:15</span></span></div>
                                    <div class="permission-item"><label class="sc-switch"><input type="checkbox" name="a17" value="1" <?php echo checked($a[16]);?>><span class="slider"></span></label><span>Lista Traslados <span class="permiso-badge">P:16</span></span></div>
                                    <div class="permission-item"><label class="sc-switch"><input type="checkbox" name="a18" value="1" <?php echo checked($a[17]);?>><span class="slider"></span></label><span>Entradas <span class="permiso-badge">P:17</span></span></div>
                                    <div class="permission-item"><label class="sc-switch"><input type="checkbox" name="a19" value="1" <?php echo checked($a[18]);?>><span class="slider"></span></label><span>Lista Entradas <span class="permiso-badge">P:18</span></span></div>
                                </div>
                            </div>

                            <div class="sc-card">
                                <div class="sc-body">
                                    <div class="group-title"><i class="fa fa-users"></i> Contactos & Laboral</div>
                                    <div class="permission-item"><label class="sc-switch"><input type="checkbox" name="a20" value="1" <?php echo checked($a[19]);?>><span class="slider"></span></label><span>Clientes <span class="permiso-badge">P:19</span></span></div>
                                    <div class="permission-item"><label class="sc-switch"><input type="checkbox" name="a21" value="1" <?php echo checked($a[20]);?>><span class="slider"></span></label><span>Proveedores <span class="permiso-badge">P:20</span></span></div>
                                    <div class="permission-item"><label class="sc-switch"><input type="checkbox" name="a22" value="1" <?php echo checked($a[21]);?>><span class="slider"></span></label><span>Trabajadores <span class="permiso-badge">P:21</span></span></div>
                                    <div class="permission-item"><label class="sc-switch"><input type="checkbox" name="a23" value="1" <?php echo checked($a[22]);?>><span class="slider"></span></label><span>Accesos <span class="permiso-badge">P:22</span></span></div>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-4 col-sm-6 col-xs-12">
                            <div class="sc-card">
                                <div class="sc-body">
                                    <div class="group-title"><i class="fa fa-shopping-cart"></i> Ventas & Facturación</div>
                                    <div class="permission-item"><label class="sc-switch"><input type="checkbox" name="a8" value="1" <?php echo checked($a[7]);?>><span class="slider"></span></label><span>Factura Electrónica <span class="permiso-badge">P:7</span></span></div>
                                    <div class="permission-item"><label class="sc-switch"><input type="checkbox" name="a9" value="1" <?php echo checked($a[8]);?>><span class="slider"></span></label><span>Lista Notas/Bol <span class="permiso-badge">P:8</span></span></div>
                                    <div class="permission-item"><label class="sc-switch"><input type="checkbox" name="a10" value="1" <?php echo checked($a[9]);?>><span class="slider"></span></label><span>Notas de Venta <span class="permiso-badge">P:9</span></span></div>
                                    <div class="permission-item"><label class="sc-switch"><input type="checkbox" name="a11" value="1" <?php echo checked($a[10]);?>><span class="slider"></span></label><span>Cotizaciones <span class="permiso-badge">P:10</span></span></div>
                                </div>
                            </div>

                            <div class="sc-card">
                                <div class="sc-body">
                                    <div class="group-title"><i class="fa fa-truck"></i> Compras & Gastos</div>
                                    <div class="permission-item"><label class="sc-switch"><input type="checkbox" name="a12" value="1" <?php echo checked($a[11]);?>><span class="slider"></span></label><span>Nueva Compra <span class="permiso-badge">P:11</span></span></div>
                                    <div class="permission-item"><label class="sc-switch"><input type="checkbox" name="a13" value="1" <?php echo checked($a[12]);?>><span class="slider"></span></label><span>Registrar Gastos <span class="permiso-badge">P:12</span></span></div>
                                    <div class="permission-item"><label class="sc-switch"><input type="checkbox" name="a14" value="1" <?php echo checked($a[13]);?>><span class="slider"></span></label><span>Lista Compras <span class="permiso-badge">P:13</span></span></div>
                                    <div class="permission-item"><label class="sc-switch"><input type="checkbox" name="a15" value="1" <?php echo checked($a[14]);?>><span class="slider"></span></label><span>Lista Pagos <span class="permiso-badge">P:14</span></span></div>
                                </div>
                            </div>

                            <div class="sc-card">
                                <div class="sc-body">
                                    <div class="group-title"><i class="fa fa-calculator"></i> Contabilidad & Reportes</div>
                                    <div class="permission-item"><label class="sc-switch"><input type="checkbox" name="a29" value="1" <?php echo checked($a[28]);?>><span class="slider"></span></label><span>Pago de trabajador<span class="permiso-badge">P:28</span></span></div>
                                    <div class="permission-item"><label class="sc-switch"><input type="checkbox" name="a30" value="1" <?php echo checked($a[29]);?>><span class="slider"></span></label><span>Reporte mensual<span class="permiso-badge">P:29</span></span></div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row" style="margin-top: 20px; margin-bottom: 50px;">
                        <div class="col-md-12 text-center">
                            <button type="submit" class="btn btn-save">
                                <i class="fa fa-save"></i> Guardar Cambios de Acceso
                            </button>
                        </div>
                    </div>

                </form>
                <?php } ?>

            </div>
            <?php footer(); ?>
        </div>
    </div>

    <script src="js/jquery.min.js"></script>
    <script src="js/bootstrap.min.js"></script>
    <script src="js/custom.js"></script>
    <script src="js/select/select2.full.js"></script>
    <script src="js/nicescroll/jquery.nicescroll.min.js"></script>

    <script>
        $(document).ready(function() {
            $(".select2_single").select2({
                placeholder: "Buscar usuario...",
                allowClear: true,
                width: '100%'
            });
            
            window.setTimeout(function() {
                $(".alert").fadeTo(500, 0).slideUp(500, function(){
                    $(this).remove(); 
                });
            }, 3000);
        });

        function seleccionar_todo(){ 
           $("input[type=checkbox]").prop('checked', true);
        } 
        function deseleccionar_todo(){ 
           $("input[type=checkbox]").prop('checked', false);
        }
    </script>
</body>
</html>