<?php
include('is_logged.php');
$session_id = session_id();
require_once("../config/db.php");
require_once("../config/conexion.php");

// 1. ELIMINAR ITEM
if (isset($_GET['id'])) {
    $id_tmp = intval($_GET['id']);
    $delete = mysqli_query($con, "DELETE FROM tmp WHERE id_tmp='" . $id_tmp . "'");
}

// 2. AGREGAR ITEM NUEVO
if (isset($_POST['id'])) {
    $id = intval($_POST['id']);
    $cantidad = floatval($_POST['cantidad']);
    $precio_venta = floatval($_POST['precio_venta']);
    $tienda = $_SESSION['tienda'];

    // Verificar si ya existe (Seguridad backend)
    $sql_check = mysqli_query($con, "SELECT id_tmp FROM tmp WHERE id_producto='$id' AND session_id='$session_id'");
    
    if (mysqli_num_rows($sql_check) > 0) {
        // Ya existe, el JS se encarga de avisar, pero aquí evitamos duplicados en BD
    } else {
        // Verificar límite de 40
        $sql_count = mysqli_query($con, "SELECT count(*) as total FROM tmp WHERE session_id='$session_id'");
        $rw_count = mysqli_fetch_array($sql_count);
        if ($rw_count['total'] < 40) {
            $insert_tmp = mysqli_query($con, "INSERT INTO tmp (id_producto,cantidad_tmp,precio_tmp,session_id,tienda) VALUES ('$id','$cantidad','$precio_venta','$session_id','1000')");
        }
    }
}

// 3. ACTUALIZAR CANTIDAD (Desde la tabla)
if (isset($_POST['id_tmp']) && isset($_POST['cantidad_update'])) {
    $id_tmp_up = intval($_POST['id_tmp']);
    $cant_up = floatval($_POST['cantidad_update']);
    $update = mysqli_query($con, "UPDATE tmp SET cantidad_tmp='$cant_up' WHERE id_tmp='$id_tmp_up'");
}

// 4. ACTUALIZAR PRECIO (Desde la tabla)
if (isset($_POST['id_tmp']) && isset($_POST['precio_update'])) {
    $id_tmp_up = intval($_POST['id_tmp']);
    $precio_up = floatval($_POST['precio_update']);
    $update = mysqli_query($con, "UPDATE tmp SET precio_tmp='$precio_up' WHERE id_tmp='$id_tmp_up'");
}

// =======================================================================
// 5. DIBUJAR LA TABLA DE RESULTADOS
// =======================================================================
?>
<div class="table-responsive">
    <table class="table table-hover" style="background: white; border: 1px solid #e2e8f0; border-radius: 8px; overflow: hidden;">
        <thead style="background:#0f172a; color:white;">
            <tr style="font-size: 11px; text-transform: uppercase;">
                <th class='text-center' style="width: 10%;">CÓDIGO</th>
                <th class='text-center' style="width: 10%;">CANT.</th>
                <th style="width: 40%;">DESCRIPCIÓN</th>
                <th class='text-center' style="width: 10%;">MEDIDA</th>
                <th class='text-right' style="width: 15%;">PRECIO UNIT.</th>
                <th class='text-right' style="width: 15%;">TOTAL</th>
                <th class='text-center' style="width: 5%;"></th>
            </tr>
        </thead>
        <tbody>
        <?php
        $sumador_total = 0;
        $sql = mysqli_query($con, "select * from products, tmp where products.id_producto=tmp.id_producto and tmp.session_id='" . $session_id . "'");
        $item_count = 0;
        
        while ($row = mysqli_fetch_array($sql)) {
            $id_tmp = $row["id_tmp"];
            $id_producto = $row["id_producto"];
            $codigo_producto = $row['codigo_producto'];
            $cantidad = $row['cantidad_tmp'];
            $nombre_producto = $row['nombre_producto'];
            $medida = $row['und_pro']; 
            $precio_venta = $row['precio_tmp'];
            
            // Cálculos
            $precio_venta_f = number_format($precio_venta, 2, '.', '');
            $precio_total = $precio_venta * $cantidad;
            $precio_total_f = number_format($precio_total, 2);
            $sumador_total += $precio_total;
            $item_count++;
            ?>
            <tr style="border-bottom: 1px solid #f1f5f9;">
                <td class='text-center text-muted' style="vertical-align: middle; font-size:11px;"><?php echo $codigo_producto; ?></td>
                
                <td class='text-center' style="vertical-align: middle;">
                    <input type="number" class="form-control input-sm text-center" style="border-radius: 5px; border:1px solid #cbd5e1; font-weight:bold;" value="<?php echo $cantidad; ?>" onchange="actualizar_cantidad('<?php echo $id_tmp; ?>', this.value)" min="1">
                </td>
                
                <td style="vertical-align: middle; font-weight: 600; color: #334155;">
                    <?php echo $nombre_producto; ?>
                    <input type="hidden" class="id_producto_lista" value="<?php echo $id_producto; ?>">
                </td>
                
                <td class='text-center' style="vertical-align: middle; font-size:11px;">
                    <span class="label label-default"><?php echo strtoupper($medida); ?></span>
                </td>
                
                <td class='text-right' style="vertical-align: middle;">
                    <div class="input-group input-group-sm">
                        <span class="input-group-addon" style="border:none; background:transparent; padding:2px;">S/.</span>
                        <input type="text" class="form-control text-right" style="border-radius: 5px; border:1px solid #cbd5e1;" value="<?php echo $precio_venta_f; ?>" onchange="actualizar_precio('<?php echo $id_tmp; ?>', this.value)">
                    </div>
                </td>
                
                <td class='text-right' style="vertical-align: middle; font-weight: 800; color: #2563eb;">
                    S/. <?php echo $precio_total_f; ?>
                </td>
                
                <td class='text-center' style="vertical-align: middle;">
                    <a href="#" class='btn btn-danger btn-xs' onclick="eliminar('<?php echo $id_tmp; ?>'); return false;" title="Quitar item" style="border-radius: 50%; width: 26px; height: 26px; padding: 0; line-height: 24px;">
                        <i class="fa fa-trash"></i>
                    </a>
                </td>
            </tr>
        <?php
        }
        
        // TOTALES
        $subtotal = number_format($sumador_total / 1.18, 2, '.', '');
        $total_iva = number_format($sumador_total / 1.18 * 0.18, 2, '.', '');
        $total_factura = number_format($sumador_total, 2, '.', '');
        ?>
        
        <input type="hidden" id="total_items_temporal" value="<?php echo $nums-1; ?>">

        <tr>
            <td colspan=5 class="text-right" style="padding-top:15px; font-weight:bold; color:#64748b;">OP. GRAVADA S/.</td>
            <td class="text-right" style="padding-top:15px; font-weight:bold;"><?php echo number_format($subtotal, 2); ?></td>
            <td></td>
        </tr>
        <tr>
            <td colspan=5 class="text-right" style="font-weight:bold; color:#64748b;">IGV (18%) S/.</td>
            <td class="text-right" style="font-weight:bold;"><?php echo number_format($total_iva, 2); ?></td>
            <td></td>
        </tr>
        <tr style="background: #f0fdf4;">
            <td colspan=5 class="text-right" style="font-weight:800; color:#166534; font-size:15px; border-top: 2px solid #16a34a;">TOTAL A PAGAR S/.</td>
            <td class="text-right" style="font-weight:800; color:#166534; font-size:15px; border-top: 2px solid #16a34a;"><?php echo number_format($total_factura, 2); ?></td>
            <td></td>
        </tr>
        </tbody>
    </table>
</div>