<?php
include('is_logged.php');
require_once ("../config/db.php");
require_once ("../config/conexion.php");

$id_factura = intval($_GET['id_factura']);

// 1. CAPTURAR EL MOTIVO
$obs_texto = "";
if (isset($_GET['motivo'])) {
    $obs_texto = mysqli_real_escape_string($con, (strip_tags($_GET['motivo'], ENT_QUOTES)));
}

// 2. OBTENER DATOS DE LA NOTA (Añadimos la lectura de la 'tienda')
$sql_fact = mysqli_query($con, "SELECT numero_factura, folio, estado_factura, tienda FROM facturas WHERE id_factura='$id_factura'");
$rw = mysqli_fetch_array($sql_fact);

if (!$rw) {
    die("<div class='alert alert-danger'>Error: No se encontró la nota.</div>");
}

$numero = $rw['numero_factura'];
$folio = $rw['folio'];
$estado_actual = $rw['estado_factura'];
$tienda = intval($rw['tienda']); // Obtenemos el ID de la tienda (Ej: 1)

// 3. RETORNO DE STOCK
if ($estado_actual == 3) {
    
    // Generamos el nombre de la columna dinámicamente según tu base de datos (Ej: b1, b2, b3...)
    $columna_stock = "b" . $tienda; 

    // Buscar los ítems
    $sql_detalle = mysqli_query($con, "SELECT id_producto, cantidad FROM detalle_factura WHERE numero_factura='$numero' AND folio='$folio'");
    
    $items_leidos = mysqli_num_rows($sql_detalle);
    $productos_devueltos = 0;
    $errores_detectados = ""; 
    
    if ($items_leidos > 0) {
        while ($row = mysqli_fetch_array($sql_detalle)) {
            $id_p = $row['id_producto'];
            $cant = floatval($row['cantidad']);
            
            if (!empty($id_p) && $cant > 0) {
                // INTENTO DE ACTUALIZAR STOCK EN LA SUCURSAL CORRECTA
                $query_update = "UPDATE products SET $columna_stock = $columna_stock + $cant WHERE id_producto='$id_p'";
                $update_stock = mysqli_query($con, $query_update);
                
                if ($update_stock) {
                    if (mysqli_affected_rows($con) > 0) {
                        $productos_devueltos++;
                    } else {
                        $errores_detectados .= "[El ID $id_p no se encontró] ";
                    }
                } else {
                    $errores_detectados .= "[Error SQL: " . mysqli_error($con) . "] ";
                }
            }
        }
    }

    // 4. CAMBIAR ESTADO Y GUARDAR MOTIVO
    $update_factura = mysqli_query($con, "UPDATE facturas SET estado_factura=32, obs='".$obs_texto."' WHERE id_factura='$id_factura'");

    if ($update_factura) {
        if ($productos_devueltos > 0) {
            echo "<div class='alert alert-success' style='margin-top:10px;'><i class='fa fa-check'></i> Nota anulada. Se devolvió stock a la sucursal (<b>$columna_stock</b>) de <b>$productos_devueltos</b> producto(s).</div>";
        } else {
            echo "<div class='alert alert-warning' style='margin-top:10px;'><i class='fa fa-warning'></i> Nota anulada. Falló el stock. <b>Motivo Técnico:</b> $errores_detectados</div>";
        }
    } else {
        echo "<div class='alert alert-danger' style='margin-top:10px;'><i class='fa fa-warning'></i> Error BD Facturas: " . mysqli_error($con) . "</div>";
    }
    
} else {
    echo "<div class='alert alert-warning' style='margin-top:10px;'><i class='fa fa-info-circle'></i> Esta nota ya estaba anulada.</div>";
}
?>