<?php
    include('is_logged.php');
    require_once ("../config/db.php");
    require_once ("../config/conexion.php");

    $tienda1 = $_SESSION['tienda'];
    $action = (isset($_REQUEST['action']) && $_REQUEST['action'] != NULL) ? $_REQUEST['action'] : '';

    // --- 1. LÓGICA DE ACTIVAR / DESACTIVAR (TOGGLE) ---
    if (isset($_GET['id'])){
        $id_cliente = intval($_GET['id']);
        
        // Consultamos estado actual
        $sql_check = mysqli_query($con, "SELECT status_cliente FROM clientes WHERE id_cliente='$id_cliente'");
        if ($row_check = mysqli_fetch_array($sql_check)) {
            $estado_actual = $row_check['status_cliente'];
            
            // Invertimos el estado (1 -> 0, 0 -> 1)
            $new_status = ($estado_actual == 1) ? 0 : 1;
            $mensaje_accion = ($new_status == 1) ? "Activado" : "Desactivado";
            $tipo_alerta = ($new_status == 1) ? "success" : "warning";
            $icono_alerta = ($new_status == 1) ? "fa-check-circle" : "fa-ban";

            $sql_update = "UPDATE clientes SET status_cliente='$new_status' WHERE id_cliente='$id_cliente'";
            
            if (mysqli_query($con, $sql_update)){
                ?>
                <div class="alert alert-<?php echo $tipo_alerta; ?> alert-dismissible" role="alert" style="border-radius: 8px;">
                  <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                  <strong><i class="fa <?php echo $icono_alerta; ?>"></i> Éxito:</strong> Cliente <?php echo $mensaje_accion; ?> correctamente.
                </div>
                <?php
            } else {
                ?>
                <div class="alert alert-danger alert-dismissible" role="alert" style="border-radius: 8px;">
                  <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                  <strong>Error!</strong> No se pudo cambiar el estado.
                </div>
                <?php
            }
        }
    }

    // --- 2. CONSULTA Y TABLA ---
    if($action == 'ajax'){
        $sTable = "clientes";
        $q = mysqli_real_escape_string($con,(strip_tags($_REQUEST['q'], ENT_QUOTES)));
        
        // Filtro solo para clientes (tipo1=1)
        $sWhere = "WHERE tipo1=1 ";
        if ( $_GET['q'] != "" ){
            $sWhere .= " AND (nombre_cliente LIKE '%$q%' OR documento LIKE '%$q%' OR telefono_cliente LIKE '%$q%')";
        }
        $sWhere .= " ORDER BY nombre_cliente ASC";

        include 'pagination.php'; 
        $page = (isset($_REQUEST['page']) && !empty($_REQUEST['page'])) ? $_REQUEST['page'] : 1;
        $per_page = 10; 
        $adjacents = 4; 
        $offset = ($page - 1) * $per_page;
        
        $count_query = mysqli_query($con, "SELECT count(*) AS numrows FROM $sTable $sWhere");
        $row_count = mysqli_fetch_array($count_query);
        $numrows = $row_count['numrows'];
        $total_pages = ceil($numrows/$per_page);
        $reload = './clientes.php';

        $sql = "SELECT * FROM $sTable $sWhere LIMIT $offset,$per_page";
        $query = mysqli_query($con, $sql);

        if ($numrows > 0){	
            ?>
            <style>
                /* BOTONES CIRCULARES (Igual que Proveedores) */
                .btn-circle {
                    width: 32px; height: 32px; padding: 0; border-radius: 50%;
                    text-align: center; font-size: 14px; line-height: 32px;
                    margin: 0 3px; border: none; color: white !important;
                    box-shadow: 0 2px 5px rgba(0,0,0,0.15); transition: all 0.2s ease;
                    display: inline-block;
                }
                .btn-circle:hover { transform: translateY(-2px); box-shadow: 0 4px 8px rgba(0,0,0,0.2); }
                
                .btn-orange { background: #F39C12; }
                .btn-red { background: #E74C3C; }    
                .btn-green { background: #27AE60; }  

                /* TABLA LIMPIA */
                .table-clean { width: 100%; border-collapse: separate; border-spacing: 0; }
                
                /* HEADER AZUL PETRÓLEO */
                .table-clean thead th {
                    background-color: #007B9E; 
                    color: white; padding: 12px 15px; border: none;
                    font-weight: 600; text-transform: uppercase; font-size: 12px;
                }
                
                /* FILAS */
                .table-clean tbody td {
                    border-bottom: 1px solid #E5E7EB; padding: 12px 15px;
                    color: #555; font-size: 13px; vertical-align: middle;
                }
                .table-clean tbody tr:hover { background-color: #F8FAFC; }
            </style>

            <div class="table-responsive" style="background: white; border-radius: 8px; overflow: hidden; box-shadow: 0 1px 3px rgba(0,0,0,0.1); margin-top: 10px;">
              <table class="table-clean">
                <thead>
                    <tr>
                        <th style="width:35%;">Razón Social / Nombre</th>
                        <th style="width:15%;">Documento</th>
                        <th style="width:10%;">Tipo</th>
                        <th style="width:15%;">Teléfono</th>
                        <th style="width:10%; text-align: center;">Estado</th>
                        <th style="width:15%; text-align: center;">Acciones</th>
                    </tr>
                </thead>
                <tbody>
                <?php
                while ($row = mysqli_fetch_array($query)){
                        $id_cliente = $row['id_cliente'];
                        $nombre_cliente = $row['nombre_cliente'];
                        $telefono_cliente = $row['telefono_cliente'];
                        $email_cliente = $row['email_cliente'];
                        $direccion_cliente = $row['direccion_cliente'];
                        
                        // Lógica Documento (Prioridad DOC > DNI > Documento)
                        $doc_val = "";
                        $tipo_val = "OTRO";
                        $tipo_cod = 1; // Para el modal

                        if(!empty($row['doc']) && $row['doc'] > 0){
                            $doc_val = $row['doc']; $tipo_val = "RUC"; $tipo_cod = 2;
                        } elseif(!empty($row['dni']) && $row['dni'] > 0){
                            $doc_val = $row['dni']; $tipo_val = "DNI"; $tipo_cod = 1;
                        } else {
                            $doc_val = $row['documento']; 
                            $tipo_val = (strlen($doc_val)==11) ? "RUC" : "DNI";
                        }

                        // Datos ocultos adicionales
                        $vendedor = $row['vendedor'];
                        $departamento = $row['departamento'];
                        $provincia = $row['provincia'];
                        $distrito = $row['distrito'];
                        $cuenta = $row['cuenta'];

                        // Estado y Botones
                        $status_cliente = $row['status_cliente'];
                        if ($status_cliente == 1) {
                            $estado_label = "<span class='label label-success' style='border-radius:10px;'>ACTIVO</span>";
                            $btn_clase = "btn-red";
                            $btn_icon = "fa-power-off"; // Icono de apagado para desactivar
                            $btn_title = "Desactivar Cliente";
                        } else {
                            $estado_label = "<span class='label label-danger' style='border-radius:10px;'>INACTIVO</span>";
                            $btn_clase = "btn-green";
                            $btn_icon = "fa-power-off"; // Icono de encendido para activar
                            $btn_title = "Activar Cliente";
                        }
                    ?>
                    <tr>
                        <input type="hidden" value="<?php echo $nombre_cliente;?>" id="nombre_cliente<?php echo $id_cliente;?>">
                        <input type="hidden" value="<?php echo $telefono_cliente;?>" id="telefono_cliente<?php echo $id_cliente;?>">
                        <input type="hidden" value="<?php echo $email_cliente;?>" id="email_cliente<?php echo $id_cliente;?>">
                        <input type="hidden" value="<?php echo $direccion_cliente;?>" id="direccion_cliente<?php echo $id_cliente;?>">
                        <input type="hidden" value="<?php echo $doc_val;?>" id="doc<?php echo $id_cliente;?>">
                        <input type="hidden" value="<?php echo $doc_val;?>" id="dni<?php echo $id_cliente;?>">
                        <input type="hidden" value="<?php echo $tipo_cod;?>" id="tipo<?php echo $id_cliente;?>">
                        <input type="hidden" value="<?php echo $status_cliente;?>" id="status_cliente<?php echo $id_cliente;?>">
                        <input type="hidden" value="<?php echo $vendedor;?>" id="vendedor<?php echo $id_cliente;?>">
                        <input type="hidden" value="<?php echo $departamento;?>" id="departamento<?php echo $id_cliente;?>">
                        <input type="hidden" value="<?php echo $provincia;?>" id="provincia<?php echo $id_cliente;?>">
                        <input type="hidden" value="<?php echo $distrito;?>" id="distrito<?php echo $id_cliente;?>">
                        <input type="hidden" value="<?php echo $cuenta;?>" id="cuenta<?php echo $id_cliente;?>">

                        <td style="font-weight: 500; color: #333;"><?php echo $nombre_cliente; ?></td>
                        <td><?php echo $doc_val; ?></td>
                        <td><?php echo $tipo_val; ?></td>
                        <td><?php echo $telefono_cliente; ?></td>
                        <td class="text-center"><?php echo $estado_label;?></td>
                        
                        <td class="text-center">
                            <a href="#" class='btn-circle btn-orange' title='Editar' onclick="obtener_datos('<?php echo $id_cliente;?>');" data-toggle="modal" data-target="#nuevoCliente">
                                <i class="fa fa-pencil"></i>
                            </a> 
                            
                            <a href="#" class='btn-circle <?php echo $btn_clase; ?>' title='<?php echo $btn_title; ?>' onclick="eliminar('<?php echo $id_cliente; ?>', '<?php echo $status_cliente; ?>')">
                                <i class="fa <?php echo $btn_icon; ?>"></i>
                            </a>
                        </td>   
                    </tr>
                    <?php
                }
                ?>
                </tbody>
              </table>
              <div class="text-right" style="padding: 10px;">
                  <?php echo paginate($reload, $page, $total_pages, $adjacents); ?>
              </div>
            </div>
            <?php
        } else {
            ?>
            <div class="alert alert-info" style="background: white; color: #475569; border: 1px solid #e2e8f0; border-radius: 8px; margin-top: 10px; box-shadow: 0 2px 4px rgba(0,0,0,0.05);">
              <i class="fa fa-info-circle" style="color: #007B9E;"></i> No se encontraron clientes registrados.
            </div>
            <?php
        }
    }
?>