<style>
    /* MANTENIENDO TU DISEÑO EXACTO */
    .table-sc { border-collapse: separate; border-spacing: 0; width: 100%; font-size: 13px; }
    .table-sc thead th { background: #0f172a !important; color: #ffffff !important; text-transform: uppercase; font-size: 11px; padding: 12px; border: none; }
    .row-card { background: white; transition: 0.3s; }
    .row-card:hover { background: #f8fafc !important; }
    .row-card td { padding: 12px; border-bottom: 1px solid #f1f5f9; vertical-align: middle; }

    /* BOTONES DE ACCIÓN */
    .btn-action-sc { border-radius: 50%; width: 34px; height: 34px; display: inline-flex; align-items: center; justify-content: center; border: none; color: white !important; transition: 0.2s; margin: 0 2px; text-decoration: none; }
    .btn-pdf { background: #0a2463; } /* Color actualizado a Premium */
    .btn-ticket { background: #3b82f6; } 
    .btn-wsp { background: #25d366; }
    .btn-action-sc:hover { transform: scale(1.1); opacity: 0.9; color: white; }

    .btn-conv { background: #3b82f6; border-radius: 20px !important; font-weight: 700; font-size: 11px; padding: 5px 15px !important; text-transform: uppercase; color: white !important; text-decoration: none; }

    /* ESTILOS DEL MODAL */
    .modal-pdf-container { height: 600px; width: 100%; border: none; border-radius: 8px; }
    .wsp-input-group { background: #f1f5f9; padding: 15px; border-radius: 12px; margin-top: 15px; border: 1px solid #e2e8f0; }
</style>

<?php
	include('is_logged.php');
	require_once ("../config/db.php");
	require_once ("../config/conexion.php");
	$tienda1=$_SESSION['tienda'];
	
	$action = (isset($_REQUEST['action'])&& $_REQUEST['action'] !=NULL)?$_REQUEST['action']:'';

	if($action == 'ajax'){
        $q = mysqli_real_escape_string($con,(strip_tags($_REQUEST['q'], ENT_QUOTES)));
        $q1 = mysqli_real_escape_string($con,(strip_tags($_REQUEST['q1'], ENT_QUOTES)));
        
		$sTable = "facturas, clientes, users";
        // FILTRO ESTRICTO: Solo estado 8 (Pendientes) para que desaparezcan al convertir
		$sWhere = " WHERE facturas.id_cliente=clientes.id_cliente and facturas.tienda='$tienda1' and facturas.id_vendedor=users.user_id and facturas.ven_com=1 and facturas.estado_factura=8 and facturas.numero_factura>0";
        
        if ($_GET['q'] != "") { $sWhere.= " and (clientes.nombre_cliente like '%$q%')"; }
        if ($_GET['q1'] != "") { $sWhere.= " and (facturas.numero_factura like '%$q1%' or facturas.folio like '%$q1%')"; }

		$sWhere.=" order by facturas.id_factura desc";
		include 'pagination.php';

		$page = (isset($_REQUEST['page']) && !empty($_REQUEST['page']))?$_REQUEST['page']:1;
		$per_page = 10; $adjacents = 4; $offset = ($page - 1) * $per_page;
		$count_query = mysqli_query($con, "SELECT count(*) AS numrows FROM $sTable $sWhere");
		$row= mysqli_fetch_array($count_query);
		$numrows = $row['numrows']; $total_pages = ceil($numrows/$per_page);
		$sql="SELECT * FROM $sTable $sWhere LIMIT $offset,$per_page";
		$query = mysqli_query($con, $sql);

		if ($numrows>0){
			?>
			<div class="table-responsive">
			  <table class="table-sc">
				<thead>
                    <tr>
                        <th>Documento</th>
                        <th>Fecha</th>
                        <th>Cliente</th>
                        <th class='text-right'>Total</th>
                        <th class='text-center'>PDF / Ticket / WhatsApp</th>
                        <th class='text-right'>Acción</th>
                    </tr>
                </thead>
                <tbody>
				<?php
				while ($row=mysqli_fetch_array($query)){
					$id_factura=$row['id_factura'];
					$numero_factura=$row['numero_factura'];
					$folio=$row['folio'];
					$fecha=date("d/m/Y", strtotime($row['fecha_factura']));
					$nombre_cliente=$row['nombre_cliente'];
                    $telf_cliente=$row['telefono_cliente'];
					$total_venta=$row['total_venta'];
					$mon = ($row['moneda'] == 1) ? 'S/.' : '$'; 
                    $hash = isset($row['cod_hash']) ? $row['cod_hash'] : md5($id_factura . 'SoundCrowSecret');
					?>
					<tr class="row-card">
						<td style="font-weight:bold; color:#0a2463;"><?php echo "$folio-$numero_factura"; ?></td>
						<td><?php echo $fecha; ?></td>
						<td style="font-weight:500;"><?php echo $nombre_cliente;?></td>
						<td class='text-right' style="font-weight:bold; color:#2473f2;"><?php echo "$mon ".number_format($total_venta,2);?></td>

						<td class="text-center">
                            <a href="javascript:void(0)" class='btn-action-sc btn-pdf' title='Ver Vista Premium' onclick="abrir_modal_documento('<?php echo $id_factura;?>', '<?php echo $nombre_cliente;?>', '<?php echo $folio.'-'.$numero_factura;?>', '<?php echo $telf_cliente;?>', '<?php echo $mon.' '.number_format($total_venta,2);?>', '<?php echo $hash;?>');">
                                <i class="fa fa-eye"></i>
                            </a> 
                            <a href="javascript:void(0)" class='btn-action-sc btn-ticket' title='Ver Ticket' onclick="ver_ticket_cotizacion('<?php echo $id_factura;?>', '<?php echo $hash;?>');">
                                <i class="fa fa-print"></i>
                            </a> 
                            <a href="javascript:void(0)" class='btn-action-sc btn-wsp' title='WhatsApp' onclick="abrir_modal_documento('<?php echo $id_factura;?>', '<?php echo $nombre_cliente;?>', '<?php echo $folio.'-'.$numero_factura;?>', '<?php echo $telf_cliente;?>', '<?php echo $mon.' '.number_format($total_venta,2);?>', '<?php echo $hash;?>');">
                                <i class="fab fa-whatsapp"></i>
                            </a>
						</td>

						<td class="text-right">
						    <a href="nueva_conv_cotizacion.php?id_factura=<?php echo $id_factura;?>" class='btn-conv'>
                                <i class="fa fa-refresh"></i> Convertir
                            </a> 
						</td>
					</tr>
				<?php } ?>
                </tbody>
			  </table>
              <div class="text-right" style="padding:10px;"><?php echo paginate($reload, $page, $total_pages, $adjacents); ?></div>
			</div>
			<?php
		} else {
            echo '<div class="alert alert-info text-center" style="margin-top:20px;"><i class="fa fa-info-circle"></i> No hay cotizaciones pendientes por convertir.</div>';
        }
	}
?>

<div class="modal fade" id="modalDocumento" tabindex="-1" role="dialog">
  <div class="modal-dialog modal-lg" role="document">
    <div class="modal-content" style="border-radius:15px; overflow:hidden;">
      <div class="modal-header" style="background:#0a2463; color:white;">
        <button type="button" class="close" data-dismiss="modal" style="color:white;">&times;</button>
        <h4 class="modal-title" id="tituloModalDoc"><i class="fa fa-file-text-o"></i> Vista Previa Premium</h4>
      </div>
      <div class="modal-body" style="background:#f8fafc; padding:0;">
        <iframe id="iframePdf" class="modal-pdf-container" src=""></iframe>
        <div class="wsp-input-group" style="margin: 15px;">
            <div class="row">
                <div class="col-md-7">
                    <div class="input-group">
                        <span class="input-group-addon" style="background:#25d366; color:white; border:none;"><i class="fab fa-whatsapp"></i></span>
                        <input type="text" class="form-control" id="wsp_numero" placeholder="Ej: 987654321">
                    </div>
                </div>
                <div class="col-md-5">
                    <button type="button" class="btn btn-success btn-block" onclick="enviar_por_wsp();" style="background:#25d366; border:none; font-weight:700;">ENVIAR DIRECTO <i class="fa fa-paper-plane"></i></button>
                </div>
            </div>
        </div>
        <input type="hidden" id="wsp_id_factura"><input type="hidden" id="wsp_cliente"><input type="hidden" id="wsp_doc_nro"><input type="hidden" id="wsp_monto"><input type="hidden" id="wsp_hash">
      </div>
    </div>
  </div>
</div>

<div class="modal fade" id="modalTicket" tabindex="-1" role="dialog">
  <div class="modal-dialog" role="document" style="width: 400px; margin: auto; margin-top: 50px;">
    <div class="modal-content" style="border-radius:10px;">
        <div class="modal-header" style="background:#3b82f6; color:white;">
            <button type="button" class="close" data-dismiss="modal" style="color:white;">&times;</button>
            <h4 class="modal-title"><i class="fa fa-print"></i> Formato Ticket</h4>
        </div>
        <div class="modal-body" style="padding:0;">
            <iframe id="iframeTicket" style="width:100%; height:500px; border:none;" src=""></iframe>
        </div>
    </div>
  </div>
</div>

<script>
// SCRIPTS DE BOTONES ACTUALIZADOS A VISTA PREVIA PREMIUM
function abrir_modal_documento(id, cliente, doc, telf, monto, hash) {
    // AHORA APUNTA A VISTA_PREVIA.PHP
    var url_pdf = "vista_previa.php?id_factura=" + id;
    $("#iframePdf").attr("src", url_pdf);
    $("#wsp_numero").val(telf); $("#wsp_id_factura").val(id); $("#wsp_cliente").val(cliente); $("#wsp_doc_nro").val(doc); $("#wsp_monto").val(monto); $("#wsp_hash").val(hash);
    $("#modalDocumento").modal("show");
}

function ver_ticket_cotizacion(id, hash) {
    var url_ticket = "pdf/documentos/ver_ticket.php?id_factura=" + id + "&hash=" + hash;
    $("#iframeTicket").attr("src", url_ticket);
    $("#modalTicket").modal("show");
}

function enviar_por_wsp() {
    var num = $("#wsp_numero").val().replace(/\s+/g, '').replace(/-/g, '');
    var cliente = $("#wsp_cliente").val();
    var doc = $("#wsp_doc_nro").val();
    var id = $("#wsp_id_factura").val();
    
    if (num == "") { alert("Ingrese un número de WhatsApp."); return; }
    if (num.length == 9) { num = "51" + num; }
    
    // ENLACE DIRECTO A VISTA PREVIA
    var link_pdf = "https://majalustore.com/sound/vista_previa.php?id_factura=" + id;
    
    var msg = "Hola *" + cliente + "*, le adjuntamos su cotización *" + doc + "*.\n📄 *Véala aquí:* " + link_pdf;
    var wa_url = "https://web.whatsapp.com/send?phone=" + num + "&text=" + encodeURIComponent(msg);
    window.open(wa_url, '_blank');
}
</script>