<?php
	include('is_logged.php');
	require_once ("../config/db.php");
	require_once ("../config/conexion.php");
	
	date_default_timezone_set('America/Lima');
	
    $tienda1 = $_SESSION['tienda']; 

    // Obtener RUC de la sucursal
    $sql_ruc = mysqli_query($con, "SELECT ruc FROM sucursal WHERE tienda='$tienda1'");
    $rw_ruc = mysqli_fetch_array($sql_ruc);
    $ruc_emisor = $rw_ruc['ruc']; // O usa $rw_ruc['ruc'] si prefieres dinmico

	$action = (isset($_REQUEST['action']) && $_REQUEST['action'] != NULL) ? $_REQUEST['action'] : '';
	
	if($action == 'ajax'){
        $q = mysqli_real_escape_string($con,(strip_tags($_REQUEST['q'], ENT_QUOTES))); 
        $q1 = mysqli_real_escape_string($con,(strip_tags($_REQUEST['q1'], ENT_QUOTES))); 
        $q4 = mysqli_real_escape_string($con,(strip_tags($_REQUEST['q4'], ENT_QUOTES))); 
        
        // Recibimos el parmetro per_page, si no existe, usamos 5 por defecto
        $per_page = (isset($_REQUEST['per_page']) && !empty($_REQUEST['per_page'])) ? intval($_REQUEST['per_page']) : 5; 
        
		$sTable = "facturas, clientes, users";
		$sWhere = " WHERE facturas.id_cliente=clientes.id_cliente 
            AND facturas.id_vendedor=users.user_id
            AND facturas.tienda=$tienda1 
            AND facturas.activo=1 
            AND facturas.ven_com=1 
            AND (facturas.estado_factura=1 OR facturas.estado_factura=2)";
		
		if ( $q != "" ) { $sWhere.= " and clientes.nombre_cliente LIKE '%$q%'"; }
        if ( $q1 != "" ) { $sWhere.= " and facturas.numero_factura LIKE '%$q1%'"; }
        if ( $q4 != "" ) { $sWhere.= " and facturas.estado_factura='$q4'"; }
		
		$sWhere.=" order by facturas.fecha_factura desc, facturas.id_factura desc";
		
		include 'pagination.php';
		
		$page = (isset($_REQUEST['page']) && !empty($_REQUEST['page'])) ? $_REQUEST['page'] : 1;
        $adjacents  = 4; 
		$offset = ($page - 1) * $per_page;
		
		$count_query = mysqli_query($con, "SELECT count(*) AS numrows FROM $sTable $sWhere");
		$row= mysqli_fetch_array($count_query);
		$numrows = $row['numrows'];
		$total_pages = ceil($numrows/$per_page);
		$reload = './fac.php';
		
		$sql="SELECT facturas.*, clientes.nombre_cliente, clientes.telefono_cliente FROM $sTable $sWhere LIMIT $offset,$per_page";
		$query = mysqli_query($con, $sql);
		
		if ($numrows>0){
			?>
            <style>
                .btn-icon-action { width: 35px; height: 35px; border-radius: 50%; border: none; color: white; display: inline-flex; align-items: center; justify-content: center; font-size: 16px; margin: 0 2px; box-shadow: 0 2px 5px rgba(0,0,0,0.1); transition: all 0.3s ease; text-decoration: none !important; cursor: pointer; }
                .btn-icon-action:hover { transform: translateY(-2px); color: white; filter: brightness(1.1); }
                .btn-xml { background: #10b981; }
                .btn-cdr { background: #f59e0b; }
                .btn-send { background: #3b82f6; }
                .btn-pdf { background: #ef4444; }
                .btn-ticket { background: #6366f1; }
                .btn-whatsapp { background: #25D366; } /* Color oficial WhatsApp */
                
                .badge-pill { padding: 4px 10px; border-radius: 50px; font-size: 10px; font-weight: 700; }
                .badge-success { background: #ecfdf5; color: #059669; border: 1px solid #10b981; }
                .badge-warning { background: #fff7ed; color: #c2410c; border: 1px solid #f97316; }
            </style>

			<div class="table-responsive" style="border-radius: 12px; box-shadow: 0 4px 20px rgba(0,0,0,0.05); background: white;">
			  <table id="tablaFacturas" class="table table-hover" style="margin-bottom: 0; color: #475569; font-size: 13px;">
				<thead style="background: #0a2463; color: white;">
					<tr>
						<th style="padding: 15px;">Emisin</th>
						<th style="padding: 15px;">Documento</th>
						<th style="padding: 15px;">Cliente</th>
						<th class='text-right' style="padding: 15px;">Total</th>
                        <th class='text-center' style="padding: 15px;">Estado</th>
						<th class='text-center' style="padding: 15px;">SUNAT</th>
						<th class='text-center' style="padding: 15px;">Acciones</th>
					</tr>
				</thead>
				<tbody>
				<?php
				while ($row=mysqli_fetch_array($query)){
						$id_factura=$row['id_factura'];
						$numero_factura=$row['numero_factura'];
						$fecha = date("d/m/Y", strtotime($row['fecha_factura']));
						$hora = date("H:i A", strtotime($row['fecha_factura']));
						$nombre_cliente=$row['nombre_cliente'];
                        $telefono_cliente=$row['telefono_cliente']; // Para WhatsApp si se necesita
						$estado_factura=$row['estado_factura'];
						$total_venta=$row['total_venta'];
                        $folio = $row['folio']; 
                        
                        // === SEGURIDAD: Recuperamos el HASH ===
                        $hash_seguridad = $row['cod_hash'];
                        
                        // Determinamos tipo de documento
                        $tip = "01"; 
						if ($estado_factura==1){ $tip = "01"; } 
                        if ($estado_factura==2){ $tip = "03"; } 

                        if(strpos($numero_factura, '-') !== false){
                            $parts = explode('-', $numero_factura);
                            $numero_limpio = end($parts); 
                        } else {
                            $numero_limpio = $numero_factura;
                        }

                        $numero_factura_pad = str_pad($numero_limpio, 8, "0", STR_PAD_LEFT); 
                        $numero_final_visual = $folio . "-" . $numero_limpio; 

                        // Nombres de archivos
                        $nombre_archivo_xml = $ruc_emisor . '-' . $tip . '-' . $folio . '-' . $numero_factura_pad . '.XML';
                        $nombre_archivo_cdr = 'R-' . $ruc_emisor . '-' . $tip . '-' . $folio . '-' . $numero_factura_pad . '.XML';
                        $nombre_base_envio = $ruc_emisor . '-' . $tip . '-' . $folio . '-' . $numero_factura_pad;
                        $ruta_check_cdr = "../pdf/documentos/cdr/" . $nombre_archivo_cdr;

                        $campo_aceptado = isset($row['aceptado']) ? $row['aceptado'] : '';
                        $enviado = (!empty($campo_aceptado)) ? true : false;

                        // Construccin del enlace seguro para WhatsApp y PDF
                        // Ajusta 'tudominio.com' por tu dominio real
                        $dominio_sistema = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://$_SERVER[HTTP_HOST]";
                        // Si tu sistema est en una subcarpeta, agrgala (ej: /sound)
                        $path_sistema = dirname(dirname($_SERVER['PHP_SELF'])); // Sube un nivel desde /ajax/
                        $url_publica = $dominio_sistema . "/sound/pdf/documentos/ver_factura.php?id_factura=" . $id_factura . "&hash=" . $hash_seguridad;
                        
                        $msj_whatsapp = "Hola, le enviamos su comprobante electrnico $numero_final_visual. Puede descargarlo aqu: $url_publica";
                        $link_whatsapp = "https://api.whatsapp.com/send?text=" . urlencode($msj_whatsapp);
					?>
					<tr style="border-bottom: 1px solid #f1f5f9;">
                        <td style="padding: 12px;">
                            <strong><?php echo $fecha; ?></strong><br>
                            <small class="text-muted"><?php echo $hora; ?></small>
                        </td>
						<td style="padding: 12px; font-weight:bold; color:#0a2463;"><?php echo $numero_final_visual; ?></td>
						<td style="padding: 12px;"><?php echo $nombre_cliente; ?></td>
						<td class='text-right' style="padding: 12px; font-weight:bold;">S/. <?php echo number_format($total_venta,2); ?></td>
                        <td class="text-center" style="padding: 12px;">
                            <?php if ($enviado): ?>
                                <span class="badge-pill badge-success"><i class="fa fa-check"></i> Aceptado</span>
                            <?php else: ?>
                                <span class="badge-pill badge-warning"><i class="fa fa-clock-o"></i> Pendiente</span>
                            <?php endif; ?>
                        </td>
                        <td class="text-center" style="padding: 12px;">
                            <a href="#" onclick="ver_archivo('<?php echo $nombre_archivo_xml;?>', 'xml'); return false;" class="btn-icon-action btn-xml" title="Ver XML" data-toggle="tooltip"><i class="fa fa-code"></i></a>
                            
                            <?php if ($enviado): ?>
                                <?php if (file_exists($ruta_check_cdr)): ?>
                                    <a href="#" onclick="ver_archivo('<?php echo $nombre_archivo_cdr;?>', 'cdr'); return false;" class="btn-icon-action btn-cdr" title="Ver CDR" data-toggle="tooltip"><i class="fa fa-file-archive-o"></i></a>
                                <?php else: ?>
                                    <a href="#" class="btn-icon-action" style="background:#cbd5e1; cursor:not-allowed;" title="CDR no encontrado" data-toggle="tooltip"><i class="fa fa-file-archive-o"></i></a>
                                <?php endif; ?>
                            <?php else: ?>
                                <a href="#" onclick="enviar('<?php echo $nombre_base_envio;?>');" class="btn-icon-action btn-send" title="Enviar a SUNAT" data-toggle="tooltip"><i class="fa fa-paper-plane"></i></a>
                            <?php endif; ?>
                        </td>
                        <td class="text-center" style="padding: 12px;">
                            <a href="<?php echo $link_whatsapp; ?>" target="_blank" class="btn-icon-action btn-whatsapp" title="Enviar por WhatsApp" data-toggle="tooltip">
                                <i class="fab fa-whatsapp"></i>
                            </a>
                            
                            <a href="pdf/documentos/ver_factura.php?id_factura=<?php echo $id_factura;?>&hash=<?php echo $hash_seguridad; ?>" target="_blank" class="btn-icon-action btn-pdf" title="PDF">
                                <i class="fa fa-file-pdf-o"></i>
                            </a>
                            
                            <a href="#" onclick="imprimir_ticket('<?php echo $id_factura;?>'); return false;" class="btn-icon-action btn-ticket" title="Ticket">
                                <i class="fa fa-print"></i>
                            </a>
                        </td>
					</tr>
					<?php
				}
				?>
				</tbody>
			  </table>
			</div>
            <div class="row" style="margin-top: 20px;">
                <div class="col-md-12 text-right">
                    <?php echo paginate($reload, $page, $total_pages, $adjacents); ?>
                </div>
            </div>
            <script>
            $(function () { $('[data-toggle="tooltip"]').tooltip() })
            // Aseguramos que la funcin imprimir_ticket use el modal definido en fac.php
            // Nota: La funcin real est en fac.php, aqu solo se invoca
            </script>
			<?php
		} else {
            echo '<div class="alert alert-info" role="alert" style="margin-top:20px;"><i class="fa fa-info-circle"></i> No se encontraron comprobantes con esos filtros.</div>';
        }
	}
?>