<?php
    include('is_logged.php');
    require_once ("../config/db.php");
    require_once ("../config/conexion.php");
    $tienda1=$_SESSION['tienda'];

    // Lgica de Anulacin (Activo = 0)
    if (isset($_GET['id'])){
        $id_factura=intval($_GET['id']);
        $del1="UPDATE facturas SET activo=0 WHERE id_factura='$id_factura'";
        if(mysqli_query($con, $del1)){
            echo "<div class='alert alert-success'>Documento anulado correctamente.</div>";
        }
    }

    if($action == 'ajax'){
        $q = mysqli_real_escape_string($con,(strip_tags($_REQUEST['q'], ENT_QUOTES)));
        $q1 = mysqli_real_escape_string($con,(strip_tags($_REQUEST['q1'], ENT_QUOTES)));
        $q2 = mysqli_real_escape_string($con,(strip_tags($_REQUEST['q2'], ENT_QUOTES)));
        $q3 = mysqli_real_escape_string($con,(strip_tags($_REQUEST['q3'], ENT_QUOTES)));

        // RESTRICCI07N LIMPIA: Solo ventas (ven_com = 1) y estados 1 o 2
        $sWhere = " WHERE facturas.id_cliente=clientes.id_cliente AND facturas.tienda=$tienda1 AND facturas.activo=1 AND facturas.ven_com=1 AND (facturas.estado_factura=1 OR facturas.estado_factura=2)";
        
        if (!empty($q)){ $sWhere .= " AND clientes.nombre_cliente LIKE '%$q%'"; }
        if (!empty($q1)){ $sWhere .= " AND facturas.numero_factura LIKE '%$q1%'"; }
        if (!empty($q2)){ $sWhere .= " AND DATE(fecha_factura) >= '$q2'"; }
        if (!empty($q3)){ $sWhere .= " AND DATE(fecha_factura) <= '$q3'"; }

        $sWhere .= " ORDER BY id_factura DESC";
        include 'pagination.php';
        $page = (isset($_REQUEST['page']) && !empty($_REQUEST['page']))?$_REQUEST['page']:1;
        $per_page = 15; $offset = ($page - 1) * $per_page;
        
        $count_query = mysqli_query($con, "SELECT count(*) AS numrows FROM facturas, clientes $sWhere");
        if (!$count_query) { die("Error en la consulta: " . mysqli_error($con)); }
        
        $numrows = mysqli_fetch_array($count_query)['numrows'];
        $total_pages = ceil($numrows/$per_page);

        $sql="SELECT facturas.*, clientes.nombre_cliente FROM facturas, clientes $sWhere LIMIT $offset,$per_page";
        $query = mysqli_query($con, $sql);

        if ($numrows > 0){
            ?>
            <div class="table-responsive">
              <table class="table" style="color:#334155; font-size:13px; margin-top:20px;">
                <tr style="background-color:#0a2463; color:white;">
                    <th class="text-center">Nro Doc</th>
                    <th class="text-center">Tipo</th>
                    <th class="text-center">Fecha</th>
                    <th style="width:30%;">Cliente</th>
                    <th class="text-right">Total</th>
                    <th class="text-right">Acciones</th>
                </tr>
                <?php
                while ($row=mysqli_fetch_array($query)){
                    $id_factura=$row['id_factura'];
                    $numero=$row['numero_factura'];
                    $fecha=date("d/m/Y", strtotime($row['fecha_factura']));
                    $cliente=$row['nombre_cliente'];
                    $total=number_format($row['total_venta'],2);
                    $estado=$row['estado_factura'];
                    $folio=$row['folio'];
                    
                    if ($estado == 1) { $tipo_txt = "Factura"; $label = "label-success"; } 
                    else { $tipo_txt = "Boleta"; $label = "label-primary"; }
                ?>
                <tr style="border-bottom: 1px solid #f1f5f9;">
                    <td class="text-center"><b><?php echo "$folio-$numero"; ?></b></td>
                    <td class="text-center"><span class="label <?php echo $label; ?>"><?php echo $tipo_txt; ?></span></td>
                    <td class="text-center"><?php echo $fecha; ?></td>
                    <td><?php echo $cliente; ?></td>
                    <td class="text-right"><b>S/. <?php echo $total; ?></b></td>
                    <td class="text-right">
                        <a href="#" class="btn btn-primary btn-xs" title="Ver PDF" onclick="imprimir_factura('<?php echo $id_factura;?>')"><i class="fas fa-file-pdf"></i></a>
                        <a href="#" class="btn btn-info btn-xs" title="Ticket" onclick="imprimir_factura4('<?php echo $id_factura;?>')"><i class="fas fa-print"></i></a>
                        <a href="#" class="btn btn-danger btn-xs" title="Anular" onclick="eliminar('<?php echo $id_factura;?>')"><i class="fas fa-ban"></i></a>
                    </td>
                </tr>
                <?php } ?>
              </table>
              <div class="text-right"><?php echo paginate('', $page, $total_pages, 4); ?></div>
            </div>
            <?php
        } else {
            echo '<div class="alert alert-info" style="margin-top:20px;">No se encontraron Ventas oficiales (ven_com=1).</div>';
        }
    }
?>