<?php
include('is_logged.php');
require_once ("../config/db.php");
require_once ("../config/conexion.php");

$action = (isset($_REQUEST['action']) && $_REQUEST['action'] != NULL) ? $_REQUEST['action'] : '';
$tienda = $_SESSION['tienda'];

// ==========================================
// FUNCIÓN PARA ELIMINAR GASTO (CON SOLUCIÓN DE DUPLICADO)
// ==========================================
if (isset($_GET['id_gasto_eliminar'])){
    $id_gasto = intval($_GET['id_gasto_eliminar']);
    $delete = mysqli_query($con, "DELETE FROM gastos WHERE id_gasto='".$id_gasto."'");
    if($delete){
        // Usamos el nuevo sistema de Toast
        echo "<script>mostrar_notificacion('success', 'Eliminado', 'Gasto eliminado correctamente.');</script>";
    } else {
        echo "<script>mostrar_notificacion('error', 'Error', 'No se pudo eliminar el gasto.');</script>";
    }
    exit; // ¡ESTO EVITA QUE LA TABLA SE DUPLIQUE!
}

if($action == 'ajax'){
    $q = mysqli_real_escape_string($con,(strip_tags($_REQUEST['q'], ENT_QUOTES)));
    $q2 = mysqli_real_escape_string($con,(strip_tags($_REQUEST['q2'], ENT_QUOTES)));
    $q3 = mysqli_real_escape_string($con,(strip_tags($_REQUEST['q3'], ENT_QUOTES)));
    
    $sTable = "gastos, users";
    $sWhere = " WHERE gastos.id_usuario = users.user_id AND gastos.tienda = '$tienda'";
    
    if ( $_GET['q'] != "" ) { $sWhere .= " AND gastos.referencia LIKE '%$q%'"; }
    if (!empty($q2) && !empty($q3)) { $sWhere .= " AND DATE(gastos.fecha_agregado) BETWEEN '$q2' AND '$q3'"; }
    
    $sWhere .= " ORDER BY id_gasto DESC";
    include 'pagination.php';
    
    $page = (isset($_REQUEST['page']) && !empty($_REQUEST['page']))?$_REQUEST['page']:1;
    $per_page = 10; $adjacents = 4; $offset = ($page - 1) * $per_page;
    $count_query = mysqli_query($con, "SELECT count(*) AS numrows FROM $sTable $sWhere");
    $row = mysqli_fetch_array($count_query); $numrows = $row['numrows'];
    $total_pages = ceil($numrows/$per_page);
    $sql = "SELECT * FROM $sTable $sWhere LIMIT $offset,$per_page";
    $query = mysqli_query($con, $sql);

    if ($numrows > 0){
        $suma_gastos_filtrados = 0;
        ?>
        <style>
            .btn-circle-sc-sm { width: 30px; height: 30px; border-radius: 50%; display: inline-flex; align-items: center; justify-content: center; color: white !important; border: none; margin-right: 4px; transition: 0.3s; text-decoration: none; }
            .btn-circle-sc-sm:hover { transform: scale(1.1); }
            .btn-edit-gasto { background: #3b82f6; } .btn-del-gasto { background: #ef4444; }
            .total-footer { background: #f8fafc; font-weight: 800; text-transform: uppercase; font-size: 14px; }
        </style>
        <div class="table-responsive">
          <table class="table table-hover">
            <thead style="background:#0f172a; color:white;">
                <tr>
                    <th>Fecha</th>
                    <th>Motivo / Referencia</th>
                    <th>Registrado por</th>
                    <th class='text-center'>Monto (S/.)</th>
                    <th class='text-right'>Acciones</th>
                </tr>
            </thead>
            <tbody>
            <?php
            while ($row = mysqli_fetch_array($query)){
                $id_gasto = $row['id_gasto'];
                $fecha = date("d/m/Y H:i A", strtotime($row['fecha_agregado']));
                $referencia = $row['referencia'];
                $id_usuario_gasto = $row['id_usuario'];
                $usuario = $row['nombres'];
                $monto = floatval($row['monto']);
                $suma_gastos_filtrados += $monto; 
                ?>
                <tr>
                    <td style="vertical-align: middle;"><?php echo $fecha; ?></td>
                    <td style="vertical-align: middle; font-weight:600; text-transform:uppercase;"><?php echo $referencia; ?></td>
                    <td style="vertical-align: middle;"><i class="fa fa-user" style="color:#64748b;"></i> <?php echo $usuario; ?></td>
                    <td class='text-center' style="vertical-align: middle; font-weight:bold; color:#ef4444;">- S/. <?php echo number_format($monto,2); ?></td>
                    <td class='text-right' style="vertical-align: middle;">
                        <button onclick="obtener_datos('<?php echo $id_gasto;?>', '<?php echo addslashes($referencia);?>', '<?php echo $monto;?>', '<?php echo $id_usuario_gasto;?>')" class="btn-circle-sc-sm btn-edit-gasto" title="Editar" data-toggle="modal" data-target="#editarGastoModal"><i class="fa fa-edit"></i></button>
                        <button onclick="eliminar_gasto('<?php echo $id_gasto;?>')" class="btn-circle-sc-sm btn-del-gasto" title="Borrar"><i class="fa fa-trash"></i></button>
                    </td>
                </tr>
            <?php } ?>
            <tr class="total-footer">
                <td colspan="3" class="text-right" style="color: #0f172a;">TOTAL GASTOS EN ESTA PÁGINA:</td>
                <td class="text-center" style="color:#ef4444;">- S/. <?php echo number_format($suma_gastos_filtrados, 2); ?></td>
                <td></td>
            </tr>
            </tbody>
          </table>
          <div class="text-right"><?php echo paginate("", $page, $total_pages, $adjacents); ?></div>
        </div>
        <?php
    } else {
        echo '<div class="alert alert-info"><i class="fa fa-info-circle"></i> No se encontraron gastos.</div>';
    }
}
?>