<?php
include('is_logged.php');
require_once ("../config/db.php");
require_once ("../config/conexion.php");

$action = (isset($_REQUEST['action']) && $_REQUEST['action'] != NULL) ? $_REQUEST['action'] : '';

if($action == 'ajax'){
    // Recibir variables
    $f_inicio = mysqli_real_escape_string($con, strip_tags($_REQUEST['f_inicio'], ENT_QUOTES));
    $f_fin = mysqli_real_escape_string($con, strip_tags($_REQUEST['f_fin'], ENT_QUOTES));
    $sucursal = mysqli_real_escape_string($con, strip_tags($_REQUEST['sucursal'], ENT_QUOTES));
    
    // Condicionales de Búsqueda
    $sWhere = " WHERE DATE(c.fec_reg) BETWEEN '$f_inicio' AND '$f_fin' ";
    
    if ($sucursal != 'todas') {
        $sWhere .= " AND c.tienda = '$sucursal' ";
    }

    $sWhere .= " ORDER BY c.id_caja DESC";

    // Paginación (Opcional, aquí mostramos todo lo del rango para facilitar la auditoría, limit a 100)
    $query = mysqli_query($con, "SELECT c.*, s.nombre_stand, s.nombre, u.nombres as cajero 
                                 FROM caja c 
                                 INNER JOIN sucursal s ON c.tienda = s.id_sucursal 
                                 INNER JOIN users u ON c.usuario_inicio = u.user_id 
                                 $sWhere LIMIT 100");
    
    $numrows = mysqli_num_rows($query);
    
    if ($numrows > 0) {
        ?>
        <div class="table-responsive">
            <table class="table table-hover" style="margin: 0; background: white;">
                <thead style="background: #f8fafc; color: #475569; font-size: 12px; text-transform: uppercase;">
                    <tr>
                        <th style="padding: 15px;">Fecha / Hora</th>
                        <th>Sucursal</th>
                        <th>Cajero</th>
                        <th class="text-right">Apertura</th>
                        <th class="text-right" style="color:#10b981;">Ingresos</th>
                        <th class="text-right" style="color:#ef4444;">Egresos</th>
                        <th class="text-right" style="color:#f59e0b;">Faltante</th>
                        <th class="text-right" style="color:#2473f2;">Saldo Cierre</th>
                        <th class="text-center">Estado</th>
                    </tr>
                </thead>
                <tbody>
                <?php
                $tot_apertura = 0; $tot_ingresos = 0; $tot_egresos = 0; $tot_faltante = 0; $tot_cierre = 0;

                while ($row = mysqli_fetch_array($query)) {
                    $fecha_apertura = date('d/m/Y h:i A', strtotime($row['fec_reg']));
                    $tienda_nombre = !empty($row['nombre_stand']) ? $row['nombre_stand'] : $row['nombre'];
                    $cajero = $row['cajero'];
                    
                    $apertura = floatval($row['inicio']);
                    $ingresos = floatval($row['entrada']);
                    $egresos = floatval($row['salida']);
                    $faltante = floatval($row['faltante']);
                    
                    // Si la caja está abierta (usuario_cierre = 0), el saldo de cierre calculado es referencial
                    $estado_abierta = ($row['usuario_cierre'] == 0);
                    $cierre = $estado_abierta ? (($apertura + $ingresos) - $egresos - $faltante) : floatval($row['cierre']);
                    
                    // Sumatorias para el pie de tabla
                    $tot_apertura += $apertura; $tot_ingresos += $ingresos; $tot_egresos += $egresos; 
                    $tot_faltante += $faltante; $tot_cierre += $cierre;
                    
                    $label_estado = $estado_abierta ? '<span class="label label-success" style="padding:5px 10px; border-radius:4px;">ACTIVA</span>' : '<span class="label label-danger" style="padding:5px 10px; border-radius:4px; background:#ef4444;">CERRADA</span>';
                    ?>
                    <tr style="border-bottom: 1px solid #f1f5f9;">
                        <td style="padding: 15px; font-weight: 600; color:#334155;"><?php echo $fecha_apertura; ?></td>
                        <td style="font-weight: 700; color:#2473f2;"><i class="fa fa-shopping-bag" style="opacity:0.5;"></i> <?php echo $tienda_nombre; ?></td>
                        <td><?php echo $cajero; ?></td>
                        <td class="text-right font-weight-bold">S/ <?php echo number_format($apertura, 2); ?></td>
                        <td class="text-right" style="color:#10b981; font-weight:bold;">S/ <?php echo number_format($ingresos, 2); ?></td>
                        <td class="text-right" style="color:#ef4444; font-weight:bold;">S/ <?php echo number_format($egresos, 2); ?></td>
                        <td class="text-right" style="color:#f59e0b; font-weight:bold;">S/ <?php echo number_format($faltante, 2); ?></td>
                        <td class="text-right" style="color:#2473f2; font-weight:900;">S/ <?php echo number_format($cierre, 2); ?></td>
                        <td class="text-center"><?php echo $label_estado; ?></td>
                    </tr>
                    <?php
                }
                ?>
                </tbody>
                <tfoot style="background: #d9dbdd; color: white;">
                    <tr>
                        <td colspan="3" class="text-right" style="padding: 15px; font-weight: 800; font-size: 14px;">TOTALES DEL REPORTE:</td>
                        <td class="text-right" style="padding: 15px; font-weight: 800;">S/ <?php echo number_format($tot_apertura, 2); ?></td>
                        <td class="text-right" style="padding: 15px; font-weight: 800; color:#34d399;">S/ <?php echo number_format($tot_ingresos, 2); ?></td>
                        <td class="text-right" style="padding: 15px; font-weight: 800; color:#f87171;">S/ <?php echo number_format($tot_egresos, 2); ?></td>
                        <td class="text-right" style="padding: 15px; font-weight: 800; color:#fbbf24;">S/ <?php echo number_format($tot_faltante, 2); ?></td>
                        <td class="text-right" style="padding: 15px; font-weight: 900; color:#60a5fa; font-size: 16px;">S/ <?php echo number_format($tot_cierre, 2); ?></td>
                        <td></td>
                    </tr>
                </tfoot>
            </table>
        </div>
        <?php
    } else {
        ?>
        <div class="alert alert-warning" style="margin: 20px; background: white; border: 2px dashed #f59e0b; color: #b45309; border-radius: 12px; padding: 30px; text-align: center;">
            <i class="fa fa-folder-open-o fa-3x" style="margin-bottom: 15px; opacity: 0.5;"></i>
            <h4 style="font-weight: 800; margin:0;">No se encontraron registros de caja</h4>
            <p style="margin:0;">No hay aperturas ni cierres en las fechas seleccionadas para esta sucursal.</p>
        </div>
        <?php
    }
}
?>