<?php
include('is_logged.php');
require_once ("../config/db.php");
require_once ("../config/conexion.php");

$action = (isset($_REQUEST['action']) && $_REQUEST['action'] != NULL) ? $_REQUEST['action'] : '';

if($action == 'ajax'){
    $q = mysqli_real_escape_string($con,(strip_tags($_REQUEST['q'], ENT_QUOTES)));
    $q1 = mysqli_real_escape_string($con,(strip_tags($_REQUEST['q1'], ENT_QUOTES)));
    $q2 = $_REQUEST['q2']; 
    $q3 = $_REQUEST['q3'];
    $q4 = intval($_REQUEST['q4']);
    
    $sTable = "facturas, clientes, users";
    $sWhere = " WHERE facturas.id_cliente=clientes.id_cliente AND facturas.id_vendedor=users.user_id"; 
    
    if ($q4 == 0) { 
        $sWhere .= " AND (facturas.estado_factura=3 OR facturas.estado_factura=32)";    
    } else { 
        $sWhere .= " AND facturas.estado_factura='$q4'"; 
    }
    
    if (!empty($q)) { $sWhere .= " AND clientes.nombre_cliente LIKE '%$q%'"; }
    if (!empty($q1)) { $sWhere .= " AND facturas.numero_factura = '$q1'"; }
    if (!empty($q2) && !empty($q3)) { $sWhere .= " AND DATE(facturas.fecha_factura) BETWEEN '$q2' AND '$q3'"; }
    
    $sWhere.=" ORDER BY facturas.id_factura DESC";
    include 'pagination.php';

    $page = (isset($_REQUEST['page']) && !empty($_REQUEST['page']))?$_REQUEST['page']:1;
    $per_page = 10; $adjacents = 4; $offset = ($page - 1) * $per_page;
    $count_query = mysqli_query($con, "SELECT count(*) AS numrows FROM $sTable $sWhere");
    $row = mysqli_fetch_array($count_query);
    $numrows = $row['numrows'];
    $total_pages = ceil($numrows/$per_page);
    
    $query = mysqli_query($con, "SELECT facturas.*, clientes.nombre_cliente, clientes.telefono_cliente, users.nombres FROM $sTable $sWhere LIMIT $offset,$per_page");

    if ($numrows > 0){
        ?>
        <style>
            .badge-emitida { background: #dcfce7; color: #15803d; padding: 4px 10px; border-radius: 12px; font-weight: 700; font-size: 10px; }
            .badge-anulada { background: #fee2e2; color: #b91c1c; padding: 4px 10px; border-radius: 12px; font-weight: 700; font-size: 10px; }
            .table-sc thead { background: #0f172a; color: white; text-transform: uppercase; font-size: 11px; }
            .table-sc td { vertical-align: middle !important; font-size: 12px; border-bottom: 1px solid #f1f5f9; }
            
            .btn-circle-sc { 
                width: 32px; height: 32px; border-radius: 50%; display: inline-flex; align-items: center; justify-content: center; 
                color: white !important; border: none; margin-right: 4px; transition: 0.3s; text-decoration: none;
            }
            .btn-circle-sc i { font-size: 14px; line-height: 1; }
            
            .btn-premium { background: #0a2463; } 
            .btn-ticket { background: #3b82f6; } 
            .btn-whatsapp { background: #25d366; } 
            .btn-anular { background: #f97316; }
            .text-anulado-label { color: #ef4444; font-weight: 800; font-size: 11px; text-transform: uppercase; }
        </style>
        <div class="table-responsive">
          <table class="table table-sc">
            <thead>
                <tr>
                    <th>DOCUMENTO</th>
                    <th>FECHA</th>
                    <th>CLIENTE</th>
                    <th>VENDEDOR</th>
                    <th class="text-center">ESTADO</th> 
                    <th class="text-center">TOTAL</th>
                    <th class="text-center">OPCIONES</th>
                    <th class="text-right">ACCIONES</th>
                </tr>
            </thead>
            <tbody>
            <?php
            while ($row=mysqli_fetch_array($query)){
                $id=$row['id_factura']; 
                $nro=$row['folio']."-".$row['numero_factura'];
                $fecha=date("d/m/Y", strtotime($row['fecha_factura'])); 
                $cliente=$row['nombre_cliente'];
                $vendedor_original=$row['nombres'];
                $total=$row['total_venta']; 
                $tel=$row['telefono_cliente'];
                $est=$row['estado_factura'];
                $moneda_simbolo = ($row['moneda'] == 1) ? "S/." : "$";
                $observacion = isset($row['obs']) ? $row['obs'] : '';

                // ==========================================
                // 1. GENERAMOS LA LLAVE SECRETA (HASH) AQUÍ
                // ==========================================
                $hash_seguridad = md5($id . 'SoundCrowSecret');

                // LÓGICA DE VENDEDOR VS ANULADOR
                if ($est == 32) {
                    $label_estado = '<span class="badge-anulada">ANULADA</span>';
                    $btn_acciones = '<span class="text-anulado-label">ANULADO</span>';
                    
                    if (preg_match('/\(Anulado por:\s*(.*?)\)/', $observacion, $matches)) {
                        $trabajador_anulo = $matches[1];
                        $columna_vendedor = "<span style='line-height: 16px !important;color:#ef4444; font-weight:bold; font-size:10.5px;' title='Creado originalmente por: $vendedor_original'><i class='fa fa-user-times'></i> Anulado por:<br>" . strtoupper($trabajador_anulo) . "</span>";
                    } else {
                        $columna_vendedor = "<span style='color:#ef4444; font-weight:bold; font-size:10.5px;'><i class='fa fa-user-times'></i> Anulado</span>";
                    }
                } else {
                    $label_estado = '<span class="badge-emitida">EMITIDA</span>';
                    $columna_vendedor = "<span style='color:#0a2463; font-weight:bold; font-size:11px;'><i class='fa fa-user'></i> " . strtoupper($vendedor_original) . "</span>";
                    
                    $btn_acciones = '
                        <button onclick="preparar_anulacion('.$id.')" class="btn-circle-sc btn-anular" title="Anular"><i class="fa fa-ban"></i></button>
                        <a href="nueva_conv.php?id_factura='.$id.'" class="btn-convert-sc" style="background:#2473f2;color:white;padding:6px 12px;border-radius:20px;font-size:10px;text-decoration:none;font-weight:700;">CONVERTIR</a>
                    ';
                }

                // WhatsApp protegido
                $tipo_ws = ($est == 32) ? "NOTA ANULADA" : "NOTA DE VENTA";
                $link_pago = "https://majalustore.com/sound/vista_previa.php?id_factura=".$id."&hash=".$hash_seguridad;
                $mensaje_ws = "Hola *$cliente*, le enviamos su *$tipo_ws* *$nro*. Véala aquí de forma segura: $link_pago";
                
                $ws_action = (!empty($tel) && strlen($tel) >= 9) 
                    ? 'href="https://api.whatsapp.com/send?phone=51'.$tel.'&text='.urlencode($mensaje_ws).'" target="_blank"' 
                    : 'href="javascript:void(0);" onclick="solicitar_numero_ws(\''.urlencode($mensaje_ws).'\')"';
                ?>
                <tr>
                    <td><b><?php echo $nro; ?></b></td>
                    <td><?php echo $fecha; ?></td>
                    <td><?php echo $cliente; ?></td>
                    <td><?php echo $columna_vendedor; ?></td>
                    <td class="text-center"><?php echo $label_estado; ?></td>
                    <td class="text-center"><b><?php echo $moneda_simbolo; ?> <?php echo number_format($total,2); ?></b></td>
                    <td class="text-center">
                        <button onclick="mostrar_modal_premium('<?php echo $id;?>', '<?php echo $hash_seguridad;?>')" class="btn-circle-sc btn-premium" title="Ver Nota"><i class="fa fa-eye"></i></button>
                        <button onclick="mostrar_modal_ticket('<?php echo $id;?>', '<?php echo $hash_seguridad;?>')" class="btn-circle-sc btn-ticket" title="Ticket"><i class="fa fa-print"></i></button>
                        <a <?php echo $ws_action; ?> class="btn-circle-sc btn-whatsapp" title="WhatsApp"><i class="fab fa-whatsapp"></i></a>
                    </td>
                    <td class="text-right">
                        <?php echo $btn_acciones; ?>
                    </td>
                </tr>
            <?php } ?>
            </tbody>
          </table>
          <div class="text-right"><?php echo paginate("", $page, $total_pages, $adjacents); ?></div>
        </div>
        <?php
    }
}
?>