<?php
session_start();
include('is_logged.php'); // O tu validación de sesión habitual
require_once ("../config/db.php");
require_once ("../config/conexion.php");

$action = (isset($_REQUEST['action'])&& $_REQUEST['action'] !=NULL)?$_REQUEST['action']:'';

if($action == 'ajax'){
    // Escape de variables para prevenir SQL Injection
    $q = mysqli_real_escape_string($con,(strip_tags($_REQUEST['q'], ENT_QUOTES)));
    $fecha_ini = mysqli_real_escape_string($con,(strip_tags($_REQUEST['fecha_ini'], ENT_QUOTES)));
    $fecha_fin = mysqli_real_escape_string($con,(strip_tags($_REQUEST['fecha_fin'], ENT_QUOTES)));
    $forma_pago = intval($_REQUEST['forma_pago']);
    $tienda = intval($_REQUEST['tienda']);

    // Construcción de la consulta
    // ven_com = 2 asegura que sean PAGOS DE COMPRAS (no ventas)
    $sTable = "pagos p, facturas f, clientes c";
    $sWhere = "WHERE p.id_factura = f.id_factura AND f.id_cliente = c.id_cliente AND f.ven_com = 2";
    
    // Filtros
    if ( $_GET['q'] != "" ){
        $sWhere.= " AND (c.nombre_cliente LIKE '%$q%' OR f.numero_factura LIKE '%$q%')";
    }
    if ( $_GET['fecha_ini'] != "" && $_GET['fecha_fin'] != "" ){
        $sWhere.= " AND DATE(p.fecha_pago) BETWEEN '$fecha_ini' AND '$fecha_fin'";
    }
    if ( $forma_pago > 0 ){
        $sWhere.= " AND p.forma_pago = '$forma_pago'";
    }
    if ( $tienda > 0 ){
        $sWhere.= " AND p.tienda = '$tienda'";
    }

    $sWhere.=" ORDER BY p.fecha_pago DESC";
    
    // Paginación
    include 'pagination.php'; 
    $page = (isset($_REQUEST['page']) && !empty($_REQUEST['page']))?$_REQUEST['page']:1;
    $per_page = 15; 
    $adjacents  = 4; 
    $offset = ($page - 1) * $per_page;
    
    // Contar total
    $count_query = mysqli_query($con, "SELECT count(*) AS numrows FROM $sTable $sWhere");
    $row= mysqli_fetch_array($count_query);
    $numrows = $row['numrows'];
    $total_pages = ceil($numrows/$per_page);
    $reload = './reporte_pagos_compras.php';

    // Obtener datos
    $sql="SELECT p.id_pago, p.fecha_pago, p.importe_pago, p.forma_pago, f.numero_factura, c.nombre_cliente, p.tienda 
          FROM $sTable $sWhere LIMIT $offset,$per_page";
    $query = mysqli_query($con, $sql);
    
    // Calcular Total General de la consulta (para el footer)
    $sql_total = "SELECT SUM(p.importe_pago) as total_filtrado FROM $sTable $sWhere";
    $query_total = mysqli_query($con, $sql_total);
    $row_total = mysqli_fetch_array($query_total);
    $gran_total = $row_total['total_filtrado'];

    if ($numrows>0){
        ?>
        <div class="table-responsive" style="margin-top: 10px;">
            <table class="table table-hover table-striped" style="border:1px solid #f1f5f9;">
                <thead style="background: #f8fafc; color: #475569;">
                    <tr>
                        <th class='text-center'>Fecha</th>
                        <th>Proveedor</th>
                        <th>Documento Ref.</th>
                        <th>Método Pago</th>
                        <th class='text-center'>Tienda</th>
                        <th class='text-right'>Monto Pagado</th>
                    </tr>
                </thead>
                <tbody>
                <?php
                while ($row=mysqli_fetch_array($query)){
                        $id_pago=$row['id_pago'];
                        $fecha=date("d/m/Y", strtotime($row['fecha_pago']));
                        $proveedor=$row['nombre_cliente'];
                        $doc=$row['numero_factura'];
                        $monto=$row['importe_pago'];
                        $id_tienda=$row['tienda'];
                        
                        // Formateo de método de pago
                        $forma_pago_txt = "";
                        $badge_class = "";
                        switch ($row['forma_pago']) {
                            case 1: $forma_pago_txt="Efectivo"; $badge_class="bg-efectivo"; break;
                            case 2: $forma_pago_txt="Transferencia"; $badge_class="bg-banco"; break;
                            case 3: $forma_pago_txt="Yape / Plin"; $badge_class="bg-app"; break;
                            case 4: $forma_pago_txt="Tarjeta"; $badge_class="bg-tarjeta"; break;
                            default: $forma_pago_txt="Otro"; $badge_class="bg-efectivo"; break;
                        }
                        
                        // Obtener nombre de tienda para mostrar (opcional si quieres nombre en vez de ID)
                        $nom_tienda = "Tienda $id_tienda"; // Fallback
                        // Aquí podrías hacer una query rápida a sucursal si quieres el nombre exacto por fila, 
                        // pero por rendimiento a veces es mejor dejar el número o traerlo en el JOIN principal.
                    ?>
                    <tr>
                        <td class='text-center'><?php echo $fecha; ?></td>
                        <td style="font-weight:600; color:#0a2463;"><?php echo $proveedor; ?></td>
                        <td><?php echo $doc; ?></td>
                        <td><span class="badge-pago <?php echo $badge_class; ?>"><?php echo $forma_pago_txt; ?></span></td>
                        <td class='text-center'><?php echo $nom_tienda; ?></td>
                        <td class='text-right' style="font-weight:bold;"><?php echo "S/ ".number_format($monto,2); ?></td>
                    </tr>
                    <?php
                }
                ?>
                <tr style="background-color: #dce3f5; color: white;">
                    <td colspan="5" class="text-right" style="font-weight:bold; padding-right: 20px;">TOTAL EGRESOS REGISTRADOS:</td>
                    <td class="text-right" style="font-weight:bold; font-size:16px;"><?php echo "S/ ".number_format($gran_total,2); ?></td>
                </tr>
                </tbody>
            </table>
        </div>
        <div class="table-pagination text-right">
            <?php echo paginate($reload, $page, $total_pages, $adjacents); ?>
        </div>
        <?php
    } else {
        ?>
        <div class="alert alert-warning alert-dismissible" role="alert" style="margin-top:20px; border-radius:8px;">
          <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
          <strong>Aviso!</strong> No se encontraron pagos realizados con los filtros seleccionados.
        </div>
        <?php
    }
}
?>