<?php
/**
 * AJAX - BUSCAR PRODUCTO STOCK GLOBAL
 * Muestra el producto y en qué sucursales/almacenes se encuentra.
 */
include('is_logged.php');
require_once ("../config/db.php");
require_once ("../config/conexion.php");

$action = (isset($_REQUEST['action']) && $_REQUEST['action'] != NULL) ? $_REQUEST['action'] : '';

if($action == 'ajax'){
    $q = mysqli_real_escape_string($con, (strip_tags($_REQUEST['q'], ENT_QUOTES)));
    $sTable = "products";
    
    // Solo mostramos productos (pro_ser = 1 asumiendo que es producto físico)
    $sWhere = " WHERE 1=1 ";
    
    if ( $q != "" ){
        $sWhere .= " AND (nombre_producto LIKE '%$q%' OR codigo_producto LIKE '%$q%' OR barras LIKE '%$q%')";
    }
    
    $sWhere .= " ORDER BY nombre_producto ASC LIMIT 10"; // Limitamos a 10 resultados para no saturar

    $query = mysqli_query($con, "SELECT * FROM $sTable $sWhere");
    $numrows = mysqli_num_rows($query);

    // OBTENEMOS TODAS LAS SUCURSALES ACTIVAS
    $sucursales = [];
    $q_suc = mysqli_query($con, "SELECT tienda, nombre, nombre_stand, tipo_sucursal FROM sucursal ORDER BY tipo_sucursal DESC, tienda ASC");
    while($suc = mysqli_fetch_array($q_suc)) {
        $sucursales[] = $suc;
    }

    if ($numrows > 0){
        ?>
        <style>
            .prod-card { background: white; border: 1px solid #e2e8f0; border-radius: 12px; padding: 15px; margin-bottom: 15px; box-shadow: 0 2px 4px rgba(0,0,0,0.02); display: flex; flex-direction: column; }
            .prod-header { display: flex; justify-content: space-between; border-bottom: 1px solid #f1f5f9; padding-bottom: 10px; margin-bottom: 15px; }
            .prod-title { font-weight: 800; color: #1e293b; font-size: 16px; margin: 0; }
            .prod-code { color: #94a3b8; font-size: 12px; background: #f8fafc; padding: 3px 8px; border-radius: 4px; border: 1px solid #e2e8f0; }
            .prod-price { font-weight: 800; color: #10b981; font-size: 16px; margin: 0; }
            
            .stock-grid { display: grid; grid-template-columns: repeat(auto-fill, minmax(200px, 1fr)); gap: 10px; }
            .stock-item { background: #f8fafc; border: 1px solid #e2e8f0; padding: 10px 15px; border-radius: 8px; display: flex; justify-content: space-between; align-items: center; }
            .stock-name { font-size: 12px; font-weight: 700; color: #475569; }
            .badge-tienda { background: #3b82f6; color: white; font-size: 9px; padding: 2px 5px; border-radius: 4px; text-transform: uppercase; margin-right: 5px; }
            .badge-almacen { background: #f59e0b; color: white; font-size: 9px; padding: 2px 5px; border-radius: 4px; text-transform: uppercase; margin-right: 5px; }
            .stock-qty { font-weight: 800; font-size: 15px; }
            .stock-zero { color: #ef4444; }
            .stock-ok { color: #10b981; }
        </style>
        
        <?php
        while ($row = mysqli_fetch_array($query)){
            $id_producto = $row['id_producto'];
            $codigo_producto = $row['codigo_producto'];
            $nombre_producto = $row['nombre_producto'];
            $precio = $row['precio_producto'];
            
            echo '<div class="prod-card">';
                echo '<div class="prod-header">';
                    echo '<div>';
                        echo '<h4 class="prod-title"><i class="fa fa-cube" style="color:#8e44ad; margin-right:5px;"></i> '.$nombre_producto.'</h4>';
                        echo '<span class="prod-code"><i class="fa fa-barcode"></i> CÓD: '.$codigo_producto.'</span>';
                    echo '</div>';
                    echo '<div><h4 class="prod-price">S/ '.number_format($precio, 2).'</h4></div>';
                echo '</div>';

                echo '<div class="stock-grid">';
                // Iteramos sobre las sucursales para ver el stock de este producto en cada una
                foreach ($sucursales as $s) {
                    $numero_tienda = $s['tienda']; 
                    $columna_stock = 'b'.$numero_tienda; // Ejemplo: b1, b2, b3
                    
                    // Aseguramos que exista la columna en la tabla por si es un error de BD
                    $stock_actual = isset($row[$columna_stock]) ? floatval($row[$columna_stock]) : 0;
                    
                    $nombre_mostrar = (!empty($s['nombre_stand'])) ? $s['nombre_stand'] : $s['nombre'];
                    $es_almacen = ($s['tipo_sucursal'] == 2);
                    $badge = $es_almacen ? '<span class="badge-almacen"><i class="fa fa-archive"></i> ALM</span>' : '<span class="badge-tienda"><i class="fa fa-shopping-bag"></i> TIE</span>';
                    
                    $color_class = ($stock_actual > 0) ? 'stock-ok' : 'stock-zero';
                    
                    echo '<div class="stock-item">';
                        echo '<div class="stock-name">'.$badge.' '.$nombre_mostrar.'</div>';
                        echo '<div class="stock-qty '.$color_class.'">'.$stock_actual.'</div>';
                    echo '</div>';
                }
                echo '</div>';
            echo '</div>';
        }
    } else {
        ?>
        <div class="alert alert-warning" style="background: white; border: 2px dashed #f59e0b; color: #b45309; border-radius: 12px; padding: 20px; text-align: center;">
            <i class="fa fa-exclamation-triangle fa-3x" style="margin-bottom: 10px; opacity: 0.5;"></i>
            <h4 style="font-weight: 800; margin:0;">Producto no encontrado</h4>
            <p style="margin:0;">No hay resultados que coincidan con "<strong><?php echo htmlspecialchars($q); ?></strong>". Revisa el código o nombre escrito.</p>
        </div>
        <?php
    }
}
?>