<?php
    include('is_logged.php');
    require_once ("../config/db.php");
    require_once ("../config/conexion.php");

    $tienda1 = $_SESSION['tienda'];
    $action = (isset($_REQUEST['action']) && $_REQUEST['action'] != NULL) ? $_REQUEST['action'] : '';

    // --- 1. LÓGICA DE ACTIVAR / DESACTIVAR ---
    if (isset($_GET['id'])){
        $id_proveedor = intval($_GET['id']);
        
        // Consultar estado actual
        $sql_estado = mysqli_query($con, "SELECT status_cliente FROM clientes WHERE id_cliente='".$id_proveedor."'");
        $row_estado = mysqli_fetch_array($sql_estado);
        $estado_actual = $row_estado['status_cliente'];
        
        // Invertir estado
        $nuevo_estado = ($estado_actual == 1) ? 0 : 1;
        $mensaje_accion = ($nuevo_estado == 1) ? "Activado" : "Desactivado";
        $tipo_alerta = ($nuevo_estado == 1) ? "success" : "warning";
        $icono_alerta = ($nuevo_estado == 1) ? "fa-check-circle" : "fa-ban";

        if ($update = mysqli_query($con, "UPDATE clientes SET status_cliente='$nuevo_estado' WHERE id_cliente='".$id_proveedor."'")){
            ?>
            <div class="alert alert-<?php echo $tipo_alerta; ?> alert-dismissible" role="alert" style="border-radius: 8px;">
              <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
              <strong><i class="fa <?php echo $icono_alerta; ?>"></i> Éxito:</strong> Proveedor <?php echo $mensaje_accion; ?> correctamente.
            </div>
            <?php 
        } else {
            ?>
            <div class="alert alert-danger alert-dismissible" role="alert" style="border-radius: 8px;">
              <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
              <strong>Error!</strong> No se pudo actualizar el estado.
            </div>
            <?php
        }
    }

    // --- 2. TABLA ---
    if($action == 'ajax'){
        $sTable = "clientes";
        $q = mysqli_real_escape_string($con,(strip_tags($_REQUEST['q'], ENT_QUOTES)));
        
        include 'pagination.php'; 
        $page = (isset($_REQUEST['page']) && !empty($_REQUEST['page'])) ? $_REQUEST['page'] : 1;
        $per_page = 10; 
        $adjacents  = 4; 
        $offset = ($page - 1) * $per_page;

        $sWhere = " WHERE tipo1=2";
        if ( $_GET['q'] != "" ){
            $sWhere.= " AND (nombre_cliente LIKE '%$q%' OR documento LIKE '%$q%' OR telefono_cliente LIKE '%$q%')";
        }
        
        $count_query = mysqli_query($con, "SELECT count(*) AS numrows FROM $sTable $sWhere");
        $row = mysqli_fetch_array($count_query);
        $numrows = $row['numrows'];
        $total_pages = ceil($numrows/$per_page);
        $reload = './proveedores.php';

        $sql = "SELECT * FROM $sTable $sWhere ORDER BY nombre_cliente ASC LIMIT $offset,$per_page";
        $query = mysqli_query($con, $sql);

        if ($numrows > 0){
            ?>
            <style>
                /* BOTONES CIRCULARES */
                .btn-circle {
                    width: 32px;
                    height: 32px;
                    padding: 0;
                    border-radius: 50%;
                    text-align: center;
                    font-size: 14px;
                    line-height: 32px;
                    margin: 0 3px;
                    border: none;
                    color: white !important;
                    box-shadow: 0 2px 5px rgba(0,0,0,0.15);
                    transition: all 0.2s ease;
                    display: inline-block;
                }
                .btn-circle:hover {
                    transform: translateY(-2px);
                    box-shadow: 0 4px 8px rgba(0,0,0,0.2);
                }
                
                .btn-orange { background: #F39C12; }
                .btn-red { background: #E74C3C; }    /* Desactivar */
                .btn-green { background: #27AE60; }  /* Activar */

                /* ESTILO DE TABLA */
                .table-clean { width: 100%; border-collapse: separate; border-spacing: 0; }
                
                /* HEADER AZUL PETRÓLEO (#007B9E) */
                .table-clean thead th {
                    background-color: #007B9E; 
                    color: white;
                    padding: 12px 15px;
                    border: none;
                    font-weight: 600;
                    text-transform: uppercase;
                    font-size: 12px;
                }
                
                /* SIN BORDES VERTICALES */
                .table-clean tbody td {
                    border-bottom: 1px solid #E5E7EB;
                    padding: 12px 15px;
                    color: #555;
                    font-size: 13px;
                    vertical-align: middle;
                }
                
                .table-clean tbody tr:hover { background-color: #F8FAFC; }
            </style>

            <div class="table-responsive" style="background: white; border-radius: 8px; overflow: hidden; box-shadow: 0 1px 3px rgba(0,0,0,0.1);">
                <table class="table-clean">
                    <thead>
                        <tr>
                            <th style="width: 35%;">Razón Social / Nombre</th>
                            <th style="width: 15%;">Documento</th>
                            <th style="width: 10%;">Tipo</th>
                            <th style="width: 15%;">Teléfono</th>
                            <th style="width: 10%; text-align: center;">Estado</th>
                            <th style="width: 15%; text-align: center;">Acciones</th>
                        </tr>
                    </thead>
                    <tbody>
                    <?php
                    while ($row=mysqli_fetch_array($query)){
                        $id_cliente=$row['id_cliente'];
                        $nombre_cliente=$row['nombre_cliente'];
                        $telefono_cliente=$row['telefono_cliente'];
                        $email_cliente=$row['email_cliente'];
                        $direccion_cliente=$row['direccion_cliente'];
                        $documento=$row['documento'];
                        $status_cliente=$row['status_cliente'];
                        
                        // Datos para modal
                        $dni=$row['dni'];
                        $departamento=$row['departamento'];
                        $provincia=$row['provincia'];
                        $distrito=$row['distrito'];
                        $cuenta=$row['cuenta'];
                        $vendedor=$row['vendedor'];
                        
                        // Tipo Documento
                        $tipo_visual = "OTRO";
                        $tipo_val_modal = 1;
                        if(!empty($row['ruc']) || strlen($documento)==11){
                             $tipo_visual = "RUC"; $tipo_val_modal = 2;
                        } elseif(!empty($row['dni']) || strlen($documento)==8){
                             $tipo_visual = "DNI"; $tipo_val_modal = 1;
                        }

                        // LÓGICA DE BOTÓN INTELIGENTE
                        if ($status_cliente==1){
                            // ESTÁ ACTIVO -> MOSTRAR BOTÓN ROJO PARA APAGAR
                            $estado_label="<span class='label label-success' style='border-radius:10px;'>ACTIVO</span>";
                            $btn_clase = "btn-red";
                            $btn_icono = "fa-power-off"; 
                            $btn_titulo = "Desactivar Proveedor";
                        } else {
                            // ESTÁ INACTIVO -> MOSTRAR BOTÓN VERDE PARA ENCENDER
                            $estado_label="<span class='label label-danger' style='border-radius:10px;'>INACTIVO</span>";
                            $btn_clase = "btn-green";
                            $btn_icono = "fa-power-off";
                            $btn_titulo = "Activar Proveedor";
                        }
                    ?>
                        <input type="hidden" value="<?php echo $nombre_cliente;?>" id="nombre_cliente<?php echo $id_cliente;?>">
                        <input type="hidden" value="<?php echo $telefono_cliente;?>" id="telefono_cliente<?php echo $id_cliente;?>">
                        <input type="hidden" value="<?php echo $email_cliente;?>" id="email_cliente<?php echo $id_cliente;?>">
                        <input type="hidden" value="<?php echo $documento;?>" id="doc<?php echo $id_cliente;?>">
                        <input type="hidden" value="<?php echo $vendedor;?>" id="vendedor<?php echo $id_cliente;?>">
                        <input type="hidden" value="<?php echo $direccion_cliente;?>" id="direccion_cliente<?php echo $id_cliente;?>">
                        <input type="hidden" value="<?php echo $status_cliente;?>" id="status_cliente<?php echo $id_cliente;?>">
                        <input type="hidden" value="<?php echo $dni;?>" id="dni<?php echo $id_cliente;?>">
                        <input type="hidden" value="<?php echo $departamento;?>" id="departamento<?php echo $id_cliente;?>">
                        <input type="hidden" value="<?php echo $provincia;?>" id="provincia<?php echo $id_cliente;?>">
                        <input type="hidden" value="<?php echo $distrito;?>" id="distrito<?php echo $id_cliente;?>">
                        <input type="hidden" value="<?php echo $cuenta;?>" id="cuenta<?php echo $id_cliente;?>">
                        <input type="hidden" value="<?php echo $tipo_val_modal;?>" id="tipo<?php echo $id_cliente;?>">    

                        <tr>
                            <td style="font-weight: 500; color: #333;"><?php echo $nombre_cliente;?></td>
                            <td><?php echo $documento;?></td>
                            <td><?php echo $tipo_visual;?></td>
                            <td><?php echo $telefono_cliente;?></td>
                            <td style="text-align: center;"><?php echo $estado_label;?></td>
                            <td style="text-align: center;">
                                <a href="#" class='btn-circle btn-orange' title='Editar' onclick="obtener_datos('<?php echo $id_cliente;?>');" data-toggle="modal" data-target="#myModal2">
                                    <i class="fa fa-pencil"></i>
                                </a> 
                                
                                <a href="#" class='btn-circle <?php echo $btn_clase; ?>' title='<?php echo $btn_titulo; ?>' onclick="eliminar('<?php echo $id_cliente; ?>', '<?php echo $status_cliente; ?>')">
                                    <i class="fa <?php echo $btn_icono; ?>"></i>
                                </a>
                            </td>   
                        </tr>
                        <?php
                    }
                    ?>
                    </tbody>
                </table>
            </div>
            <div class="table-pagination text-right" style="margin-top: 15px;">
                <?php echo paginate($reload, $page, $total_pages, $adjacents);?>
            </div>
            <?php
        } else {
            ?>
            <div class="alert alert-info" style="background: white; color: #475569; border: 1px solid #e2e8f0; border-radius: 8px; margin-top: 10px;">
              <i class="fa fa-info-circle" style="color: #007B9E;"></i> No se encontraron proveedores.
            </div>
            <?php
        }
    }
?>