<?php
include('is_logged.php');
require_once ("../config/db.php");
require_once ("../config/conexion.php");

$action = (isset($_REQUEST['action']) && $_REQUEST['action'] != NULL) ? $_REQUEST['action'] : '';

if($action == 'ajax'){
    $inicio = mysqli_real_escape_string($con, (strip_tags($_REQUEST['inicio'], ENT_QUOTES)));
    $fin = mysqli_real_escape_string($con, (strip_tags($_REQUEST['fin'], ENT_QUOTES)));
    $q = mysqli_real_escape_string($con, (strip_tags($_REQUEST['q'], ENT_QUOTES)));
    
    // CONSULTA INTELIGENTE (JOIN de 3 tablas)
    // Buscamos en PAGOS, pero traemos datos del CLIENTE y la FACTURA asociada
    $sTable = "pagos p 
               INNER JOIN facturas f ON p.id_factura = f.id_factura 
               INNER JOIN clientes c ON f.id_cliente = c.id_cliente";
               
    $sWhere = " WHERE p.tienda=".$_SESSION['tienda'];
    
    // Filtro Fechas (DE LOS PAGOS, NO DE LA FACTURA)
    if ($inicio != "" && $fin != ""){
        $sWhere .= " AND p.fecha_pago BETWEEN '$inicio' AND '$fin'";
    }
    
    // Filtro Proveedor
    if ($q != ""){
        $sWhere .= " AND c.nombre_cliente LIKE '%$q%'";
    }
    
    $sWhere .= " ORDER BY p.fecha_pago DESC, p.id_pago DESC";
    
    // Paginación
    include 'pagination.php';
    $page = (isset($_REQUEST['page']) && !empty($_REQUEST['page'])) ? $_REQUEST['page'] : 1;
    $per_page = 20; // Mostramos más registros por página
    $adjacents = 4;
    $offset = ($page - 1) * $per_page;
    
    $count_query = mysqli_query($con, "SELECT count(*) AS numrows FROM $sTable $sWhere");
    if (!$count_query) { die("Error SQL: ".mysqli_error($con)); }
    $row = mysqli_fetch_array($count_query);
    $numrows = $row['numrows'];
    $total_pages = ceil($numrows/$per_page);
    $reload = './reporte_pagos.php';
    
    // Consulta Datos
    $sql = "SELECT p.fecha_pago, p.importe_pago, p.forma_pago, f.numero_factura, c.nombre_cliente 
            FROM $sTable $sWhere LIMIT $offset,$per_page";
    $query = mysqli_query($con, $sql);
    
    // Consulta para el TOTAL GLOBAL del rango seleccionado (sin paginación)
    $sql_total = mysqli_query($con, "SELECT SUM(p.importe_pago) as total_rango FROM $sTable $sWhere");
    $rw_total = mysqli_fetch_array($sql_total);
    $total_global = $rw_total['total_rango'];
    
    if ($numrows > 0){
        ?>
        <style>
            .table-report th { background: #f1f5f9; color: #475569; font-weight: 700; text-transform: uppercase; font-size: 11px; }
            .table-report td { font-size: 13px; color: #334155; vertical-align: middle; }
            .amount-text { color: #0a2463; font-weight: 700; }
        </style>

        <div class="table-responsive">
            <table class="table table-hover table-report">
                <thead>
                    <tr>
                        <th>Fecha Pago</th>
                        <th>Proveedor</th>
                        <th>Ref. Compra (Doc)</th>
                        <th>Método</th>
                        <th class="text-right">Monto Pagado</th>
                    </tr>
                </thead>
                <tbody>
                <?php
                while ($row = mysqli_fetch_array($query)){
                    $fecha = date("d/m/Y", strtotime($row['fecha_pago']));
                    $cliente = $row['nombre_cliente'];
                    $doc = strtoupper($row['numero_factura']);
                    $monto = floatval($row['importe_pago']);
                    $forma = $row['forma_pago'];
                    
                    switch ($forma) {
                        case 1: $f_pago = "Efectivo"; break;
                        case 2: $f_pago = "Transferencia"; break;
                        case 3: $f_pago = "Yape/Plin"; break;
                        case 4: $f_pago = "Tarjeta"; break;
                        default: $f_pago = "Otro"; break;
                    }
                ?>
                    <tr>
                        <td><?php echo $fecha; ?></td>
                        <td><?php echo $cliente; ?></td>
                        <td><?php echo $doc; ?></td>
                        <td><span class="label label-default" style="background:#e2e8f0; color:#475569;"><?php echo $f_pago; ?></span></td>
                        <td class="text-right amount-text">S/ <?php echo number_format($monto, 2); ?></td>
                    </tr>
                <?php
                }
                ?>
                </tbody>
            </table>
        </div>
        
        <div class="row">
            <div class="col-md-6">
                <div class="table-pagination">
                    <?php echo paginate($reload, $page, $total_pages, $adjacents); ?>
                </div>
            </div>
            <div class="col-md-6">
                <div class="total-floating">
                    Total Egresos en este periodo: S/ <?php echo number_format($total_global, 2); ?>
                </div>
            </div>
        </div>
        <?php
    } else {
        ?>
        <div class="alert alert-warning" style="border-radius:8px;">
            <i class="fa fa-info-circle"></i> No se encontraron pagos realizados en las fechas seleccionadas.
        </div>
        <?php
    }
}
?>