<?php
    require_once ("../config/db.php");
    require_once ("../config/conexion.php");
    include('is_logged.php');

    $action = (isset($_REQUEST['action']) && $_REQUEST['action'] != NULL) ? $_REQUEST['action'] : '';

    // --- ELIMINAR ---
    if (isset($_GET['id'])){
        $id_sucursal = intval($_GET['id']);
        $query=mysqli_query($con, "SELECT * from caja where tienda='".$id_sucursal."'");
        $count=mysqli_num_rows($query);

        if ($count == 0){
            if ($delete1=mysqli_query($con,"DELETE FROM sucursal WHERE id_sucursal='".$id_sucursal."'")){
                ?>
                <div class="alert alert-success alert-dismissible" role="alert" style="border-radius: 8px;">
                  <button type="button" class="close" data-dismiss="alert">&times;</button>
                  <strong><i class="fa fa-check-circle"></i></strong> Eliminado correctamente.
                </div>
                <?php 
            } else {
                ?>
                <div class="alert alert-danger alert-dismissible" role="alert" style="border-radius: 8px;">
                  <button type="button" class="close" data-dismiss="alert">&times;</button>
                  <strong>Error!</strong> No se pudo eliminar.
                </div>
                <?php	
            }	
        } else {
            ?>
            <div class="alert alert-warning alert-dismissible" role="alert" style="border-radius: 8px;">
              <button type="button" class="close" data-dismiss="alert">&times;</button>
              <strong>Aviso:</strong> Tiene registros asociados (Caja, Usuarios, etc).
            </div>
            <?php
        }	
    }

    // --- LISTAR ---
    if($action == 'ajax'){
        $q = mysqli_real_escape_string($con,(strip_tags($_REQUEST['q'], ENT_QUOTES)));
        $sTable = "sucursal";
        $sWhere = "";
        
        // Búsqueda inteligente
        if ( $_GET['q'] != "" ){
            $sWhere = " WHERE (nombre LIKE '%$q%' OR nombre_stand LIKE '%$q%' OR ruc LIKE '%$q%')";
        }
        $sWhere .= " ORDER BY tienda ASC";

        include 'pagination.php'; 
        $page = (isset($_REQUEST['page']) && !empty($_REQUEST['page'])) ? $_REQUEST['page'] : 1;
        $per_page = 10; 
        $adjacents  = 4; 
        $offset = ($page - 1) * $per_page;
        
        $count_query = mysqli_query($con, "SELECT count(*) AS numrows FROM $sTable $sWhere");
        $row = mysqli_fetch_array($count_query);
        $numrows = $row['numrows'];
        $total_pages = ceil($numrows/$per_page);
        $reload = './sucursal.php';

        $sql = "SELECT * FROM $sTable $sWhere LIMIT $offset,$per_page";
        $query = mysqli_query($con, $sql);

        if ($numrows > 0){
            ?>
            <style>
                .btn-circle {
                    width: 32px; height: 32px; padding: 0; border-radius: 50%;
                    text-align: center; font-size: 14px; line-height: 32px;
                    margin: 0 2px; border: none; color: white !important;
                    box-shadow: 0 2px 5px rgba(0,0,0,0.15); transition: all 0.2s ease;
                    display: inline-block;
                }
                .btn-circle:hover { transform: translateY(-2px); box-shadow: 0 4px 8px rgba(0,0,0,0.2); }
                
                .btn-orange { background: #F39C12; }
                .btn-red { background: #E74C3C; }
                .btn-purple { background: #8E44AD; } 

                .table-clean { width: 100%; border-collapse: separate; border-spacing: 0; }
                .table-clean thead th {
                    background-color: #007B9E; color: white; padding: 12px 15px; border: none;
                    font-weight: 600; text-transform: uppercase; font-size: 12px;
                }
                .table-clean tbody td {
                    border-bottom: 1px solid #E5E7EB; padding: 12px 15px;
                    color: #555; font-size: 13px; vertical-align: middle;
                }
                .table-clean tbody tr:hover { background-color: #F8FAFC; }
                
                .stand-name { font-weight: 700; color: #0a2463; font-size: 14px; }
                .badge-tienda { background-color: #10b981; color: white; padding: 3px 8px; border-radius: 12px; font-size: 10px; font-weight: bold; text-transform: uppercase; }
                .badge-almacen { background-color: #f59e0b; color: white; padding: 3px 8px; border-radius: 12px; font-size: 10px; font-weight: bold; text-transform: uppercase; }
            </style>

            <div class="table-responsive" style="background: white; border-radius: 8px; overflow: hidden; box-shadow: 0 1px 3px rgba(0,0,0,0.1); margin-top: 10px;">
                <table class="table-clean">
                    <thead>
                        <tr>
                            <th style="width: 80px;">LOGO</th>
                            <th>STAND / TIENDA</th>
                            <th>RUC</th>
                            <th class="text-center" style="width: 150px;">ACCIONES</th>
                        </tr>
                    </thead>
                    <tbody>
                    <?php
                    while ($row=mysqli_fetch_array($query)){
                        $id_sucursal=$row['id_sucursal'];
                        $nombre=$row['nombre']; 
                        
                        $nombre_stand = isset($row['nombre_stand']) && !empty($row['nombre_stand']) ? $row['nombre_stand'] : $nombre;
                        
                        $ruc=$row['ruc'];
                        $direccion=$row['direccion'];
                        $correo=$row['correo'];
                        $telefono=$row['telefono'];
                        $ubigeo=$row['ubigeo'];
                        $departamento=$row['dep_suc'];
                        $provincia=$row['pro_suc'];
                        $distrito=$row['dis_suc'];
                        $foto=$row['foto'];
                        $tien=$row['tienda'];
                        $tipo_sucursal = isset($row['tipo_sucursal']) ? $row['tipo_sucursal'] : 1; // NUEVO
                        
                        if(empty($foto)){ $foto1="logo.jpg"; } else { $foto1=$foto; }
                        ?>

                        <input type="hidden" value="<?php echo $nombre;?>" id="nombre<?php echo $id_sucursal;?>">
                        <input type="hidden" value="<?php echo $nombre_stand;?>" id="nombre_stand<?php echo $id_sucursal;?>">
                        <input type="hidden" value="<?php echo $ruc;?>" id="ruc<?php echo $id_sucursal;?>">
                        <input type="hidden" value="<?php echo $direccion;?>" id="direccion<?php echo $id_sucursal;?>">
                        <input type="hidden" value="<?php echo $correo;?>" id="correo<?php echo $id_sucursal;?>">
                        <input type="hidden" value="<?php echo $telefono;?>" id="telefono<?php echo $id_sucursal;?>">
                        <input type="hidden" value="<?php echo $ubigeo;?>" id="ubigeo<?php echo $id_sucursal;?>">
                        <input type="hidden" value="<?php echo $departamento;?>" id="departamento<?php echo $id_sucursal;?>">
                        <input type="hidden" value="<?php echo $provincia;?>" id="provincia<?php echo $id_sucursal;?>">
                        <input type="hidden" value="<?php echo $distrito;?>" id="distrito<?php echo $id_sucursal;?>">
                        <input type="hidden" value="<?php echo $tipo_sucursal;?>" id="tipo_sucursal<?php echo $id_sucursal;?>">

                        <tr>
                            <td>
                                <img src="pdf/documentos/<?php echo $foto1; ?>" style="width: 40px; height: 40px; border-radius: 50%; object-fit: cover; border: 1px solid #ddd;">
                            </td>
                            
                            <td class="stand-name">
                                <i class="fa <?php echo ($tipo_sucursal == 2) ? 'fa-archive' : 'fa-shopping-bag'; ?>" style="color:#2473f2; margin-right:5px;"></i> 
                                <?php echo $nombre_stand; ?> 
                                <?php if($tipo_sucursal == 2) { echo "<span class='badge-almacen'>Almacén</span>"; } else { echo "<span class='badge-tienda'>Tienda</span>"; } ?>
                                <div style="font-weight:400; font-size:11px; color:#999; margin-top:2px;"><?php echo $direccion; ?></div>
                            </td>
                            
                            <td><?php echo $ruc; ?></td>
                            
                            <td class="text-center">
                                <a href="#" class='btn-circle btn-purple' title='Cambiar Logo' onclick="cambiar_logo('<?php echo $id_sucursal;?>', '<?php echo $nombre_stand;?>', '<?php echo $foto1;?>');" data-toggle="modal" data-target="#modal_logo">
                                    <i class="fa fa-image"></i>
                                </a>
                                <a href="#" class='btn-circle btn-orange' title='Editar' onclick="obtener_datos('<?php echo $id_sucursal;?>');" data-toggle="modal" data-target="#myModal2">
                                    <i class="fa fa-pencil"></i>
                                </a>
                                <a href="#" class='btn-circle btn-red' title='Eliminar' onclick="eliminar('<?php echo $id_sucursal; ?>')">
                                    <i class="fa fa-trash"></i>
                                </a>
                            </td>
                        </tr>
                        <?php
                    }
                    ?>
                    </tbody>
                </table>
            </div>
            <div class="table-pagination text-right" style="margin-top: 15px;">
                <?php echo paginate($reload, $page, $total_pages, $adjacents);?>
            </div>
            <?php
        } else {
            ?>
            <div class="alert alert-info" style="background: white; border: 1px solid #e2e8f0; border-radius: 8px; margin-top: 10px;">
              <i class="fa fa-info-circle"></i> No hay sucursales registradas.
            </div>
            <?php
        }
    }
?>