<?php
    require_once ("../config/db.php");
    require_once ("../config/conexion.php");
    include('is_logged.php');

    $action = (isset($_REQUEST['action']) && $_REQUEST['action'] != NULL) ? $_REQUEST['action'] : '';

    // --- 1. LÓGICA DE ACTIVAR / DESACTIVAR (CORREGIDA PARA EVITAR DUPLICADO) ---
    if (isset($_GET['id'])){
        $user_id = intval($_GET['id']);
        
        if ($user_id != $_SESSION['user_id']) {
            $sql_estado = mysqli_query($con, "SELECT estado FROM users WHERE user_id='".$user_id."'");
            $row_estado = mysqli_fetch_array($sql_estado);
            $estado_actual = $row_estado['estado'];
            
            $nuevo_estado = ($estado_actual == 1) ? 0 : 1;
            
            if ($update = mysqli_query($con, "UPDATE users SET estado='$nuevo_estado' WHERE user_id='".$user_id."'")){
                $msg_txt = ($nuevo_estado == 1) ? "Usuario activado." : "Usuario desactivado.";
                // Llamada segura a la notificación
                echo "<script>if(typeof mostrar_notificacion === 'function'){ mostrar_notificacion('success', 'Estado', '$msg_txt'); } else { alert('$msg_txt'); }</script>";
            }
        } else {
            echo "<script>if(typeof mostrar_notificacion === 'function'){ mostrar_notificacion('error', 'Denegado', 'No puedes desactivar tu propia cuenta.'); }</script>";
        }
        exit; // CLAVE: Detiene la ejecución para no duplicar la tabla
    }

    // --- 2. CONSULTA Y TABLA ---
    if($action == 'ajax'){
        $sTable = "users";
        $q = mysqli_real_escape_string($con,(strip_tags($_REQUEST['q'], ENT_QUOTES)));
        
        $sWhere = "";
        if ( $_GET['q'] != "" ){
            $sWhere = " WHERE (nombres LIKE '%$q%' OR user_name LIKE '%$q%' OR dni LIKE '%$q%')";
        }
        $sWhere .= " ORDER BY user_id DESC";

        include 'pagination.php'; 
        $page = (isset($_REQUEST['page']) && !empty($_REQUEST['page'])) ? $_REQUEST['page'] : 1;
        $per_page = 10; 
        $adjacents  = 4; 
        $offset = ($page - 1) * $per_page;
        
        $count_query = mysqli_query($con, "SELECT count(*) AS numrows FROM $sTable $sWhere");
        $row = mysqli_fetch_array($count_query);
        $numrows = $row['numrows'];
        $total_pages = ceil($numrows/$per_page);
        $reload = './usuarios.php';

        $sql = "SELECT * FROM $sTable $sWhere LIMIT $offset,$per_page";
        $query = mysqli_query($con, $sql);

        if ($numrows > 0){
            ?>
            <style>
                /* MANTENIENDO TUS BOTONES ORIGINALES */
                .btn-circle-sc {
                    width: 32px; height: 32px; border-radius: 50%; display: inline-flex;
                    align-items: center; justify-content: center; color: white !important;
                    border: none; margin: 0 2px; transition: 0.3s; text-decoration: none;
                }
                .btn-circle-sc:hover { transform: translateY(-2px); box-shadow: 0 4px 8px rgba(0,0,0,0.2); }
                
                .btn-blue-sc { background: #3498DB; }   /* Acceso */
                .btn-teal-sc { background: #00897b; }   /* Documentos */
                .btn-green-sc { background: #27AE60; }  /* Foto / Activar */
                .btn-orange-sc { background: #F39C12; } /* Editar */
                .btn-purple-sc { background: #8E44AD; } /* Clave */
                .btn-red-sc { background: #E74C3C; }    /* Desactivar */

                .table-sc { width: 100%; border-collapse: separate; border-spacing: 0; }
                .table-sc thead th {
                    background-color: #0a2463; color: white; padding: 12px 15px;
                    text-transform: uppercase; font-size: 11px; font-weight: 700; border: none;
                }
                .table-sc tbody td { border-bottom: 1px solid #f1f5f9; padding: 12px 15px; vertical-align: middle; font-size: 13px; }
                
                .label-rol { border-radius: 10px; padding: 4px 10px; font-size: 10px; font-weight: 700; color: white; }
                .label-admin { background: #1e3a8a; } 
                .label-trabajador { background: #3b82f6; } 
                .label-almacenero { background: #10b981; }
                
                .avatar-sc { width: 35px; height: 35px; border-radius: 50%; object-fit: cover; border: 2px solid #e2e8f0; }
            </style>

            <div class="table-responsive" style="background: white; border-radius: 12px; box-shadow: 0 4px 20px rgba(0,0,0,0.05);">
                <table class="table-sc">
                    <thead>
                        <tr>
                            <th style="width: 50px;">Foto</th>
                            <th>Nombres</th>
                            <th class="text-center">Rol</th>
                            <th>Usuario</th>
                            <th>DNI</th>
                            <th class="text-center">Estado</th>
                            <th class="text-right">Acciones</th>
                        </tr>
                    </thead>
                    <tbody>
                    <?php
                    while ($row=mysqli_fetch_array($query)){
                        $user_id=$row['user_id'];
                        $fullname=$row['nombres'];
                        $user_name=$row['user_name'];
                        $user_email=$row['user_email'];
                        $dni=$row['dni'];
                        $tel=$row['telefono'];
                        $sucursal=$row['sucursal'];
                        $foto=$row['foto'];
                        $estado = $row['estado'];
                        $f_nacimiento = $row['f_nacimiento'];
                        
                        // LÓGICA DE ROL DESDE LA NUEVA COLUMNA
                        $rol_id = isset($row['rol']) ? $row['rol'] : 1;
                        if ($rol_id == 2) { $rol_lbl = "<span class='label-rol label-admin'>ADMINISTRADOR</span>"; }
                        elseif ($rol_id == 3) { $rol_lbl = "<span class='label-rol label-almacenero'>ALMACENERO</span>"; }
                        else { $rol_lbl = "<span class='label-rol label-trabajador'>TRABAJADOR</span>"; }

                        $img_path = (!empty($foto)) ? "images/".$foto : "https://ui-avatars.com/api/?name=".urlencode($fullname)."&background=random&color=fff";
                        $estado_label = ($estado == 1) ? "<span class='label label-success'>ACTIVO</span>" : "<span class='label label-danger'>INACTIVO</span>";
                        $btn_pwr = ($estado == 1) ? "btn-red-sc" : "btn-green-sc";
                        ?>
                        
                        <input type="hidden" value="<?php echo $fullname;?>" id="nombres<?php echo $user_id;?>">
                        <input type="hidden" value="<?php echo $user_name;?>" id="usuario<?php echo $user_id;?>">
                        <input type="hidden" value="<?php echo $user_email;?>" id="email<?php echo $user_id;?>">
                        <input type="hidden" value="<?php echo $dni;?>" id="dni<?php echo $user_id;?>">
                        <input type="hidden" value="<?php echo $tel;?>" id="tel<?php echo $user_id;?>">
                        <input type="hidden" value="<?php echo $sucursal;?>" id="sucursal<?php echo $user_id;?>">
                        <input type="hidden" value="<?php echo $f_nacimiento;?>" id="f_nacimiento<?php echo $user_id;?>">
                        <input type="hidden" value="<?php echo $rol_id;?>" id="nivel<?php echo $user_id;?>">
                        <input type="hidden" id="barcode<?php echo $user_id;?>" value="<?php echo $row['codigo_barras'];?>">

                        <tr <?php if($estado==0) echo 'style="opacity:0.6;"'; ?>>
                            <td><img src="<?php echo $img_path; ?>" class="avatar-sc"></td>
                            <td style="font-weight: 600; color: #1e293b;"><?php echo $fullname; ?></td>
                            <td class="text-center"><?php echo $rol_lbl; ?></td>
                            <td><?php echo $user_name; ?></td>
                            <td><?php echo $dni; ?></td>
                            <td class="text-center"><?php echo $estado_label; ?></td>
                            <td class="text-right">
                                <a href="acceso.php?usuario=<?php echo $fullname;?>" class='btn-circle-sc btn-blue-sc' title='Accesos'><i class="fa fa-shield"></i></a>
                                
                                <a href="#" class='btn-circle-sc btn-teal-sc' title='Documentos' onclick="subir_documento('<?php echo $user_id;?>');"><i class="fa fa-file-text-o"></i></a>
                                
                                <a href="#" class='btn-circle-sc btn-green-sc' title='Foto' onclick="cambiar_foto('<?php echo $user_id;?>', '<?php echo $fullname;?>');" data-toggle="modal" data-target="#modal_foto"><i class="fa fa-camera"></i></a>
                                
                                <a href="#" class='btn-circle-sc btn-orange-sc' title='Editar' onclick="obtener_datos('<?php echo $user_id;?>');" data-toggle="modal" data-target="#myModal2"><i class="fa fa-pencil"></i></a>
                                
                                <a href="#" class='btn-circle-sc btn-purple-sc' title='Clave' onclick="get_user_id('<?php echo $user_id;?>');" data-toggle="modal" data-target="#myModal3"><i class="fa fa-key"></i></a>
                                
                                <a href="#" class='btn-circle-sc <?php echo $btn_pwr; ?>' title='Cambiar Estado' onclick="eliminar('<?php echo $user_id; ?>', <?php echo $estado; ?>)"><i class="fa fa-power-off"></i></a>
                            </td>
                        </tr>
                        <?php
                    }
                    ?>
                    </tbody>
                </table>
            </div>
            
            <div class="table-pagination text-right" style="margin-top: 15px;">
                <?php echo paginate($reload, $page, $total_pages, $adjacents);?>
            </div>
            <?php
        } else {
            echo '<div class="alert alert-info" style="margin-top: 10px;"><i class="fa fa-info-circle"></i> No hay usuarios registrados.</div>';
        }
    }
?>