<?php
header('Content-Type: application/json; charset=utf-8');
session_start();
if (!isset($_SESSION['user_login_status']) || $_SESSION['user_login_status'] != 1) {
  echo json_encode(['ok'=>0,'msg'=>'Sesión expirada']); exit;
}

require_once("../config/db.php");
require_once("../config/conexion.php");

function val($k,$def=''){ return isset($_POST[$k]) ? trim($_POST[$k]) : $def; }

$codigo       = val('codigo_producto');
$nombre       = val('nombre_producto');
$marca        = val('marca');
$modelo       = val('modelo');
$id_categoria = (int)val('id_categoria',0);
$unidad       = val('unidad');
$stock        = (int)val('stock',0);
$pc           = (float)val('precio_compra',0);
$pv           = (float)val('precio_venta',0);
$pm           = (float)val('precio_mayor',0);
$tipo         = (int)val('tipo',0); // 0 gravado, 1 exonerado
$descripcion  = val('descripcion');

if ($codigo === '' || $nombre === '') {
  echo json_encode(['ok'=>0,'msg'=>'Código y nombre son obligatorios']); exit;
}

// Verifica duplicados por código
$dup = mysqli_query($con, "SELECT id_producto FROM products WHERE codigo_producto='".mysqli_real_escape_string($con,$codigo)."' LIMIT 1");
if ($dup && mysqli_num_rows($dup) > 0) {
  echo json_encode(['ok'=>0,'msg'=>'El código ya existe']); exit;
}

$fecha = date('Y-m-d H:i:s');
$sql = sprintf(
  "INSERT INTO products
  (codigo_producto, nombre_producto, marca, modelo, id_categoria, unidad, stock, precio_compra, precio_venta, precio_mayor, tipo, descripcion, fecha_added, status)
  VALUES ('%s','%s','%s','%s',%d,'%s',%d,%.2f,%.2f,%.2f,%d,'%s','%s',1)",
  mysqli_real_escape_string($con,$codigo),
  mysqli_real_escape_string($con,$nombre),
  mysqli_real_escape_string($con,$marca),
  mysqli_real_escape_string($con,$modelo),
  $id_categoria,
  mysqli_real_escape_string($con,$unidad),
  $stock,
  $pc, $pv, $pm,
  $tipo,
  mysqli_real_escape_string($con,$descripcion),
  $fecha
);

if (!mysqli_query($con,$sql)) {
  echo json_encode(['ok'=>0,'msg'=>'Error al guardar: '.mysqli_error($con)]); exit;
}

$id = mysqli_insert_id($con);
echo json_encode([
  'ok'     => 1,
  'id'     => $id,
  'codigo' => $codigo,
  'nombre' => $nombre,
  'precio' => $pv
]);
