<?php
include('is_logged.php');

if (isset($_POST['mod_id'])) {
    require_once ("../config/db.php");
    require_once ("../config/conexion.php");
    
    $id_caja = intval($_POST['mod_id']);
    $user_id = $_SESSION['user_id'];
    $tienda = $_SESSION['tienda'];
    
    // 1. VALIDACIÓN ESTRICTA: ¿Es el mismo usuario que la abrió?
    $q_caja = mysqli_query($con, "SELECT usuario_inicio, inicio, fec_reg FROM caja WHERE id_caja='$id_caja' AND tienda='$tienda' AND usuario_cierre=0");
    $rw_caja = mysqli_fetch_array($q_caja);
    
    if (!$rw_caja) {
        $errors[] = "La caja no existe o ya ha sido cerrada previamente.";
    } else if ($rw_caja['usuario_inicio'] != $user_id) {
        // AQUÍ ESTÁ EL CANDADO MAESTRO
        $errors[] = "Error de Seguridad: Solo el usuario que aperturó esta caja tiene permiso para cerrarla.";
    } else {
        $inicio_turno = $rw_caja['fec_reg'];
        $monto_apertura = floatval($rw_caja['inicio']);
        
        // 2. AUTO-CÁLCULO DEL SISTEMA
        // Ingresos (Efectivo cobrado al instante + Abonos)
        $q_ingreso = mysqli_query($con, "SELECT SUM(total_venta - deuda_total) as t FROM facturas WHERE tienda='$tienda' AND ven_com=1 AND estado_factura<>32 AND fecha_factura >= '$inicio_turno'");
        $ingreso_efectivo = ($q_ingreso && $r = mysqli_fetch_array($q_ingreso)) ? floatval($r['t']) : 0;
        
        $q_abonos = mysqli_query($con, "SELECT SUM(p.importe_pago) as t FROM pagos p INNER JOIN facturas f ON p.id_factura = f.id_factura WHERE f.tienda='$tienda' AND f.ven_com=1 AND p.fecha_pago >= DATE('$inicio_turno')");
        $abonos = ($q_abonos && $r = mysqli_fetch_array($q_abonos)) ? floatval($r['t']) : 0;
        
        $total_ingresos = $ingreso_efectivo + $abonos;
        
        // Egresos (Compras pagadas + Gastos)
        $total_egresos = 0;
        $q_compras = mysqli_query($con, "SELECT SUM(total_venta - deuda_total) as t FROM facturas WHERE tienda='$tienda' AND ven_com=2 AND estado_factura<>32 AND fecha_factura >= '$inicio_turno'");
        if ($q_compras && $r = mysqli_fetch_array($q_compras)) { $total_egresos += floatval($r['t']); }

        $q_pagos_compras = mysqli_query($con, "SELECT SUM(p.importe_pago) as t FROM pagos p INNER JOIN facturas f ON p.id_factura = f.id_factura WHERE f.tienda='$tienda' AND f.ven_com=2 AND p.fecha_pago >= DATE('$inicio_turno')");
        if ($q_pagos_compras && $r = mysqli_fetch_array($q_pagos_compras)) { $total_egresos += floatval($r['t']); }

        $q_gastos = mysqli_query($con, "SELECT SUM(monto) as t FROM gastos WHERE tienda='$tienda' AND fecha_agregado >= '$inicio_turno'");
        if ($q_gastos && $r = mysqli_fetch_array($q_gastos)) { $total_egresos += floatval($r['t']); }

        // Cierre Final Automático
        $cierre_calculado = ($monto_apertura + $total_ingresos) - $total_egresos;
        date_default_timezone_set('America/Lima');
        $fecha_cierre = date("Y-m-d H:i:s");

        // 3. ACTUALIZAR CAJA CON DATOS DEL SISTEMA
        $sql_update = "UPDATE caja SET 
                        usuario_cierre='$user_id', 
                        fecha_cierre='$fecha_cierre', 
                        cierre='$cierre_calculado', 
                        entrada='$total_ingresos', 
                        salida='$total_egresos', 
                        faltante='0' 
                        WHERE id_caja='$id_caja'";
                        
        if (mysqli_query($con, $sql_update)) {
            // Actualizamos la tienda para decir que ya no tiene caja abierta
            mysqli_query($con, "UPDATE sucursal SET caja='0' WHERE id_sucursal='$tienda'");
            $messages[] = "Caja cerrada correctamente. Montos procesados por el sistema.";
        } else {
            $errors[] = "Error SQL: " . mysqli_error($con);
        }
    }
}

if (isset($errors)){ ?><div class="alert alert-danger" style="border-radius:8px;"><strong>¡Atención!</strong><br> <?php foreach($errors as $e) echo $e; ?></div><?php }
if (isset($messages)){ ?><div class="alert alert-success" style="border-radius:8px;"><strong>¡Éxito!</strong><br> <?php foreach($messages as $m) echo $m; ?></div><?php }
?>