<?php
// 1. Verificar sesión
include('is_logged.php');

// 2. Validar que llegue el ID
if (empty($_POST['user_id'])) {
    $errors[] = "ID de usuario vacío. Por favor recarga la página.";
} else {
    // 3. Conexión a la BD
    require_once ("../config/db.php");
    require_once ("../config/conexion.php");

    $user_id = intval($_POST['user_id']);
    
    // 4. Verificar archivo
    if (isset($_FILES["imagefile"]["name"]) && $_FILES["imagefile"]["name"] != "") {
        
        $target_dir = "../images/";
        // Limpiamos el nombre de archivo y agregamos tiempo para evitar duplicados
        $image_name = time()."_".basename($_FILES["imagefile"]["name"]);
        $target_file = $target_dir . $image_name;
        $imageFileType = strtolower(pathinfo($target_file,PATHINFO_EXTENSION));
        $uploadOk = 1;

        // 5. Validar formato de imagen
        if($imageFileType != "jpg" && $imageFileType != "png" && $imageFileType != "jpeg" && $imageFileType != "gif" ) {
            $errors[] = "Lo siento, solo archivos JPG, JPEG, PNG y GIF son permitidos.";
            $uploadOk = 0;
        }

        // 6. Intentar subir
        if ($uploadOk == 1) {
            if (move_uploaded_file($_FILES["imagefile"]["tmp_name"], $target_file)) {
                
                // --- IMPORTANTE: Escapar caracteres para evitar error SQL ---
                $image_name_clean = mysqli_real_escape_string($con, $image_name);
                
                $sql = "UPDATE users SET foto='$image_name_clean' WHERE user_id='$user_id'";
                $query_update = mysqli_query($con, $sql);

                if ($query_update) {
                    $messages[] = "La foto de perfil ha sido actualizada exitosamente.";
                } else {
                    // Muestra el error exacto de MySQL para poder depurar
                    $errors[] = "Error SQL al actualizar la base de datos: " . mysqli_error($con); 
                }
            } else {
                $errors[] = "Lo siento, no se pudo guardar el archivo en la carpeta 'images/'. Verifica permisos de escritura.";
            }
        }
    } else {
        $errors[] = "No seleccionaste ninguna imagen para subir.";
    }
}

// 7. Mostrar Mensajes
if (isset($errors)){
    ?>
    <div class="alert alert-danger" role="alert" style="border-radius: 8px;">
        <button type="button" class="close" data-dismiss="alert">&times;</button>
        <strong>Error!</strong> 
        <?php foreach ($errors as $error) { echo $error; } ?>
    </div>
    <?php
}
if (isset($messages)){
    ?>
    <div class="alert alert-success" role="alert" style="border-radius: 8px;">
        <button type="button" class="close" data-dismiss="alert">&times;</button>
        <strong>¡Éxito!</strong>
        <?php foreach ($messages as $message) { echo $message; } ?>
    </div>
    <?php
}
?>