<?php
include('is_logged.php');

if (empty($_POST['logo_id'])) {
    $errors[] = "ID de sucursal vacío";
} else {
    require_once ("../config/db.php");
    require_once ("../config/conexion.php");

    $id_sucursal = intval($_POST['logo_id']);
    
    // Verificar si se subió imagen
    if (isset($_FILES["imagefile"]["name"]) && $_FILES["imagefile"]["name"] != "") {
        
        $target_dir = "../pdf/documentos/"; // RUTA SEGÚN TU SISTEMA ANTIGUO
        $imageFileType = strtolower(pathinfo($_FILES["imagefile"]["name"], PATHINFO_EXTENSION));
        
        // Nombre único: logo_ID_TIMESTAMP.ext
        $image_name = "logo_" . $id_sucursal . "_" . time() . "." . $imageFileType;
        $target_file = $target_dir . $image_name;
        
        $uploadOk = 1;
        
        // Validar imagen
        $check = getimagesize($_FILES["imagefile"]["tmp_name"]);
        if($check === false) {
            $errors[] = "El archivo no es una imagen.";
            $uploadOk = 0;
        }
        
        // Validar formato
        if($imageFileType != "jpg" && $imageFileType != "png" && $imageFileType != "jpeg" && $imageFileType != "gif" ) {
            $errors[] = "Solo se permiten archivos JPG, JPEG, PNG y GIF.";
            $uploadOk = 0;
        }

        if ($uploadOk == 1) {
            if (move_uploaded_file($_FILES["imagefile"]["tmp_name"], $target_file)) {
                
                // Actualizar base de datos
                $sql = "UPDATE sucursal SET foto='$image_name' WHERE id_sucursal='$id_sucursal'";
                $query_update = mysqli_query($con, $sql);

                if ($query_update) {
                    $messages[] = "Logo actualizado satisfactoriamente.";
                } else {
                    $errors[] = "Error SQL: " . mysqli_error($con);
                }
            } else {
                $errors[] = "Error al subir el archivo a la carpeta.";
            }
        }
    } else {
        $errors[] = "No seleccionaste ninguna imagen.";
    }
}

if (isset($errors)){
    ?>
    <div class="alert alert-danger" role="alert" style="border-radius: 8px;">
        <button type="button" class="close" data-dismiss="alert">&times;</button>
        <strong>Error!</strong> <?php foreach ($errors as $error) { echo $error; } ?>
    </div>
    <?php
}
if (isset($messages)){
    ?>
    <div class="alert alert-success" role="alert" style="border-radius: 8px;">
        <button type="button" class="close" data-dismiss="alert">&times;</button>
        <strong>¡Éxito!</strong> <?php foreach ($messages as $message) { echo $message; } ?>
    </div>
    <?php
}
?>