<?php
session_start();
if (!isset($_SESSION['user_login_status']) AND $_SESSION['user_login_status'] != 1) { exit; }
require_once ("../config/db.php");
require_once ("../config/conexion.php");

if (empty($_POST['id_proveedor'])) { echo "<div class='alert alert-danger'>Selecciona un proveedor.</div>"; }
elseif (empty($_POST['nombres']) || empty($_POST['precios'])) { echo "<div class='alert alert-danger'>Tabla vacía.</div>"; }
else {
    $id_proveedor = intval($_POST['id_proveedor']);
    $fecha = mysqli_real_escape_string($con, strip_tags($_POST["fecha"], ENT_QUOTES));
    $forma_pago = intval($_POST['forma_pago']); 
    $moneda = intval($_POST['moneda']); // Nuevo campo
    
    // DOCUMENTO OPCIONAL
    $serie = mysqli_real_escape_string($con, strip_tags($_POST["serie"], ENT_QUOTES));
    $correlativo = mysqli_real_escape_string($con, strip_tags($_POST["correlativo"], ENT_QUOTES));
    
    if(empty($serie) && empty($correlativo)){
        $numero_factura = "S/N";
    } else {
        $numero_factura = strtoupper($serie . "-" . $correlativo);
    }
    
    $cantidades = $_POST['cantidades']; $nombres = $_POST['nombres']; $precios = $_POST['precios'];
    $total_venta = 0;
    for ($i=0; $i < count($nombres); $i++) { $total_venta += (floatval($cantidades[$i]) * floatval($precios[$i])); }
    
    $a_cuenta = floatval($_POST['a_cuenta']);
    $saldo = $total_venta - $a_cuenta; if($saldo < 0) $saldo = 0;
    $estado_factura = ($saldo <= 0) ? 1 : 2;
    $id_vendedor = $_SESSION['user_id']; $tienda = $_SESSION['tienda'];
    
    $sql = "INSERT INTO facturas (numero_factura, fecha_factura, id_cliente, id_vendedor, condiciones, total_venta, estado_factura, ven_com, tienda, activo, moneda) VALUES ('$numero_factura', '$fecha', '$id_proveedor', '$id_vendedor', '$forma_pago', '$total_venta', '$estado_factura', 2, '$tienda', 1, '$moneda')";
    
    if (mysqli_query($con, $sql)) {
        $id_factura = mysqli_insert_id($con);
        for ($i=0; $i < count($nombres); $i++) { 
            $cant = floatval($cantidades[$i]); $prec = floatval($precios[$i]); $nom = mysqli_real_escape_string($con, strip_tags($nombres[$i], ENT_QUOTES));
            mysqli_query($con, "INSERT INTO detalle_compra_manual (id_factura, descripcion, cantidad, precio) VALUES ('$id_factura', '$nom', '$cant', '$prec')");
        }
        if ($a_cuenta > 0) { mysqli_query($con, "INSERT INTO pagos (id_factura, fecha_pago, forma_pago, importe_pago, tienda) VALUES ('$id_factura', '$fecha', '$forma_pago', '$a_cuenta', '$tienda')"); }
        if (isset($_FILES["imagen"]["name"]) && $_FILES["imagen"]["name"] != "") {
            $target_dir = "../pdf/documentos/compras/"; if (!file_exists($target_dir)) { mkdir($target_dir, 0777, true); }
            $ext = strtolower(pathinfo($_FILES["imagen"]["name"], PATHINFO_EXTENSION));
            move_uploaded_file($_FILES["imagen"]["tmp_name"], $target_dir . "evidencia_" . $id_factura . "." . $ext);
        }
        echo "<div class='alert alert-success'>Compra registrada correctamente.</div>";
    } else { echo "<div class='alert alert-danger'>Error SQL: ".mysqli_error($con)."</div>"; }
}
?>