<?php
session_start();
if (empty($_POST['id_producto'])) { echo "<div class='alert alert-danger'>Selecciona un producto</div>"; exit; }
if (empty($_POST['cantidad'])) { echo "<div class='alert alert-danger'>Ingresa cantidad</div>"; exit; }
if (empty($_POST['tienda'])) { echo "<div class='alert alert-danger'>Selecciona la tienda destino</div>"; exit; }

require_once ("../config/db.php");
require_once ("../config/conexion.php");

$id_producto = intval($_POST['id_producto']);
$tienda = intval($_POST['tienda']);
$cantidad = floatval($_POST['cantidad']); 
$referencia = mysqli_real_escape_string($con, $_POST['referencia']);
$id_compra = !empty($_POST['id_compra']) ? intval($_POST['id_compra']) : 'NULL';
$user_id = $_SESSION['user_id'];
$fecha = date("Y-m-d H:i:s");

// PRECIOS DEL FORMULARIO
$nuevo_costo = floatval($_POST['precio_costo']);
$nuevo_precio_venta = floatval($_POST['precio_venta']);

// 1. Obtener Stock Actual (para el inv_ini del Kardex)
$col_tienda = "b".$tienda; 
$sql_prod = mysqli_query($con, "SELECT $col_tienda as stock_actual FROM products WHERE id_producto='$id_producto'");
$rw_prod = mysqli_fetch_array($sql_prod);
$stock_antes = $rw_prod['stock_actual']; 

// 2. ACTUALIZAR PRODUCTO (Stock + Nuevos Precios)
$nuevo_stock = $stock_antes + $cantidad;

// Actualizamos stock Y el precio de venta en la ficha del producto
// Si tienes columna 'costo', agrégala aquí: , costo='$nuevo_costo'
$update_sql = "UPDATE products SET $col_tienda = '$nuevo_stock', precio_producto = '$nuevo_precio_venta' WHERE id_producto='$id_producto'";
$update_stock = mysqli_query($con, $update_sql);

if($update_stock){
    
    // 3. Registrar Historial
    $sql_hist = "INSERT INTO entradas (fecha, id_producto, cantidad, tienda, user_id, referencia, id_compra) 
                 VALUES ('$fecha', '$id_producto', '$cantidad', '$tienda', '$user_id', '$referencia', $id_compra)";
    mysqli_query($con, $sql_hist);
    
    $id_movimiento = mysqli_insert_id($con);

    // 4. INSERTAR EN KARDEX
    // IMPORTANTE: 
    // - En 'precio_venta' y 'precio_compra' guardamos el $nuevo_costo.
    // - ¿Por qué? Porque para una ENTRADA (ven_com=2), el sistema lee el costo de ingreso para el promedio ponderado.
    
    $sql_kardex = "INSERT INTO detalle_factura (id_producto, cantidad, precio_venta, precio_compra, numero_factura, tipo_doc, tienda, ven_com, activo, fecha, ot, inv_ini, folio, id_cliente, id_vendedor, moneda) 
                   VALUES ('$id_producto', '$cantidad', '$nuevo_costo', '$nuevo_costo', '$id_movimiento', '10', '$tienda', '2', '1', '$fecha', '2', '$stock_antes', '$referencia', '0', '$user_id', '1')";
                   
    if(mysqli_query($con, $sql_kardex)){
        echo "<div class='alert alert-success'>Entrada registrada. Stock y precios actualizados.</div>";
    } else {
        echo "<div class='alert alert-danger'>Error al registrar en Kardex: ".mysqli_error($con)."</div>";
    }

} else {
    echo "<div class='alert alert-danger'>Error al actualizar producto.</div>";
}
?>