<?php
session_start();
if (empty($_POST['id_producto'])) { echo "<div class='alert alert-danger'>Selecciona un producto</div>"; exit; }
if (empty($_POST['cantidad'])) { echo "<div class='alert alert-danger'>Ingresa cantidad</div>"; exit; }

require_once ("../config/db.php");
require_once ("../config/conexion.php");

$id_producto = intval($_POST['id_producto']);
$origen = intval($_POST['origen']);
$destino = intval($_POST['destino']);
$cantidad = intval($_POST['cantidad']);
$referencia = mysqli_real_escape_string($con, $_POST['referencia']);
$user_id = $_SESSION['user_id'];
$fecha = date("Y-m-d H:i:s");

// 1. Obtener Stock Actual y Datos del Producto para Kardex (Precios)
$sql_prod = mysqli_query($con, "SELECT * FROM products WHERE id_producto='$id_producto'");
$rw_prod = mysqli_fetch_array($sql_prod);
$col_origen = "b".$origen; // Ej: b1
$col_destino = "b".$destino; // Ej: b2
$stock_actual_origen = $rw_prod[$col_origen];
$precio_costo = $rw_prod['precio_producto']; // Usamos precio ref para Kardex

// Validación de Servidor
if($cantidad > $stock_actual_origen){
    echo "<div class='alert alert-danger'>Error: Stock insuficiente en origen.</div>";
    exit;
}

// 2. Actualizar Stocks en Tabla Products
$update_origen = mysqli_query($con, "UPDATE products SET $col_origen = $col_origen - $cantidad WHERE id_producto='$id_producto'");
$update_destino = mysqli_query($con, "UPDATE products SET $col_destino = $col_destino + $cantidad WHERE id_producto='$id_producto'");

if($update_origen && $update_destino){
    
    // 3. Registrar en Historial de Traslados (Tabla Nueva)
    $sql_hist = "INSERT INTO traslados (fecha, id_producto, cantidad, origen, destino, user_id, referencia) 
                 VALUES ('$fecha', '$id_producto', '$cantidad', '$origen', '$destino', '$user_id', '$referencia')";
    mysqli_query($con, $sql_hist);

    // 4. INSERTAR EN KARDEX (detalle_factura)
    // Para que aparezca en el Kardex, necesitamos registrar movimiento
    // Nota: Usaremos tipo_doc=9 (Ent/Sal) o el que uses para traslados internos.
    // ot=1 (Salida), ot=2 (Entrada)
    
    // A) SALIDA DE ORIGEN
    $sql_kardex_out = "INSERT INTO detalle_factura (id_producto, cantidad, precio_venta, id_factura, numero_factura, tipo_doc, tienda, ven_com, activo, fecha, ot) 
                       VALUES ('$id_producto', '$cantidad', '$precio_costo', '0', '0', '9', '$origen', '1', '1', '$fecha', '1')";
    mysqli_query($con, $sql_kardex_out);

    // B) ENTRADA A DESTINO
    $sql_kardex_in = "INSERT INTO detalle_factura (id_producto, cantidad, precio_venta, id_factura, numero_factura, tipo_doc, tienda, ven_com, activo, fecha, ot) 
                       VALUES ('$id_producto', '$cantidad', '$precio_costo', '0', '0', '9', '$destino', '2', '1', '$fecha', '2')";
    mysqli_query($con, $sql_kardex_in);

    echo "<div class='alert alert-success'>Traslado realizado con éxito.</div>";
} else {
    echo "<div class='alert alert-danger'>Error al actualizar base de datos.</div>";
}
?>