<?php
include('is_logged.php');

if (empty($_POST['nombre'])) {
    $errors[] = "Nombre de la sucursal vacío";
} else {
    require_once ("../config/db.php");
    require_once ("../config/conexion.php");
    
    // 1. RECIBIR DATOS
    $nombre = mysqli_real_escape_string($con,(strip_tags($_POST["nombre"],ENT_QUOTES)));
    $nombre_stand = mysqli_real_escape_string($con,(strip_tags($_POST["nombre_stand"],ENT_QUOTES))); 
    $ruc = mysqli_real_escape_string($con,(strip_tags($_POST["ruc"],ENT_QUOTES)));
    $direccion = mysqli_real_escape_string($con,(strip_tags($_POST["direccion"],ENT_QUOTES)));
    $correo = mysqli_real_escape_string($con,(strip_tags($_POST["correo"],ENT_QUOTES)));
    $telefono = mysqli_real_escape_string($con,(strip_tags($_POST["telefono"],ENT_QUOTES)));
    
    // NUEVO: Recibir el tipo de sucursal (1: Tienda, 2: Almacén)
    $tipo_sucursal = isset($_POST["tipo_sucursal"]) ? intval($_POST["tipo_sucursal"]) : 1;
    
    // Datos ocultos/default
    $ubigeo = mysqli_real_escape_string($con,(strip_tags($_POST["ubigeo"],ENT_QUOTES)));
    $departamento = mysqli_real_escape_string($con,(strip_tags($_POST["departamento"],ENT_QUOTES)));
    $provincia = mysqli_real_escape_string($con,(strip_tags($_POST["provincia"],ENT_QUOTES)));
    $distrito = mysqli_real_escape_string($con,(strip_tags($_POST["distrito"],ENT_QUOTES)));
    
    // 2. CALCULAR 'TIENDA' AUTOMÁTICO
    $sql_tienda = mysqli_query($con, "SELECT MAX(tienda) as max_tienda FROM sucursal");
    $rw_tienda = mysqli_fetch_array($sql_tienda);
    $max_tienda = $rw_tienda['max_tienda'];
    $next_tienda = ($max_tienda) ? $max_tienda + 1 : 1;

    // 3. INSERTAR (Incluyendo tipo_sucursal)
    $sql = "INSERT INTO sucursal (nombre, nombre_stand, ruc, direccion, correo, telefono, ubigeo, dep_suc, pro_suc, dis_suc, tienda, foto, caja, tipo_sucursal) 
            VALUES ('$nombre', '$nombre_stand', '$ruc', '$direccion', '$correo', '$telefono', '$ubigeo', '$departamento', '$provincia', '$distrito', '$next_tienda', '', '1', '$tipo_sucursal')";
            
    $query_new = mysqli_query($con,$sql);
    
    if ($query_new) {
        $messages[] = "Sucursal creada satisfactoriamente.";
    } else {
        $errors[] = "Error SQL: " . mysqli_error($con);
    }
}

if (isset($errors)){
    ?>
    <div class="alert alert-danger" role="alert" style="border-radius: 8px;">
        <button type="button" class="close" data-dismiss="alert">&times;</button>
        <strong>Error!</strong> 
        <?php foreach ($errors as $error) { echo $error; } ?>
    </div>
    <?php
}
if (isset($messages)){
    ?>
    <div class="alert alert-success" role="alert" style="border-radius: 8px;">
        <button type="button" class="close" data-dismiss="alert">&times;</button>
        <strong>¡Éxito!</strong>
        <?php foreach ($messages as $message) { echo $message; } ?>
    </div>
    <?php
}
?>