<style type="text/css">
    /* --- TABLA ESTILO DASHBOARD MODERNO --- */
    .table-container {
        padding: 5px 15px;
        background: #fff;
    }

    .header-info-bar {
        display: flex;
        justify-content: space-between;
        align-items: center;
        padding: 10px 15px;
        background: #f8fafc;
        border-radius: 8px;
        margin-bottom: 10px;
        border: 1px solid #e2e8f0;
    }

    .counter-badge {
        background: #0f172a;
        color: white;
        padding: 4px 12px;
        border-radius: 20px;
        font-size: 12px;
        font-weight: 700;
    }

    .table-modern {
        width: 100%;
        border-collapse: separate;
        border-spacing: 0 10px; /* Hueco entre filas */
    }

    .table-modern thead th {
        background: transparent !important;
        color: #64748b !important;
        text-transform: uppercase;
        font-size: 11px;
        font-weight: 800;
        padding: 10px;
        border: none;
    }

    /* Filas como Tarjetas Flotantes */
    .row-card {
        background: #ffffff !important;
        box-shadow: 0 2px 4px rgba(0,0,0,0.02);
        transition: all 0.2s ease;
    }

    .row-card td {
        padding: 12px 10px !important;
        vertical-align: middle !important;
        border-top: 1px solid #f1f5f9 !important;
        border-bottom: 1px solid #f1f5f9 !important;
    }

    .row-card td:first-child { border-left: 1px solid #f1f5f9 !important; border-radius: 12px 0 0 12px; }
    .row-card td:last-child { border-right: 1px solid #f1f5f9 !important; border-radius: 0 12px 12px 0; }

    .row-card:hover {
        transform: translateY(-2px);
        box-shadow: 0 8px 15px rgba(0,0,0,0.05);
        background: #f1f5f9 !important;
    }

    /* Imagen con Borde */
    .img-thumb {
        border-radius: 10px;
        border: 2px solid #f1f5f9;
        object-fit: cover;
    }

    /* Inputs de alta visibilidad */
    .input-modern {
        border: 2px solid #e2e8f0 !important;
        border-radius: 8px !important;
        height: 38px !important;
        text-align: center !important;
        font-weight: 700 !important;
        color: #0f172a !important;
        transition: 0.2s;
        background: #f8fafc !important;
    }

    .input-modern:focus {
        border-color: #3b82f6 !important;
        background: #fff !important;
        box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.1) !important;
    }

    /* Stock Status */
    .stock-label {
        font-size: 14px;
        font-weight: 800;
        padding: 5px 10px;
        border-radius: 6px;
    }
    .stock-ok { color: #10b981; background: #ecfdf5; }
    .stock-low { color: #ef4444; background: #fef2f2; }

    /* Botón Agregar */
    .btn-add-circle {
        background: #3b82f6;
        color: white !important;
        width: 38px;
        height: 38px;
        border-radius: 12px;
        display: flex;
        align-items: center;
        justify-content: center;
        text-decoration: none !important;
        transition: 0.3s;
        box-shadow: 0 4px 10px rgba(59, 130, 246, 0.3);
    }
    .btn-add-circle:hover {
        background: #10b981;
        transform: scale(1.1) rotate(90deg);
        box-shadow: 0 4px 15px rgba(16, 185, 129, 0.4);
    }
</style>

<?php
	include('is_logged.php');
	require_once ("../config/db.php");
	require_once ("../config/conexion.php");

	$action = (isset($_REQUEST['action'])&& $_REQUEST['action'] !=NULL)?$_REQUEST['action']:'';
	if($action == 'ajax'){
         $q = mysqli_real_escape_string($con,(strip_tags($_REQUEST['q'], ENT_QUOTES)));
		 $sTable = "products,und";
		 $sWhere=" WHERE products.und_pro=und.id_und";
		if ( $_GET['q'] != "" )
		{
			$sWhere.= " and  (products.nombre_producto like '%$q%' or products.codigo_producto like '%$q%')";
		}
        $sWhere.=" ORDER BY `products`.`id_producto` DESC ";

		include 'pagination.php';
		$page = (isset($_REQUEST['page']) && !empty($_REQUEST['page']))?$_REQUEST['page']:1;
		
        // LIMITADOR DE 40 ITEMS POR PÁGINA
        $per_page = 40; 
		$adjacents  = 4; 
		$offset = ($page - 1) * $per_page;
		
        $count_query = mysqli_query($con, "SELECT count(*) AS numrows FROM $sTable $sWhere");
		$row= mysqli_fetch_array($count_query);
		$numrows = $row['numrows'];
		$total_pages = ceil($numrows/$per_page);
		$reload = './index.php';
		
        $sql="SELECT * FROM  $sTable $sWhere LIMIT $offset,$per_page";
		$query = mysqli_query($con, $sql);

		if ($numrows>0){
			?>
            <div class="table-container">
                <div class="header-info-bar">
                    <span style="font-weight: 600; color: #64748b;">Mostrando resultados de búsqueda</span>
                    <span class="counter-badge">
                        <i class="fa fa-tag"></i> <?php echo $numrows; ?> Productos encontrados
                    </span>
                </div>

                <div class="table-responsive" style="overflow-x: hidden;">
                    <table class="table-modern">
                        <thead>
                            <tr>
                                <th class='text-center'>Visual</th>
                                <th>Código / Producto</th>
                                <th class='text-center'>Medida</th>
                                <th class='text-center' style="width: 70px;">Cant.</th>
                                <th class='text-center' style="width: 100px;">Precio</th>
                                <th class='text-center'>Disponibilidad</th>
                                <th class='text-center'>Acción</th>
                            </tr>
                        </thead>
                        <tbody>
                        <?php
                            while ($row=mysqli_fetch_array($query)){
                            $id_producto=$row['id_producto'];
                            $codigo_producto=$row['codigo_producto'];
                            $nombre_producto=$row['nombre_producto']." ".$row['marca']." ".$row['modelo'];
                            $nom_und=$row['nom_und'];
                            $foto=$row['foto1'];
                            $tienda=$_SESSION['tienda'];
                            $b=$row["b$tienda"];
                            $precio_venta=number_format($row["precio_producto"],2,'.','');
                            
                            $class_stock = ($b <= 0) ? "stock-low" : "stock-ok";
                        ?>
                        <tr class="row-card">
                            <td class="text-center"> 
                                <img class="img-thumb" src="fotos/<?php echo $foto;?>" width="45" height="45" />
                            </td>
                            <td>
                                <div style="font-weight: 800; color: #3b82f6; font-size: 11px;"><?php echo $codigo_producto; ?></div>
                                <div style="font-weight: 600; color: #1e293b; font-size: 13px;"><?php echo $nombre_producto; ?></div>
                            </td>
                            <td class="text-center"><span style="font-size: 11px; font-weight: 700; color: #94a3b8;"><?php echo $nom_und; ?></span></td>
                            <td>
                                <input type="text" class="form-control input-modern" id="cantidad_<?php echo $id_producto; ?>" placeholder="0" onfocus="this.select()">
                            </td>
                            <td>
                                <input type="text" class="form-control input-modern" id="precio_venta_<?php echo $id_producto; ?>" value="<?php echo $precio_venta;?>" onfocus="this.select()">
                            </td>
                            <td class="text-center">
                                <span class="stock-label <?php echo $class_stock; ?>">
                                    <?php echo number_format($b,0); ?>
                                </span>
                                <input type="hidden" id="stock_<?php echo $id_producto; ?>" value="<?php echo $b;?>">
                            </td>
                            <td class='text-center'>
                                <a href="javascript:void(0)" class="btn-add-circle" onclick="agregar('<?php echo $id_producto ?>')">
                                    <i class="fa fa-plus"></i>
                                </a>
                            </td>
                        </tr>
                        <?php } ?>
                        </tbody>
                    </table>
                </div>

                <div class="text-center" style="margin-top: 20px;">
                    <?php echo paginate($reload, $page, $total_pages, $adjacents); ?>
                </div>
            </div>
			<?php
		}
	}
?>