<?php
// ajax/subir_documento.php
session_start();
if (!isset($_SESSION['user_login_status']) AND $_SESSION['user_login_status'] != 1) { exit; }
require_once ("../config/db.php");
require_once ("../config/conexion.php");

// 1. Recibir datos
$user_id = intval($_POST['mod_id_documento']);
$tipo_select = mysqli_real_escape_string($con, $_POST['tipo_documento']);
$tipo_otro = mysqli_real_escape_string($con, $_POST['otro_tipo_documento']);

// 2. Definir el tipo final
$tipo_final = ($tipo_select == "Otro") ? strtoupper($tipo_otro) : $tipo_select;

if (empty($tipo_final)) {
    die("<div class='alert alert-danger'>Error: Debes especificar el tipo de documento.</div>");
}

// 3. Directorio
$target_dir = "../pdf/documentos/trabajadores/";
if (!file_exists($target_dir)) { mkdir($target_dir, 0777, true); }

// 4. Procesar Archivo
if (isset($_FILES["documento_adjunto"]["name"]) && $_FILES["documento_adjunto"]["name"] != "") {
    
    $nombre_archivo = $_FILES["documento_adjunto"]["name"];
    $ext = strtolower(pathinfo($nombre_archivo, PATHINFO_EXTENSION));
    // Nombre único: IDUsuario_Tipo_Timestamp
    $nombre_final = $user_id . "_" . preg_replace('/[^A-Za-z0-9]/', '', $tipo_final) . "_" . time() . "." . $ext;
    $target_file = $target_dir . $nombre_final;
    
    $valid_extensions = array("pdf", "doc", "docx", "jpg", "jpeg", "png");
    
    if(in_array($ext, $valid_extensions)) {
        if (move_uploaded_file($_FILES["documento_adjunto"]["tmp_name"], $target_file)) {
            
            // 5. Insertar en la nueva tabla
            $fecha = date("Y-m-d H:i:s");
            $sql = "INSERT INTO documentos_usuarios (user_id, tipo_documento, nombre_archivo, fecha_subida) 
                    VALUES ('$user_id', '$tipo_final', '$nombre_final', '$fecha')";
            
            if (mysqli_query($con, $sql)) {
                echo "ok"; // Respuesta de éxito para JS
            } else {
                echo "<div class='alert alert-danger'>Error BD: " . mysqli_error($con) . "</div>";
            }
        } else {
            echo "<div class='alert alert-danger'>Error al subir archivo al servidor.</div>";
        }
    } else {
        echo "<div class='alert alert-danger'>Formato no válido.</div>";
    }
} else {
    echo "<div class='alert alert-warning'>Selecciona un archivo.</div>";
}
?>