<?php
session_start();
include('menu.php');
require_once ("config/db.php");
require_once ("config/conexion.php");

// 1. Verificar sesión
if (!isset($_SESSION['user_login_status']) AND $_SESSION['user_login_status'] != 1) {
    header("location: login.php"); exit;
}
$sql1="select * from users where user_id=$_SESSION[user_id]";
$rw1=mysqli_query($con,$sql1);
$rs1=mysqli_fetch_array($rw1);
$modulo=$rs1["accesos"];
$a = explode(".", $modulo); 
if($a[4]==0){ header("location:error.php"); }
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Categorías | SoundCrow</title>
    <link rel="icon" href="logo.png" type="image/png">

    <link href="css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <link href="css/custom.min.css" rel="stylesheet">
    
    <style>
        body { background-color: #f1f5f9; font-family: 'Plus Jakarta Sans', sans-serif; }
        /* --- NUEVOS ESTILOS PARA BOTONES DE ACCIÓN ELEGANTES --- */
        .btn-action {
            border: none;
            border-radius: 50px; /* Botones completamente redondos */
            width: 40px; /* Ancho fijo */
            height: 40px; /* Alto fijo para que sean círculos perfectos */
            margin: 0 4px; /* Espacio entre ellos */
            font-size: 16px; /* Icono más grande */
            transition: all 0.3s cubic-bezier(0.25, 0.8, 0.25, 1); /* Animación muy suave */
            box-shadow: 0 4px 6px rgba(0,0,0,0.1);
            display: inline-flex;
            align-items: center;
            justify-content: center;
            color: white;
        }
        
        .btn-action i { margin: 0; } /* Centrar icono perfectamente */

        /* Botón Editar (Ámbar/Naranja elegante) */
        .btn-edit {
            background: linear-gradient(135deg, #f59e0b 0%, #d97706 100%);
        }
        .btn-edit:hover {
            transform: translateY(-4px) scale(1.05); /* Elevación y ligero aumento */
            box-shadow: 0 10px 20px rgba(245, 158, 11, 0.4); /* Sombra difusa intensa */
            color: white;
        }

        /* Botón Eliminar (Rojo intenso elegante) */
        .btn-delete {
            background: linear-gradient(135deg, #ef4444 0%, #b91c1c 100%);
        }
        .btn-delete:hover {
            transform: translateY(-4px) scale(1.05);
            box-shadow: 0 10px 20px rgba(239, 68, 68, 0.4);
            color: white;
        }
        /* BANNER */
        .form-header {
            background: linear-gradient(135deg, #0f172a 0%, #1d4ed8 100%);
            color: white;
            padding: 25px 40px;
            border-radius: 15px 15px 0 0;
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-top: 60px; 
            box-shadow: 0 10px 25px rgba(15, 23, 42, 0.2);
        }
        .form-header h3 { margin: 0; font-size: 20px; font-weight: 800; letter-spacing: 1px; text-transform: uppercase; }
        .form-header p { margin: 5px 0 0 0; font-size: 13px; opacity: 0.8; font-weight: 500; }
        .header-icon { font-size: 32px; opacity: 0.8; color: rgba(255,255,255,0.8); }

        /* CONTENEDOR */
        .form-container {
            background: white;
            padding: 30px;
            border-radius: 0 0 15px 15px;
            box-shadow: 0 20px 40px rgba(0,0,0,0.06);
            margin-bottom: 50px;
            border: 1px solid #e2e8f0; border-top: none;
        }

        /* BUSCADOR */
        .search-wrapper { position: relative; width: 100%; }
        
        .search-input {
            border: 2px solid #e2e8f0; border-radius: 50px;
            padding: 12px 25px 12px 50px; height: 50px; font-size: 15px;
            background-color: #f8fafc; width: 100%; transition: all 0.3s;
            color: #334155; font-weight: 500;
        }
        .search-input:focus {
            background-color: #fff; border-color: #3b82f6;
            box-shadow: 0 4px 20px rgba(59, 130, 246, 0.15); outline: none;
        }
        .search-icon {
            position: absolute; left: 20px; top: 50%; transform: translateY(-50%);
            color: #94a3b8; font-size: 18px; pointer-events: none;
        }

        /* BOTÓN NUEVO */
        .btn-new {
            background: linear-gradient(135deg, #2563eb 0%, #1d4ed8 100%);
            color: white; border: none; padding: 12px 30px; border-radius: 50px;
            font-weight: 700; font-size: 13px; letter-spacing: 0.5px; text-transform: uppercase;
            box-shadow: 0 4px 15px rgba(37, 99, 235, 0.3); transition: 0.3s; display: block; width: 100%;
        }
        .btn-new:hover { 
            background: linear-gradient(135deg, #3b82f6 0%, #2563eb 100%);
            transform: translateY(-2px); box-shadow: 0 8px 20px rgba(37, 99, 235, 0.4); color: white;
        }

        /* UTILIDADES */
        #loader { margin-left: 10px; }
        #resultados { margin-top: 20px; }
        .outer_div { padding: 0; }
    </style>
</head>

<body class="nav-md">
    <div class="container body">
        <div class="main_container">
            <div class="col-md-3 left_col">
                <div class="left_col scroll-view">
                    <div class="clearfix"></div>
                    <?php menu2(); menu1(); ?>
                </div>
            </div>
            
            <?php menu3(); ?>

            <div class="right_col" role="main">
                
                <?php
                    include("modal/registro_categorias.php");
                    include("modal/editar_categorias.php");
                ?>

                <div class="form-header">
                    <div>
                        <h3>Gestión de Categorías</h3>
                        <p>Administra las familias de productos de tu inventario.</p>
                    </div>
                    <div class="header-icon"><i class="fas fa-tags"></i></div>
                </div>

                <div class="form-container">
                    
                    <form class="form-horizontal" role="form" id="datos_categorias">
                        <div class="row" style="display: flex; align-items: center; flex-wrap: wrap;">
                            
                            <div class="col-md-9 col-sm-8 col-xs-12" style="margin-bottom: 10px;">
                                <div class="search-wrapper">
                                    <i class="fas fa-search search-icon"></i>
                                    <input type="text" class="search-input" id="q" placeholder="Buscar categoría por nombre..." onkeyup='load(1);' autocomplete="off">
                                </div>
                            </div>

                            <div class="col-md-3 col-sm-4 col-xs-12" style="margin-bottom: 10px;">
                                <button type='button' class="btn btn-new" data-toggle="modal" data-target="#nuevoProducto">
                                    <i class="fas fa-plus-circle"></i> Nueva Categoría
                                </button>
                            </div>
                            
                            <div class="col-md-12 text-center">
                                <span id="loader"></span>
                            </div>

                        </div>
                    </form>

                    <hr style="border-top: 1px solid #f1f5f9; margin: 15px 0;">

                    <div id="resultados"></div>
                    <div class='outer_div'></div>

                </div>

            </div>
        </div>
    </div>

    <script src="js/jquery.min.js"></script>
    <script src="js/bootstrap.min.js"></script>
    <script src="js/nicescroll/jquery.nicescroll.min.js"></script>
    <script src="js/custom.js"></script>
    <script src="js/pace/pace.min.js"></script>

    <script>
    $(document).ready(function(){
        load(1);
    });

function load(page){
        var q = $("#q").val();
        var parametros = {'action':'ajax','page':page,'q':q};
        $("#loader").fadeIn('slow');
        $.ajax({
            url:'./ajax/buscar_categorias.php', // URL limpia
            data: parametros, // Datos enviados correctamente como objeto
            beforeSend: function(objeto){
                $('#loader').html('<img src="./img/ajax-loader.gif"> Cargando...');
            },
            success:function(data){
                $(".outer_div").html(data).fadeIn('slow');
                $('#loader').html('');
            }
        })
    }

    function eliminar (id){
        var q= $("#q").val();
        if (confirm("Realmente deseas eliminar la categoria")){	
            $.ajax({
                type: "GET",
                url: "./ajax/buscar_categorias.php",
                data: "id="+id+"&q="+q,
                beforeSend: function(objeto){
                    $("#resultados").html("Mensaje: Cargando...");
                },
                success: function(datos){
                    $("#resultados").html(datos);
                    load(1);
                }
            });
        }
    }
		
    $( "#guardar_categoria" ).submit(function( event ) {
      $('#guardar_datos').attr("disabled", true);
      
     var parametros = $(this).serialize();
         $.ajax({
                type: "POST",
                url: "ajax/nuevo_categoria.php",
                data: parametros,
                 beforeSend: function(objeto){
                    $("#resultados_ajax").html("Mensaje: Cargando...");
                  },
                success: function(datos){
                $("#resultados_ajax").html(datos);
                $('#guardar_datos').attr("disabled", false);
                load(1);
              }
        });
      event.preventDefault();
    })

    $( "#editar_categoria" ).submit(function( event ) {
      $('#actualizar_datos').attr("disabled", true);
      
     var parametros = $(this).serialize();
         $.ajax({
                type: "POST",
                url: "ajax/editar_categoria.php",
                data: parametros,
                 beforeSend: function(objeto){
                    $("#resultados_ajax2").html("Mensaje: Cargando...");
                  },
                success: function(datos){
                $("#resultados_ajax2").html(datos);
                $('#actualizar_datos').attr("disabled", false);
                load(1);
              }
        });
      event.preventDefault();
    })

    function obtener_datos(id){
        var nom_cat = $("#nom_cat"+id).val();
        var des_cat = $("#des_cat"+id).val(); 
        $("#mod_cat").val(nom_cat);
        $("#mod_des").val(des_cat);
        $("#mod_id").val(id);
    }
    </script>
</body>
</html>