<?php
session_start();

require_once ("config/db.php");//Contiene las variables de configuracion para conectar a la base de datos
require_once ("config/conexion.php");//Contiene funcion que conecta a la base de datos
include('menu.php');

// LÓGICA ORIGINAL (NO TOCAR)
$sql1="select * from users where user_id=$_SESSION[user_id]";
$rw1=mysqli_query($con,$sql1);
$rs1=mysqli_fetch_array($rw1);
$modulo=$rs1["accesos"];
$tienda=$_SESSION['tienda'];
$sql2="select * from sucursal where tienda=$tienda";
$rw2=mysqli_query($con,$sql2);
$rs2=mysqli_fetch_array($rw2);
$ruc=$rs2["ruc"];

$a = explode(".", $modulo); 
if (!isset($_SESSION['user_login_status']) AND $_SESSION['user_login_status'] != 1) {
    header("location: login.php");
    exit;
}
if($a[26]==0){
    header("location:error.php");    
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Conf. Facturación Electrónica | SoundCrow</title>

    <link href="css/bootstrap.min.css" rel="stylesheet">
    <link href="fonts/css/font-awesome.min.css" rel="stylesheet">
    <link href="css/custom.min.css" rel="stylesheet">
    <link href="css/select/select2.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">

    <style>
        body { font-family: 'Poppins', sans-serif !important; background-color: #F0F2F5; color: #334155; }
        
        .sc-card {
            background: #ffffff; border-radius: 12px;
            box-shadow: 0 4px 20px rgba(0,0,0,0.05); border: none;
            overflow: hidden; margin-bottom: 30px;
        }
        .sc-header {
            background: linear-gradient(90deg, #0a2463 0%, #2473f2 100%);
            padding: 20px 30px; color: white;
            display: flex; align-items: center; justify-content: space-between;
        }
        .sc-title { margin: 0; font-size: 18px; font-weight: 700; text-transform: uppercase; letter-spacing: 0.5px; color: white; }
        .sc-body { padding: 19px 25px }

        /* Subtítulos de Sección */
        .sc-subtitle {
            font-size: 14px; font-weight: 700; color: #0a2463; 
            border-bottom: 2px solid #e2e8f0; padding-bottom: 10px; 
            margin-bottom: 20px; text-transform: uppercase;
            display: flex; align-items: center; gap: 10px;
        }
        .sc-subtitle i { color: #2473f2; }

        /* Inputs Modernos */
        .form-control-sc {
            border-radius: 8px; border: 1px solid #e2e8f0;
            padding: 10px 15px; height: 45px; background-color: #f8fafc;
            width: 100%; transition: 0.3s; color: #334155; font-weight: 500;
        }
        .form-control-sc:focus {
            background-color: #fff; border-color: #2473f2;
            box-shadow: 0 0 0 3px rgba(36, 115, 242, 0.1); outline: none;
        }
        .form-label-sc {
            font-weight: 600; color: #64748b; font-size: 12px;
            text-transform: uppercase; margin-bottom: 8px; display: block;
        }

        /* Input File Personalizado */
        .input-file-wrapper {
            position: relative; overflow: hidden; display: inline-block; width: 100%;
        }
        .input-file-wrapper input[type=file] {
            font-size: 100px; position: absolute; left: 0; top: 0; opacity: 0; cursor: pointer;
        }
        .btn-file-custom {
            background: white; border: 2px dashed #cbd5e1; color: #64748b;
            padding: 10px; border-radius: 8px; text-align: center; width: 100%;
            font-weight: 600; cursor: pointer; transition: all 0.3s;
        }
        .btn-file-custom:hover { border-color: #2473f2; color: #2473f2; background: #f0f9ff; }
        
        /* Botón Guardar */
        .btn-save {
            background: #2473f2; color: white; border-radius: 30px;
            padding: 12px 40px; border: none; font-weight: 600;
            box-shadow: 0 4px 10px rgba(36, 115, 242, 0.3); transition: all 0.3s;
        }
        .btn-save:hover { background: #1d4ed8; transform: translateY(-2px); }

        /* Select2 Custom */
        .select2-container .select2-selection--single { height: 45px !important; border: 1px solid #e2e8f0 !important; border-radius: 8px !important; background-color: #f8fafc !important; }
        .select2-container--default .select2-selection--single .select2-selection__rendered { line-height: 45px !important; color: #334155 !important; padding-left: 15px !important; }
        .select2-container--default .select2-selection--single .select2-selection__arrow { height: 45px !important; right: 10px !important; }
    </style>
</head>

<body class="nav-md">
    <div class="container body">
        <div class="main_container">

            <div class="col-md-3 left_col">
                <div class="left_col scroll-view">
                    <div class="clearfix"></div>
                    <?php menu2(); menu1(); ?>
                </div>
            </div>

            <?php menu3(); ?>

            <div class="right_col" role="main">
                
                <?php
                // LÓGICA DE RECUPERACIÓN DE DATOS (INTACTA)
                $sql1="SELECT * FROM datosempresa WHERE id_emp=1";
                $rw1=mysqli_query($con,$sql1);
                while ($valor1 = mysqli_fetch_array($rw1)) {
                    $usuariosol=$valor1['usuariosol'];
                    $clavesol=$valor1['clavesol'];
                    $clave=$valor1['clave'];
                    $fac_ele=$valor1['fac_ele'];
                }
                ?>

                <div class="row">
                    <div class="col-md-12" style="padding-top: 15px;">
                        <form class="form-horizontal" id="guardar_producto" enctype="multipart/form-data" action="conf_electronica1.php" method="POST">
                            
                            <div class="sc-card">
                                <div class="sc-header">
                                    <h3 class="sc-title"><i class="fa fa-cogs"></i> Configuración Facturación Electrónica</h3>
                                </div>
                                
                                <div class="sc-body">
                                    
                                    <div class="sc-subtitle"><i class="fa fa-rocket"></i> Entorno de Ejecución</div>
                                    
                                    <div class="row" style="margin-bottom: 30px;">
                                        <div class="col-md-6 col-sm-12">
                                            <label class="form-label-sc">Tipo de Fase (Entorno)</label>
                                            <select class="form-control-sc select2_single" id="fac_ele" name="fac_ele" style="width: 100%;">
                                                <?php         
                                                if ($fac_ele==3) {
                                                    echo '<option value="3" selected>Beta (Pruebas)</option>';
                                                    echo '<option value="1">Producción</option>';
                                                }         
                                                if ($fac_ele==1) {
                                                    echo '<option value="1" selected>Producción</option>';
                                                    echo '<option value="3">Beta (Pruebas)</option>';
                                                }         
                                                ?>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="sc-subtitle"><i class="fa fa-key"></i> Credenciales SUNAT (SOL)</div>

                                    <div class="row" style="margin-bottom: 30px;">
                                        <div class="col-md-6 col-sm-12">
                                            <label class="form-label-sc">Usuario SOL</label>
                                            <div class="input-group">
                                                <span class="input-group-addon" style="background:#e0f2fe; border:1px solid #e2e8f0; color:#0284c7;"><i class="fa fa-user"></i></span>
                                                <input type="text" class="form-control-sc" id="usuariosol" name="usuariosol" placeholder="Ej: MODDATOS" value="<?php echo $usuariosol;?>">
                                            </div>
                                        </div>
                                        <div class="col-md-6 col-sm-12">
                                            <label class="form-label-sc">Clave SOL</label>
                                            <div class="input-group">
                                                <span class="input-group-addon" style="background:#e0f2fe; border:1px solid #e2e8f0; color:#0284c7;"><i class="fa fa-lock"></i></span>
                                                <input type="text" class="form-control-sc" id="clavesol" name="clavesol" placeholder="Ej: moddatos" value="<?php echo $clavesol;?>">
                                            </div>
                                        </div>
                                    </div>

                                    <input type="hidden" id="ruc" name="ruc" value="<?php echo $ruc;?>">

                                    <div class="sc-subtitle"><i class="fa fa-certificate"></i> Certificado Digital</div>

                                    <div class="row">
                                        <div class="col-md-6 col-sm-12">
                                            <label class="form-label-sc">Archivo Certificado (.pfx)</label>
                                            <div class="input-file-wrapper">
                                                <div class="btn-file-custom">
                                                    <i class="fa fa-cloud-upload"></i> Seleccionar Archivo .pfx
                                                </div>
                                                <input type="file" id="files" name="files" accept=".pfx">
                                            </div>
                                            <small style="color:#64748b; display:block; margin-top:5px;">Si no desea cambiar el certificado, deje este campo vacío.</small>
                                        </div>
                                        <div class="col-md-6 col-sm-12">
                                            <label class="form-label-sc">Contraseña del Certificado</label>
                                            <div class="input-group">
                                                <span class="input-group-addon" style="background:#e0f2fe; border:1px solid #e2e8f0; color:#0284c7;"><i class="fa fa-key"></i></span>
                                                <input type="text" class="form-control-sc" id="clave" name="clave" placeholder="Contraseña del archivo .pfx" value="<?php echo $clave;?>">
                                            </div>
                                        </div>
                                    </div>

                                    <div class="row" style="margin-top: 40px;">
                                        <div class="col-md-12 text-center">
                                            <button type="submit" class="btn btn-save" id="guardar_datos">
                                                <i class="fa fa-save"></i> Guardar Configuración
                                            </button>
                                        </div>
                                    </div>

                                </div>
                            </div>
                        </form>
                    </div>
                </div>

            </div>
        </div>
    </div>

    <script src="js/jquery.min.js"></script>
    <script src="js/bootstrap.min.js"></script>
    <script src="js/custom.js"></script>
    <script src="js/nicescroll/jquery.nicescroll.min.js"></script>
    <script src="js/select/select2.full.js"></script>

    <script>
        $(document).ready(function() {
            // Inicializar Select2 con estilo moderno
            $(".select2_single").select2({
                placeholder: "Seleccionar opción",
                allowClear: false,
                minimumResultsForSearch: Infinity // Ocultar buscador si son pocas opciones
            });

            // Feedback visual al seleccionar archivo
            $('input[type="file"]').change(function(e){
                var fileName = e.target.files[0].name;
                $('.btn-file-custom').html('<i class="fa fa-check-circle" style="color:#10b981"></i> ' + fileName);
                $('.btn-file-custom').css('border-color', '#10b981');
                $('.btn-file-custom').css('background', '#ecfdf5');
            });
            
            // Auto-ocultar notificaciones si las hubiera
            window.setTimeout(function() {
                $(".alert").fadeTo(500, 0).slideUp(500, function(){
                    $(this).remove(); 
                });
            }, 3000);
        });
    </script>
</body>
</html>