<?php
// --- DIAGN07STICO DE ERRORES (Activo) ---
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

session_start();

// Verificaciones de seguridad y archivos
$archivos = ['menu.php', 'config/db.php', 'config/conexion.php'];
foreach ($archivos as $file) {
    if (!file_exists($file)) die("<div style='text-align:center; padding:50px; color:red;'>Error: Falta el archivo <b>$file</b></div>");
}

include('menu.php');
require_once ("config/db.php");
require_once ("config/conexion.php");

if (!isset($_SESSION['user_login_status']) OR $_SESSION['user_login_status'] != 1) {
    header("location: login.php"); exit;
}

// Consulta segura
$user_id = mysqli_real_escape_string($con, $_SESSION['user_id']);
$sql1 = "SELECT * FROM users WHERE user_id='$user_id'";
$rw1 = mysqli_query($con, $sql1);
$rs1 = mysqli_fetch_array($rw1);
$modulo = $rs1["accesos"];
$a = explode(".", $modulo); 

if (!isset($a[16]) || $a[16]==0) { header("location:error.php"); exit; }

$simbolo_moneda = defined('moneda') ? moneda : 'S/';
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Consulta de Precios | SoundCrow</title>

    <link rel="icon" href="logo.ico">
    <link href="css/bootstrap.min.css" rel="stylesheet">
    <link href="fonts/css/font-awesome.min.css" rel="stylesheet">
    <link href="css/custom.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="//code.jquery.com/ui/1.11.4/themes/smoothness/jquery-ui.css">

    <style>
        body { font-family: 'Poppins', sans-serif !important; background-color: #F0F2F5; color: #334155; }
        
        /* Tarjeta Principal */
        .sc-card { 
            background: #ffffff; 
            border-radius: 16px; 
            box-shadow: 0 10px 40px rgba(0,0,0,0.08); 
            border: none; 
            overflow: hidden; 
            max-width: 850px; 
            margin: 20px auto; 
        }
        
        /* Cabecera con Gradiente */
        .sc-header { 
            background: linear-gradient(135deg, #0a2463 0%, #2473f2 100%); 
            padding: 35px 30px; 
            text-align: center; 
            color: white; 
        }
        .sc-title { font-size: 24px; font-weight: 700; margin: 0; text-transform: uppercase; letter-spacing: 1px; }
        .sc-subtitle { font-size: 13px; opacity: 0.8; margin-top: 5px; }

        /* Cuerpo */
        .sc-body { padding: 40px; }

        /* Input de Bsqueda */
        .search-group { position: relative; margin-bottom: 30px; }
        .search-icon { position: absolute; left: 20px; top: 15px; color: #94a3b8; font-size: 20px; }
        .form-control-sc { 
            width: 100%; 
            padding: 15px 15px 15px 55px; 
            font-size: 16px; 
            border-radius: 12px; 
            border: 2px solid #e2e8f0; 
            background-color: #f8fafc; 
            color: #334155; 
            font-weight: 500; 
            transition: all 0.3s;
        }
        .form-control-sc:focus { 
            background-color: #fff; 
            border-color: #2473f2; 
            outline: none; 
            box-shadow: 0 0 0 4px rgba(36, 115, 242, 0.1); 
        }

        /* Seccin de Resultados */
        .result-container { display: none; /* Oculto al inicio */ animation: fadeIn 0.5s; }
        @keyframes fadeIn { from { opacity: 0; transform: translateY(10px); } to { opacity: 1; transform: translateY(0); } }

        /* Caja de Precio */
        .price-display {
            background: #eff6ff;
            border: 2px dashed #bfdbfe;
            border-radius: 12px;
            padding: 20px;
            text-align: center;
            margin-bottom: 25px;
        }
        .price-label { font-size: 12px; text-transform: uppercase; color: #64748b; font-weight: 700; letter-spacing: 1px; }
        .price-value { font-size: 42px; font-weight: 800; color: #2563eb; display: block; margin-top: 5px; }
        
        /* Grid de Detalles */
        .details-grid { display: grid; grid-template-columns: repeat(2, 1fr); gap: 20px; }
        .detail-box { 
            background: white; 
            border: 1px solid #e2e8f0; 
            border-radius: 10px; 
            padding: 15px; 
            transition: 0.2s;
        }
        .detail-box:hover { border-color: #cbd5e1; box-shadow: 0 4px 6px rgba(0,0,0,0.02); }
        .detail-title { font-size: 11px; color: #94a3b8; text-transform: uppercase; font-weight: 700; display: block; margin-bottom: 5px; }
        .detail-data { font-size: 15px; color: #1e293b; font-weight: 600; width: 100%; border: none; background: transparent; }

        /* Botn Limpiar */
        .btn-clean { 
            background: #fee2e2; color: #dc2626; border: none; 
            padding: 12px; border-radius: 10px; width: 100%; 
            font-weight: 600; margin-top: 25px; cursor: pointer; transition: 0.2s; 
        }
        .btn-clean:hover { background: #fecaca; }

        /* Estado Inicial */
        .empty-state { text-align: center; padding: 40px; color: #94a3b8; }
        .empty-icon { font-size: 60px; margin-bottom: 15px; opacity: 0.3; }
    </style>
</head>

<body class="nav-md">
    <div class="container body">
        <div class="main_container">
            <div class="col-md-3 left_col"><div class="left_col scroll-view"><div class="clearfix"></div><?php menu2(); menu1(); ?></div></div>
            <?php menu3(); ?>

            <div class="right_col" role="main">
                
                <div class="sc-card">
                    <div class="sc-header">
                        <h1 class="sc-title"><i class="fa fa-tags"></i> Consulta de Precios</h1>
                        <div class="sc-subtitle">Busca productos por nombre o cdigo de barras</div>
                    </div>

                    <div class="sc-body">
                        <div class="search-group">
                            <i class="fa fa-search search-icon"></i>
                            <input type="search" class="form-control-sc" id="nombre_producto" placeholder="Escribe el nombre del producto aqu..." autofocus>
                            <input type="hidden" id="id_producto">
                        </div>

                        <div id="empty-state" class="empty-state">
                            <i class="fa fa-barcode empty-icon"></i>
                            <p>Usa el buscador para ver los detalles del producto.</p>
                        </div>

                        <div id="result-container" class="result-container">
                            
                            <div class="price-display">
                                <span class="price-label">Precio de Venta</span>
                                <span class="price-value" id="display_precio">S/ 0.00</span>
                            </div>

                            <div class="details-grid">
                                <div class="detail-box">
                                    <span class="detail-title">Stock Disponible</span>
                                    <input type="text" class="detail-data" id="inv_producto" readonly style="color: #059669;">
                                </div>
                                <div class="detail-box">
                                    <span class="detail-title">Marca</span>
                                    <input type="text" class="detail-data" id="marca" readonly>
                                </div>
                                <div class="detail-box">
                                    <span class="detail-title">Modelo</span>
                                    <input type="text" class="detail-data" id="modelo" readonly>
                                </div>
                                <div class="detail-box">
                                    <span class="detail-title">Tipo / Estado</span>
                                    <input type="text" class="detail-data" id="tipo_text" readonly>
                                </div>
                                <input type="hidden" id="precio">
                                <input type="hidden" id="tipo">
                                <input type="hidden" id="color">
                                <input type="hidden" id="foto">
                            </div>

                            <button class="btn-clean" onclick="limpiarFormulario()">
                                <i class="fa fa-trash"></i> Limpiar Consulta
                            </button>
                        </div>

                    </div>
                </div>

            </div>
        </div>
    </div>

    <script src="js/jquery.min.js"></script>
    <script src="js/bootstrap.min.js"></script>
    <script src="js/nicescroll/jquery.nicescroll.min.js"></script> <script src="js/custom.js"></script>
    
    <script src="//code.jquery.com/ui/1.11.4/jquery-ui.js"></script>

    <script>
        $(function() {
            // Configuracin del Autocomplete
            $("#nombre_producto").autocomplete({
                source: "./ajax/autocomplete/productos1.php",
                minLength: 1,
                select: function(event, ui) {
                    event.preventDefault();
                    
                    // Llenar campos ocultos y visibles
                    $('#id_producto').val(ui.item.id_producto);
                    $('#nombre_producto').val(ui.item.nombre_producto);
                    
                    // Mostrar Precio bonito
                    var precio = parseFloat(ui.item.precio_producto).toFixed(2);
                    $('#display_precio').text("<?php echo $simbolo_moneda; ?> " + precio);
                    $('#precio').val(precio);

                    $('#inv_producto').val(ui.item.inv_producto);
                    $('#marca').val(ui.item.marca);
                    $('#modelo').val(ui.item.modelo);
                    
                    // Texto legible para Tipo
                    var tipoRaw = ui.item.status_producto; // Asumiendo que viene en el JSON
                    var tipoText = "Normal";
                    if(tipoRaw == 0) tipoText = "De Segunda";
                    if(tipoRaw == 1) tipoText = "Nuevo";
                    if(tipoRaw == 2) tipoText = "Repuesto";
                    $('#tipo_text').val(tipoText);

                    // Efecto visual: Ocultar vaco, Mostrar resultados
                    $('#empty-state').slideUp();
                    $('#result-container').slideDown();
                    
                    // Limpiar input para esttica (opcional)
                    $(this).val("");
                }
            });
        });

        // Funcin Limpiar
        function limpiarFormulario() {
            $('#result-container').slideUp();
            $('#empty-state').slideDown();
            $("#nombre_producto").val("").focus();
            
            // Resetear valores internos
            $('#id_producto').val("");
            $('#precio').val("");
            $('#inv_producto').val("");
        }

        // Detectar tecla borrar para limpiar
        $("#nombre_producto").on("keydown", function(event) {
            if (event.keyCode == $.ui.keyCode.DELETE || event.keyCode == $.ui.keyCode.BACKSPACE) {
                if($(this).val().length < 2) {
                    limpiarFormulario();
                }
            }
        });
    </script>
</body>
</html>