<?php
// descargar_archivo.php
ob_start(); // Iniciar búfer
session_start();

if (!isset($_SESSION['user_login_status']) AND $_SESSION['user_login_status'] != 1) {
    header("HTTP/1.0 403 Forbidden");
    exit;
}

$name = basename($_GET['name']);
$type = $_GET['type'];
// Nuevo parámetro: si es 1, se ve en navegador. Si no, se descarga.
$view = isset($_GET['view']) ? $_GET['view'] : 0; 

if ($type == 'xml') {
    $ruta = 'pdf/documentos/factura-firmada/' . $name;
} else {
    $ruta = 'pdf/documentos/cdr/' . $name;
}

if (file_exists($ruta)) {
    ob_end_clean(); // Limpieza total
    
    // Si view=1, usamos 'inline' (ver), si no 'attachment' (descargar)
    $disposition = ($view == 1) ? 'inline' : 'attachment';

    header('Content-Description: File Transfer');
    header('Content-Type: text/xml; charset=utf-8'); // text/xml ayuda a que el navegador lo muestre bonito
    header('Content-Disposition: ' . $disposition . '; filename="'.basename($ruta).'"');
    header('Expires: 0');
    header('Cache-Control: must-revalidate');
    header('Pragma: public');
    header('Content-Length: ' . filesize($ruta));
    
    readfile($ruta);
    exit;
} else {
    ob_end_clean();
    echo "El archivo no existe.";
}
?>