<?php
session_start();
if (!isset($_SESSION['user_login_status']) AND $_SESSION['user_login_status'] != 1) {
    header("location: login.php");
    exit;
}
require_once ("config/db.php");
require_once ("config/conexion.php");

// Configuracin Excel
header("Content-Type:   application/vnd.ms-excel; charset=utf-8");
header("Content-Disposition: attachment; filename=Reporte_Clientes_".date('d-m-Y').".xls");
header("Pragma: no-cache");
header("Expires: 0");

echo "
<table border='1'>
    <tr style='background-color: #0a2463; color: white;'>
        <th>NRO</th>
        <th>DOCUMENTO</th>
        <th>NOMBRE</th>
        <th>DIRECCION</th>
        <th>TELEFONO</th>
        <th>FECHA REGISTRO</th>
    </tr>";

$sql = "SELECT * FROM clientes ORDER BY nombre_cliente ASC";
$query = mysqli_query($con, $sql);
$item = 0;

while ($row = mysqli_fetch_array($query)) {
    $item++;
    
    // --- L07GICA INTELIGENTE PARA ENCONTRAR EL DOCUMENTO ---
    $doc = "";
    if(!empty($row['documento_cliente'])) { $doc = $row['documento_cliente']; }
    elseif(!empty($row['documento'])) { $doc = $row['documento']; }
    elseif(!empty($row['dni'])) { $doc = $row['dni']; }
    elseif(!empty($row['ruc'])) { $doc = $row['ruc']; }
    elseif(!empty($row['numero_documento'])) { $doc = $row['numero_documento']; }
    // ------------------------------------------------------

    echo "
    <tr>
        <td>".$item."</td>
        <td style='mso-number-format:\"@\";'>".$doc."</td>
        <td>".utf8_decode($row['nombre_cliente'])."</td>
        <td>".utf8_decode($row['direccion_cliente'])."</td>
        <td>".$row['telefono_cliente']."</td>
        <td>".date("d/m/Y", strtotime($row['date_added']))."</td>
    </tr>";
}
echo "</table>";
?>