<?php   
    session_start();
    include('menu.php');
    require_once ("config/db.php");
    require_once ("config/conexion.php");   
    
    if (!isset($_SESSION['user_login_status']) AND $_SESSION['user_login_status'] != 1) {
        header("Location: login.php");
        exit;
    }
    
    $sql1="select * from users where user_id=$_SESSION[user_id]";
    $rw1=mysqli_query($con,$sql1);
    $rs1=mysqli_fetch_array($rw1);
    $modulo=$rs1["accesos"];
    $a = explode(".", $modulo); 
    
    if($a[8]==0){ header("location:error.php"); }
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="icon" href="logo.png" type="image/png">
    <title>Facturas y Boletas | SoundCrow</title>
    
    <link href="css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css" rel="stylesheet">
    <link href="css/custom.min.css" rel="stylesheet">
    
    <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:wght@400;500;600;700;800&display=swap" rel="stylesheet">

    <style>
        body { background-color: #f1f5f9; font-family: 'Plus Jakarta Sans', sans-serif; color: #334155; }
        
        /* HEADER AZUL INTENSO */
        .form-header {
            background: linear-gradient(135deg, #0f172a 0%, #1e40af 100%);
            color: white;
            padding: 25px 40px;
            border-radius: 12px 12px 0 0;
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-top: 60px; 
            box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -1px rgba(0, 0, 0, 0.06);
            position: relative;
            overflow: hidden;
        }
        
        .form-header::after {
            content: "\f0f6";
            font-family: 'FontAwesome';
            position: absolute;
            right: 35px;
            top: 50%;
            transform: translateY(-50%);
            font-size: 55px;
            color: rgba(255, 255, 255, 0.15);
            pointer-events: none;
        }

        .form-header h3 { 
            margin: 0; 
            font-size: 18px; 
            font-weight: 800; 
            letter-spacing: 0.5px; 
            text-transform: uppercase; 
            position: relative; z-index: 2; 
        }
        .form-header p { 
            margin: 5px 0 0 0; 
            font-size: 13px; 
            opacity: 0.8; 
            font-weight: 500; 
            position: relative; z-index: 2; 
        }
        
        .header-actions { position: relative; z-index: 5; margin-right: 60px; }

        .form-container {
            background: white;
            padding: 30px;
            border-radius: 0 0 12px 12px;
            box-shadow: 0 10px 15px -3px rgba(0, 0, 0, 0.1);
            margin-bottom: 50px;
            border: 1px solid #e2e8f0;
            border-top: none;
        }

        .form-label { font-size: 12px; font-weight: 700; color: #64748b; text-transform: uppercase; margin-bottom: 5px; display: block; }
        
        .form-control {
            border: 2px solid #e2e8f0; border-radius: 8px; height: 42px; padding: 8px 15px;
            font-size: 13px; font-weight: 500; color: #334155; transition: all 0.3s; background-color: #f8fafc; box-shadow: none;
        }
        .form-control:focus { border-color: #3b82f6; background: white; box-shadow: 0 0 0 4px rgba(59, 130, 246, 0.1); outline: none; }
        .input-group-addon { background-color: #f1f5f9; border: 2px solid #e2e8f0; border-right: none; color: #64748b; border-radius: 8px 0 0 8px; }
        .input-group .form-control { border-radius: 0 8px 8px 0; }

        .btn-new {
            background: rgba(255,255,255,0.2); border: 1px solid rgba(255,255,255,0.3); color: white;
            padding: 8px 20px; border-radius: 6px; font-weight: 700; font-size: 13px; transition: 0.3s;
            display: flex; align-items: center; gap: 8px; text-decoration: none !important;
        }
        .btn-new:hover { background: white; color: #1e40af; transform: translateY(-1px); }

        .btn-modern {
            border: none; border-radius: 50px; padding: 10px 25px; font-weight: 700; font-size: 13px;
            transition: 0.3s; display: inline-flex; align-items: center; justify-content: center; gap: 8px; text-transform: uppercase;
        }
        .btn-search { background: linear-gradient(135deg, #2563eb 0%, #1d4ed8 100%); color: white; }
        .btn-search:hover { transform: translateY(-2px); box-shadow: 0 5px 15px rgba(37, 99, 235, 0.4); color: white; }
        .btn-clear { background: #e2e8f0; color: #475569; }
        .btn-clear:hover { background: #cbd5e1; color: #1e293b; transform: translateY(-2px); }

        /* TOAST */
        .custom-toast {
            position: fixed; top: 80px; right: 20px; z-index: 10000;
            background: white; border-left: 5px solid #2563eb; border-radius: 8px;
            padding: 20px; box-shadow: 0 10px 30px rgba(0,0,0,0.2);
            min-width: 300px; max-width: 450px;
            animation: slideInRight 0.5s cubic-bezier(0.175, 0.885, 0.32, 1.275);
            font-family: 'Plus Jakarta Sans', sans-serif;
        }
        .custom-toast-content { font-size: 13px; color: #334155; line-height: 1.5; }
        .custom-toast .close-btn { position: absolute; top: 5px; right: 10px; cursor: pointer; color: #94a3b8; font-size: 18px; font-weight: bold; }
        @keyframes slideInRight { from { transform: translateX(100%); opacity: 0; } to { transform: translateX(0); opacity: 1; } }
        @keyframes fadeOutRight { from { transform: translateX(0); opacity: 1; } to { transform: translateX(100%); opacity: 0; } }
    </style>
</head>

<body class="nav-md">
    <div class="container body">
        <div class="main_container">
            <div class="col-md-3 left_col">
                <div class="left_col scroll-view">
                    <div class="clearfix"></div>
                    <?php menu2(); menu1(); ?>
                </div>
            </div>
            <?php menu3(); ?>

            <div class="right_col" role="main">
                
                <div class="form-header">
                    <div>
                        <h3>Facturas y Boletas</h3>
                        <p>Gestión exclusiva de comprobantes de pago válidos (F/B).</p>
                    </div>
                    <div class="header-actions">
                        <a href="nueva_factura.php" class="btn-new">
                            <i class="fa fa-plus-circle"></i> Nuevo
                        </a>
                    </div>
                </div>

                <div class="form-container">
                    <form class="form-horizontal" id="datos_cotizacion">
                        <div class="row" style="margin-bottom: 20px;">
                            <div class="col-md-4 col-sm-6 col-xs-12" style="margin-bottom: 15px;">
                                <label class="form-label">Cliente</label>
                                <div class="input-group">
                                    <span class="input-group-addon"><i class="fa fa-user"></i></span>
                                    <input type="text" class="form-control" id="q" placeholder="Nombre o Razón Social..." autocomplete="off">
                                </div>
                            </div>
                            <div class="col-md-2 col-sm-6 col-xs-12" style="margin-bottom: 15px;">
                                <label class="form-label">Nro. Doc</label>
                                <div class="input-group">
                                    <span class="input-group-addon"><i class="fa fa-barcode"></i></span>
                                    <input type="text" class="form-control" id="q1" placeholder="Ej: F001-123" autocomplete="off">
                                </div>
                            </div>
                            <div class="col-md-2 col-sm-4 col-xs-12" style="margin-bottom: 15px;">
                                <label class="form-label">Tipo</label>
                                <select class="form-control" id="q4">
                                    <option value="">Todos (F y B)</option>
                                    <option value="1">Factura</option>
                                    <option value="2">Boleta</option>
                                </select>
                            </div>
                            <div class="col-md-2 col-sm-4 col-xs-6" style="margin-bottom: 15px;">
                                <label class="form-label">Desde</label>
                                <input type="date" class="form-control" id="q2">
                            </div>
                            <div class="col-md-2 col-sm-4 col-xs-6" style="margin-bottom: 15px;">
                                <label class="form-label">Hasta</label>
                                <input type="date" class="form-control" id="q3">
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-12 text-center" style="border-top: 1px solid #f1f5f9; padding-top: 20px;">
                                <button type="button" class="btn-modern btn-clear" id="btnClear"><i class="fa fa-eraser"></i> Limpiar</button>
                                <button type="button" class="btn-modern btn-search" onclick="load(1);"><i class="fa fa-search"></i> Buscar</button>
                                <span id="loader"></span>
                            </div>
                        </div>
                    </form>

                    <hr style="margin-top: 20px; border-color: #f1f5f9;">
                    <div id="resultados"></div>
                    <div class="outer_div"></div>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="modalVista" tabindex="-1" role="dialog" aria-labelledby="modalVistaLabel">
        <div class="modal-dialog modal-lg" role="document" style="width: 90%; max-width: 1000px;">
            <div class="modal-content" style="border-radius: 12px; border: none; overflow: hidden;">
                <div class="modal-header" style="background: linear-gradient(135deg, #0f172a 0%, #1e40af 100%); color: white; border-radius: 12px 12px 0 0; padding: 15px 25px;">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close" style="color: white; opacity: 1; text-shadow: none;"><span aria-hidden="true">&times;</span></button>
                    <h4 class="modal-title" id="tituloVista" style="font-weight: 700;"><i class="fa fa-eye"></i> Visualización de Archivo</h4>
                </div>
                <div class="modal-body" style="padding: 0; height: 75vh; background: #f1f5f9;">
                    <iframe id="iframeVista" src="" style="width: 100%; height: 100%; border: none;"></iframe>
                </div>
                <div class="modal-footer" style="background: white; border-top: 1px solid #e2e8f0; padding: 15px 25px;">
                    <button type="button" class="btn btn-default" data-dismiss="modal" style="border-radius: 6px; font-weight: 600;">Cerrar</button>
                    <a href="#" id="btnDescargarModal" class="btn btn-primary" style="border-radius: 6px; font-weight: 600; background: #10b981; border: none;">
                        <i class="fa fa-download"></i> Descargar Copia
                    </a>
                </div>
            </div>
        </div>
    </div>

    <script src="js/jquery.min.js"></script>
    <script src="js/bootstrap.min.js"></script>
    <script src="js/progressbar/bootstrap-progressbar.min.js"></script>
    <script src="js/nicescroll/jquery.nicescroll.min.js"></script> 
    <script src="js/icheck/icheck.min.js"></script>
    <script src="js/custom.js"></script>
    <script type="text/javascript" src="js/VentanaCentrada.js"></script>
    
    <script>
        $(document).ready(function(){
            $('[data-toggle="tooltip"]').tooltip();
            load(1);
        });

        // FUNCIÓN PRINCIPAL PARA ABRIR MODAL (LLAMADA DESDE LA TABLA)
        function ver_archivo(nombre, tipo) {
            // 1. URL PARA VER (view=1) -> Se carga en el iframe
            var urlVer = 'descargar_archivo.php?type=' + tipo + '&name=' + nombre + '&view=1';
            
            // 2. URL PARA DESCARGAR (sin view) -> Se pone en el botón
            var urlDescargar = 'descargar_archivo.php?type=' + tipo + '&name=' + nombre;

            // 3. Asignar al DOM
            $('#iframeVista').attr('src', urlVer);
            $('#btnDescargarModal').attr('href', urlDescargar);
            
            // 4. Título Dinámico
            var titulo = (tipo == 'xml') ? 'Factura XML' : 'Constancia CDR';
            $('#tituloVista').html('<i class="fa fa-eye"></i> Visualizando: ' + titulo + ' <small style="color: #cbd5e1;">' + nombre + '</small>');

            // 5. Mostrar
            $('#modalVista').modal('show');
        }
        
        // Limpiar iframe al cerrar para ahorrar memoria
        $('#modalVista').on('hidden.bs.modal', function () {
            $('#iframeVista').attr('src', '');
        });

        function load(page){
            var q = $("#q").val();
            var q1 = $("#q1").val();
            var q2 = $("#q2").val();
            var q3 = $("#q3").val();
            var q4 = $("#q4").val();
            $("#loader").fadeIn('slow');
            $.ajax({
                url:'./ajax/buscar_fac.php?action=ajax&page='+page+'&q='+q+'&q1='+q1+'&q2='+q2+'&q3='+q3+'&q4='+q4,
                beforeSend: function(objeto){ $('#loader').html('<img src="./img/ajax-loader.gif"> Cargando...'); },
                success:function(data){ $(".outer_div").html(data).fadeIn('slow'); $('#loader').html(''); }
            })
        }

        // Búsqueda en Vivo
        function debounce(func, wait) {
            let timeout;
            return function(...args) {
                const context = this;
                clearTimeout(timeout);
                timeout = setTimeout(() => func.apply(context, args), wait);
            };
        }
        const busquedaEnVivo = debounce(function() { load(1); }, 300);
        document.getElementById('q').addEventListener('input', busquedaEnVivo);
        document.getElementById('q1').addEventListener('input', busquedaEnVivo);
        document.getElementById('q4').addEventListener('change', busquedaEnVivo);
        document.getElementById('q2').addEventListener('change', busquedaEnVivo);
        document.getElementById('q3').addEventListener('change', busquedaEnVivo);

        // Enviar a SUNAT
        function enviar(nombre_archivo){
            mostrarToast('<i class="fa fa-spinner fa-spin"></i> Conectando con SUNAT...', 'info');
            $.ajax({
                type: "GET",
                url: "./pdf/documentos/enviar_sunat.php",
                data: { fac: nombre_archivo }, 
                success: function(datos){ mostrarToast(datos, 'success'); load(1); }
            });
        } 

        function mostrarToast(contenido, tipo) {
            $(".custom-toast").remove();
            var borderColor = "#2563eb"; 
            if(tipo === 'error') borderColor = "#ef4444";
            var toastHTML = `<div class="custom-toast" style="border-left-color: ${borderColor};"><div class="close-btn" onclick="$(this).parent().fadeOut();">&times;</div><div class="custom-toast-content">${contenido}</div></div>`;
            $("body").append(toastHTML);
            setTimeout(function(){ var toast = $(".custom-toast"); toast.css('animation', 'fadeOutRight 0.5s forwards'); setTimeout(function(){ toast.remove(); }, 500); }, 8000);
        }
        
        function imprimir_factura(id_factura){ VentanaCentrada('./pdf/documentos/ver_factura.php?id_factura='+id_factura,'Factura','','1024','768','true'); }
function imprimir_ticket(id_factura){
    // 1. Construimos la URL
    var url = './pdf/documentos/ver_ticket.php?id_factura=' + id_factura;
    
    // 2. Cargamos el ticket dentro del iframe del modal
    $('#iframeVista').attr('src', url);
    
    // 3. Cambiamos el título del modal para que el usuario sepa qué ve
    $('#tituloVista').html('<i class="fa fa-print"></i> Ticket de Venta');
    
    // 4. Mostramos el modal (ID: modalVista)
    $('#modalVista').modal('show');
}
    </script>    
</body>
</html>