<?php
session_start();
include('menu.php');
require_once ("config/db.php");
require_once ("config/conexion.php");

$sql1="select * from users where user_id=$_SESSION[user_id]";
$rw1=mysqli_query($con,$sql1);
$rs1=mysqli_fetch_array($rw1);

$modulo=$rs1["accesos"];
$a = explode(".", $modulo); 

if (!isset($_SESSION['user_login_status']) AND $_SESSION['user_login_status'] != 1) {
    header("location: login.php");
    exit;
}
if($a[12]==0){
    header("location:error.php");    
}

?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="utf-8">
    <title>Gastos | SoundCrow</title>
    <link href="css/bootstrap.min.css" rel="stylesheet">
    <link href="fonts/css/font-awesome.min.css" rel="stylesheet">
    <link href="css/custom.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        body { font-family: 'Poppins', sans-serif; background-color: #F0F2F5; color: #334155; }
        .sc-card { background: #ffffff; border-radius: 12px; box-shadow: 0 4px 20px rgba(0,0,0,0.05); margin-bottom: 30px; overflow: hidden; }
        
        .sc-header { background: linear-gradient(90deg, #112b65 0%, #2563eb 100%); padding: 20px 30px; color: white; display: flex; justify-content: space-between; align-items: center; }
        .sc-title { margin: 0; font-size: 16px; font-weight: 700; text-transform: uppercase; letter-spacing: 0.5px; }
        
        .btn-new { background: rgba(255, 255, 255, 0.15); color: white; border: 1px solid rgba(255, 255, 255, 0.8); border-radius: 20px; padding: 6px 18px; font-weight: 600; font-size: 13px; transition: 0.3s; }
        .btn-new:hover { background: white; color: #112b65; }

        .label-filter { font-size: 11px; font-weight: 700; text-transform: uppercase; color: #64748b; margin-bottom: 5px; display:block; }
        .form-control-sc { border-radius: 8px; border: 1px solid #e2e8f0; height: 38px; font-size: 13px; width: 100%; padding: 0 12px; }
        .btn-search { background: #2563eb; color: white; border: none; border-radius: 8px; height: 38px; padding: 0 20px; font-weight: 600; width: 100%; }

        /* ============================================== */
        /* SISTEMA DE NOTIFICACIONES FLOTANTES (TOAST)    */
        /* ============================================== */
        .toast-sc-container { position: fixed; top: 20px; right: 20px; z-index: 99999; display: flex; flex-direction: column; gap: 10px; }
        .toast-sc {
            min-width: 280px; padding: 15px 20px; border-radius: 8px; color: white; box-shadow: 0 4px 15px rgba(0,0,0,0.2);
            display: flex; align-items: center; gap: 15px; animation: slideInRight 0.3s ease forwards;
        }
        .toast-sc.hide { animation: fadeOutRight 0.3s ease forwards; }
        .toast-success { background: #10b981; } /* Verde */
        .toast-error { background: #ef4444; } /* Rojo */
        .toast-icon { font-size: 24px; }
        .toast-text { display: flex; flex-direction: column; }
        .toast-title { font-weight: 700; font-size: 14px; margin-bottom: 2px; }
        .toast-desc { font-size: 13px; opacity: 0.95; }
        @keyframes slideInRight { from { transform: translateX(100%); opacity: 0; } to { transform: translateX(0); opacity: 1; } }
        @keyframes fadeOutRight { from { transform: translateX(0); opacity: 1; } to { transform: translateX(100%); opacity: 0; } }
    </style>
</head>
<body class="nav-md">
    <div class="container body">
        <div class="main_container">
            <div class="col-md-3 left_col"><div class="left_col scroll-view"><?php menu2(); menu1(); ?></div></div>
            <?php menu3(); ?>

            <div class="right_col" role="main">
                <div class="row">
                    <div class="col-md-12" style="padding-top:15px">
                        <div class="sc-card">
                            <div class="sc-header">
                                <h3 class="sc-title"><i class="fa fa-list-alt"></i> REGISTRO DE GASTOS</h3>
                                <button class="btn-new" data-toggle="modal" data-target="#nuevoGastoModal"><i class="fa fa-plus"></i> Nuevo Gasto</button>
                            </div>
                            <div class="sc-body" style="padding:25px;">
                                <div class="row">
                                    <div class="col-md-4 mb-3">
                                        <span class="label-filter">Motivo / Referencia</span>
                                        <input type="text" class="form-control-sc" id="q" placeholder="Buscar gasto..." onkeyup='load(1);'>
                                    </div>
                                    <div class="col-md-3 mb-3">
                                        <span class="label-filter">Desde</span>
                                        <input type="date" class="form-control-sc" id="q2" onchange='load(1);'>
                                    </div>
                                    <div class="col-md-3 mb-3">
                                        <span class="label-filter">Hasta</span>
                                        <input type="date" class="form-control-sc" id="q3" onchange='load(1);'>
                                    </div>
                                    <div class="col-md-2 mb-3">
                                        <span class="label-filter">&nbsp;</span>
                                        <button type="button" class="btn-search" onclick='load(1);'><i class="fa fa-search"></i> Buscar</button>
                                    </div>
                                </div>
                                <hr style="margin-top: 5px; margin-bottom: 20px; border-top: 1px solid #f1f5f9;">
                                
                                <div id="resultados_ajax"></div>
                                <div class='outer_div'></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="nuevoGastoModal" tabindex="-1" role="dialog">
      <div class="modal-dialog modal-sm" role="document">
        <div class="modal-content" style="border-radius:12px;">
          <div class="modal-header" style="background:#2563eb; color:white; border-radius:12px 12px 0 0;">
            <button type="button" class="close" data-dismiss="modal" style="color:white;">&times;</button>
            <h4 class="modal-title"><i class="fa fa-plus-circle"></i> Registrar Gasto</h4>
          </div>
          <div class="modal-body">
            <form id="guardar_gasto" name="guardar_gasto">
              <div class="form-group">
                <label>Registrado por (Trabajador):</label>
                <select class="form-control" id="id_usuario" name="id_usuario" required>
                    <option value="">-- Seleccionar Trabajador --</option>
                    <?php
                    $sql_users = mysqli_query($con, "SELECT user_id, nombres FROM users");
                    while($u = mysqli_fetch_array($sql_users)){
                        echo "<option value='".$u['user_id']."'>".$u['nombres']."</option>";
                    }
                    ?>
                </select>
              </div>
              <div class="form-group">
                <label>Motivo del gasto</label>
                <input type="text" class="form-control" id="referencia" name="referencia" required>
              </div>
              <div class="form-group">
                <label>Monto (S/.)</label>
                <input type="number" step="0.01" class="form-control" id="monto" name="monto" required>
              </div>
          </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-default" data-dismiss="modal">Cerrar</button>
            <button type="submit" class="btn btn-primary" id="guardar_datos">Guardar Gasto</button>
          </div>
          </form>
        </div>
      </div>
    </div>

    <div class="modal fade" id="editarGastoModal" tabindex="-1" role="dialog">
      <div class="modal-dialog modal-sm" role="document">
        <div class="modal-content" style="border-radius:12px;">
          <div class="modal-header" style="background:#3b82f6; color:white; border-radius:12px 12px 0 0;">
            <button type="button" class="close" data-dismiss="modal" style="color:white;">&times;</button>
            <h4 class="modal-title"><i class="fa fa-edit"></i> Editar Gasto</h4>
          </div>
          <div class="modal-body">
            <form id="editar_gasto" name="editar_gasto">
              <input type="hidden" id="mod_id" name="mod_id">
              <div class="form-group">
                <label>Registrado por (Trabajador):</label>
                <select class="form-control" id="mod_id_usuario" name="mod_id_usuario" required>
                    <?php
                    $sql_users = mysqli_query($con, "SELECT user_id, nombres FROM users");
                    while($u = mysqli_fetch_array($sql_users)){
                        echo "<option value='".$u['user_id']."'>".$u['nombres']."</option>";
                    }
                    ?>
                </select>
              </div>
              <div class="form-group">
                <label>Motivo del gasto</label>
                <input type="text" class="form-control" id="mod_referencia" name="mod_referencia" required>
              </div>
              <div class="form-group">
                <label>Monto (S/.)</label>
                <input type="number" step="0.01" class="form-control" id="mod_monto" name="mod_monto" required>
              </div>
          </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-default" data-dismiss="modal">Cerrar</button>
            <button type="submit" class="btn btn-primary" id="actualizar_datos">Actualizar</button>
          </div>
          </form>
        </div>
      </div>
    </div>

    <script src="js/jquery.min.js"></script>
    <script src="js/bootstrap.min.js"></script>
    <script src="js/nicescroll/jquery.nicescroll.min.js"></script>
    <script src="js/custom.js"></script>
    <script>
        $(document).ready(function(){ load(1); });

        // Función que lanza el Toast visual
        function mostrar_notificacion(type, title, message) {
            if ($("#toast-container-sc").length === 0) {
                $("body").append('<div id="toast-container-sc" class="toast-sc-container"></div>');
            }
            var bgClass = type === 'success' ? 'toast-success' : 'toast-error';
            var iconClass = type === 'success' ? 'fa-check-circle' : 'fa-exclamation-triangle';
            var toastId = 'toast_' + Date.now();
            
            var toastHTML = `
                <div class="toast-sc ${bgClass}" id="${toastId}">
                    <div class="toast-icon"><i class="fa ${iconClass}"></i></div>
                    <div class="toast-text">
                        <span class="toast-title">${title}</span>
                        <span class="toast-desc">${message}</span>
                    </div>
                </div>
            `;
            $("#toast-container-sc").append(toastHTML);
            
            // Auto eliminar a los 3 segundos
            setTimeout(function() {
                $("#" + toastId).addClass("hide");
                setTimeout(function() { $("#" + toastId).remove(); }, 300);
            }, 3000);
        }

        function load(page){
            var q = $("#q").val();
            var q2 = $("#q2").val();
            var q3 = $("#q3").val();
            $.ajax({
                url:'./ajax/buscar_gastos.php?action=ajax&page='+page+'&q='+q+'&q2='+q2+'&q3='+q3,
                success:function(data){
                    $(".outer_div").html(data);
                }
            })
        }

        $("#guardar_gasto").submit(function( event ) {
            $('#guardar_datos').attr("disabled", true);
            var parametros = $(this).serialize();
            $.ajax({
                type: "POST",
                url: "ajax/nuevo_gasto.php",
                data: parametros,
                beforeSend: function(objeto){ $("#resultados_ajax").html(""); },
                success: function(datos){
                    $("#resultados_ajax").html(datos);
                    $('#guardar_datos').attr("disabled", false);
                    $('#nuevoGastoModal').modal('hide');
                    $("#guardar_gasto")[0].reset();
                    load(1);
                }
            });
            event.preventDefault();
        });

        $("#editar_gasto").submit(function( event ) {
            $('#actualizar_datos').attr("disabled", true);
            var parametros = $(this).serialize();
            $.ajax({
                type: "POST",
                url: "ajax/editar_gasto.php",
                data: parametros,
                beforeSend: function(objeto){ $("#resultados_ajax").html(""); },
                success: function(datos){
                    $("#resultados_ajax").html(datos);
                    $('#actualizar_datos').attr("disabled", false);
                    $('#editarGastoModal').modal('hide');
                    load(1);
                }
            });
            event.preventDefault();
        });

        function obtener_datos(id, referencia, monto, id_usuario){
            $("#mod_id").val(id);
            $("#mod_referencia").val(referencia);
            $("#mod_monto").val(monto);
            $("#mod_id_usuario").val(id_usuario);
        }

        function eliminar_gasto(id){
            if (confirm('¿Estás seguro que deseas eliminar este gasto de forma permanente?')) {
                $.ajax({
                    type: "GET",
                    url: "./ajax/buscar_gastos.php",
                    data: "action=ajax&id_gasto_eliminar=" + id,
                    beforeSend: function(objeto){ $("#resultados_ajax").html(""); },
                    success: function(datos){
                        $("#resultados_ajax").html(datos);
                        load(1);
                    }
                });
            }
        }
    </script>
</body>
</html>