<?php
/**
 * HISTORIAL_CAJAS.PHP - AUDITORÍA Y RESUMEN DE CAJAS
 * Diseño Moderno basado en sc-card (Estilo Conf. Electrónica).
 */
session_start();
if (!isset($_SESSION['user_login_status']) || $_SESSION['user_login_status'] != 1) { 
    header("location: login.php"); 
    exit; 
}

require_once ("config/db.php");
require_once ("config/conexion.php");

// Seguridad: Solo administradores (Rol 2) deberían ver todas las sucursales libremente
$user_id_actual = $_SESSION['user_id'];
$sql_rol = mysqli_query($con, "SELECT rol FROM users WHERE user_id = '$user_id_actual'");
$rw_rol = mysqli_fetch_array($sql_rol);
$rol_actual = isset($rw_rol['rol']) ? intval($rw_rol['rol']) : 1;

include('menu.php');
date_default_timezone_set('America/Lima');
$fecha_hoy = date("Y-m-d");

// Validación de Permisos (Asumo que es el primer módulo, índice 0)
$sql1="select * from users where user_id='".$_SESSION['user_id']."'";
$rw1=mysqli_query($con,$sql1);
$rs1=mysqli_fetch_array($rw1);
$modulo=$rs1["accesos"];
$a = explode(".", $modulo); 

if($a[27]==0){
    header("location:error.php");    
    exit;
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Historial de Cajas | SoundCrow</title>
    
    <link rel="icon" href="logo.ico">
    <link href="css/bootstrap.min.css" rel="stylesheet">
    <link href="fonts/css/font-awesome.min.css" rel="stylesheet">
    <link href="css/custom.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">

    <style>
        body { font-family: 'Poppins', sans-serif !important; background-color: #F0F2F5; color: #334155; }
        
        /* Contenedor Principal (Tarjeta) */
        .sc-card {
            background: #ffffff; border-radius: 12px;
            box-shadow: 0 4px 20px rgba(0,0,0,0.05); border: none;
            overflow: hidden; margin-bottom: 30px;
        }
        
        /* Cabecera en Degradado */
        .sc-header {
            background: linear-gradient(90deg, #0a2463 0%, #2473f2 100%);
            padding: 20px 30px; color: white;
            display: flex; align-items: center; justify-content: space-between;
        }
        .sc-title { margin: 0; font-size: 18px; font-weight: 700; text-transform: uppercase; letter-spacing: 0.5px; color: white; }
        
        /* Cuerpo del Card */
        .sc-body { padding: 25px; }

        /* Inputs Modernos */
        .form-control-sc {
            border-radius: 8px; border: 1px solid #e2e8f0;
            padding: 10px 15px; height: 45px; background-color: #f8fafc;
            width: 100%; transition: 0.3s; color: #334155; font-weight: 500;
        }
        .form-control-sc:focus {
            background-color: #fff; border-color: #2473f2;
            box-shadow: 0 0 0 3px rgba(36, 115, 242, 0.1); outline: none;
        }
        .form-label-sc {
            font-weight: 600; color: #64748b; font-size: 12px;
            text-transform: uppercase; margin-bottom: 8px; display: block;
        }

        /* Botones de Acción */
        .btn-search {
            background: #2473f2; color: white; border-radius: 8px;
            padding: 10px 20px; border: none; font-weight: 600; height: 45px; width: 100%;
            box-shadow: 0 4px 10px rgba(36, 115, 242, 0.3); transition: all 0.3s;
        }
        .btn-search:hover { background: #1d4ed8; transform: translateY(-2px); color: white; }
        
        .btn-report {
            background: #10b981; color: white; border-radius: 8px;
            padding: 10px 20px; border: none; font-weight: 600; height: 45px; width: 100%;
            box-shadow: 0 4px 10px rgba(16, 185, 129, 0.3); transition: all 0.3s;
        }
        .btn-report:hover { background: #059669; transform: translateY(-2px); color: white; }
        
        /* Estilos para el contenedor de la tabla */
        .table-container { margin-top: 20px; border-radius: 8px; overflow: hidden; border: 1px solid #e2e8f0; }
    </style>
</head>

<body class="nav-md">
    <div class="container body">
        <div class="main_container">
            <div class="col-md-3 left_col">
                <div class="left_col scroll-view">
                    <div class="clearfix"></div>
                    <?php menu2(); menu1(); ?>
                </div>
            </div>
            
            <?php menu3(); ?>

            <div class="right_col" role="main" style="background-color: #F0F2F5;">
                
                <div class="row">
                    <div class="col-md-12" style="padding-top: 15px;">
                        
                        <div class="sc-card">
                            
                            <div class="sc-header">
                                <h3 class="sc-title"><i class="fa fa-search"></i> Buscar Historial de Cajas</h3>
                            </div>
                            
                            <div class="sc-body">
                                
                                <form id="filtro_cajas" class="row" style="margin-bottom: 25px;">
                                    <div class="col-md-3 col-sm-6" style="margin-bottom: 15px;">
                                        <label class="form-label-sc">Fecha Inicio</label>
                                        <div class="input-group" style="width: 100%;">
                                            <input type="date" class="form-control-sc" id="f_inicio" value="<?php echo $fecha_hoy; ?>" onchange="load(1)">
                                        </div>
                                    </div>
                                    
                                    <div class="col-md-3 col-sm-6" style="margin-bottom: 15px;">
                                        <label class="form-label-sc">Fecha Fin</label>
                                        <div class="input-group" style="width: 100%;">
                                            <input type="date" class="form-control-sc" id="f_fin" value="<?php echo $fecha_hoy; ?>" onchange="load(1)">
                                        </div>
                                    </div>
                                    
                                    <div class="col-md-3 col-sm-6" style="margin-bottom: 15px;">
                                        <label class="form-label-sc">Sucursal / Tienda</label>
                                        <select class="form-control-sc" id="id_sucursal" onchange="load(1)">
                                            <?php if($rol_actual == 2): ?>
                                                <option value="todas">Todas las Tiendas</option>
                                            <?php endif; ?>
                                            <?php
                                            // Filtramos según el rol.
                                            $filtro_tienda = ($rol_actual == 2) ? "WHERE tipo_sucursal=1" : "WHERE id_sucursal='".$_SESSION['tienda']."' AND tipo_sucursal=1";
                                            $q_tiendas = mysqli_query($con, "SELECT * FROM sucursal $filtro_tienda");
                                            while ($rw = mysqli_fetch_array($q_tiendas)) {
                                                $nombre_s = !empty($rw['nombre_stand']) ? $rw['nombre_stand'] : $rw['nombre'];
                                                echo "<option value='".$rw['id_sucursal']."'>$nombre_s</option>";
                                            }
                                            ?>
                                        </select>
                                    </div>
                                    
                                    <div class="col-md-3 col-sm-6" style="display:flex; gap:10px; align-items:flex-end; padding-top: 23px; margin-bottom: 15px;">
                                        <button type="button" class="btn-search" onclick="load(1)">
                                            <i class="fa fa-search"></i> Buscar
                                        </button>
                                        <button type="button" class="btn-report" onclick="generarReporte()">
                                            <i class="fa fa-print"></i> Reporte
                                        </button>
                                    </div>
                                </form>

                                <hr style="border-top: 1px dashed #e2e8f0; margin-bottom: 20px;">

                                <div id="loader" style="text-align: center; display:none; margin-bottom:15px;">
                                    <img src="./img/ajax-loader.gif"> Consultando base de datos...
                                </div>
                                
                                <div class="table-container" id="resultados">
                                    </div>

                            </div>
                        </div>
                        </div>
                </div>
            </div>
            
            <?php footer(); ?>
            
        </div>
    </div>

    <script src="js/jquery.min.js"></script>
    <script src="js/bootstrap.min.js"></script>
    <script src="js/nicescroll/jquery.nicescroll.min.js"></script>
    <script src="js/custom.js"></script>

    <script>
        $(document).ready(function(){
            load(1);
        });

        function load(page){
            var f_inicio = $("#f_inicio").val();
            var f_fin = $("#f_fin").val();
            var sucursal = $("#id_sucursal").val();
            
            $("#loader").fadeIn('fast');
            $.ajax({
                url: './ajax/buscar_historial_cajas.php',
                type: 'GET',
                data: { action: 'ajax', page: page, f_inicio: f_inicio, f_fin: f_fin, sucursal: sucursal },
                success: function(data){
                    $("#resultados").html(data).fadeIn('fast');
                    $("#loader").fadeOut('fast');
                }
            });
        }

        function generarReporte() {
            var f_inicio = $("#f_inicio").val();
            var f_fin = $("#f_fin").val();
            var sucursal = $("#id_sucursal").val();
            
            var url = "reporte_cajas.php?f_inicio=" + f_inicio + "&f_fin=" + f_fin + "&sucursal=" + sucursal;
            window.open(url, '_blank');
        }
    </script>
</body>
</html>