<?php
session_start();
include('menu.php');
require_once ("config/db.php");
require_once ("config/conexion.php");

// 1. Verificar sesión
if (!isset($_SESSION['user_login_status']) AND $_SESSION['user_login_status'] != 1) {
    header("location: login.php"); exit;
}
$sql1="select * from users where user_id=$_SESSION[user_id]";
$rw1=mysqli_query($con,$sql1);
$rs1=mysqli_fetch_array($rw1);
$modulo=$rs1["accesos"];
$a = explode(".", $modulo); 
if($a[2]==0){ header("location:error.php"); }

// 2. PARCHE DE SEGURIDAD
if (!function_exists('recoge1')) {
    function recoge1($var) {
        $tmp = (isset($_REQUEST[$var])) ? trim(strip_tags($_REQUEST[$var])) : '';
        if (function_exists('get_magic_quotes_gpc') && get_magic_quotes_gpc()) { $tmp = stripslashes($tmp); }
        $tmp = str_replace('&', '&amp;',  $tmp);
        $tmp = str_replace('"', '&quot;', $tmp);
        return $tmp;
    }
}
$mensaje = recoge1('mensaje');

function generar_numero_aleatorio($longitud) {
    $key = '';
    $pattern = '1234567890';
    $max = strlen($pattern)-1;
    for($i=0;$i < $longitud;$i++) $key .= $pattern{mt_rand(0,$max)};
    return $key;
}

$barras_defecto = generar_numero_aleatorio(13);
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Ingreso de Productos | SoundCrow</title>
    
    <link rel="icon" href="logo.png" type="image/png">

    <link href="css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <link href="css/custom.min.css" rel="stylesheet">
    
    <link href="css/select/select2.min.css" rel="stylesheet">
    <link rel="stylesheet" href="//code.jquery.com/ui/1.11.4/themes/smoothness/jquery-ui.css">

    <style>
        body { font-family: 'Plus Jakarta Sans', sans-serif; }
        
        /* BANNER STATIC (Deep Ocean Blue) */
        .form-header {
            background: linear-gradient(135deg, #0f172a 0%, #1d4ed8 100%);
            color: white;
            padding: 25px 40px;
            border-radius: 15px 15px 0 0;
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-top: 60px; 
            box-shadow: 0 10px 25px rgba(15, 23, 42, 0.2);
        }
        
        .form-header h3 { margin: 0; font-size: 20px; font-weight: 800; letter-spacing: 1px; text-transform: uppercase; }
        .form-header p { margin: 5px 0 0 0; font-size: 13px; opacity: 0.8; font-weight: 500; }
        .header-icon { font-size: 32px; opacity: 0.8; color: rgba(255,255,255,0.8); }

        /* Contenedor Cuerpo */
        .form-container {
            background: white;
            padding: 40px;
            border-radius: 0 0 15px 15px;
            box-shadow: 0 20px 40px rgba(0,0,0,0.06);
            margin-bottom: 50px;
            border: 1px solid #e2e8f0; border-top: none;
        }

        /* Inputs Modernos */
        .form-group label {
            font-size: 11px; font-weight: 700; text-transform: uppercase;
            color: #64748b; margin-bottom: 8px; letter-spacing: 0.5px;
        }
        .form-control {
            border: 2px solid #f1f5f9; border-radius: 10px;
            padding: 10px 15px; height: 50px; font-size: 14px;
            background-color: #f8fafc; color: #334155; font-weight: 600;
            transition: all 0.3s; box-shadow: none;
        }
        .form-control:focus {
            background-color: #fff; border-color: #3b82f6;
            box-shadow: 0 0 0 4px rgba(59, 130, 246, 0.15);
        }
        
        /* INPUT FILE DINÁMICO */
        .file-input-wrapper {
            position: relative; height: 50px;
            border: 2px dashed #cbd5e1; border-radius: 10px;
            display: flex; align-items: center; justify-content: center;
            color: #64748b; cursor: pointer; transition: 0.3s; background: #f8fafc;
        }
        .file-input-wrapper:hover { border-color: #3b82f6; color: #3b82f6; background: #eff6ff; }
        .file-input-wrapper input[type="file"] { position: absolute; width: 100%; height: 100%; opacity: 0; cursor: pointer; }

        /* ESTADOS DE CARGA (CHECK/X) */
        .file-loaded {
            border-color: #10b981 !important; /* Verde */
            background-color: #ecfdf5 !important;
            color: #059669 !important;
            border-style: solid !important;
        }
        .file-empty {
            border-color: #ef4444 !important; /* Rojo */
            background-color: #fef2f2 !important;
            color: #dc2626 !important;
            border-style: solid !important;
        }

        /* BOTONES */
        .btn-toolbar { 
            margin-top: 40px; display: flex; justify-content: center; gap: 20px; 
            border-top: 1px solid #f1f5f9; padding-top: 30px; 
        }
        .btn-custom-primary {
            background: linear-gradient(135deg, #2563eb 0%, #1d4ed8 100%);
            color: white; border: none;
            padding: 14px 50px; font-weight: 800; border-radius: 50px;
            text-transform: uppercase; font-size: 13px; letter-spacing: 1px;
            transition: 0.3s; box-shadow: 0 10px 20px rgba(37, 99, 235, 0.3);
        }
        .btn-custom-primary:hover { 
            transform: translateY(-2px); 
            box-shadow: 0 15px 30px rgba(37, 99, 235, 0.4);
            background: linear-gradient(135deg, #3b82f6 0%, #2563eb 100%);
        }
        .btn-custom-light {
            background-color: white; color: #64748b; border: 2px solid #e2e8f0;
            padding: 14px 40px; font-weight: 700; border-radius: 50px;
            font-size: 13px; transition: 0.3s;
        }
        .btn-custom-light:hover { background-color: #f1f5f9; color: #ef4444; border-color: #ef4444; }

        /* Alertas */
        .alert-custom { border-radius: 10px; font-weight: 600; margin-top: 20px; border: none; box-shadow: 0 4px 15px rgba(0,0,0,0.05); }
    </style>
</head>

<body class="nav-md">
    <div class="container body">
        <div class="main_container">
            <div class="col-md-3 left_col">
                <div class="left_col scroll-view">
                    <div class="clearfix"></div>
                    <?php menu2(); menu1(); ?>
                </div>
            </div>
            
            <?php menu3(); ?>

            <div class="right_col" role="main">
                
                <?php if($mensaje<>""){ ?>
                <div class="alert alert-danger alert-custom alert-dismissible fade in" role="alert">
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">×</span></button>
                    <i class="fas fa-exclamation-circle margin-right-5"></i> <?php echo $mensaje;?>
                </div>
                <?php } ?>

                <form id="guardar_producto" enctype="multipart/form-data" action="ingresoproductos1.php" method="POST">
                    
                    <div class="form-header">
                        <div>
                            <h3>Ingreso de Nuevo Producto</h3>
                            <p>Registro de inventario</p>
                        </div>
                        <div class="header-icon">
                            <i class="fas fa-box-open"></i>
                        </div>
                    </div>

                    <div class="form-container">
                        
                        <div class="row">
                            <div class="col-md-8 col-sm-12 form-group">
                                <label for="nombre_producto">Nombre del Producto *</label>
                                <input type="text" class="form-control" id="nombre_producto" name="nombre" placeholder="Ej: Laptop HP Pavilion 15..." required autocomplete="off">
                                <input type="hidden" id="id_producto">
                            </div>
                            <div class="col-md-4 col-sm-12 form-group">
                                <label for="codigo">Código Interno *</label>
                                <input type="text" class="form-control" id="codigo" name="codigo" placeholder="Ej: PROD-001" required autocomplete="off">
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-3 col-sm-6 form-group">
                                <label for="costo">Costo Compra (S/)</label>
                                <input type="number" step="0.01" class="form-control" id="costo" name="costo" placeholder="0.00" required onChange="multiplicar();">
                            </div>
                            <div class="col-md-3 col-sm-6 form-group">
                                <label for="precio">Precio Venta (S/)</label>
                                <input type="number" step="0.01" class="form-control" id="precio" name="precio" placeholder="0.00">
                            </div>
                            <div class="col-md-3 col-sm-6 form-group">
                                <label for="inventario">Stock Inicial</label> 
                                <input type="number" class="form-control" id="inventario" name="inventario" placeholder="0" required> 
                            </div>
                            <div class="col-md-3 col-sm-6 form-group">
                                <label for="stockmin">Stock Mínimo</label>
                                <input type="number" class="form-control" id="stockmin" name="stockmin" placeholder="Ej: 5">
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-4 col-sm-6 form-group">
                                <label for="cat_pro">Categoría</label>
                                <select class="form-control" id="cat_pro" name="cat_pro" required>
                                    <?php 
                                    $sql_cat="select * from categorias";
                                    $rs_cat=mysqli_query($con,$sql_cat);
                                    while($row_cat=mysqli_fetch_array($rs_cat)){
                                        echo '<option value="'.$row_cat['id_categoria'].'">'.$row_cat['nom_cat'].'</option>';
                                    }
                                    ?>
                                </select>
                            </div>
                            
                            <div class="col-md-4 col-sm-6 form-group">
                                <label for="barras">Código de Barras (13 Dígitos)</label>
                                <div class="input-group">
                                    <span class="input-group-addon" style="background:#f8fafc; border:2px solid #f1f5f9; border-right:none; border-radius: 10px 0 0 10px;"><i class="fa fa-barcode"></i></span>
                                    <input type="text" class="form-control" id="barras" name="barras" value="<?php echo $barras_defecto;?>" required maxlength="13" style="border-radius: 0 10px 10px 0;">
                                </div>
                            </div>

                            <div class="col-md-4 col-sm-12 form-group">
                                <label for="files">Imagen del Producto</label>
                                <div class="file-input-wrapper" id="wrapper_files">
                                    <i class="fas fa-camera" id="icon_files" style="margin-right: 8px;"></i> 
                                    <span id="text_files">Subir Foto</span>
                                    <input type="file" id="files" name="files" accept="image/jpeg">
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-4 col-sm-6 form-group">
                                <label for="und_pro">Unidad de Medida</label>
                                <select class="form-control" id="und_pro" name="und_pro" required>
                                    <?php 
                                    $sql_und="select * from und";
                                    $rs_und=mysqli_query($con,$sql_und);
                                    while($row_und=mysqli_fetch_array($rs_und)){
                                        echo '<option value="'.$row_und['id_und'].'">'.$row_und['nom_und'].'</option>';
                                    }
                                    ?>
                                </select>
                            </div>
                            <div class="col-md-4 col-sm-6 form-group">
                                <label for="estado">Estado / Tipo</label>
                                <select class="form-control" id="estado" name="estado" required>
                                    <option value="1">Nuevo</option>
                                    <option value="0">De segunda</option>
                                    <option value="2">Repuesto</option>
                                </select>
                            </div>
                             <input type="hidden" name="multiplicando" value="1">
                             <input type="hidden" id="precio1" name="precio1" value="0">
                             <input type="hidden" id="precio2" name="precio2" value="0">
                        </div>

                        <div class="btn-toolbar">
                            <button type="button" class="btn btn-custom-light" onclick="limpiarFormulario()">
                                <i class="fas fa-trash-alt"></i> Limpiar
                            </button>
                            <button type="submit" class="btn btn-custom-primary" id="guardar_datos">
                                <i class="fas fa-check-circle"></i> Guardar Producto
                            </button>
                        </div>

                    </div>
                </form>

            </div>
        </div>
    </div>

    <script src="js/jquery.min.js"></script>
    <script src="js/bootstrap.min.js"></script>
    <script src="//code.jquery.com/ui/1.11.4/jquery-ui.js"></script>
    <script src="js/nicescroll/jquery.nicescroll.min.js"></script>
    <script src="js/custom.js"></script>

    <script>
    $(function() {
        // Autocomplete
        $("#nombre_producto").autocomplete({
            source: "./ajax/autocomplete/productos1.php",
            minLength: 1,
            select: function(event, ui) {
                event.preventDefault();
                $('#nombre_producto').val(ui.item.nombre_producto);
            }
        });

        // LÓGICA DE ICONO DE CARGA (CHECK / X)
        $('#files').on('change', function() {
            var fileName = $(this).val();
            if (fileName) {
                // Hay archivo: Poner Verde + Check
                $('#wrapper_files').removeClass('file-empty').addClass('file-loaded');
                $('#icon_files').removeClass('fa-camera fa-times').addClass('fa-check-circle');
                $('#text_files').text('Foto Cargada');
            } else {
                // No hay archivo: Poner Rojo + X
                $('#wrapper_files').removeClass('file-loaded').addClass('file-empty');
                $('#icon_files').removeClass('fa-camera fa-check-circle').addClass('fa-times');
                $('#text_files').text('Sin Foto');
            }
        });
    });

    function limpiarFormulario() {
        document.getElementById("guardar_producto").reset();
        // Resetear también el estilo del input file
        $('#wrapper_files').removeClass('file-loaded file-empty');
        $('#icon_files').removeClass('fa-check-circle fa-times').addClass('fa-camera');
        $('#text_files').text('Subir Foto');
    }
    </script>
</body>
</html>