<?php
session_start();
include('menu.php');
require_once ("config/db.php");
require_once ("config/conexion.php");
	  
$sql1="select * from users where user_id=$_SESSION[user_id]";
$rw1=mysqli_query($con,$sql1);
$rs1=mysqli_fetch_array($rw1);
$modulo=$rs1["accesos"];

$a = explode(".", $modulo); 
if (!isset($_SESSION['user_login_status']) AND $_SESSION['user_login_status'] != 1) { header("location: login.php"); exit; }
if($a[6]==0){ header("location:error.php"); }

// --- LÓGICA DE BÚSQUEDA DIRECTA (GET) ---
// Inicializamos variables vacías por defecto
$d = 0; 
$id_producto = 0; 
$producto1 = "";
// Fechas por defecto: Hoy
$fecha1 = date('Y-m-d');
$fecha2 = date('Y-m-d');
$tiend = 0;
$tienda1 = 0;

// Si se ha enviado el formulario (existen parámetros en la URL)
if (isset($_GET['id_producto']) && $_GET['id_producto'] > 0) {
    $id_producto = intval($_GET['id_producto']);
    $producto1 = $_GET['producto']; // Texto del producto
    $fecha1 = $_GET['fecha1'];
    $fecha2 = $_GET['fecha2'];
    $tiend = intval($_GET['tienda']);
    $tienda1 = $tiend;
    $d = 1; // Bandera para mostrar la tabla
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Kardex Valorizado | SoundCrow</title>

    <link rel="icon" href="logo.ico">
    <link href="css/bootstrap.min.css" rel="stylesheet">
    <link href="fonts/css/font-awesome.min.css" rel="stylesheet">
    <link href="css/custom.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    
    <link href="https://cdn.datatables.net/1.10.16/css/dataTables.bootstrap.min.css" rel="stylesheet"/>
    <link href="https://cdn.datatables.net/buttons/1.5.1/css/buttons.dataTables.min.css" rel="stylesheet">
    <link rel="stylesheet" href="//code.jquery.com/ui/1.11.4/themes/smoothness/jquery-ui.css">

    <style>
        body { font-family: 'Poppins', sans-serif !important; background-color: #F0F2F5; color: #334155; }
        
        .sc-card { background: #ffffff; border-radius: 12px; box-shadow: 0 4px 20px rgba(0,0,0,0.05); border: none; overflow: hidden; margin-bottom: 30px; }
        .sc-header { background: linear-gradient(90deg, #0a2463 0%, #2473f2 100%); padding: 20px 30px; color: white; display: flex; align-items: center; justify-content: space-between; }
        .sc-title { margin: 0; font-size: 18px; font-weight: 700; text-transform: uppercase; color: white; }
        .sc-body { padding: 30px; }

        .form-control-sc { border-radius: 8px; border: 1px solid #e2e8f0; padding: 0 10px; height: 40px; background-color: #f8fafc; width: 100%; color: #334155; font-weight:500; font-size: 13px; }
        .form-control-sc:focus { background-color: #fff; border-color: #2473f2; outline: none; }
        .label-filter { font-size: 11px; font-weight: 700; text-transform: uppercase; color: #64748b; margin-bottom: 5px; display:block; }
        
        .btn-search { background: #2473f2; color: white; border: none; border-radius: 8px; height: 40px; width: 100%; font-weight: 600; transition: 0.3s; margin-top: 24px;}
        .btn-search:hover { background: #1a5cbf; }

        .report-info { background: #f1f5f9; border-radius: 8px; padding: 20px; margin-bottom: 20px; border: 1px solid #e2e8f0; }
        .info-row { display: flex; justify-content: space-between; margin-bottom: 5px; font-size: 12px; }
        .info-label { font-weight: 700; color: #64748b; width: 150px; }
        .info-value { font-weight: 600; color: #334155; flex: 1; }

        .table-kardex { width: 100% !important; border-collapse: separate; border-spacing: 0; font-size: 11px; }
        .th-group-in { background: #e0f2fe !important; color: #0369a1 !important; text-align: center; border-bottom: 1px solid #bae6fd !important; }
        .th-group-out { background: #fee2e2 !important; color: #b91c1c !important; text-align: center; border-bottom: 1px solid #fecaca !important; }
        .th-group-bal { background: #dcfce7 !important; color: #15803d !important; text-align: center; border-bottom: 1px solid #bbf7d0 !important; }
        .th-general { background: #f8fafc !important; color: #475569 !important; border-bottom: 2px solid #e2e8f0 !important; padding: 10px !important; vertical-align: middle !important; }
        .col-in { background-color: #f0f9ff; }
        .col-out { background-color: #fef2f2; }
        .col-bal { background-color: #f0fdf4; font-weight: 600; }
        .table-kardex tbody td { padding: 8px 10px; border-bottom: 1px solid #f1f5f9; vertical-align: middle; }
        .table-kardex tbody tr:hover td { background-color: #eef2ff; }

        .dt-buttons .dt-button { border-radius: 20px !important; border: none !important; font-size: 11px !important; font-weight: 600 !important; padding: 5px 15px !important; margin-right: 5px !important; color: white !important; }
        .dt-button.green, .dt-button.green1 { background: #10b981 !important; }
        .dt-button.red { background: #ef4444 !important; }
        .dt-button.orange { background: #f59e0b !important; }
        .dt-button.green2 { background: #3b82f6 !important; }
    </style>
    
    <script src="js/jquery.min.js"></script>
    <script src="//code.jquery.com/ui/1.11.4/jquery-ui.js"></script>
</head>

<body class="nav-md">
    <div class="container body">
        <div class="main_container">
            <div class="col-md-3 left_col"><div class="left_col scroll-view"><div class="clearfix"></div><?php menu2(); menu1(); ?></div></div>
            <?php menu3(); ?>

            <div class="right_col" role="main">
                
                <div class="row">
                    <div class="col-md-12" style="padding-top:15px">
                        <div class="sc-card">
                            <div class="sc-header">
                                <h3 class="sc-title"><i class="fa fa-list-alt"></i> Kardex Valorizado (F. 13.1)</h3>
                            </div>
                            <div class="sc-body">
                                <form id="demo-form2" method="GET" action="kardex.php">
                                    <div class="row">
                                        <div class="col-md-4 form-group">
                                            <span class="label-filter">Producto</span>
                                            <input type="search" class="form-control-sc" id="nombre_producto" name="producto" value="<?php echo $producto1;?>" placeholder="Escribe para buscar..." required>
                                            <input id="id_producto" name="id_producto" type='hidden' value="<?php echo $id_producto;?>">
                                        </div>
                                        <div class="col-md-3 form-group">
                                            <span class="label-filter">Desde</span>
                                            <input type="date" class="form-control-sc" id="fecha1" name="fecha1" value="<?php echo $fecha1;?>" required>
                                        </div>
                                        <div class="col-md-3 form-group">
                                            <span class="label-filter">Hasta</span>
                                            <input type="date" class="form-control-sc" id="fecha2" name="fecha2" value="<?php echo $fecha2;?>" required>
                                        </div>
                                        
                                        <div class="col-md-2 form-group">
                                            <span class="label-filter">Stand / Tienda</span>
                                            <select class="form-control-sc" name="tienda" required>
                                                <option value="">Seleccionar</option>
                                                <?php 
                                                $sql_s = "SELECT * FROM sucursal ORDER BY tienda ASC";
                                                $res_s = mysqli_query($con, $sql_s);
                                                while($row_s = mysqli_fetch_array($res_s)){
                                                    $id_t = $row_s['tienda'];
                                                    $nom_stand = isset($row_s['nombre_stand']) ? $row_s['nombre_stand'] : '';
                                                    $nom_empresa = $row_s['nombre'];
                                                    
                                                    if (!empty($nom_stand)) {
                                                        $nombre_mostrar = $nom_stand;
                                                    } else {
                                                        $nombre_mostrar = $nom_empresa;
                                                    }
                                                    
                                                    $selected = ($id_t == $tiend) ? "selected" : "";
                                                    echo "<option value='$id_t' $selected>$nombre_mostrar</option>";
                                                }
                                                ?>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-12 text-right">
                                            <a href="kardex.php" class="btn btn-default" style="border-radius:20px; padding: 8px 20px; margin-right: 5px;">
                                                <i class="fa fa-eraser"></i> Limpiar Filtro
                                            </a>
                                            
                                            <button type="submit" class="btn btn-primary" style="border-radius:20px; padding: 8px 30px;"><i class="fa fa-search"></i> Consultar Kardex</button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>

                <?php if($d > 0 && $id_producto > 0): ?>
                
                <?php 
                    $sql3="select * from sucursal where tienda=$tiend ";
                    $rw3=mysqli_query($con,$sql3);
                    $rs3=mysqli_fetch_array($rw3);
                    
                    $nombre_suc = $rs3["nombre"]; 
                    $ruc_suc = $rs3["ruc"]; 
                    $dir_suc = $rs3["direccion"];

                    $sql4="select * from products,und where products.id_producto=$id_producto and und.id_und=products.und_pro";
                    $rw4=mysqli_query($con,$sql4);
                    $rs4=mysqli_fetch_array($rw4);
                    $nombre_producto=$rs4["nombre_producto"]; $cod_und=$rs4["cod_und"];
                ?>

                <div class="row">
                    <div class="col-md-12">
                        <div class="sc-card">
                            <div class="sc-body">
                                
                                <div class="report-info">
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="info-row"><span class="info-label">PERIODO:</span> <span class="info-value"><?php echo "$fecha1 al $fecha2"; ?></span></div>
                                            <div class="info-row"><span class="info-label">RUC:</span> <span class="info-value"><?php echo $ruc_suc; ?></span></div>
                                            <div class="info-row"><span class="info-label">RAZÓN SOCIAL:</span> <span class="info-value"><?php echo $nombre_suc; ?></span></div>
                                            <div class="info-row"><span class="info-label">ESTABLECIMIENTO:</span> <span class="info-value"><?php echo $dir_suc; ?></span></div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="info-row"><span class="info-label">PRODUCTO:</span> <span class="info-value" style="color:#0a2463; font-size:14px;"><?php echo $nombre_producto; ?></span></div>
                                            <div class="info-row"><span class="info-label">CÓDIGO UNIDAD:</span> <span class="info-value"><?php echo $cod_und; ?></span></div>
                                            <div class="info-row"><span class="info-label">MÉTODO:</span> <span class="info-value">PROMEDIO PONDERADO</span></div>
                                            <div class="info-row"><span class="info-label">MONEDA:</span> <span class="info-value">PEN (Soles)</span></div>
                                        </div>
                                    </div>
                                </div>

                                <div class="table-responsive">
                                    <table id="example" class="table table-kardex display nowrap">
                                        <thead>
                                            <tr>
                                                <th rowspan="2" class="th-general">FECHA</th>
                                                <th rowspan="2" class="th-general">DOC</th>
                                                <th rowspan="2" class="th-general">SERIE</th>
                                                <th rowspan="2" class="th-general">NÚMERO</th>
                                                <th rowspan="2" class="th-general">OPERACIÓN</th>
                                                
                                                <th colspan="3" class="th-group-in">ENTRADAS</th>
                                                <th colspan="3" class="th-group-out">SALIDAS</th>
                                                <th colspan="3" class="th-group-bal">SALDO FINAL</th>
                                            </tr>
                                            <tr>
                                                <th class="th-group-in" style="font-size:10px;">CANT</th>
                                                <th class="th-group-in" style="font-size:10px;">C. UNIT</th>
                                                <th class="th-group-in" style="font-size:10px;">TOTAL</th>
                                                
                                                <th class="th-group-out" style="font-size:10px;">CANT</th>
                                                <th class="th-group-out" style="font-size:10px;">C. UNIT</th>
                                                <th class="th-group-out" style="font-size:10px;">TOTAL</th>
                                                
                                                <th class="th-group-bal" style="font-size:10px;">CANT</th>
                                                <th class="th-group-bal" style="font-size:10px;">C. UNIT</th>
                                                <th class="th-group-bal" style="font-size:10px;">TOTAL</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php   
                                            // QUERY ORIGINAL
                                            $sql="select * from detalle_factura where tipo_doc<>8 and id_producto=$id_producto and tienda>=$tienda1 and tienda<=$tienda1 and DATE_FORMAT(fecha, '%Y-%m-%d')>='$fecha1' and DATE_FORMAT(fecha, '%Y-%m-%d')<='$fecha2' ORDER BY `detalle_factura`.`id_detalle` ASC "; 
                                            $rs=mysqli_query($con,$sql);
                                            
                                            $inv_ini1=0; $valor=0; $cont=0; $ini=0;
                                            
                                            while($row= mysqli_fetch_array($rs)){
                                                $numero_factura=$row['numero_factura'];
                                                $cantidad1=$row['cantidad'];
                                                $precio_compra = ($row['ven_com']==2) ? $row['precio_venta'] : $row['precio_compra'];
                                                
                                                $tipo=$row['ot'];
                                                $tipo_doc=$row['tipo_doc'];
                                                $inv_ini=$row['inv_ini'];
                                                $ven_com=$row['ven_com'];
                                                $activo=$row['activo'];
                                                $folio = ($row['folio']<>"") ? $row['folio'] : "";
                                                
                                                $descripcion2 = "00"; $descripcion3 = "00"; 
                                                if($numero_factura==0){ $descripcion2="00"; $descripcion3="11"; }
                                                else {
                                                    if($tipo_doc==1) $descripcion2="01"; 
                                                    if($tipo_doc==2) $descripcion2="03";
                                                    if($tipo_doc==3) $descripcion2="Nt";
                                                    if($tipo_doc==5) $descripcion2="08";
                                                    if($tipo_doc==6) $descripcion2="07";
                                                    if($ven_com==1 && $activo==1 && $precio_compra>0 && $tipo_doc<=3) $descripcion3="01";
                                                    if($ven_com==2 && $activo==1 && $precio_compra>0) $descripcion3="02"; 
                                                    if($precio_compra==0 && $activo==1) $descripcion3="11";
                                                    if($activo==0){ $descripcion2="00 (Elim)"; }
                                                }

                                                $entrada=0; $salida=0; $costo_entrada=0; $costo_salida=0;
                                                if($tipo==1){ $salida=$cantidad1; $costo_salida=$valor; }
                                                if($tipo==2){ $entrada=$cantidad1; $costo_entrada=$row['precio_venta']; }

                                                $fecha3=$row['fecha'];
                                                $dd5=date("d-m-Y",strtotime($fecha3)); 

                                                if($cont==0){
                                                    ?>
                                                    <tr>
                                                        <td><?php echo $dd5;?></td>
                                                        <td>-</td><td>-</td><td>-</td>
                                                        <td class="text-center"><span class="label label-default">SALDO INICIAL</span></td>
                                                        <td class="col-in">-</td><td class="col-in">-</td><td class="col-in">-</td>
                                                        <td class="col-out">-</td><td class="col-out">-</td><td class="col-out">-</td>
                                                        <td class="col-bal text-right"><?php echo number_format($inv_ini, 2);?></td>
                                                        <td class="col-bal text-right"><?php echo number_format($precio_compra, 2);?></td>
                                                        <td class="col-bal text-right"><?php echo number_format($precio_compra*$inv_ini, 2);?></td>
                                                    </tr>
                                                    <?php
                                                    $valor=$precio_compra;
                                                    $inv_ini1=$inv_ini;
                                                    $ini=$precio_compra*$inv_ini;
                                                    $costo_salida=$valor; $costo_salida2=$valor;
                                                }

                                                if($salida==0) $costo_salida=0;
                                                if($salida>0) $costo_salida=$costo_salida2;
                                                $inv_ini1 = $inv_ini1 + $entrada - $salida; 
                                                $ini = $ini - ($salida*$costo_salida) + ($entrada*$costo_entrada);
                                                if($inv_ini1 > 0){ $costo_salida2 = $ini / $inv_ini1; }
                                                ?>
                                                
                                                <tr>
                                                    <td><?php echo $dd5;?></td>
                                                    <td class="text-center"><?php echo $descripcion2;?></td>
                                                    <td><?php echo $folio;?></td>
                                                    <td><?php echo $numero_factura;?></td>
                                                    <td class="text-center"><?php echo $descripcion3;?></td>
                                                    
                                                    <td class="col-in text-right"><?php echo ($entrada>0) ? number_format($entrada, 2) : '-';?></td>
                                                    <td class="col-in text-right"><?php echo ($entrada>0) ? number_format($costo_entrada, 2) : '-';?></td>
                                                    <td class="col-in text-right"><?php echo ($entrada>0) ? number_format($entrada*$costo_entrada, 2) : '-';?></td>
                                                    
                                                    <td class="col-out text-right"><?php echo ($salida>0) ? number_format($salida, 2) : '-';?></td>
                                                    <td class="col-out text-right"><?php echo ($salida>0) ? number_format($costo_salida, 2) : '-';?></td>
                                                    <td class="col-out text-right"><?php echo ($salida>0) ? number_format($salida*$costo_salida, 2) : '-';?></td>
                                                    
                                                    <td class="col-bal text-right"><?php echo number_format($inv_ini1, 2);?></td>
                                                    <td class="col-bal text-right"><?php echo number_format($costo_salida2, 4);?></td>
                                                    <td class="col-bal text-right"><?php echo number_format($ini, 2);?></td>
                                                </tr>
                                                <?php
                                                $cont++;
                                            }
                                            ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <?php endif; ?>

            </div>
        </div>
    </div>

    <script src="js/bootstrap.min.js"></script>
    <script src="js/nicescroll/jquery.nicescroll.min.js"></script>
    <script src="js/custom.js"></script>
    <script src="js/select/select2.full.js"></script>

    <script type="text/javascript" src="https://cdn.datatables.net/1.10.16/js/jquery.dataTables.min.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/1.10.16/js/dataTables.bootstrap.min.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/buttons/1.5.1/js/dataTables.buttons.min.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/buttons/1.5.1/js/buttons.colVis.min.js"></script>
    <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
    <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.32/pdfmake.min.js"></script>
    <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.32/vfs_fonts.js"></script>
    <script type="text/javascript" src="Buttons/js/buttons.html5.min.js"></script>
    <script type="text/javascript" src="Buttons/js/buttons.print.min.js"></script>

    <script>
    $(document).ready(function() {
        $("#nombre_producto").autocomplete({
            source: "./ajax/autocomplete/productos1.php",
            minLength: 1,
            select: function(event, ui) {
                event.preventDefault();
                $('#id_producto').val(ui.item.id_producto);
                $('#nombre_producto').val(ui.item.nombre_producto);
            }
        });

        $('#example').DataTable({
            language: { "url": "//cdn.datatables.net/plug-ins/1.10.16/i18n/Spanish.json" },
            bDestroy: true,
            dom: 'Bfrtip',
            pageLength: 100,
            scrollX: true, 
            buttons: [
                { extend: 'colvis', text: '<i class="fa fa-eye"></i> Ver', className: 'green2' },
                { extend: 'excel', text: '<i class="fa fa-file-excel-o"></i> Excel', className: 'green' },
                { extend: 'pdf', text: '<i class="fa fa-file-pdf-o"></i> PDF', className: 'red', orientation: 'landscape' },
                { extend: 'print', text: '<i class="fa fa-print"></i> Imprimir', className: 'green2' }
            ]
        });
    });
    </script>
</body>
</html>