<?php
session_start();
include('menu.php');
require_once ("config/db.php");
require_once ("config/conexion.php");

$sql1="select * from users where user_id=$_SESSION[user_id]";
$rw1=mysqli_query($con,$sql1);
$rs1=mysqli_fetch_array($rw1);

$modulo=$rs1["accesos"];
$a = explode(".", $modulo); 

if (!isset($_SESSION['user_login_status']) AND $_SESSION['user_login_status'] != 1) {
    header("location: login.php");
    exit;
}
if($a[18]==0){
    header("location:error.php");    
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Historial Entradas | SoundCrow</title>
    <link rel="icon" href="logo.ico">
    <link href="css/bootstrap.min.css" rel="stylesheet">
    <link href="fonts/css/font-awesome.min.css" rel="stylesheet">
    <link href="css/custom.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        body { font-family: 'Poppins', sans-serif !important; background-color: #F0F2F5; color: #334155; }
        .sc-card { background: #ffffff; border-radius: 12px; box-shadow: 0 4px 20px rgba(0,0,0,0.05); border: none; margin-bottom: 30px; }
        .sc-header { background: linear-gradient(90deg, #0a2463 0%, #2473f2 100%); padding: 20px 30px; color: white; display:flex; justify-content:space-between; align-items:center;}
        .sc-title { margin: 0; font-size: 18px; font-weight: 700; text-transform: uppercase; color: white; }
        .sc-body { padding: 30px; }
        .table-sc thead th { background: #f8fafc; color: #64748b; text-transform: uppercase; font-size: 11px; border-bottom: 2px solid #e2e8f0; }
    </style>
</head>
<body class="nav-md">
    <div class="container body">
        <div class="main_container">
            <div class="col-md-3 left_col"><div class="left_col scroll-view"><div class="clearfix"></div><?php menu2(); menu1(); ?></div></div>
            <?php menu3(); ?>
            <div class="right_col" role="main">
                <div class="sc-card">
                    <div class="sc-header">
                        <h3 class="sc-title"><i class="fa fa-arrow-circle-down"></i> Reporte de Entradas (Ajustes)</h3>
                        <a href="nueva_entrada.php" class="btn btn-default btn-sm" style="border-radius:20px; color:#0a2463; font-weight:bold;">Nueva Entrada</a>
                    </div>
                    <div class="sc-body">
                        <div class="table-responsive">
                            <table class="table table-hover table-sc">
                                <thead>
                                    <tr>
                                        <th>Fecha</th>
                                        <th>Producto</th>
                                        <th class="text-center">Cant.</th>
                                        <th>Tienda Destino</th>
                                        <th>Referencia</th>
                                        <th>Compra Vinculada</th>
                                        <th>Usuario</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    // CONSULTA SQL CON LEFT JOIN PARA VER SI HAY COMPRA VINCULADA
                                    $sql = "SELECT e.*, p.nombre_producto, u.nombres, s.nombre as nom_tienda, s.nombre_stand,
                                            f.numero_factura, c.nombre_cliente
                                            FROM entradas e
                                            JOIN products p ON e.id_producto = p.id_producto
                                            JOIN users u ON e.user_id = u.user_id
                                            JOIN sucursal s ON e.tienda = s.tienda
                                            LEFT JOIN facturas f ON e.id_compra = f.id_factura
                                            LEFT JOIN clientes c ON f.id_cliente = c.id_cliente
                                            ORDER BY e.fecha DESC LIMIT 100";
                                    
                                    $query = mysqli_query($con, $sql);

                                    if (!$query) {
                                        echo "<tr><td colspan='7' class='text-center text-danger'>Error SQL: " . mysqli_error($con) . "</td></tr>";
                                    } else {
                                        if (mysqli_num_rows($query) == 0) {
                                            echo "<tr><td colspan='7' class='text-center' style='padding:20px; color:#999;'>No hay entradas registradas.</td></tr>";
                                        }
                                        while($row = mysqli_fetch_array($query)){
                                            $fecha = date("d/m/Y H:i", strtotime($row['fecha']));
                                            $tienda = !empty($row['nombre_stand']) ? $row['nombre_stand'] : $row['nom_tienda'];
                                            
                                            // Link de Compra
                                            $compra_info = "<span style='color:#ccc;'>-</span>";
                                            if(!empty($row['numero_factura'])){
                                                $compra_info = "<a href='#' title='Proveedor: ".$row['nombre_cliente']."' style='color:#2473f2; font-weight:600;'><i class='fa fa-file-text-o'></i> ".$row['numero_factura']."</a>";
                                            }
                                            ?>
                                            <tr>
                                                <td><?php echo $fecha; ?></td>
                                                <td style="font-weight:600; color:#0a2463;"><?php echo $row['nombre_producto']; ?></td>
                                                <td class="text-center"><span class="badge" style="background:#10b981;"><?php echo $row['cantidad']; ?></span></td>
                                                <td><?php echo $tienda; ?></td>
                                                <td><?php echo $row['referencia']; ?></td>
                                                <td><?php echo $compra_info; ?></td>
                                                <td><?php echo $row['nombres']; ?></td>
                                            </tr>
                                            <?php
                                        }
                                    }
                                    ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script src="js/jquery.min.js"></script>
    <script src="js/bootstrap.min.js"></script>
    <script src="js/nicescroll/jquery.nicescroll.min.js"></script>
    <script src="js/custom.js"></script>
</body>
</html>