<?php
session_start();
include('menu.php');
require_once ("config/db.php");
require_once ("config/conexion.php");

$sql1="select * from users where user_id=$_SESSION[user_id]";
$rw1=mysqli_query($con,$sql1);
$rs1=mysqli_fetch_array($rw1);

$modulo=$rs1["accesos"];
$a = explode(".", $modulo); 

if (!isset($_SESSION['user_login_status']) AND $_SESSION['user_login_status'] != 1) {
    header("location: login.php");
    exit;
}
if($a[16]==0){
    header("location:error.php");    
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Historial Traslados | SoundCrow</title>
    <link rel="icon" href="logo.ico">
    <link href="css/bootstrap.min.css" rel="stylesheet">
    <link href="fonts/css/font-awesome.min.css" rel="stylesheet">
    <link href="css/custom.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        body { font-family: 'Poppins', sans-serif !important; background-color: #F0F2F5; color: #334155; }
        .sc-card { background: #ffffff; border-radius: 12px; box-shadow: 0 4px 20px rgba(0,0,0,0.05); border: none; margin-bottom: 30px; }
        .sc-header { border-radius: 13px; background: linear-gradient(90deg, #0a2463 0%, #2473f2 100%); padding: 20px 30px; color: white; display:flex; justify-content:space-between; align-items:center;}
        .sc-title { margin: 0; font-size: 18px; font-weight: 700; text-transform: uppercase; color: white; }
        .sc-body { padding: 30px; }
        .table-sc thead th { background: #f8fafc; color: #64748b; text-transform: uppercase; font-size: 11px; border-bottom: 2px solid #e2e8f0; }
    </style>
</head>
<body class="nav-md">
    <div class="container body">
        <div class="main_container">
            <div class="col-md-3 left_col"><div class="left_col scroll-view"><div class="clearfix"></div><?php menu2(); menu1(); ?></div></div>
            <?php menu3(); ?>
            <div class="right_col" style="padding-top: 72px;" role="main">
                <div class="sc-card">
                    <div class="sc-header">
                        <h3 class="sc-title"><i class="fa fa-list"></i> Reporte de Traslados</h3>
                        <a href="nuevo_traslado.php" class="btn btn-default btn-sm" style="border-radius:20px; color:#0a2463; font-weight:bold;">Nuevo Traslado</a>
                    </div>
                    <div class="sc-body">
                        <div class="table-responsive">
                            <table class="table table-hover table-sc">
                                <thead>
                                    <tr>
                                        <th>Fecha</th>
                                        <th>Producto</th>
                                        <th class="text-center">Cant.</th>
                                        <th>Origen</th>
                                        <th>Destino</th>
                                        <th>Ref.</th>
                                        <th>Usuario</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    // CORRECCIÓN: Cambiado u.firstname por u.nombres
                                    $sql = "SELECT t.*, p.nombre_producto, u.nombres, 
                                            s1.nombre as nom_ori, s1.nombre_stand as stand_ori,
                                            s2.nombre as nom_des, s2.nombre_stand as stand_des
                                            FROM traslados t
                                            JOIN products p ON t.id_producto = p.id_producto
                                            JOIN users u ON t.user_id = u.user_id
                                            JOIN sucursal s1 ON t.origen = s1.tienda
                                            JOIN sucursal s2 ON t.destino = s2.tienda
                                            ORDER BY t.fecha DESC LIMIT 100";
                                    
                                    $query = mysqli_query($con, $sql);

                                    // --- MANEJO DE ERRORES SQL ---
                                    if (!$query) {
                                        echo "<tr><td colspan='7' class='text-center text-danger' style='padding:20px;'>
                                            <b>Error en la base de datos:</b> " . mysqli_error($con) . "<br>
                                            <small>Posiblemente la columna 'nombres' tampoco exista. Verifica si es 'user_name' o 'nombres' en tu tabla users.</small>
                                        </td></tr>";
                                    } else {
                                        if (mysqli_num_rows($query) == 0) {
                                            echo "<tr><td colspan='7' class='text-center' style='padding:20px; color:#999;'>No hay traslados registrados aún.</td></tr>";
                                        }
                                        while($row = mysqli_fetch_array($query)){
                                            $fecha = date("d/m/Y H:i", strtotime($row['fecha']));
                                            // Prioridad nombre stand
                                            $origen = !empty($row['stand_ori']) ? $row['stand_ori'] : $row['nom_ori'];
                                            $destino = !empty($row['stand_des']) ? $row['stand_des'] : $row['nom_des'];
                                            ?>
                                            <tr>
                                                <td><?php echo $fecha; ?></td>
                                                <td style="font-weight:600; color:#0a2463;"><?php echo $row['nombre_producto']; ?></td>
                                                <td class="text-center"><span class="badge" style="background:#2473f2;"><?php echo $row['cantidad']; ?></span></td>
                                                <td><?php echo $origen; ?></td>
                                                <td><?php echo $destino; ?></td>
                                                <td><?php echo $row['referencia']; ?></td>
                                                <td><?php echo $row['nombres']; ?></td>
                                            </tr>
                                            <?php
                                        }
                                    }
                                    ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script src="js/jquery.min.js"></script>
    <script src="js/bootstrap.min.js"></script>
    <script src="js/custom.js"></script>
</body>
</html>