<?php
/**
 * LOGIN SOUNDCROW - ULTIMATE AI EDITION (CENTRADO & STAND NAMES)
 * Adaptable, Novedoso e Inteligente
 */
require_once("config/db.php");
require_once("config/conexion.php");
require_once("classes/Login.php");

$login = new Login();

// Procesamiento de Login y Sucursal
if (isset($_POST['sucursal']) && $login->isUserLoggedIn() == true) {
    if (session_status() == PHP_SESSION_NONE) { session_start(); }
    $_SESSION['tienda'] = intval($_POST['sucursal']);
    $_SESSION['doc_ventas'] = 1; $_SESSION['tipo'] = 0; $_SESSION['tabla'] = 1; $_SESSION['servicio1'] = "0";
    header("location: resumen.php");
    exit;
}

$error_swal = "";
if (isset($login) && isset($login->errors) && count($login->errors) > 0) {
    $error_swal = $login->errors[0];
}

// Consulta de Sucursales y Almacenes
$q_lugares = mysqli_query($con, "SELECT id_sucursal, nombre_stand, nombre, tipo_sucursal FROM sucursal ORDER BY tipo_sucursal ASC, nombre_stand ASC");
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no">
    <title>SISTEMA | Acceso Inteligente</title>
    <link rel="icon" href="logo.ico">
    <link href="fonts/css/font-awesome.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:wght@300;400;600;800&display=swap" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/sweetalert2@11.7.12/dist/sweetalert2.min.css" rel="stylesheet">

    <style>
        :root { --primary: #3b82f6; --accent: #6366f1; --bg: #030712; }
        * { box-sizing: border-box; margin: 0; padding: 0; font-family: 'Plus Jakarta Sans', sans-serif; }
        
        body { background: var(--bg); height: 100vh; display: flex; align-items: center; justify-content: center; overflow: hidden; color: #fff; }
        #particles-js { position: absolute; width: 100%; height: 100%; top: 0; left: 0; z-index: 1; }

        .login-wrapper { position: relative; z-index: 2; width: 100%; max-width: 440px; padding: 20px; animation: fadeInScale 0.8s ease-out; }
        @keyframes fadeInScale { from { opacity: 0; transform: scale(0.9); } to { opacity: 1; transform: scale(1); } }

        .glass-card {
            background: rgba(17, 24, 39, 0.75); backdrop-filter: blur(25px); -webkit-backdrop-filter: blur(25px);
            border: 1px solid rgba(255, 255, 255, 0.1); border-radius: 35px;
            padding: 45px 35px; box-shadow: 0 25px 50px rgba(0,0,0,0.7); text-align: center;
            display: flex; flex-direction: column; align-items: center;
        }

        .logo-box { width: 100%; margin-bottom: 25px; }
        .logo-box img { max-width: 160px; filter: drop-shadow(0 0 15px rgba(59, 130, 246, 0.4)); margin: 0 auto; display: block; }

        /* === SLIDER PASOS CENTRADO === */
        .slider-wrapper { position: relative; width: 100%; height: 300px; overflow: hidden; }
        .step { 
            position: absolute; width: 100%; height: 100%; 
            transition: 0.6s cubic-bezier(0.23, 1, 0.32, 1); opacity: 0; 
            pointer-events: none; transform: translateX(50px) scale(0.95);
            display: flex; flex-direction: column; align-items: center; justify-content: center;
        }
        .step.active { opacity: 1; pointer-events: auto; transform: translateX(0) scale(1); }
        
        .method-btn { 
            background: rgba(255,255,255,0.03); border: 1px solid rgba(255,255,255,0.08); 
            border-radius: 20px; padding: 22px; width: 100%; margin-bottom: 15px; 
            color: #fff; cursor: pointer; transition: 0.3s; display: flex; align-items: center; justify-content: center; gap: 18px; 
        }
        .method-btn:hover { background: rgba(59, 130, 246, 0.15); border-color: var(--primary); transform: translateY(-5px); }
        .method-btn i { font-size: 26px; color: var(--primary); text-shadow: 0 0 10px var(--primary); }

        .custom-input { width: 100%; height: 55px; background: rgba(0,0,0,0.4); border: 1px solid rgba(255,255,255,0.1); border-radius: 15px; padding: 10px 18px; color: #fff; margin-bottom: 18px; outline: none; transition: 0.3s; text-align: center; }
        .custom-input:focus { border-color: var(--primary); box-shadow: 0 0 15px rgba(59, 130, 246, 0.3); }

        .btn-entry { 
            width: 100%; height: 55px; background: linear-gradient(135deg, var(--primary), var(--accent)); 
            border: none; border-radius: 15px; color: #fff; font-weight: 800; cursor: pointer; 
            box-shadow: 0 12px 24px rgba(59, 130, 246, 0.4); transition: 0.3s; 
        }
        .btn-entry:hover { transform: translateY(-3px); box-shadow: 0 15px 30px rgba(59, 130, 246, 0.5); }

        .scanner-ui { background: rgba(0,0,0,0.5); border: 2px dashed var(--primary); border-radius: 25px; padding: 45px 20px; position: relative; overflow: hidden; width: 100%; }
        .laser { position: absolute; top: 0; left: 0; width: 100%; height: 3px; background: #22c55e; box-shadow: 0 0 20px #22c55e; animation: scan 2s infinite linear; }
        @keyframes scan { 0% { top: 5%; } 100% { top: 95%; } }
        #codigo_fotocheck { position: absolute; opacity: 0; top: -500px; }

        /* === BURBUJA IA === */
        .ai-bubble {
            position: fixed; bottom: 35px; right: 35px; width: 70px; height: 70px;
            background: linear-gradient(135deg, var(--primary), var(--accent));
            border-radius: 50%; display: flex; align-items: center; justify-content: center;
            font-size: 30px; color: white; cursor: pointer; z-index: 1000;
            box-shadow: 0 15px 35px rgba(59, 130, 246, 0.6); animation: pulse-ai 2s infinite; transition: 0.4s;
        }
        .ai-bubble:hover { transform: scale(1.15) rotate(15deg); }
        @keyframes pulse-ai { 0% { box-shadow: 0 0 0 0 rgba(59, 130, 246, 0.7); } 70% { box-shadow: 0 0 0 20px rgba(59, 130, 246, 0); } 100% { box-shadow: 0 0 0 0 rgba(59, 130, 246, 0); } }

        .ai-window {
            position: fixed; bottom: 120px; right: 35px; width: 380px; height: 520px;
            background: #0f172a; border: 1px solid rgba(255,255,255,0.15); border-radius: 30px;
            display: flex; flex-direction: column; z-index: 1001; overflow: hidden;
            box-shadow: 0 25px 60px rgba(0,0,0,0.8);
            transform: translateY(40px) scale(0.8); opacity: 0; pointer-events: none; transition: 0.5s cubic-bezier(0.175, 0.885, 0.32, 1.275);
        }
        .ai-window.open { transform: translateY(0) scale(1); opacity: 1; pointer-events: auto; }

        .chat-header { background: rgba(255,255,255,0.03); padding: 25px; display: flex; align-items: center; gap: 15px; border-bottom: 1px solid rgba(255,255,255,0.1); }
        .chat-body { flex: 1; padding: 20px; overflow-y: auto; display: flex; flex-direction: column; gap: 12px; }
        .msg { max-width: 85%; padding: 12px 16px; border-radius: 18px; font-size: 14px; line-height: 1.5; text-align: left; }
        .bot { background: rgba(255,255,255,0.05); color: #e2e8f0; align-self: flex-start; border-bottom-left-radius: 4px; }
        .user { background: var(--primary); color: #fff; align-self: flex-end; border-bottom-right-radius: 4px; }
        .chat-footer { padding: 20px; background: rgba(0,0,0,0.3); display: flex; gap: 10px; }
        .chat-input { flex: 1; background: #1e293b; border: 1px solid rgba(255,255,255,0.1); border-radius: 12px; padding: 12px; color: #fff; outline: none; }
        .btn-send { background: var(--primary); border: none; padding: 0 18px; border-radius: 12px; color: #fff; cursor: pointer; }

        @media (max-width: 480px) {
            .ai-window { width: calc(100% - 40px); right: 20px; }
            .glass-card { padding: 35px 20px; }
        }
    </style>
</head>
<body>

    <div id="particles-js"></div>

    <div class="login-wrapper">
        <div class="glass-card">
            <div class="logo-box">
                <img src="logo.png" alt="Logo">
                <h2>SoundCrow AI</h2>
                <p style="color: #94a3b8; font-size: 13px; font-weight: 500;">ACCESO V.1.0.2</p>
            </div>

            <form method="post" action="login.php" id="loginForm" style="width: 100%;">
                <input type="hidden" name="tipo_login" id="tipo_login" value="credenciales">
                
                <div class="slider-wrapper">
                    <div class="step active" id="step-1">
                        <div class="method-btn" onclick="goStep('fotocheck')">
                            <i class="fa fa-barcode"></i>
                            <div style="text-align: left;"><strong>Fotocheck</strong><br><small>Escaneo Biométrico</small></div>
                        </div>
                        <div class="method-btn" onclick="goStep('credenciales')">
                            <i class="fa fa-keyboard-o"></i>
                            <div style="text-align: left;"><strong>Credenciales</strong><br><small>Usuario y Clave</small></div>
                        </div>
                    </div>

                    <div class="step" id="step-fotocheck">
                        <div class="scanner-ui" onclick="$('#codigo_fotocheck').focus()">
                            <div class="laser"></div>
                            <i class="fa fa-qrcode" style="font-size: 50px; color: var(--primary); display: block; margin-bottom: 15px;"></i>
                            <p style="font-weight: 600; color: #94a3b8;">ESCANEANDO...</p>
                        </div>
                        <input type="text" name="codigo_fotocheck" id="codigo_fotocheck" maxlength="13">
                        <button type="button" onclick="goBack()" style="background:none; border:none; color:#64748b; margin-top:20px; cursor:pointer; font-weight:700;">VOLVER</button>
                    </div>

                    <div class="step" id="step-credenciales">
                        <input type="text" class="custom-input" name="user_name" id="user_name" placeholder="Tu Usuario" autocomplete="off">
                        <input type="password" class="custom-input" name="user_password" id="user_password" placeholder="Tu Contraseña">
                        <button type="button" class="btn-entry" onclick="goLocation()">CONTINUAR</button>
                        <button type="button" onclick="goBack()" style="background:none; border:none; color:#64748b; margin-top:20px; cursor:pointer; font-weight:700;">VOLVER</button>
                    </div>

                    <div class="step" id="step-location">
                        <p style="margin-bottom:15px; font-weight:600; color:#cbd5e1;">ELEGIR STAND / ALMACÉN:</p>
                        <select class="custom-input" name="sucursal" id="sucursal" required style="text-align-last: center;">
                            <?php
                            mysqli_data_seek($q_lugares, 0);
                            while ($rw = mysqli_fetch_array($q_lugares)) {
                                $ico = ($rw['tipo_sucursal'] == 1) ? "🏢 " : "📦 ";
                                // Priorizamos mostrar nombre_stand
                                $nombre_mostrar = !empty($rw['nombre_stand']) ? $rw['nombre_stand'] : $rw['nombre'];
                                echo "<option value='".$rw['id_sucursal']."'>$ico ".$nombre_mostrar."</option>";
                            }
                            ?>
                        </select>
                        <button type="submit" name="login" class="btn-entry">ENTRAR AHORA</button>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <div class="ai-bubble" onclick="toggleChat()"><i class="fa fa-android"></i></div>

    <div class="ai-window" id="aiWindow">
        <div class="chat-header">
            <div style="width:12px; height:12px; background:#22c55e; border-radius:50%;"></div>
            <div>
                <strong style="display:block; font-size:15px;">Asistente SoundCrow</strong>
                <span style="font-size:11px; color:#22c55e;">Soporte IA en línea</span>
            </div>
            <i class="fa fa-times" onclick="toggleChat()" style="margin-left:auto; cursor:pointer; opacity:0.5;"></i>
        </div>
        <div class="chat-body" id="chatBody">
            <div class="msg bot">¡Hola! ¿Dudas con el <b>fotocheck o tu clave</b>? Escríbeme y te ayudo.</div>
        </div>
        <div style="padding:0 25px 10px; font-size:12px; color:#60a5fa; display:none; text-align: left;" id="typing">La IA está procesando...</div>
        <div class="chat-footer">
            <input type="text" id="aiInput" class="chat-input" placeholder="Pregúntame algo..." onkeypress="if(event.keyCode==13) sendAi()">
            <button class="btn-send" onclick="sendAi()"><i class="fa fa-paper-plane"></i></button>
        </div>
    </div>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/particles.js/2.0.0/particles.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11.7.12/dist/sweetalert2.all.min.js"></script>

    <script>
        particlesJS("particles-js", { "particles": { "number": { "value": 70 }, "color": { "value": "#3b82f6" }, "shape": { "type": "circle" }, "opacity": { "value": 0.4 }, "size": { "value": 2.5 }, "line_linked": { "enable": true, "distance": 150, "color": "#3b82f6", "opacity": 0.2, "width": 1 }, "move": { "enable": true, "speed": 1.2 } }, "interactivity": { "events": { "onhover": { "enable": true, "mode": "grab" } } } });

        <?php if(!empty($error_swal)): ?>
            Swal.fire({ icon: 'error', text: '<?php echo $error_swal; ?>', background: '#0f172a', color: '#fff', confirmButtonColor: '#3b82f6' });
        <?php endif; ?>

        function goStep(m) {
            $('#tipo_login').val(m);
            $('.step').removeClass('active');
            if(m==='fotocheck') { $('#step-fotocheck').addClass('active'); $('#codigo_fotocheck').focus(); }
            else { $('#step-credenciales').addClass('active'); }
        }
        function goBack() { $('.step').removeClass('active'); $('#step-1').addClass('active'); }
        function goLocation() {
            if($('#user_name').val()==='' || $('#user_password').val()==='') return;
            $('.step').removeClass('active'); $('#step-location').addClass('active');
        }

        $('#codigo_fotocheck').on('input', function() { if($(this).val().length >= 13) { $('.step').removeClass('active'); $('#step-location').addClass('active'); } });

        function toggleChat() { $('#aiWindow').toggleClass('open'); }
        function sendAi() {
            let msg = $('#aiInput').val(); if(!msg) return;
            $('#chatBody').append(`<div class="msg user">${msg}</div>`);
            $('#aiInput').val('');
            $('#chatBody').scrollTop($('#chatBody')[0].scrollHeight);
            $('#typing').show();
            setTimeout(() => {
                $('#typing').hide();
                let res = "Prueba consultando sobre 'fotocheck' o 'clave'.";
                let low = msg.toLowerCase();
                if(low.includes("fotocheck")) res = "Elige la opción Fotocheck y pasa tu tarjeta por el lector láser.";
                else if(low.includes("clave") || low.includes("contraseña")) res = "Si olvidaste tu clave, pídela a Juan; suele resetearse a tu número de DNI.";
                else if(low.includes("hola")) res = "¡Hola! Soy la IA de soporte. ¿En qué te ayudo?";
                $('#chatBody').append(`<div class="msg bot">${res}</div>`);
                $('#chatBody').scrollTop($('#chatBody')[0].scrollHeight);
            }, 1000);
        }
    </script>
</body>
</html>