<?php
/**
 * MENU SOUNDCROW - VERSIÓN CORREGIDA Y OPTIMIZADA
 * Soluciona los errores de conexión y muestra el nombre real del Stand.
 */

// 1. ESTILOS VISUALES (SoundCrow Dark)
function estilos_visuales() {
    ?>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:wght@400;500;600;700&display=swap" rel="stylesheet">
    
    <style>
        /* BASE */
        /* BASE & FIX PANTALLA GRANDE */
        body {
            font-family: 'Plus Jakarta Sans', sans-serif !important;
            background: #0f172a !important;
            overflow-x: hidden; /* Evita scroll horizontal */
        }

        /* Esto obliga al menú a medir AL MENOS el alto total de la pantalla */
        .nav-md .container.body .col-md-3.left_col {
            font-family: 'Plus Jakarta Sans', sans-serif !important;
            background: #0f172a !important;
            min-height: 100vh !important; /* Altura mínima del 100% de la ventana */
            height: 100% !important;
            display: flex;
            flex-direction: column;
        }

        /* Asegura que el contenedor principal no sea blanco por defecto */
        .main_container {
            background: #0f172a !important;
        }
        .left_col {
            background: #0f172a !important;
            border-right: 1px solid rgba(255,255,255,0.05);
        }
        .nav_title, .menu_section h3 { display: none !important; }
        #sidebar-menu { margin-top: 20px; margin-bottom: 80px; }

        /* ITEMS MENÚ PRINCIPAL */
        .nav.side-menu > li > a {
            display: block !important;
            color: #94a3b8 !important; font-weight: 500;
            padding: 13px 15px !important; margin: 4px 10px;
            border-radius: 8px; font-size: 14px; text-decoration: none;
            transition: all 0.3s ease; 
        }
        .nav.side-menu > li > a i {
            display: inline-block; vertical-align: middle;
            font-size: 18px !important; margin-right: 10px !important;
            width: 26px; text-align: center; color: #64748b;
            transition: transform 0.3s ease, color 0.3s ease;
        }
        .nav.side-menu > li > a span { vertical-align: middle; }
        .nav.side-menu > li > a span.fa-chevron-down { float: right; margin-top: 4px; font-size: 12px !important; }

        /* EFECTO HOVER Y ACTIVO */
        .nav.side-menu > li > a:hover, .nav.side-menu > li.active > a {
            background: rgba(255, 255, 255, 0.08) !important; color: #fff !important;
            box-shadow: 0 4px 15px rgba(0,0,0,0.2); transform: translateX(5px); 
        }
        .nav.side-menu > li:hover > a i { color: #6366f1 !important; transform: scale(1.2); }

        /* SUBMENÚS */
        .nav.child_menu { background: rgba(0,0,0,0.3) !important; display: none; }
        .nav.side-menu > li.active > ul.child_menu { display: block; }
        .nav.child_menu li a {
            color: #cbd5e1 !important; font-size: 13px !important;
            padding: 9px 15px 9px 50px !important; /* Indentación */
            display: block; text-decoration: none;
        }
        .nav.child_menu li a:hover { 
            background: transparent !important; color: #fff !important; 
            padding-left: 55px !important; /* Pequeño movimiento */
        }

/* PERFIL INFERIOR UNIFICADO */
.sidebar-bottom-profile {
    position: fixed; 
    bottom: 0; 
    left: 0; 
    width: 230px;
    background: #0f172a; /* Mismo código HEX que el resto del menú */
    border-top: 1px solid rgba(255,255,255,0.05); /* Línea sutil separadora */
    padding: 15px; 
    display: block; 
    z-index: 1000;
}
        .sb-inner { display: flex; align-items: center; gap: 15px; }
        .bottom-pic img { width: 40px; height: 40px; border-radius: 50%; border: 2px solid #10b981; padding: 2px; }
        .bottom-name { color: #fff; font-weight: 700; font-size: 13px; display: block; }
        .bottom-status { font-size: 11px; color: #10b981; display: block; margin-top: 2px; }

        /* TOP BAR */
        .nav_menu { background: #fff; border-bottom: 1px solid #e2e8f0; margin-bottom: 0; min-height: 60px; }
        .toggle a { padding: 15px 0 0 15px !important; float: left; }
        .toggle a i { color: #1e293b; font-size: 22px; }
        .user-profile { padding-top: 12px !important; display: block; }
        .branch-badge {
            background: linear-gradient(135deg, #4f46e5 0%, #3b82f6 100%);
            color: white !important; font-weight: 700; font-size: 12px;
            padding: 6px 15px; border-radius: 20px;
            box-shadow: 0 4px 10px rgba(79, 70, 229, 0.3); display: inline-block; vertical-align: middle;
        }
        .nav.navbar-nav.navbar-right { width: auto; float: right; }

        /* MODO CONTRAÍDO (NAV-SM) */
        body.nav-sm .nav.side-menu li a span { display: none !important; }
        body.nav-sm .nav.side-menu li a { text-align: center !important; padding: 15px 5px !important; transform: none !important; }
        body.nav-sm .nav.side-menu li a i { margin-right: 0 !important; font-size: 24px !important; display: block; width: 100%; }
        body.nav-sm .sidebar-bottom-profile { width: 70px !important; padding: 15px 0; text-align: center; }
        body.nav-sm .sb-inner { display: block; } 
        body.nav-sm .bottom-info { display: none !important; }
        body.nav-sm .bottom-pic img { margin: 0 auto; }
    </style>
    <?php
}

// 2. FUNCIÓN DE SEGURIDAD
if (!function_exists('recoge1')) {
    function recoge1($var) {
        $tmp = (isset($_REQUEST[$var])) ? trim(strip_tags($_REQUEST[$var])) : '';
        if (function_exists('get_magic_quotes_gpc') && get_magic_quotes_gpc()) {
            $tmp = stripslashes($tmp);
        }
        $tmp = str_replace('&', '&amp;',  $tmp);
        $tmp = str_replace('"', '&quot;', $tmp);
        $tmp = str_replace('í', '&iacute;', $tmp);
        return $tmp;
    }
}

// 3. MENÚ LATERAL (MENU 1)
function menu1(){
    estilos_visuales(); 
    global $con;
    if(!isset($con) || !$con) { require_once("config/db.php"); require_once("config/conexion.php"); }
    
    $user_id = $_SESSION['user_id']; 
    $sql_u = "SELECT foto, user_name, accesos FROM users WHERE user_id='$user_id'";
    $res_u = mysqli_query($con, $sql_u);
    $row_u = mysqli_fetch_array($res_u);
    $a = explode(".", $row_u["accesos"]);

    $img_f = (!empty($row_u['foto']) && file_exists("images/" . $row_u['foto'])) ? "images/" . $row_u['foto'] : "https://ui-avatars.com/api/?name=" . urlencode($row_u['user_name']) . "&background=6366f1&color=fff";
    ?>
    <div id="sidebar-menu" class="main_menu_side hidden-print main_menu">
        <div class="menu_section">
            <ul class="nav side-menu">
                
                <?php if($a[1]==1){ ?>
                <li><a href="resumen.php"><i class="fas fa-chart-pie"></i> <span>Inicio <span class="permiso-tag"></span></span></a></li>
                <?php } ?>
                
                <?php if($a[2]==1 || $a[3]==1 || $a[4]==1 || $a[5]==1 || $a[6]==1){ ?>
                <li><a><i class="fas fa-boxes-stacked"></i> <span>Almacén</span> <span class="fas fa-chevron-down"></span></a>
                    <ul class="nav child_menu">
                        <?php if($a[2]==1){ ?><li><a href="ingresoproductos.php">Nuevo producto <span class="permiso-tag"></span></a></li><?php } ?>
                        <?php if($a[3]==1){ ?><li><a href="productos.php">Lista productos <span class="permiso-tag"></span></a></li><?php } ?>
                        <?php if($a[4]==1){ ?><li><a href="categorias.php">Categorías <span class="permiso-tag"></span></a></li><?php } ?>
                        <?php if($a[5]==1){ ?><li><a href="consultaproductos.php">Consulta prod. <span class="permiso-tag"></span></a></li><?php } ?>
                        <?php if($a[6]==1){ ?><li><a href="kardex.php">Kardex <span class="permiso-tag"></span></a></li><?php } ?>
                    </ul>
                </li>
                <?php } ?>

                <?php if($a[7]==1 || $a[8]==1 || $a[9]==1 || $a[10]==1){ ?>
                <li><a><i class="fas fa-cash-register"></i> <span>Ventas</span> <span class="fas fa-chevron-down"></span></a>
                    <ul class="nav child_menu">
                        <?php if($a[7]==1){ ?><li><a href="nueva_factura.php">Factura Elect. <span class="permiso-tag"></span></a></li><?php } ?>
                        <?php if($a[8]==1){ ?><li><a href="fac.php">Lista Notas/Bol <span class="permiso-tag"></span></a></li><?php } ?>
                        <?php if($a[9]==1){ ?><li><a href="notas_venta.php">Notas de Venta <span class="permiso-tag"></span></a></li><?php } ?>
                        <?php if($a[10]==1){ ?><li><a href="cotizacion.php">Cotizaciones <span class="permiso-tag"></span></a></li><?php } ?>
                    </ul>
                </li>
                <?php } ?>

                <?php if($a[11]==1 || $a[12]==1 || $a[13]==1 || $a[14]==1){ ?>
                <li><a><i class="fas fa-truck-fast"></i> <span>Compras</span> <span class="fas fa-chevron-down"></span></a>
                    <ul class="nav child_menu">
                        <?php if($a[11]==1){ ?><li><a href="nueva_compra.php">Nueva Compra <span class="permiso-tag"></span></a></li><?php } ?>
                        <?php if($a[12]==1){ ?><li><a href="gastos.php">Registrar Gastos <span class="permiso-tag"></span></a></li><?php } ?>
                        <?php if($a[13]==1){ ?><li><a href="compras.php">Lista Compras <span class="permiso-tag"></span></a></li><?php } ?>
                        <?php if($a[14]==1){ ?><li><a href="reporte_pagos_compras.php">Lista Pagos <span class="permiso-tag"></span></a></li><?php } ?>
                    </ul>
                </li>
                <?php } ?>

                <?php if($a[15]==1 || $a[16]==1 || $a[17]==1 || $a[18]==1){ ?>
                <li><a><i class="fas fa-dolly"></i> <span>Movimientos</span> <span class="fas fa-chevron-down"></span></a>
                    <ul class="nav child_menu">
                        <?php if($a[15]==1){ ?><li><a href="nuevo_traslado.php">Traslados <span class="permiso-tag"></span></a></li><?php } ?>
                        <?php if($a[16]==1){ ?><li><a href="listado_traslados.php">Lista Traslados <span class="permiso-tag"></span></a></li><?php } ?>
                        <?php if($a[17]==1){ ?><li><a href="nueva_entrada.php">Entradas <span class="permiso-tag"></span></a></li><?php } ?>
                        <?php if($a[18]==1){ ?><li><a href="listado_entradas.php">Lista Entradas <span class="permiso-tag"></span></a></li><?php } ?>
                    </ul>
                </li>
                <?php } ?>

                <?php if($a[19]==1 || $a[20]==1){ ?>
                <li><a><i class="fas fa-address-book"></i> <span>Contactos</span> <span class="fas fa-chevron-down"></span></a>
                    <ul class="nav child_menu">
                        <?php if($a[19]==1){ ?><li><a href="clientes.php">Clientes <span class="permiso-tag"></span></a></li><?php } ?>
                        <?php if($a[20]==1){ ?><li><a href="proveedores.php">Proveedores <span class="permiso-tag"></span></a></li><?php } ?>
                    </ul>
                </li>
                <?php } ?>

                <?php if($a[21]==1 || $a[22]==1){ ?>
                <li><a><i class="fas fa-id-card-clip"></i> <span>Laboral</span> <span class="fas fa-chevron-down"></span></a>
                    <ul class="nav child_menu">
                        <?php if($a[21]==1){ ?><li><a href="usuarios.php">Trabajadores <span class="permiso-tag"></span></a></li><?php } ?>
                        <?php if($a[22]==1){ ?><li><a href="acceso.php">Accesos <span class="permiso-tag"></span></a></li><?php } ?>
                    </ul>
                </li>
                <?php } ?>

                <?php if($a[23]==1 || $a[24]==1 || $a[25]==1 || $a[26]==1 || $a[27]==1){ ?>
                <li><a><i class="fas fa-sliders"></i> <span>Sistema</span> <span class="fas fa-chevron-down"></span></a>
                    <ul class="nav child_menu">
                        <?php if($a[23]==1){ ?><li><a href="empresa.php">Empresa <span class="permiso-tag"></span></a></li><?php } ?>
                        <?php if($a[24]==1){ ?><li><a href="sucursal.php">Sucursales <span class="permiso-tag"></span></a></li><?php } ?>
                        <?php if($a[25]==1){ ?><li><a href="documentos.php">Comprobantes <span class="permiso-tag"></span></a></li><?php } ?>
                        <?php if($a[26]==1){ ?><li><a href="conf_electronica.php">Configuración <span class="permiso-tag"></span></a></li><?php } ?>
                        <?php if($a[27]==1){ ?><li><a href="historial_cajas.php">Caja <span class="permiso-tag"></span></a></li><?php } ?>
                    </ul>
                </li>
                <?php } ?>

                <?php if($a[28]==1){ ?>
                <li><a><i class="fas fa-calculator"></i> <span>Gestion</span> <span class="fas fa-chevron-down"></span></a>
                    <ul class="nav child_menu">
                        <?php if($a[28]==1){ ?><li><a href="pago_trabajador.php">Pago de trabajador<span class="permiso-tag"></span></a></li><?php } ?>
                    </ul>
                </li>
                <?php } ?>

                <?php if($a[29]==1){ ?>
                <li><a href="reporte_mensual.php"><i class="fas fa-file-invoice-dollar"></i> <span>Reporte mensual<span class="permiso-tag"></span></span></a></li>
                <?php } ?>

            </ul>
        </div>
        <div class="sidebar-bottom-profile">
            <div class="sb-inner">
                <div class="bottom-pic"><img src="<?php echo $img_f; ?>"></div>
                <div class="bottom-info">
                    <span class="bottom-name"><?php echo strtoupper($row_u['user_name']); ?></span>
                    <span style="font-size:11px; color:#10b981;"><i class="fas fa-circle"></i> Conectado</span>
                </div>
            </div>
        </div>
    </div>
    <?php
}

function menu2(){ ?> <div style="display:none;"></div> <?php }

// 4. BARRA SUPERIOR (MENU 3) - ARREGLADO
function menu3(){
    // IMPORTANTE: USAMOS LA CONEXIÓN GLOBAL $con
    // Esto evita el error "null given" porque usamos la conexión que ya está abierta en el sistema
    global $con; 
    
    // Si por alguna razón la conexión global no existe, la invocamos (seguridad)
    if(!isset($con) || !$con){
        require_once("config/db.php");
        require_once("config/conexion.php");
    }

    $user_id = $_SESSION['user_id'];
    $user_name = $_SESSION['user_name'];
    $tienda_actual = isset($_SESSION['tienda']) ? intval($_SESSION['tienda']) : 1;
    
    // Foto
    $sql_foto = "SELECT foto FROM users WHERE user_id='$user_id'";
    $res_foto = mysqli_query($con, $sql_foto); // Ahora funciona porque $con sí existe
    $img_final = "https://ui-avatars.com/api/?name=" . urlencode($user_name) . "&background=6366f1&color=fff";
    
    if ($res_foto && $row_foto = mysqli_fetch_array($res_foto)) {
        $archivo_foto = $row_foto['foto'];
        if (!empty($archivo_foto) && file_exists("images/" . $archivo_foto)) {
            $img_final = "images/" . $archivo_foto;
        }
    }

    // BUSCAR NOMBRE REAL (STAND)
    $nombre_a_mostrar = "Sucursal " . $tienda_actual; // Texto por defecto
    $sql_suc = "SELECT nombre, nombre_stand FROM sucursal WHERE id_sucursal='$tienda_actual' LIMIT 1";
    $res_suc = mysqli_query($con, $sql_suc); // Usamos $con aquí también

    if ($res_suc && $row_suc = mysqli_fetch_array($res_suc)) {
        if (!empty($row_suc['nombre_stand'])) {
            $nombre_a_mostrar = $row_suc['nombre_stand'];
        } elseif (!empty($row_suc['nombre'])) {
            $nombre_a_mostrar = $row_suc['nombre'];
        }
    }
    ?>
    <div class="top_nav">
        <div class="nav_menu">
            <nav class="" role="navigation">
                <div class="nav toggle">
                    <a id="menu_toggle"><i class="fas fa-bars"></i></a>
                </div>

                <ul class="nav navbar-nav navbar-right">
                    <li class="">
                        <a href="javascript:;" class="user-profile dropdown-toggle" data-toggle="dropdown" aria-expanded="false">
                            <img src="<?php echo $img_final; ?>" alt="">
                            <span style="color:#334155; font-weight:600;"><?php echo $user_name; ?></span>
                            <span class="fas fa-angle-down" style="font-size:11px; margin-left:3px;"></span>
                        </a>
                        <ul class="dropdown-menu dropdown-usermenu animated fadeInDown pull-right">
                            <!--<li><a href="perfil.php"><i class="fas fa-user mr-2 text-muted"></i> Perfil</a></li>
                            <li><a href="configuracion.php"><i class="fas fa-cog mr-2 text-muted"></i> Configuración</a></li>-->
                            <li style="border-top:1px solid #eee;">
                                <a href="login.php?logout" style="color:#ef4444;"><i class="fas fa-sign-out-alt mr-2"></i> Cerrar Sesión</a>
                            </li>
                        </ul>
                    </li>

                    <li role="presentation" style="padding-top:18px; margin-right:20px;">
                        <span class="branch-badge">
                            <i class="fas fa-store-alt branch-icon"></i>
                            <?php echo $nombre_a_mostrar; ?>
                        </span>
                    </li>
                </ul>
            </nav>
        </div>
    </div>
    <?php
}

function footer(){
    ?>
    <footer>
        <div class="pull-right">SoundCrow v2.0</div>
        <div class="clearfix"></div>
    </footer>
    <?php
}
?>