<?php
	if (isset($con))
	{
?>	
	<style>
        /* --- ESTILOS MODERNOS PARA EL MODAL --- */
        .modal-content-modern {
            border-radius: 16px;
            border: none;
            box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.25);
            background-color: #f8fafc;
            overflow: hidden;
        }

        /* Cabecera con degradado elegante */
        .modal-header-modern {
            background: linear-gradient(135deg, #0f172a 0%, #1e293b 100%);
            padding: 20px 30px;
            border-bottom: 1px solid #334155;
            display: flex;
            align-items: center;
            justify-content: space-between;
        }

        .modal-title-modern {
            color: white;
            font-weight: 700;
            font-size: 18px;
            letter-spacing: 0.5px;
            margin: 0;
            display: flex;
            align-items: center;
            gap: 10px;
        }

        /* Botón cerrar personalizado */
        .btn-close-modern {
            background: rgba(255, 255, 255, 0.1);
            border: none;
            color: white;
            width: 32px;
            height: 32px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            transition: all 0.2s;
            cursor: pointer;
            font-size: 18px;
        }
        .btn-close-modern:hover {
            background: #ef4444; /* Rojo al pasar el mouse */
            transform: rotate(90deg);
        }

        /* Caja de búsqueda flotante */
        .search-container-modern {
            background: white;
            padding: 20px 30px;
            border-bottom: 1px solid #e2e8f0;
            position: relative;
            z-index: 10;
            box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.05);
        }

        .input-group-modern {
            position: relative;
            display: flex;
            align-items: center;
            width: 100%;
        }

        .input-icon {
            position: absolute;
            left: 15px;
            color: #64748b;
            font-size: 16px;
            z-index: 2;
        }

        /* Input de búsqueda estilizado */
        #q {
            width: 100%;
            padding: 12px 15px 12px 45px; /* Espacio para el icono */
            border: 2px solid #e2e8f0;
            border-radius: 12px;
            font-size: 15px;
            color: #334155;
            background-color: #f8fafc;
            transition: all 0.3s ease;
            outline: none;
            box-shadow: none;
            height: 50px;
        }

        #q:focus {
            background-color: white;
            border-color: #3b82f6; /* Azul moderno */
            box-shadow: 0 0 0 4px rgba(59, 130, 246, 0.1);
        }

        /* Botón de búsqueda */
        .btn-search-modern {
            background: #3b82f6;
            color: white;
            border: none;
            padding: 0 25px;
            border-radius: 10px;
            font-weight: 600;
            margin-left: 10px;
            height: 50px;
            transition: 0.3s;
        }
        .btn-search-modern:hover {
            background: #2563eb;
            transform: translateY(-1px);
            box-shadow: 0 4px 12px rgba(37, 99, 235, 0.3);
        }

        /* Cuerpo del modal (Resultados) */
        .modal-body-custom {
            padding: 0; /* Quitamos padding para que la tabla toque los bordes si es necesario */
            background-color: #f1f5f9;
            min-height: 300px;
            max-height: 70vh; /* Altura máxima para scrollear */
            overflow-y: auto;
        }

        /* Loader */
        .loader-modern {
            text-align: center;
            color: #64748b;
            font-weight: 600;
        }

        /* Contenedor de resultados */
        .outer_div {
            padding: 20px;
        }
        
        /* Ajuste de scrollbar */
        .modal-body-custom::-webkit-scrollbar { width: 8px; }
        .modal-body-custom::-webkit-scrollbar-track { background: #f1f5f9; }
        .modal-body-custom::-webkit-scrollbar-thumb { background: #cbd5e1; border-radius: 4px; }
        .modal-body-custom::-webkit-scrollbar-thumb:hover { background: #94a3b8; }
    </style>

	<div class="modal fade bs-example-modal-lg" id="myModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
	    <div class="modal-dialog modal-lg" role="document">
	        <div class="modal-content modal-content-modern">
                
                <div class="modal-header-modern">
                    <h4 class="modal-title-modern" id="myModalLabel">
                        <i class="fa fa-boxes"></i> Catálogo de Productos
                    </h4>
                    <button type="button" class="btn-close-modern" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>

                <div class="search-container-modern">
			        <form class="form-horizontal" onsubmit="return false;">
                        <div class="input-group-modern">
                            <span class="input-icon"><i class="glyphicon glyphicon-search"></i></span>
                            <input type="text" class="form-control" autocomplete="off" id="q" placeholder="Escribe el nombre, código o características del producto..." onkeyup="load(1)">
                            <button type="button" class="btn-search-modern" onclick="load(1)">Buscar</button>
                        </div>
			        </form>
                </div>
                
                <div class="modal-body modal-body-custom">
			        <div id="loader" class="loader-modern" style="display:none;">
                        <img src="./img/ajax-loader.gif" alt=""> Cargando productos...
                    </div>
			        
                    <div class="outer_div"></div>
		        </div>
		    </div>
	    </div>
	</div>
<?php
	}
?>