<?php
if (isset($con)) {
?>
<div class="modal fade" id="myModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
    <div class="modal-dialog" role="document" style="width: 50%;">
        <div class="modal-content" style="border-radius: 8px; border: none; overflow: hidden;">
            <div class="modal-header sc-header" style="background: linear-gradient(90deg, #0a2463 0%, #2473f2 100%); padding: 10px 20px; border-bottom: none;">
                <div style="display: flex; justify-content: space-between; align-items: center; width: 100%;">
                    <h4 class="modal-title" style="color: white; font-weight: 600; margin: 0; font-size: 15px;">
                        <i class='fa fa-user-plus' style="margin-right: 8px;"></i> Nuevo Usuario
                    </h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close" onclick="limpiarFormulario()" style="color: white; opacity: 1; text-shadow: none; float: none; font-size: 24px; line-height: 1; outline: none; background: transparent; border: none;">&times;</button>
                </div>
            </div>

            <div class="modal-body sc-body" style="background: #fff; padding: 25px;">
                <form class="form-horizontal" method="post" id="guardar_usuario" name="guardar_usuario">
                    <div id="resultados_ajax"></div>

                    <div class="row" style="margin-bottom: 15px;">
                        <div class="col-md-12">
                            <label class="form-label-sc" style="font-weight: 600; color: #64748b; font-size: 11px; text-transform: uppercase;">Código de Barras (Fotocheck)</label>
                            <div style="display: flex; gap: 5px;">
                                <input type="text" class="form-control-sc" id="codigo_barras" name="codigo_barras" placeholder="Generar o escribir 13 dígitos" maxlength="13" style="border-radius: 6px; height: 38px; width: 100%; border: 1px solid #e2e8f0; padding: 8px; font-size: 13px;">
                                <button type="button" class="btn btn-default" onclick="generarBarcode()" title="Generar Automático" style="border-radius: 6px; border: 1px solid #e2e8f0; background: #f8fafc; color: #2473f2;">
                                    <i class="fa fa-bolt"></i>
                                </button>
                            </div>
                        </div>
                    </div>

                    <div class="row" style="margin-bottom: 15px;">
                        <div class="col-md-12">
                            <label class="form-label-sc" style="font-weight: 600; color: #64748b; font-size: 11px; text-transform: uppercase;">Rol / Permisos</label>
                            <select class="form-control-sc" id="nivel" name="nivel" required style="border-radius: 6px; height: 38px; width: 100%; border: 1px solid #e2e8f0; padding: 0 10px; font-size: 13px;">
                                <option value="">-- Selecciona un rol --</option>
                                <option value="1">Trabajador (Acceso Estándar / Ventas)</option>
                                <option value="2">Administrador (Acceso Total)</option>
                                <option value="3">Almacenero (Control de Inventario)</option>
                            </select>
                        </div>
                    </div>

                    <div class="row" style="margin-bottom: 15px;">
                        <div class="col-md-12">
                            <label class="form-label-sc" style="font-weight: 600; color: #64748b; font-size: 11px; text-transform: uppercase;">Nombres y Apellidos</label>
                            <input type="text" class="form-control-sc" id="firstname" name="firstname" placeholder="Ej: Juan Pérez" required style="border-radius: 6px; height: 38px; width: 100%; border: 1px solid #e2e8f0; padding: 8px; font-size: 13px;">
                        </div>
                    </div>

                    <div class="row" style="margin-bottom: 15px;">
                        <div class="col-md-6">
                            <label class="form-label-sc" style="font-weight: 600; color: #64748b; font-size: 11px; text-transform: uppercase;">Usuario (Login)</label>
                            <input type="text" class="form-control-sc" id="user_name" name="user_name" placeholder="Ej: jperez" pattern="[a-zA-Z0-9]{2,64}" required style="border-radius: 6px; height: 38px; width: 100%; border: 1px solid #e2e8f0; padding: 8px; font-size: 13px;">
                        </div>
                        <div class="col-md-6">
                            <label class="form-label-sc" style="font-weight: 600; color: #64748b; font-size: 11px; text-transform: uppercase;">DNI</label>
                            <input type="text" class="form-control-sc" id="dni" name="dni" placeholder="Doc. Identidad" style="border-radius: 6px; height: 38px; width: 100%; border: 1px solid #e2e8f0; padding: 8px; font-size: 13px;">
                        </div>
                    </div>

                    <div class="row" style="margin-bottom: 15px;">
                        <div class="col-md-6">
                            <label class="form-label-sc" style="font-weight: 600; color: #64748b; font-size: 11px; text-transform: uppercase;">Contraseña</label>
                            <input type="password" class="form-control-sc" id="user_password_new" name="user_password_new" placeholder="******" pattern=".{6,}" required style="border-radius: 6px; height: 38px; width: 100%; border: 1px solid #e2e8f0; padding: 8px; font-size: 13px;">
                        </div>
                        <div class="col-md-6">
                            <label class="form-label-sc" style="font-weight: 600; color: #64748b; font-size: 11px; text-transform: uppercase;">Repetir Contraseña</label>
                            <input type="password" class="form-control-sc" id="user_password_repeat" name="user_password_repeat" placeholder="******" pattern=".{6,}" required style="border-radius: 6px; height: 38px; width: 100%; border: 1px solid #e2e8f0; padding: 8px; font-size: 13px;">
                        </div>
                    </div>

                    <div style="display:none;">
                        <input type="email" name="user_email" value="sin@correo.com">
                        <input type="number" name="sucursal" value="1">
                        <input type="text" name="telefono" value="">
                    </div>

                    <div class="modal-footer" style="border-top: 1px solid #f1f5f9; padding-top: 15px; margin-top: 15px; padding-bottom: 0;">
                        <button type="button" class="btn btn-default" data-dismiss="modal" onclick="limpiarFormulario()" style="border-radius: 30px; padding: 6px 20px; border: 1px solid #cbd5e1; background: white; color: #475569; font-size: 13px;">Cancelar</button>
                        <button type="submit" class="btn btn-primary" id="guardar_datos" style="background: #2473f2; border: none; border-radius: 30px; padding: 6px 25px; font-weight: 600; box-shadow: 0 4px 6px rgba(36, 115, 242, 0.2); color: white; font-size: 13px;">
                            Guardar Usuario
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<script>
    function generarBarcode() {
        // Genera 13 dígitos aleatorios
        let code = "";
        for (let i = 0; i < 13; i++) {
            code += Math.floor(Math.random() * 10);
        }
        document.getElementById("codigo_barras").value = code;
    }

    function limpiarFormulario() {
        document.getElementById("guardar_usuario").reset();
    }
</script>
<?php } ?>