<?php
session_start();
include('menu.php');
require_once ("config/db.php");
require_once ("config/conexion.php");

$sql1="select * from users where user_id=$_SESSION[user_id]";
$rw1=mysqli_query($con,$sql1);
$rs1=mysqli_fetch_array($rw1);

$modulo=$rs1["accesos"];
$a = explode(".", $modulo); 

if (!isset($_SESSION['user_login_status']) AND $_SESSION['user_login_status'] != 1) {
    header("location: login.php");
    exit;
}
if($a[9]==0){
    header("location:error.php");    
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="icon" href="logo.png" type="image/png">
    <title>Notas de Venta | SoundCrow</title>

    <link href="css/bootstrap.min.css" rel="stylesheet">
    <link href="fonts/css/font-awesome.min.css" rel="stylesheet">
    <link href="css/custom.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    
    <style>
        body { font-family: 'Poppins', sans-serif; background-color: #F0F2F5; color: #334155; }
        .sc-card { background: #ffffff; border-radius: 12px; box-shadow: 0 4px 20px rgba(0,0,0,0.05); border: none; margin-bottom: 30px; overflow: hidden; }
        .sc-header { background: linear-gradient(90deg, #0a2463 0%, #2473f2 100%); padding: 20px 30px; color: white; display: flex; align-items: center; justify-content: space-between; }
        .sc-title { margin: 0; font-size: 18px; font-weight: 700; text-transform: uppercase; }
        .sc-body { padding: 30px; }
        .form-control-sc { border-radius: 8px; border: 2px solid #e2e8f0; height: 42px; font-size: 13px; transition: 0.3s; width: 100%; padding: 0 15px; }
        .label-filter { font-size: 11px; font-weight: 700; text-transform: uppercase; color: #64748b; margin-bottom: 5px; display:block; }
        .btn-search { background: #2473f2; color: white; border: none; border-radius: 20px; height: 42px; padding: 0 30px; font-weight: 600; }
        .btn-new { background: white; color: #0a2463; border: none; border-radius: 20px; padding: 8px 20px; font-weight: 700; font-size: 12px; }
    </style>
</head>
<body class="nav-md">
    <div class="container body">
        <div class="main_container">
            <div class="col-md-3 left_col"><div class="left_col scroll-view"><?php menu2(); menu1(); ?></div></div>
            <?php menu3(); ?>

            <div class="right_col" role="main">
                <div class="row">
                    <div class="col-md-12" style="padding-top:15px">
                        
                        <div class="sc-card">
                            <div class="sc-header">
                                <h3 class="sc-title"><i class="fa fa-file-text-o"></i> Notas de Venta</h3>
                                <a href="nueva_factura.php" class="btn-new"><i class="fa fa-plus"></i> NUEVA NOTA</a>
                            </div>

                            <div class="sc-body">
                                <form id="datos_cotizacion">
                                    <div class="row">
                                        <div class="col-md-4 mb-3">
                                            <span class="label-filter">Cliente</span>
                                            <input type="text" class="form-control-sc" id="q" placeholder="Buscar por nombre..." onkeyup='load(1);'>
                                        </div>
                                        <div class="col-md-2 mb-3">
                                            <span class="label-filter">Número</span>
                                            <input type="text" class="form-control-sc" id="q1" placeholder="Ej: 154..." onkeyup='load(1);'>
                                        </div>
                                        <div class="col-md-2 mb-3">
                                            <span class="label-filter">Estado</span>
                                            <select class="form-control-sc" id="q4" onchange="load(1);">
                                                <option value="0" selected>Ver todas</option>
                                                <option value="3">Ver emitidas</option>
                                                <option value="32">Ver anuladas</option>
                                            </select>
                                        </div>
                                        <div class="col-md-2 mb-3">
                                            <span class="label-filter">Desde</span>
                                            <input type="date" class="form-control-sc" id="q2" onchange='load(1);'>
                                        </div>
                                        <div class="col-md-2 mb-3">
                                            <span class="label-filter">Hasta</span>
                                            <input type="date" class="form-control-sc" id="q3" onchange='load(1);'>
                                        </div>
                                    </div>
                                    <div class="text-right" style="margin-top:15px;">
                                        <button type="button" class="btn-search" onclick='load(1);'><i class="fa fa-search"></i> BUSCAR</button>
                                        <span id="loader"></span>
                                    </div>
                                </form>
                            </div>
                        </div>

                        <div id="resultados"></div>
                        <div class='outer_div'></div>

                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="modal fade" id="modal_premium" tabindex="-1" role="dialog">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content" style="border-radius: 15px;">
                <div class="modal-header" style="background: #0a2463; color: white;">
                    <button type="button" class="close" data-dismiss="modal" style="color:white;">&times;</button>
                    <h4 class="modal-title"><i class="fa fa-file-text"></i> Vista Previa</h4>
                </div>
                <div class="modal-body" style="padding: 0;">
                    <iframe id="iframe_premium" src="" style="width: 100%; height: 600px; border: none;"></iframe>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="modal_ticket" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document" style="width: 450px;">
            <div class="modal-content" style="border-radius: 15px;">
                <div class="modal-header" style="background: #3b82f6; color: white;">
                    <button type="button" class="close" data-dismiss="modal" style="color:white;">&times;</button>
                    <h4 class="modal-title"><i class="fa fa-print"></i> Formato Ticket</h4>
                </div>
                <div class="modal-body" style="padding: 0;">
                    <iframe id="iframe_ticket" src="" style="width: 100%; height: 550px; border: none;"></iframe>
                </div>
            </div>
        </div>
    </div>

<div class="modal fade" id="modal_anular_nota" tabindex="-1" role="dialog">
      <div class="modal-dialog modal-sm" role="document">
        <div class="modal-content" style="border-radius: 12px;">
          <div class="modal-header" style="background: #f97316; color: white; border-radius: 12px 12px 0 0;">
            <button type="button" class="close" data-dismiss="modal" style="color:white;">&times;</button>
            <h4 class="modal-title"><i class="fa fa-ban"></i> Anular Nota</h4>
          </div>
          <div class="modal-body">
            <input type="hidden" id="id_nota_anular">
            
            <div class="form-group">
              <label>Usuario que anula:</label>
              <select id="usuario_anula_input" class="form-control" style="border-radius: 6px;">
                <option value="">-- Seleccionar --</option>
                <?php
                // Extraemos los usuarios directo de la base de datos
                $sql_users = mysqli_query($con, "SELECT nombres FROM users");
                while($u = mysqli_fetch_array($sql_users)){
                    echo "<option value='".$u['nombres']."'>".$u['nombres']."</option>";
                }
                ?>
              </select>
            </div>

            <div class="form-group">
              <label>Motivo de la anulación:</label>
              <textarea id="motivo_anulacion_input" class="form-control" rows="3" placeholder="Ej: Error en precio..."></textarea>
            </div>
          </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-default" data-dismiss="modal">Cerrar</button>
            <button type="button" class="btn btn-warning" onclick="confirmar_anulacion_final()">Confirmar</button>
          </div>
        </div>
      </div>
    </div>

    <script src="js/jquery.min.js"></script>
    <script src="js/bootstrap.min.js"></script>
    <script src="js/nicescroll/jquery.nicescroll.min.js"></script>
    <script src="js/custom.js"></script>
    <script type="text/javascript" src="js/VentanaCentrada.js"></script>

    <script>
        $(document).ready(function(){ 
            load(1); 
        });

        function load(page){
            var q=$("#q").val(); 
            var q1=$("#q1").val(); 
            var q2=$("#q2").val(); 
            var q3=$("#q3").val();
            var q4=$("#q4").val();
            
            $("#loader").fadeIn('slow');
            $.ajax({
                url:'./ajax/buscar_notas_venta.php?action=ajax&page='+page+'&q='+q+'&q1='+q1+'&q2='+q2+'&q3='+q3+'&q4='+q4,
                success:function(data){ 
                    $(".outer_div").html(data); 
                    $('#loader').html(''); 
                }
            });
        }

 function mostrar_modal_premium(id, hash) {
    // Asegúrate de que arriba diga function mostrar_modal_premium(id, hash)
    var url = 'vista_previa.php?id_factura=' + id + '&hash=' + hash;
    $('#iframe_premium').attr('src', url);
    $('#modal_premium').modal('show');
}

function mostrar_modal_ticket(id, hash) {
    // Asegúrate de que arriba diga function mostrar_modal_ticket(id, hash)
    var url = './pdf/documentos/ver_ticket.php?id_factura=' + id + '&hash=' + hash;
    $('#iframe_ticket').attr('src', url);
    $('#modal_ticket').modal('show');
}

        // --- FUNCIONES PARA ANULAR NOTA ---
        function preparar_anulacion(id) {
            $("#id_nota_anular").val(id);
            $("#motivo_anulacion_input").val("");
            $("#modal_anular_nota").modal("show");
        }

function confirmar_anulacion_final() {
    var id = $("#id_nota_anular").val();
    var motivo_texto = $("#motivo_anulacion_input").val();
    var usuario_anula = $("#usuario_anula_input").val();
    
    // Validación del usuario
    if (usuario_anula === "") {
        alert("Por favor, seleccione qué trabajador está anulando la nota.");
        return;
    }
    
    // Validación del motivo
    if (motivo_texto.length < 5) {
        alert("Por favor, ingrese un motivo válido (mínimo 5 caracteres).");
        return;
    }
    
    // Unimos el motivo y el trabajador en un solo texto
    var observacion_completa = motivo_texto + " (Anulado por: " + usuario_anula + ")";
    
    if (confirm("¿Seguro que desea anular esta nota? El stock será devuelto.")) {
        $.ajax({
            type: "GET",
            url: "./ajax/anular_nota.php",
            data: "id_factura=" + id + "&motivo=" + encodeURIComponent(observacion_completa),
            success: function(datos) {
                $("#modal_anular_nota").modal("hide");
                $("#resultados").html(datos);
                load(1); // Recarga la tabla
            }
        });
    }
}

        // --- FUNCIÓN DE WHATSAPP ---
        function solicitar_numero_ws(mensaje) {
            var numero = prompt("El cliente no tiene un número registrado. Por favor, ingrese el número de WhatsApp (9 dígitos):", "");
            if (numero != null && numero.length >= 9) {
                var url = "https://api.whatsapp.com/send?phone=51" + numero + "&text=" + mensaje;
                window.open(url, '_blank');
            } else if (numero != null) {
                alert("Por favor, ingrese un número válido.");
            }
        }
    </script>
</body>
</html>