<?php
session_start();
include('menu.php');
require_once ("config/db.php");
require_once ("config/conexion.php");

if (!isset($_SESSION['user_login_status']) AND $_SESSION['user_login_status'] != 1) { header("location: login.php"); exit; }
$sql1="select * from users where user_id='".$_SESSION['user_id']."'";
$rw1=mysqli_query($con,$sql1);
$rs1=mysqli_fetch_array($rw1);
$modulo=$rs1["accesos"];
$a = explode(".", $modulo); 
if($a[11]==0){ header("location:error.php"); exit; }
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Nueva Compra | SoundCrow</title>
    <link rel="icon" href="logo.ico">
    <link href="css/bootstrap.min.css" rel="stylesheet">
    <link href="fonts/css/font-awesome.min.css" rel="stylesheet">
    <link href="css/custom.min.css" rel="stylesheet">
    <link href="css/select/select2.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        body { font-family: 'Poppins', sans-serif !important; background-color: #F0F2F5; color: #334155; }
        .sc-card { background: #ffffff; border-radius: 12px; box-shadow: 0 4px 20px rgba(0,0,0,0.05); border: none; overflow: hidden; margin-bottom: 30px; }
        .sc-header { background: linear-gradient(90deg, #0a2463 0%, #2473f2 100%); padding: 20px 30px; color: white; }
        .sc-title { margin: 0; font-size: 18px; font-weight: 700; text-transform: uppercase; color: white; }
        .sc-body { padding: 30px; }
        .form-control-sc { border-radius: 8px; border: 1px solid #e2e8f0; padding: 10px 15px; height: 40px; background-color: #f8fafc; width: 100%; color: #334155; font-weight:500; }
        .form-control-sc:focus { background-color: #fff; border-color: #2473f2; outline: none; }
        .form-label-sc { font-weight: 600; color: #64748b; font-size: 11px; text-transform: uppercase; margin-bottom: 5px; display: block; }
        .btn-save { background: #10b981; color: white; border-radius: 30px; padding: 12px 40px; border: none; font-weight: 600; width: 100%; transition: all 0.3s; font-size: 16px; }
        .btn-save:hover { background: #059669; transform: translateY(-2px); }
        .table-custom { width: 100%; border-collapse: separate; border-spacing: 0 5px; }
        .table-custom thead th { background: #f1f5f9; color: #475569; border: none; font-weight: 700; text-transform: uppercase; font-size: 11px; padding: 12px 10px; border-bottom: 2px solid #e2e8f0; }
        .table-custom tbody td { vertical-align: middle; padding: 5px 10px; background: #fff; }
        .btn-add-item { background: #e0f2fe; color: #0284c7; border: 1px solid #bae6fd; border-radius: 6px; padding: 6px 15px; font-size: 12px; font-weight: 600; float: right; }
        .btn-remove { background: #fee2e2; color: #ef4444; border: 1px solid #fecaca; width: 35px; height: 35px; border-radius: 50%; display: flex; align-items: center; justify-content: center; }
        .image-preview-container { border: 2px dashed #cbd5e1; border-radius: 10px; padding: 10px; text-align: center; background: #f8fafc; cursor: pointer; height: 80px; display: flex; align-items: center; justify-content: center; flex-direction: column; }
        #preview_img { max-width: 100%; max-height: 100%; display: none; border-radius: 5px; }
        .panel-totales { background: #f8fafc; border: 1px solid #e2e8f0; border-radius: 12px; padding: 20px; margin-top: 20px; }
        .input-money { text-align: right; font-weight: bold; color: #0a2463; font-size: 16px; }
        .deuda-text { color: #ef4444; font-weight: 700; font-size: 20px; }
        .pagado-text { color: #10b981; font-weight: 700; font-size: 20px; }
    </style>
</head>
<body class="nav-md">
    <div class="container body">
        <div class="main_container">
            <div class="col-md-3 left_col"><div class="left_col scroll-view"><div class="clearfix"></div><?php menu2(); menu1(); ?></div></div>
            <?php menu3(); ?>
            <div class="right_col" role="main">
                <form id="guardar_compra" name="guardar_compra" method="post" enctype="multipart/form-data">
                    <div class="row"><div class="col-md-12"><div class="sc-card">
                        <div class="sc-header"><h3 class="sc-title"><i class="fa fa-shopping-cart"></i> Registrar Nueva Compra</h3></div>
                        <div class="sc-body">
                            <div id="resultados_ajax"></div>
                            
                            <div class="row">
                                <div class="col-md-4 form-group">
                                    <label class="form-label-sc">Proveedor</label>
                                    <div class="input-group">
                                        <select class="form-control-sc select2_single" name="id_proveedor" id="id_proveedor" required style="width:100%;">
                                            <option value="">Selecciona Proveedor...</option>
                                            <?php $sql_prov = mysqli_query($con, "SELECT id_cliente, nombre_cliente FROM clientes WHERE tipo1=2 ORDER BY nombre_cliente");
                                            while ($rw = mysqli_fetch_array($sql_prov)){ echo '<option value="'.$rw['id_cliente'].'">'.$rw['nombre_cliente'].'</option>'; } ?>
                                        </select>
                                        <span class="input-group-btn">
                                            <button class="btn btn-primary" type="button" onclick="$('#nuevoProveedores').modal('show');" style="height:40px; border-radius:0 8px 8px 0; background: #2473f2; border-color: #2473f2;"><i class="fa fa-plus"></i></button>
                                        </span>
                                    </div>
                                </div>
                                <div class="col-md-2 form-group"><label class="form-label-sc">Fecha</label><input type="date" class="form-control-sc" name="fecha" value="<?php echo date("Y-m-d");?>" required></div>
                                
                                <div class="col-md-2 form-group">
                                    <label class="form-label-sc">Moneda</label>
                                    <select class="form-control-sc" name="moneda" id="moneda">
                                        <option value="1">Soles (S/)</option>
                                        <option value="2">Dólares ($)</option>
                                    </select>
                                </div>

                                <div class="col-md-2 form-group"><label class="form-label-sc">Tipo Doc.</label>
                                    <select class="form-control-sc" name="tipo_doc"><option value="1">Factura</option><option value="2">Boleta</option><option value="3">Guía / Nota</option></select>
                                </div>
                                
                                <div class="col-md-2 form-group"><label class="form-label-sc">Nro. Documento</label>
                                    <div class="input-group">
                                        <input type="text" class="form-control-sc" name="serie" placeholder="F001" style="width:40%; float:left; border-radius: 8px 0 0 8px; text-transform:uppercase;">
                                        <input type="text" class="form-control-sc" name="correlativo" placeholder="12345" style="width:60%; float:left; border-radius: 0 8px 8px 0;">
                                    </div>
                                    <small style="font-size:10px; color:#999;">(Opcional)</small>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-3 form-group"><label class="form-label-sc">Forma de Pago</label>
                                    <select class="form-control-sc" name="forma_pago" required><option value="1">Efectivo</option><option value="2">Transferencia</option><option value="3">Yape / Plin</option><option value="4">Tarjeta</option><option value="5">Crédito</option></select>
                                </div>
                                <div class="col-md-3 form-group"><label class="form-label-sc">Evidencia</label>
                                    <div class="image-preview-container" onclick="document.getElementById('imagen').click()">
                                        <div id="upload-placeholder"><i class="fa fa-camera" style="color:#94a3b8;"></i> <span style="font-size:11px;">Adjuntar</span></div>
                                        <input type="file" name="imagen" id="imagen" style="display: none;" accept="image/*" onchange="mostrarImagen(this)">
                                        <img id="preview_img">
                                    </div>
                                </div>
                            </div>
                            
                            <hr style="border-top: 1px dashed #e2e8f0; margin: 25px 0;">
                            
                            <div class="row"><div class="col-md-12">
                                <div style="margin-bottom: 10px; overflow: hidden;">
                                    <label class="form-label-sc" style="color:#0a2463; float:left; margin-top:5px; font-size:13px;">DETALLE DE PRODUCTOS</label>
                                    <button type="button" class="btn-add-item" onclick="agregarFila()"><i class="fa fa-plus-circle"></i> Agregar Item</button>
                                </div>
                                <table class="table table-custom">
                                    <thead><tr><th width="10%" class="text-center">CANT.</th><th width="50%">DESCRIPCIÓN</th><th width="15%" class="text-right">P. UNIT</th><th width="15%" class="text-right">SUBTOTAL</th><th width="10%"></th></tr></thead>
                                    <tbody id="tabla_productos"><tr id="fila0"><td><input type="number" step="0.01" name="cantidades[]" class="form-control-sc cantidad text-center" placeholder="1" required onkeyup="calcularTotales()"></td><td><input type="text" name="nombres[]" class="form-control-sc" placeholder="Descripción..." required></td><td><input type="number" step="0.01" name="precios[]" class="form-control-sc precio text-right" placeholder="0.00" required onkeyup="calcularTotales()"></td><td><input type="text" class="form-control-sc subtotal text-right" value="0.00" readonly style="background:transparent; border:none; font-weight:700;"></td><td class="text-center"><button type="button" class="btn-remove" onclick="eliminarFila('0')"><i class="fa fa-trash"></i></button></td></tr></tbody>
                                </table>
                            </div></div>
                            
                            <div class="row"><div class="col-md-12"><div class="panel-totales"><div class="row">
                                <div class="col-md-4 text-center"><label class="form-label-sc">TOTAL COMPRA</label><div class="input-group"><span class="input-group-addon moneda-simbolo">S/</span><input type="number" class="form-control-sc input-money" name="total_venta" id="total_venta" value="0.00" readonly></div></div>
                                <div class="col-md-4 text-center"><label class="form-label-sc" style="color:#10b981;">A CUENTA (PAGO)</label><div class="input-group"><span class="input-group-addon moneda-simbolo" style="background:#ecfdf5; color:#10b981;">S/</span><input type="number" step="0.01" class="form-control-sc input-money" name="a_cuenta" id="a_cuenta" placeholder="0.00" required onkeyup="calcularDeuda()" style="border-color:#10b981;"></div></div>
                                <div class="col-md-4 text-center"><label class="form-label-sc" style="color:#ef4444;">SALDO (DEUDA)</label><div id="texto_saldo" class="pagado-text">0.00</div><input type="hidden" name="saldo_pendiente" id="saldo_pendiente" value="0"></div>
                            </div></div></div></div>
                            <br><div class="row"><div class="col-md-12"><button type="submit" class="btn btn-save" id="btn_guardar"><i class="fa fa-save"></i> REGISTRAR COMPRA</button></div></div>
                        </div>
                    </div></div></div>
                </form>
            </div>
        </div>
    </div>

    <div class="modal fade" id="nuevoProveedores" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
        <div class="modal-dialog" role="document" style="width: 55%;">
            <div class="modal-content" style="border-radius: 8px; border: none; overflow: hidden;">
                
                <div class="modal-header sc-header" style="background: linear-gradient(90deg, #0a2463 0%, #2473f2 100%); padding: 10px 20px; border-bottom: none;">
                    <div style="display: flex; justify-content: space-between; align-items: center; width: 100%;">
                        <h4 class="modal-title" id="myModalLabel" style="color: white; font-weight: 600; margin: 0; font-size: 15px; display: flex; align-items: center;">
                            <i class='fa fa-truck' style="margin-right: 8px;"></i> Nuevo Proveedor
                        </h4>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close" style="color: white; opacity: 1;">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                </div>

                <div class="modal-body sc-body" style="background: #fff; padding: 20px;">
                    <form class="form-horizontal" method="post" id="guardar_proveedores" name="guardar_proveedores">
                        
                        <div class="row" style="margin-bottom: 10px;">
                            <div class="col-md-5">
                                <div class="form-group" style="margin: 0;">
                                    <label class="form-label-sc">Tipo Documento</label>
                                    <select class="form-control-sc" id="tipo" name="tipo" required>
                                        <option value="">Seleccionar...</option>
                                        <option value="1">DNI</option>
                                        <option value="2">RUC</option>
                                        <option value="3">Sin Documento</option> </select>
                                </div>
                            </div>
                            <div class="col-md-7">
                                <div class="form-group" style="margin: 0;">
                                    <label class="form-label-sc">Nro. Documento</label>
                                    <div class="input-group">
                                        <input type="text" class="form-control-sc" id="doc" name="doc" placeholder="Número" required style="border-radius: 6px 0 0 6px;">
                                        <span class="input-group-btn">
                                            <button type="button" class="btn btn-primary" id="btn-ingresar" title="Buscar" style="height: 40px; border-radius: 0 6px 6px 0; background: #2473f2; border: 1px solid #2473f2;">
                                                <i class="fa fa-search"></i>
                                            </button>
                                        </span>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="row" style="margin-bottom: 10px;">
                            <div class="col-md-12">
                                <div class="form-group" style="margin: 0;">
                                    <label class="form-label-sc">Razón Social / Nombre</label>
                                    <input type="text" class="form-control-sc" id="nombre" name="nombre" placeholder="Nombre completo" required>
                                </div>
                            </div>
                        </div>

                        <div class="row" style="margin-bottom: 10px;">
                            <div class="col-md-12">
                                <div class="form-group" style="margin: 0;">
                                    <label class="form-label-sc">Dirección</label>
                                    <textarea class="form-control-sc" id="direccion" name="direccion" placeholder="Dirección fiscal" style="height: 50px; resize: none;"></textarea>
                                </div>
                            </div>
                        </div>

                        <div class="row" style="margin-bottom: 10px;">
                            <div class="col-md-6">
                                <div class="form-group" style="margin: 0;">
                                    <label class="form-label-sc">Teléfono</label>
                                    <input type="text" class="form-control-sc" id="telefono" name="telefono">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group" style="margin: 0;">
                                    <label class="form-label-sc">Email</label>
                                    <input type="email" class="form-control-sc" id="email" name="email">
                                </div>
                            </div>
                        </div>

                        <div class="row" style="margin-bottom: 5px;">
                            <div class="col-md-12">
                                <div class="form-group" style="margin: 0;">
                                    <label class="form-label-sc">Estado</label>
                                    <select class="form-control-sc" id="estado" name="estado" required>
                                        <option value="1" selected>Activo</option><option value="0">Inactivo</option>
                                    </select>
                                </div>
                            </div>
                        </div>

                        <div class="modal-footer" style="border-top: 1px solid #f1f5f9; padding-top: 15px; margin-top: 15px;">
                            <button type="button" class="btn btn-default" data-dismiss="modal" onclick="document.getElementById('guardar_proveedores').reset();">Cancelar</button>
                            <button type="submit" class="btn btn-primary" id="guardar_datos" style="background: #2473f2; border: none; font-weight: 600;">Guardar Proveedor</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <script src="js/jquery.min.js"></script><script src="js/bootstrap.min.js"></script><script src="js/custom.js"></script><script src="js/select/select2.full.js"></script>
    <script>
        $(document).ready(function() { $(".select2_single").select2({ placeholder: "Buscar Proveedor", width: '100%' }); });
        
        // --- LÓGICA DE MONEDA ---
        $("#moneda").change(function(){
            var m = $(this).val(); var sim = (m == 1) ? "S/" : "$";
            $(".moneda-simbolo").text(sim); calcularDeuda(); 
        });

        // --- LÓGICA NUEVA: MANEJO DE "SIN DOCUMENTO" ---
        $("#tipo").change(function(){
            if($(this).val() == 3){ // Si elige Sin Documento
                $("#doc").removeAttr("required"); // Quitamos obligatorio
                $("#doc").val("0"); // Ponemos 0 por defecto
                $("#doc").prop("readonly", true); // Bloqueamos escritura
            } else {
                $("#doc").attr("required", true); // Ponemos obligatorio
                $("#doc").prop("readonly", false); // Desbloqueamos
                if($("#doc").val() == "0") $("#doc").val(""); // Limpiamos si estaba en 0
            }
        });

        // --- LÓGICA DE BÚSQUEDA DEL PROVEEDOR ---
        $('#btn-ingresar').click(function(){
            var btn = $(this);
            var originalText = btn.html();
            btn.html('<i class="fa fa-spinner fa-spin"></i>'); 
            
            $.ajax({                        
                type: "POST",                 
                url: "busqueda4.php",                   
                data: $("#guardar_proveedores").serialize(),
                success: function(data) {
                    $('#doc').html(data);
                    var porciones = data.split('|'); 
                    if(porciones.length > 0) document.getElementById("nombre").value = porciones[0];
                    if(porciones.length > 1) document.getElementById("direccion").value = porciones[1];
                    btn.html(originalText);
                },
                error: function(){
                    btn.html(originalText);
                    alert("Error al buscar.");
                }
            });
        });

        // --- GUARDAR PROVEEDOR ---
        $("#guardar_proveedores").submit(function(e) {
            e.preventDefault();
            $.ajax({
                type: "POST",
                url: "ajax/nuevo_proveedor_rapido.php",
                data: $(this).serialize(),
                success: function(response){
                    var data = response.split("|");
                    if(data[0] != "error"){
                        var newOption = new Option(data[1], data[0], true, true);
                        $('#id_proveedor').append(newOption).trigger('change');
                        $('#nuevoProveedores').modal('hide');
                        document.getElementById("guardar_proveedores").reset();
                        // Resetear estado del input doc
                        $("#doc").prop("readonly", false).attr("required", true);
                    } else {
                        alert("Error al guardar proveedor. Verifique los datos.");
                    }
                }
            });
        });

        // --- LÓGICA DE TABLA Y CÁLCULOS ---
        var cont = 0;
        function agregarFila(){
            cont++;
            var fila = '<tr id="fila'+cont+'"><td><input type="number" step="0.01" name="cantidades[]" class="form-control-sc cantidad text-center" placeholder="1" required onkeyup="calcularTotales()"></td><td><input type="text" name="nombres[]" class="form-control-sc" placeholder="Descripción..." required></td><td><input type="number" step="0.01" name="precios[]" class="form-control-sc precio text-right" placeholder="0.00" required onkeyup="calcularTotales()"></td><td><input type="text" class="form-control-sc subtotal text-right" value="0.00" readonly style="background:transparent; border:none; font-weight:700;"></td><td class="text-center"><button type="button" class="btn-remove" onclick="eliminarFila('+cont+')"><i class="fa fa-trash"></i></button></td></tr>';
            $('#tabla_productos').append(fila);
        }
        function eliminarFila(index){ $('#fila' + index).remove(); calcularTotales(); }
        function calcularTotales(){
            var total_global = 0;
            $("#tabla_productos tr").each(function() {
                var cant = parseFloat($(this).find(".cantidad").val()) || 0;
                var prec = parseFloat($(this).find(".precio").val()) || 0;
                var sub = cant * prec;
                $(this).find(".subtotal").val(sub.toFixed(2));
                total_global += sub;
            });
            $("#total_venta").val(total_global.toFixed(2));
            calcularDeuda();
        }
        function calcularDeuda() {
            var total = parseFloat($("#total_venta").val()) || 0;
            var acuenta = parseFloat($("#a_cuenta").val()) || 0;
            var saldo = total - acuenta;
            if (saldo < 0) saldo = 0;
            var sim = ($("#moneda").val() == 1) ? "S/ " : "$ ";
            $("#texto_saldo").html(sim + saldo.toFixed(2));
            $("#saldo_pendiente").val(saldo.toFixed(2));
            if (saldo > 0) { $("#texto_saldo").removeClass("pagado-text").addClass("deuda-text"); } 
            else { $("#texto_saldo").removeClass("deuda-text").addClass("pagado-text"); if(total > 0 && saldo == 0) $("#texto_saldo").html("PAGADO <i class='fa fa-check'></i>"); }
        }
        function mostrarImagen(input) { if (input.files && input.files[0]) { var reader = new FileReader(); reader.onload = function(e) { $('#preview_img').attr('src', e.target.result).show(); $('#upload-placeholder').hide(); }; reader.readAsDataURL(input.files[0]); } }
        
        $("#guardar_compra").on('submit', function(e){
            e.preventDefault();
            var total = parseFloat($("#total_venta").val());
            var acuenta = parseFloat($("#a_cuenta").val());
            if(total <= 0) { alert("Error: Agrega al menos un producto."); return false; }
            if(acuenta > total) { alert("Error: El abono no puede ser mayor al total."); return false; }
            var formData = new FormData(this);
            $.ajax({ type: 'POST', url: 'ajax/guardar_compra_manual.php', data: formData, contentType: false, processData: false, beforeSend: function(){ $("#btn_guardar").attr("disabled", true).html('Guardando...'); }, success: function(data){ $("#resultados_ajax").html(data); $("#btn_guardar").attr("disabled", false).html('GUARDAR COMPRA'); if(data.indexOf('alert-success') > -1){ document.getElementById("guardar_compra").reset(); $('#preview_img').hide(); $('#upload-placeholder').show(); $(".select2_single").val("").trigger("change"); $('#tabla_productos').html('<tr id="fila0"><td><input type="number" step="0.01" name="cantidades[]" class="form-control-sc cantidad text-center" placeholder="1" required onkeyup="calcularTotales()"></td><td><input type="text" name="nombres[]" class="form-control-sc" placeholder="Ej: Servicio de Flete..." required></td><td><input type="number" step="0.01" name="precios[]" class="form-control-sc precio text-right" placeholder="0.00" required onkeyup="calcularTotales()"></td><td><input type="text" class="form-control-sc subtotal text-right" value="0.00" readonly style="background:transparent; border:none; font-weight:700;"></td><td class="text-center"><button type="button" class="btn-remove" onclick="eliminarFila(\'0\')"><i class="fa fa-trash"></i></button></td></tr>'); $("#total_venta").val("0.00"); $("#texto_saldo").html("0.00"); $('html, body').animate({scrollTop:0}, 'slow'); } } });
        });
    </script>
</body>
</html>