<?php
date_default_timezone_set('America/Lima'); // Ajuste de hora para Perú
session_start();
include('menu.php');
require_once ("config/db.php");
require_once ("config/conexion.php");

if (!isset($_SESSION['user_login_status']) AND $_SESSION['user_login_status'] != 1) {
    header("location: login.php");
    exit;
}

$sql1="select * from users where user_id=$_SESSION[user_id]";
$rw1=mysqli_query($con,$sql1);
$rs1=mysqli_fetch_array($rw1);
$modulo=$rs1["accesos"];
$a = explode(".", $modulo); 

$sql2="select * from datosempresa where id_emp=1";
$rw2=mysqli_query($con,$sql2);
$rs2=mysqli_fetch_array($rw2);
$dolar=$rs2["dolar"];

$tienda=$_SESSION['tienda'];
$sql3="select * from sucursal where tienda=$tienda";
$rw3=mysqli_query($con,$sql3);
$rs3=mysqli_fetch_array($rw3);
$caja=$rs3["caja"];
if($caja==0){ header("location:error1.php"); }

// --- 1. CARGA DE CORRELATIVOS PARA AMBOS DOCUMENTOS ---
$serie_factura = ""; $num_factura = ""; $serie_boleta = ""; $num_boleta = "";
$sql_docs = mysqli_query($con, "SELECT * FROM documento");
while ($row_doc = mysqli_fetch_array($sql_docs)) {
    if ($row_doc['id_documento'] == 1) { // Factura
        $serie_factura = $row_doc['folio'.$tienda];
        $num_factura = $row_doc['tienda'.$tienda] + 1;
    }
    if ($row_doc['id_documento'] == 2) { // Boleta
        $serie_boleta = $row_doc['folio'.$tienda];
        $num_boleta = $row_doc['tienda'.$tienda] + 1;
    }
}

// --- 2. LÓGICA DE CARGA DE LA NOTA DE VENTA ---
if (isset($_GET['id_factura'])) {
    $id_factura=intval($_GET['id_factura']);
    $campos="clientes.direccion_cliente, clientes.id_cliente, clientes.nombre_cliente, clientes.documento, clientes.telefono_cliente, clientes.email_cliente, facturas.id_vendedor, facturas.fecha_factura, facturas.folio, facturas.numero_factura";
    $sqlcc="select $campos from facturas, clientes where (facturas.estado_factura=3) and facturas.id_cliente=clientes.id_cliente and id_factura='".$id_factura."'";        
    $sql_factura=mysqli_query($con,$sqlcc);
    $count=mysqli_num_rows($sql_factura);
    
    if ($count==1) {
        $rw_factura=mysqli_fetch_array($sql_factura);
        $id_cliente=$rw_factura['id_cliente'];
        $nombre_cliente=$rw_factura['nombre_cliente'];
        $telefono_cliente=$rw_factura['telefono_cliente'];
        $direccion_cliente=$rw_factura['direccion_cliente'];
        $doc1=$rw_factura['documento'];
        
        // Determinamos el tipo inicial basado en el documento del cliente
        if(strlen($doc1)==8){ 
            $_SESSION['doc_ventas']=2; $serie_actual = $serie_boleta; $num_actual = $num_boleta;
        } else { 
            $_SESSION['doc_ventas']=1; $serie_actual = $serie_factura; $num_actual = $num_factura;
        }

        $folio_org=$rw_factura['folio'];
        $numero_factura=$rw_factura['numero_factura'];

        $session_id=session_id();
        mysqli_query($con, "delete from tmp where session_id='".$session_id."'");
        $sql_det=mysqli_query($con, "select * from detalle_factura where numero_factura='".$numero_factura."' and folio='".$folio_org."' and tienda=$tienda and (tipo_doc=3 or tipo_doc=8)");
        while ($row2=mysqli_fetch_array($sql_det)) {
            $p_tmp=$row2['precio_venta']; $c_tmp=$row2['cantidad']; $id_p=$row2['id_producto'];
            mysqli_query($con, "INSERT INTO tmp (id_producto,cantidad_tmp,precio_tmp,session_id,tienda) VALUES ('$id_p','$c_tmp','$p_tmp','$session_id','1000')");
        }
    } else {
        header("location: notas_venta.php?count=error");
        exit;   
    }
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="icon" href="logo.png" type="image/png"> <title>Convertir Nota | SoundCrow</title>
    
    <link href="css/bootstrap.min.css" rel="stylesheet">
    <link href="fonts/css/font-awesome.min.css" rel="stylesheet">
    <link href="css/custom.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700&display=swap" rel="stylesheet">
    <style>
        body { background-color: #f1f5f9; font-family: 'Poppins', sans-serif; color: #334155; }
        .sc-header { background: linear-gradient(90deg, #0a2463 0%, #2473f2 100%); color: white; padding: 25px; border-radius: 12px 12px 0 0; margin-top: 50px; }
        .sc-container { background: white; padding: 30px; border-radius: 0 0 12px 12px; box-shadow: 0 10px 15px rgba(0,0,0,0.05); border: 1px solid #e2e8f0; border-top: none; }
        .label-filter { font-size: 11px; font-weight: 700; color: #64748b; text-transform: uppercase; margin-bottom: 5px; display: block; }
        .form-control { border-radius: 8px; border: 2px solid #e2e8f0; height: 42px; font-weight: 500; }
        .selection-bar { background: #f8fafc; padding: 20px; border-radius: 12px; margin-bottom: 25px; border: 1px solid #e2e8f0; } /* Sin amarillos */
    </style>
</head>
<body class="nav-md">
    <div class="container body">
        <div class="main_container">
            <div class="col-md-3 left_col"><div class="left_col scroll-view"><?php menu2(); menu1(); ?></div></div>
            <?php menu3(); ?>

            <div class="right_col" role="main">
                
                <div class="modal fade" id="myModalProductosConvert" tabindex="-1" role="dialog">
                  <div class="modal-dialog modal-lg"><div class="modal-content">
                      <div class="modal-header" style="background:#0a2463; color:white;"><button type="button" class="close" data-dismiss="modal" style="color:white;">&times;</button><h4 class="modal-title">Buscar Productos</h4></div>
                      <div class="modal-body"><input type="text" class="form-control" id="q_producto" placeholder="Nombre o código..." onkeyup="load_productos(1)"><div class="outer_div_productos" style="margin-top:15px"></div></div>
                  </div></div>
                </div>

                <div class="modal fade" id="myModalCliente" tabindex="-1" role="dialog">
                  <div class="modal-dialog modal-lg"><div class="modal-content">
                      <div class="modal-header" style="background:#0a2463; color:white;"><button type="button" class="close" data-dismiss="modal" style="color:white;">&times;</button><h4 class="modal-title">Buscar Clientes</h4></div>
                      <div class="modal-body"><input type="text" class="form-control" id="q_cliente" placeholder="Nombre o RUC/DNI..." onkeyup="load_clientes(1)"><div class="outer_div_clientes" style="margin-top:15px"></div></div>
                  </div></div>
                </div>

                <div class="sc-header"><h3><i class="fa fa-refresh"></i> Nueva Conversión</h3></div>

                <div class="sc-container">
                    <div class="selection-bar">
                        <form action="nueva_conv.php" method="get">
                            <div class="row">
                                <div class="col-md-12">
                                    <label class="label-filter">CONVERTIR A (ELIJA TIPO):</label>
                                    <select class="form-control" id="target_type" onchange="cambiar_tipo_doc(this.value)">
                                        <option value="1" <?php if($_SESSION['doc_ventas']==1) echo "selected";?>>Factura Electrónica</option>
                                        <option value="2" <?php if($_SESSION['doc_ventas']==2) echo "selected";?>>Boleta Electrónica</option>
                                    </select>
                                </div>
                            </div>
                        </form>
                    </div>

                    <form id="datos_factura">
                        <div class="row">
                            <div class="col-md-12"><h5 style="color: #2563eb; font-weight: 700; border-bottom: 2px solid #f1f5f9; padding-bottom: 10px;">1. Datos del Cliente</h5></div>
                            <div class="col-md-8 mb-3">
                                <label class="label-filter">CLIENTE</label>
                                <div class="input-group">
                                    <input type="text" class="form-control" id="nombre_cliente" value="<?php echo $nombre_cliente;?>" readonly>
                                    <span class="input-group-btn"><button class="btn btn-default" type="button" data-toggle="modal" data-target="#myModalCliente"><i class="fa fa-search"></i></button></span>
                                </div>
                                <input id="id_cliente" type='hidden' value="<?php echo $id_cliente;?>">	
                            </div>
                            <div class="col-md-4 mb-3"><label class="label-filter">DOCUMENTO</label><input type="text" class="form-control" id="doc1" value="<?php echo $doc1;?>" readonly></div>
                        </div>

                        <div class="row" style="margin-top:20px;">
                            <div class="col-md-12"><h5 style="color: #2563eb; font-weight: 700; border-bottom: 2px solid #f1f5f9; padding-bottom: 10px;">2. Detalles del Comprobante</h5></div>
                            
                            <input type="hidden" id="serie_f" value="<?php echo $serie_factura; ?>">
                            <input type="hidden" id="num_f" value="<?php echo $num_factura; ?>">
                            <input type="hidden" id="serie_b" value="<?php echo $serie_boleta; ?>">
                            <input type="hidden" id="num_b" value="<?php echo $num_boleta; ?>">

                            <div class="col-md-2 mb-3"><label class="label-filter">FOLIO</label><input type="text" class="form-control" id="folio" value="<?php echo $serie_actual;?>" readonly></div>
                            <div class="col-md-2 mb-3"><label class="label-filter">NRO DOC</label><input type="text" class="form-control" id="factura" value="<?php echo $num_actual;?>" readonly></div>
                            <div class="col-md-2 mb-3"><label class="label-filter">ORIGEN</label><input type="text" class="form-control" id="nro_doc" value="<?php echo "$folio_org-$numero_factura";?>" readonly></div>
                            <div class="col-md-3 mb-3"><label class="label-filter">FECHA</label><input type="date" class="form-control" id="fecha" value="<?php echo date("Y-m-d");?>"></div>
                            <div class="col-md-3 mb-3"><label class="label-filter">HORA</label><input type="time" class="form-control" id="hora" value="<?php echo date("H:i:s");?>"></div>
                            
                            <input type="hidden" id="tip_doc" value="<?php echo $_SESSION['doc_ventas']; ?>">
                            <input type="hidden" id="folio1" value="<?php echo $folio_org;?>"><input type="hidden" id="num_fac" value="<?php echo $numero_factura;?>">
                        </div>

                        <div class="row" style="margin-top: 25px;">
                            <div class="col-md-12">
                                <div class="pull-right"><button type="button" class="btn btn-primary" style="border-radius:20px;" data-toggle="modal" data-target="#myModalProductosConvert"><i class="fa fa-plus"></i> AÑADIR PRODUCTO</button></div>
                                <h5 style="color: #2563eb; font-weight: 700; border-bottom: 2px solid #f1f5f9; padding-bottom: 10px; display:flex; align-items:center;">
                                    3. PRODUCTOS 
                                    <span id="badge_items" style="background:#dbeafe; color:#1e40af; padding:5px 15px; border-radius:20px; font-size:12px; font-weight:bold; margin-left:15px;">
                                        ITEMS: <span id="item_count_val">0</span> / 40
                                    </span> </h5>
                            </div>
                        </div>

                        <div id="resultados" style="margin-top:10px;"></div>

                        <div class="row" style="margin-top: 30px; border-top: 1px solid #e2e8f0; padding-top: 20px;">
                            <div class="col-md-12 text-center"><button type="submit" class="btn btn-success btn-lg" style="border-radius:50px; padding:12px 60px; font-weight:700;"><i class="fa fa-save"></i> GUARDAR</button></div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <script src="js/jquery.min.js"></script>
    <script src="js/bootstrap.min.js"></script>
    <script src="js/nicescroll/jquery.nicescroll.min.js"></script>
    <script src="js/custom.js"></script>
    <script type="text/javascript" src="js/VentanaCentrada.js"></script>

    <script>
        function recontar() { $("#item_count_val").text($(".id_producto_lista").length); }

        $(document).ready(function(){
            $("#resultados").load("./ajax/agregar_facturacion_convert.php", function() { recontar(); });

            // AUTO-CARGA DE TABLAS AL ABRIR LOS MODALES
            $('#myModalProductosConvert').on('shown.bs.modal', function () { $('#q_producto').focus(); load_productos(1); });
            $('#myModalCliente').on('shown.bs.modal', function () { $('#q_cliente').focus(); load_clientes(1); });
        });

        // CAMBIO DINÁMICO DE SERIE Y NÚMERO
        function cambiar_tipo_doc(val) {
            $("#tip_doc").val(val);
            if(val == 1) { // Factura
                $("#folio").val($("#serie_f").val()); 
                $("#factura").val($("#num_f").val()); 
            } else { // Boleta
                $("#folio").val($("#serie_b").val()); 
                $("#factura").val($("#num_b").val()); 
            }
        }

        function load_productos(page){
            var q= $("#q_producto").val();
            $.ajax({ url:'./ajax/buscar_productos_convert.php?action=ajax&page='+page+'&q='+q, success:function(data){ $(".outer_div_productos").html(data); }})
        }

        function load_clientes(page){
            var q= $("#q_cliente").val();
            $.ajax({ url:'./ajax/buscar_clientes_convert.php?action=ajax&page='+page+'&q='+q, success:function(data){ $(".outer_div_clientes").html(data); }})
        }

        function agregar_cliente(id, nom, doc, dir, tel) {
            $("#id_cliente").val(id); $("#nombre_cliente").val(nom); $("#doc1").val(doc); $('#myModalCliente').modal('hide');
        }

        function agregar(id){
            var p = $('#precio_venta_'+id).val(); var c = $('#cantidad_'+id).val();
            $.ajax({ type: "POST", url: "./ajax/agregar_facturacion_convert.php", data: "id="+id+"&precio_venta="+p+"&cantidad="+c, success: function(d){ $("#resultados").html(d); recontar(); }});
        }

        function eliminar(id){
            $.ajax({ type: "GET", url: "./ajax/agregar_facturacion_convert.php", data: "id="+id, success: function(d){ $("#resultados").html(d); recontar(); }});
        }

        $("#datos_factura").submit(function(e){
            e.preventDefault();
            var id_c = $("#id_cliente").val(); var fac = $("#factura").val(); var fec = $("#fecha").val(); var hor = $("#hora").val(); var fol = $("#folio").val();
            var fol1 = $("#folio1").val(); var n_f = $("#num_fac").val(); var n_d = $("#nro_doc").val(); var n_c = $("#nombre_cliente").val();
            var d_1 = $("#doc1").val(); var t_d = $("#tip_doc").val();

            VentanaCentrada('./pdf/documentos/factura_pdf2.php?id_cliente='+id_c+'&id_vendedor=<?php echo $_SESSION['user_id'];?>&factura='+fac+'&fecha='+fec+'&hora='+hor+'&moneda=1&tcp=<?php echo $dolar;?>&folio='+fol+'&nro_doc='+n_d+'&nombre_cliente='+n_c+'&doc1='+d_1+'&tip_doc='+t_d+'&folio1='+fol1+'&num_fac='+n_f,'Factura','','1024','768','true');
            setTimeout(function(){ window.location.href = 'notas_venta.php'; }, 1500);
        });
    </script>
</body>
</html>