<?php
session_start();
date_default_timezone_set('America/Lima');
include('menu.php');
require_once ("config/db.php");
require_once ("config/conexion.php");

if (!isset($_SESSION['user_login_status']) AND $_SESSION['user_login_status'] != 1) {
   header("location: login.php");
   exit;
}

$sql1="select * from users where user_id=$_SESSION[user_id]";
$rw1=mysqli_query($con,$sql1);
$rs1=mysqli_fetch_array($rw1);
$modulo=$rs1["accesos"];
$a = explode(".", $modulo); 

$sql2="select * from datosempresa where id_emp=1";
$rw2=mysqli_query($con,$sql2);
$rs2=mysqli_fetch_array($rw2);
$dolar=$rs2["dolar"];

$tienda=$_SESSION['tienda'];
$sql3="select * from sucursal where tienda=$tienda";
$rw3=mysqli_query($con,$sql3);
$rs3=mysqli_fetch_array($rw3);
$caja=$rs3["caja"];
if($caja==0){ header("location:error1.php"); }

// Correlativos
$serie_factura = ""; $num_factura = ""; $serie_boleta = "";  $num_boleta = "";
$sql_docs = mysqli_query($con, "SELECT * FROM documento");
while ($row_doc = mysqli_fetch_array($sql_docs)) {
    if ($row_doc['id_documento'] == 1) { 
        if($tienda==1){ $serie_factura=$row_doc['folio1']; $num_factura=$row_doc['tienda1']+1; }
        if($tienda==2){ $serie_factura=$row_doc['folio2']; $num_factura=$row_doc['tienda2']+1; }
        if($tienda==3){ $serie_factura=$row_doc['folio3']; $num_factura=$row_doc['tienda3']+1; }
        if($tienda==4){ $serie_factura=$row_doc['folio4']; $num_factura=$row_doc['tienda4']+1; }
    }
    if ($row_doc['id_documento'] == 2) { 
        if($tienda==1){ $serie_boleta=$row_doc['folio1']; $num_boleta=$row_doc['tienda1']+1; }
        if($tienda==2){ $serie_boleta=$row_doc['folio2']; $num_boleta=$row_doc['tienda2']+1; }
        if($tienda==3){ $serie_boleta=$row_doc['folio3']; $num_boleta=$row_doc['tienda3']+1; }
        if($tienda==4){ $serie_boleta=$row_doc['folio4']; $num_boleta=$row_doc['tienda4']+1; }
    }
}

// Carga
if (isset($_GET['id_factura'])) {
    $id_factura=intval($_GET['id_factura']);
    $campos="clientes.direccion_cliente, clientes.id_cliente, clientes.nombre_cliente, clientes.documento, clientes.telefono_cliente, clientes.email_cliente, facturas.id_vendedor, facturas.fecha_factura, facturas.folio, facturas.condiciones, facturas.estado_factura, facturas.numero_factura";
    $sqlcc="select $campos from facturas, clientes where (facturas.estado_factura=8) and facturas.id_cliente=clientes.id_cliente and id_factura='".$id_factura."'";        
    $sql_factura=mysqli_query($con,$sqlcc);
    $count=mysqli_num_rows($sql_factura);
    
    if ($count==1) {
        $rw_factura=mysqli_fetch_array($sql_factura);
        $id_cliente=$rw_factura['id_cliente'];
        $nombre_cliente=$rw_factura['nombre_cliente'];
        $telefono_cliente=$rw_factura['telefono_cliente'];
        $direccion_cliente=$rw_factura['direccion_cliente'];
        $doc1=$rw_factura['documento'];
        
        if(strlen($doc1)==8){ 
            $_SESSION['doc_ventas']=2; $serie_actual = $serie_boleta; $num_actual = $num_boleta;
        } else { 
            $_SESSION['doc_ventas']=1; $serie_actual = $serie_factura; $num_actual = $num_factura;
        }

        $folio_cot=$rw_factura['folio'];
        $num_cot=$rw_factura['numero_factura'];
        $id_vendedor_db=$rw_factura['id_vendedor'];

        $session_id=session_id();
        $delete2=mysqli_query($con, "delete from tmp where session_id='".$session_id."'");
        $sql2=mysqli_query($con, "select * from detalle_factura where numero_factura='".$num_cot."' and folio='".$folio_cot."' and tienda=$tienda and (tipo_doc=3 or tipo_doc=8)");
        while ($row2=mysqli_fetch_array($sql2)) {
            $precio_venta=$row2['precio_venta'];
            $cantidad=$row2['cantidad'];
            $id=$row2['id_producto'];
            $insert_tmp=mysqli_query($con, "INSERT INTO tmp (id_producto,cantidad_tmp,precio_tmp,session_id,tienda) VALUES ('$id','$cantidad','$precio_venta','$session_id','1000')");
        }
        $_SESSION['id_factura']=$id_factura;
        $_SESSION['numero_factura']=$num_cot;
    } else {
        header("location: facturas.php?count=error");
        exit;   
    }
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="icon" href="logo.png" type="image/png">
    <title>Procesar Cotización | SoundCrow</title>
    <link href="css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <link href="css/custom.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:wght@400;500;600;700&display=swap" rel="stylesheet">
    <style>
        body { background-color: #f1f5f9; font-family: 'Plus Jakarta Sans', sans-serif; color: #334155; }
        .form-header { background: linear-gradient(135deg, #0f172a 0%, #1e40af 100%); color: white; padding: 25px 40px; border-radius: 12px 12px 0 0; display: flex; justify-content: space-between; align-items: center; margin-top: 60px; box-shadow: 0 4px 6px rgba(0,0,0,0.1); }
        .form-container { background: white; padding: 30px; border-radius: 0 0 12px 12px; box-shadow: 0 10px 15px -3px rgba(0,0,0,0.1); margin-bottom: 50px; border: 1px solid #e2e8f0; border-top: none; }
        .form-label { font-size: 11px; font-weight: 700; color: #64748b; text-transform: uppercase; margin-bottom: 5px; display: block; }
        .form-control { border: 2px solid #e2e8f0; border-radius: 8px; height: 42px; padding: 8px 15px; font-size: 13px; font-weight: 500; color: #334155; }
        .form-control[readonly] { background-color: #f8fafc; }
        .btn-modern { border-radius: 50px; font-weight: 700; text-transform: uppercase; font-size: 12px; }
        .btn-blue { background: #2563eb; color: white; border: none; }
        .btn-blue:hover { background: #1d4ed8; color: white; }
        .btn-success-modern { background: #10b981; color: white; border: none; }
        .ui-autocomplete { position: absolute; z-index: 2150000000 !important; cursor: default; padding: 0; margin-top: 2px; list-style: none; background-color: #ffffff; border: 1px solid #ccc; border-radius: 5px; box-shadow: 0 5px 10px rgba(0, 0, 0, 0.2); }
        .ui-autocomplete > li { padding: 3px 20px; }
        .ui-autocomplete > li.ui-state-focus { background-color: #DDD; }

        /* TOAST NOTIFICATIONS */
        #toast-container { position: fixed; top: 20px; right: 20px; z-index: 99999; pointer-events: none; }
        .toast-sc {
            min-width: 320px;
            padding: 12px 15px;
            margin-bottom: 12px;
            border-radius: 8px;
            color: white;
            font-family: 'Plus Jakarta Sans', sans-serif;
            box-shadow: 0 5px 15px rgba(0,0,0,0.2);
            display: flex;
            align-items: center;
            animation: slideIn 0.3s cubic-bezier(0.68, -0.55, 0.27, 1.55) forwards;
            pointer-events: auto;
        }
        .toast-success { background-color: #4caf50; }
        .toast-error { background-color: #f44336; }
        .toast-icon { font-size: 20px; margin-right: 12px; display: flex; align-items: center; }
        .toast-content h4 { margin: 0; font-size: 15px; font-weight: 700; line-height: 1.2; }
        .toast-content p { margin: 2px 0 0; font-size: 13px; font-weight: 500; opacity: 0.95; line-height: 1.2; }
        @keyframes slideIn { from { transform: translateX(100%); opacity: 0; } to { transform: translateX(0); opacity: 1; } }
        @keyframes fadeOut { from { opacity: 1; transform: translateY(0); } to { opacity: 0; transform: translateY(-20px); } }
    </style>
</head>
<body class="nav-md">
    <div id="toast-container"></div>

    <div class="container body">
        <div class="main_container">
            <div class="col-md-3 left_col"><div class="left_col scroll-view"><div class="clearfix"></div><?php menu2(); menu1(); ?></div></div>
            <?php menu3(); ?>
            <div class="right_col" role="main">
                
                <?php include("modal/buscar_productos_convert.php"); ?>

                <div class="form-header">
                    <div><h3><i class="fa fa-refresh"></i> Procesar Cotización</h3><p style="margin: 0; opacity: 0.8;">Verifique los datos y productos.</p></div>
                </div>

                <div class="form-container">
                    <form class="form-horizontal" role="form" id="datos_factura">
                        <div class="row">
                            <div class="col-md-12"><h5 style="color: #2563eb; font-weight: 700; margin-bottom: 15px; border-bottom: 2px solid #f1f5f9; padding-bottom: 10px;">1. Datos del Cliente</h5></div>
                            
                            <div class="col-md-6 col-sm-6 col-xs-12 mb-3">
                                <label class="form-label">Cliente *</label>
                                <div class="input-group">
                                    <input type="text" class="form-control" id="nombre_cliente" value="<?php echo $nombre_cliente;?>" placeholder="Escribe para autocompletar..." required>
                                    <span class="input-group-btn">
                                        <button class="btn btn-default" type="button" data-toggle="modal" data-target="#myModalCliente"><i class="fa fa-search"></i></button>
                                    </span>
                                </div>
                                <input id="id_cliente" name="id_cliente" type='hidden' value="<?php echo $id_cliente;?>">   
                            </div>

                            <div class="col-md-3 col-sm-3 col-xs-12 mb-3"><label class="form-label">Teléfono</label><input type="text" class="form-control" id="tel1" value="<?php echo $telefono_cliente;?>" readonly></div>
                            <div class="col-md-3 col-sm-3 col-xs-12 mb-3"><label class="form-label">RUC/DNI</label><input type="text" class="form-control" id="doc1" value="<?php echo $doc1;?>" readonly></div>
                            <div class="col-md-9 mb-3"><label class="form-label">Dirección</label><input type="text" class="form-control" id="direccion_cliente" value="<?php echo $direccion_cliente;?>" readonly></div>
                            <div class="col-md-3 mb-3"><label class="form-label">Cotización Origen</label><input type="text" class="form-control" value="<?php echo "$folio_cot-$num_cot"; ?>" readonly></div>
                        </div>

                        <div class="row" style="margin-top: 20px;">
                            <div class="col-md-12"><h5 style="color: #2563eb; font-weight: 700; margin-bottom: 15px; border-bottom: 2px solid #f1f5f9; padding-bottom: 10px;">2. Datos del Comprobante</h5></div>
                            <input type="hidden" id="serie_factura_db" value="<?php echo $serie_factura; ?>"><input type="hidden" id="num_factura_db" value="<?php echo $num_factura; ?>"><input type="hidden" id="serie_boleta_db" value="<?php echo $serie_boleta; ?>"><input type="hidden" id="num_boleta_db" value="<?php echo $num_boleta; ?>">

                            <div class="col-md-3 mb-3"><label class="form-label">Tipo</label><select class='form-control' id="tip_doc" name="tip_doc" onchange="actualizar_correlativo();"><option value="1" <?php if($_SESSION['doc_ventas']==1) echo "selected"; ?>>Factura</option><option value="2" <?php if($_SESSION['doc_ventas']==2) echo "selected"; ?>>Boleta</option></select></div>
                            <div class="col-md-2 mb-3"><label class="form-label">Serie</label><input type="text" class="form-control" id="folio" value="<?php echo $serie_actual;?>" readonly></div>
                            <div class="col-md-2 mb-3"><label class="form-label">Número</label><input type="text" class="form-control" id="factura" value="<?php echo $num_actual;?>" readonly></div>
                            <div class="col-md-3 mb-3"><label class="form-label">Fecha Emisión</label><input type="date" class="form-control" id="fecha" value="<?php echo date("Y-m-d");?>"></div>
                            <div class="col-md-2 mb-3"><label class="form-label">Hora</label><input type="time" class="form-control" id="hora" value="<?php echo date("H:i:s");?>"></div>
                        </div>
                        
                        <div class="row" style="margin-top: 25px;">
                            <div class="col-md-12">
                                <div class="pull-right">
                                    <button type="button" class="btn btn-modern btn-blue" data-toggle="modal" data-target="#myModalProductosConvert"><i class="fa fa-plus"></i> Agregar producto</button>
                                </div>
                                <h5 style="color: #2563eb; font-weight: 700; border-bottom: 2px solid #f1f5f9; padding-bottom: 10px; display:flex; justify-content:space-between; align-items:center;">
                                    3. Productos
                                    <span id="badge_items" style="background:#dbeafe; color:#1e40af; padding:5px 15px; border-radius:20px; font-size:12px; font-weight:bold;">
                                        Items: <span id="item_count_val">0</span> / 40
                                    </span>
                                </h5>
                            </div>
                        </div>

                        <div id="resultados" class='col-md-12' style="margin-top:10px"></div>
                        
                        <div class="row" style="margin-top: 30px; border-top: 1px solid #e2e8f0; padding-top: 20px;">
                            <div class="col-md-12 text-center">
                                <button type="submit" class="btn btn-modern btn-success-modern btn-lg" style="padding: 12px 50px;"><i class="fa fa-save"></i> GUARDAR Y FACTURAR</button>
                            </div>
                        </div>

                        <input type="hidden" id="moneda" value="1"><input type="hidden" id="tcp" value="<?php echo $dolar;?>"><input type="hidden" id="folio1" value="<?php echo $folio_cot;?>"><input type="hidden" id="num_fac" value="<?php echo $num_cot;?>"><input type="hidden" id="nro_doc" value="<?php print"$folio_cot-$num_cot";?>"><input type="hidden" id="motivo" value=""><input type="hidden" id="des" value="">
                    </form>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="myModalCliente" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
      <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
          <div class="modal-header" style="background:#0a2463; color:white;">
            <button type="button" class="close" data-dismiss="modal" aria-label="Close" style="color:white;"><span aria-hidden="true">&times;</span></button>
            <h4 class="modal-title" id="myModalLabel"><i class='glyphicon glyphicon-search'></i> Buscar Clientes</h4>
          </div>
          <div class="modal-body">
            <form class="form-horizontal">
              <div class="form-group row">
                <div class="col-sm-3">
                    <select class="form-control" id="tipo_busqueda_cliente" onchange="load_clientes(1)">
                        <option value="">Todos</option>
                        <option value="ruc">RUC (Empresas)</option>
                        <option value="dni">DNI (Personas)</option>
                    </select>
                </div>
                <div class="col-sm-6">
                  <input type="text" class="form-control" id="q_cliente" placeholder="Nombre o número de documento" onkeyup="load_clientes(1)">
                </div>
                <div class="col-sm-3">
                  <button type="button" class="btn btn-default" onclick="load_clientes(1)"><span class='glyphicon glyphicon-search'></span> Buscar</button>
                </div>
              </div>
            </form>
            <div id="loader_clientes" style="position: absolute; text-align: center; top: 55px;  width: 100%;display:none;"></div>
            <div class="outer_div_clientes"></div>
          </div>
          <div class="modal-footer"><button type="button" class="btn btn-default" data-dismiss="modal">Cerrar</button></div>
        </div>
      </div>
    </div>

    <script src="https://code.jquery.com/jquery-1.11.2.min.js"></script>
    <script src="js/bootstrap.min.js"></script>
    <script src="js/progressbar/bootstrap-progressbar.min.js"></script>
    <script src="js/nicescroll/jquery.nicescroll.min.js"></script> 
    <script src="js/icheck/icheck.min.js"></script>
    <script src="js/custom.js"></script>
    <script type="text/javascript" src="js/VentanaCentrada.js"></script>
    <link rel="stylesheet" href="//code.jquery.com/ui/1.11.4/themes/smoothness/jquery-ui.css">
    <script src="//code.jquery.com/ui/1.11.4/jquery-ui.js"></script>

    <script>
        // --- FUNCIÓN PARA CONTAR ÍTEMS FÍSICAMENTE ---
        function recontar_items() {
            var n = $(".id_producto_lista").length;
            $("#item_count_val").text(n);
        }

        $(document).ready(function(){
            // Carga inicial y conteo
            $("#resultados").load("./ajax/agregar_facturacion_convert.php", function() {
                recontar_items();
            });
            
            $('#myModalCliente').on('shown.bs.modal', function () { $('#q_cliente').focus(); load_clientes(1); });
            $('#myModalProductosConvert').on('shown.bs.modal', function () { $('#q_producto').focus(); load_productos(1); });
            
            $("#nombre_cliente").autocomplete({
                source: "./ajax/autocomplete/clientes_convert.php",
                minLength: 2,
                select: function(event, ui) {
                    event.preventDefault();
                    $('#id_cliente').val(ui.item.id_cliente);
                    $('#nombre_cliente').val(ui.item.nombre_cliente);
                    $('#tel1').val(ui.item.telefono_cliente);
                    $('#doc1').val(ui.item.documento);
                    $('#direccion_cliente').val(ui.item.direccion_cliente);
                }
            });
        });

        function showToast(type, title, message) {
            var icon = type === 'success' ? '<i class="fa fa-check-circle"></i>' : '<i class="fa fa-shield"></i>';
            var toastClass = type === 'success' ? 'toast-success' : 'toast-error';
            var html = `<div class="toast-sc ${toastClass}"><div class="toast-icon">${icon}</div><div class="toast-content"><h4>${title}</h4><p>${message}</p></div></div>`;
            var $toast = $(html);
            $('#toast-container').append($toast);
            setTimeout(function() { $toast.css('animation', 'fadeOut 0.5s forwards'); setTimeout(function() { $toast.remove(); }, 500); }, 3000);
        }

        function agregar(id){
            var precio_venta = $('#precio_venta_'+id).val();
            var cantidad = $('#cantidad_'+id).val();
            
            if (isNaN(cantidad)){ showToast('error', 'Error', 'Cantidad inválida'); return false; }
            if (isNaN(precio_venta)){ showToast('error', 'Error', 'Precio inválido'); return false; }

            var duplicado = false;
            $(".id_producto_lista").each(function(){
                if($(this).val() == id){ duplicado = true; }
            });

            if(duplicado){
                showToast('error', 'Repetido', 'Este producto ya está en la lista.');
                return false;
            }

            var total_items = $(".id_producto_lista").length;
            if(total_items >= 40){
                showToast('error', 'Límite', 'Has alcanzado los 40 productos.');
                return false;
            }

            $.ajax({
                type: "POST",
                url: "./ajax/agregar_facturacion_convert.php",
                data: "id="+id+"&precio_venta="+precio_venta+"&cantidad="+cantidad,
                success: function(datos){ 
                    $("#resultados").html(datos); 
                    recontar_items(); // Recuento vivo
                    showToast('success', 'Agregado', 'Producto añadido correctamente');
                }
            });
        }

        function actualizar_cantidad(id_tmp, cantidad){
            if (isNaN(cantidad) || cantidad <= 0){ showToast('error','Error','Cantidad inválida'); return; }
            $.ajax({
                type: "POST",
                url: "./ajax/agregar_facturacion_convert.php",
                data: "id_tmp="+id_tmp+"&cantidad_update="+cantidad,
                success: function(datos){ 
                    $("#resultados").html(datos); 
                }
            });
        }

        function actualizar_precio(id_tmp, precio){
            if (isNaN(precio)){ showToast('error','Error','Precio inválido'); return; }
            $.ajax({
                type: "POST",
                url: "./ajax/agregar_facturacion_convert.php",
                data: "id_tmp="+id_tmp+"&precio_update="+precio,
                success: function(datos){ 
                    $("#resultados").html(datos); 
                }
            });
        }

        function eliminar(id){
            $.ajax({
                type: "GET",
                url: "./ajax/agregar_facturacion_convert.php",
                data: "id="+id,
                success: function(datos){ 
                    $("#resultados").html(datos); 
                    recontar_items(); // Recuento vivo
                }
            });
        }

        function load_clientes(page){
            var q= $("#q_cliente").val();
            var tipo= $("#tipo_busqueda_cliente").val();
            $.ajax({
                url:'./ajax/buscar_clientes_convert.php?action=ajax&page='+page+'&q='+q+'&tipo='+tipo,
                beforeSend: function(objeto){ $('#loader_clientes').html('Cargando...'); },
                success:function(data){ $(".outer_div_clientes").html(data); $('#loader_clientes').html(''); }
            })
        }

        function load_productos(page){
            var q= $("#q_producto").val();
            $.ajax({
                url:'./ajax/buscar_productos_convert.php?action=ajax&page='+page+'&q='+q,
                beforeSend: function(objeto){ $('#loader_productos').show(); },
                success:function(data){ $(".outer_div_productos").html(data); $('#loader_productos').hide(); }
            })
        }

        function agregar_cliente(id, nombre, documento, direccion, telefono) {
            $("#id_cliente").val(id);
            $("#nombre_cliente").val(nombre);
            $("#doc1").val(documento);
            $("#tel1").val(telefono);
            $("#direccion_cliente").val(direccion);
            $('#myModalCliente').modal('hide');
        }

        function actualizar_correlativo() {
            var tipo = $("#tip_doc").val();
            if(tipo == 1) { $("#folio").val($("#serie_factura_db").val()); $("#factura").val($("#num_factura_db").val()); } 
            else if(tipo == 2) { $("#folio").val($("#serie_boleta_db").val()); $("#factura").val($("#num_boleta_db").val()); }
        }
        
        $("#datos_factura").submit(function(e){
            e.preventDefault();
            var id_cliente = $("#id_cliente").val();
            var id_vendedor = "<?php echo isset($id_vendedor_db) ? $id_vendedor_db : $_SESSION['user_id']; ?>";
            var factura = $("#factura").val();
            var fecha = $("#fecha").val();
            var hora = $("#hora").val();
            var moneda = $("#moneda").val();
            var tcp = $("#tcp").val();
            var folio = $("#folio").val();
            var folio1 = $("#folio1").val();
            var num_fac = $("#num_fac").val();
            var nro_doc = $("#nro_doc").val();
            var nombre_cliente = $("#nombre_cliente").val();
            var doc1 = $("#doc1").val();
            var tip_doc = $("#tip_doc").val();
            var tel1 = $("#tel1").val();
            var mail = ""; 
            var direccion = $("#direccion_cliente").val();
            
            if(id_cliente == "") { alert("Debe seleccionar un cliente"); return false; }

            // Abrimos PDF
            VentanaCentrada('./pdf/documentos/factura_pdf3.php?id_cliente='+id_cliente+'&id_vendedor='+id_vendedor+'&factura='+factura+'&fecha='+fecha+'&hora='+hora+'&moneda='+moneda+'&tcp='+tcp+'&folio='+folio+'&nro_doc='+nro_doc+'&nombre_cliente='+nombre_cliente+'&doc1='+doc1+'&tip_doc='+tip_doc+'&tel1='+tel1+'&mail='+mail+'&direccion='+direccion+'&folio1='+folio1+'&num_fac='+num_fac,'Factura','','1024','768','true');
        
            // Redirección inmediata a la lista principal (Limpia la búsqueda)
            setTimeout(function(){
                window.location.href = 'cotizacion.php'; 
            }, 1500);
        });
    </script>
</body>
</html>