<?php
session_start();
include('menu.php');
require_once ("config/db.php");
require_once ("config/conexion.php");

if (!isset($_SESSION['user_login_status']) AND $_SESSION['user_login_status'] != 1) { header("location: login.php"); exit; }

$sql1="select * from users where user_id='".$_SESSION['user_id']."'";
$rw1=mysqli_query($con,$sql1);
$rs1=mysqli_fetch_array($rw1);
$modulo=$rs1["accesos"];
$a = explode(".", $modulo); 
if($a[17]==0){ header("location:error.php"); exit; }
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Nueva Entrada | SoundCrow</title>
    <link rel="icon" href="logo.ico">
    <link href="css/bootstrap.min.css" rel="stylesheet">
    <link href="fonts/css/font-awesome.min.css" rel="stylesheet">
    <link href="css/custom.min.css" rel="stylesheet">
    <link href="css/select/select2.min.css" rel="stylesheet">
    <link rel="stylesheet" href="//code.jquery.com/ui/1.11.4/themes/smoothness/jquery-ui.css">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">

    <style>
        body { font-family: 'Poppins', sans-serif !important; background-color: #F0F2F5; color: #334155; }
        .sc-card { background: #ffffff; border-radius: 12px; box-shadow: 0 4px 20px rgba(0,0,0,0.05); border: none; overflow: hidden; margin-bottom: 30px; }
        .sc-header { background: linear-gradient(90deg, #0a2463 0%, #2473f2 100%); padding: 20px 30px; color: white; display: flex; align-items: center; justify-content: space-between; }
        .sc-title { margin: 0; font-size: 18px; font-weight: 700; text-transform: uppercase; color: white; }
        .sc-body { padding: 30px; }
        
        .form-control-sc { border-radius: 8px; border: 1px solid #e2e8f0; padding: 10px; height: 40px; background-color: #f8fafc; width: 100%; transition: 0.3s; }
        .form-control-sc:focus { background-color: #fff; border-color: #2473f2; outline: none; }
        
        .stock-display {
            background: #dcfce7; padding: 10px; border-radius: 8px; text-align: center;
            font-weight: 700; color: #166534; margin-top: 5px; font-size: 16px; border: 1px solid #bbf7d0;
        }

        .ui-autocomplete {
            max-height: 200px; overflow-y: auto; overflow-x: hidden; z-index: 9999 !important;
            border-radius: 0 0 8px 8px; box-shadow: 0 4px 10px rgba(0,0,0,0.1);
        }
        
        .label-price { font-size: 11px; font-weight: 700; color: #0a2463; text-transform: uppercase; }
    </style>
</head>

<body class="nav-md">
    <div class="container body">
        <div class="main_container">
            <div class="col-md-3 left_col"><div class="left_col scroll-view"><div class="clearfix"></div><?php menu2(); menu1(); ?></div></div>
            <?php menu3(); ?>

            <div class="right_col" role="main">
                <div class="row">
                    <div class="col-md-8 col-md-offset-2">
                        <div class="sc-card">
                            <div class="sc-header">
                                <h3 class="sc-title"><i class="fa fa-arrow-circle-down"></i> Registrar Entrada de Stock</h3>
                            </div>
                            <div class="sc-body">
                                <form id="guardar_entrada" name="guardar_entrada" method="post">
                                    <div id="resultados_ajax"></div>
                                    
                                    <div class="row form-group">
                                        <div class="col-md-12">
                                            <label>Buscar Producto</label>
                                            <input type="text" class="form-control-sc" id="nombre_producto" placeholder="Escribe para buscar el producto..." required>
                                            <input type="hidden" id="id_producto" name="id_producto">
                                        </div>
                                    </div>

                                    <div class="row form-group" style="background: #f8fafc; padding: 15px; border-radius: 8px; border: 1px solid #e2e8f0; margin-bottom: 15px;">
                                        <div class="col-md-6">
                                            <label class="label-price">Costo Unitario (S/)</label>
                                            <input type="number" class="form-control-sc" name="precio_costo" id="precio_costo" step="0.01" placeholder="0.00" required>
                                            <small class="text-muted">Se usará para el Kardex.</small>
                                        </div>
                                        <div class="col-md-6">
                                            <label class="label-price">Precio Venta Público (S/)</label>
                                            <input type="number" class="form-control-sc" name="precio_venta" id="precio_venta" step="0.01" placeholder="0.00" required>
                                            <small class="text-muted">Actualizará el producto.</small>
                                        </div>
                                    </div>

                                    <div class="row form-group">
                                        <div class="col-md-6">
                                            <label>Destino (Ingresa a:)</label>
                                            <select class="form-control-sc" name="tienda" id="tienda" required onchange="actualizar_stock()">
                                                <option value="">Seleccionar Tienda</option>
                                                <?php
                                                $sql_s = "SELECT * FROM sucursal ORDER BY tienda ASC";
                                                $res_s = mysqli_query($con, $sql_s);
                                                while($row_s=mysqli_fetch_array($res_s)){
                                                    $nom = !empty($row_s['nombre_stand']) ? $row_s['nombre_stand'] : $row_s['nombre'];
                                                    echo "<option value='".$row_s['tienda']."'>$nom</option>";
                                                }
                                                ?>
                                            </select>
                                        </div>
                                        <div class="col-md-6">
                                            <label>Stock Actual</label>
                                            <div class="stock-display" id="stock_actual">---</div>
                                        </div>
                                    </div>

                                    <div class="row form-group">
                                        <div class="col-md-4">
                                            <label>Cantidad a Ingresar</label>
                                            <input type="number" class="form-control-sc" name="cantidad" id="cantidad" min="1" placeholder="0" required>
                                        </div>
                                        <div class="col-md-8">
                                            <label>Vincular Compra (Opcional)</label>
                                            <select class="form-control-sc select2" name="id_compra" id="id_compra">
                                                <option value="">-- Sin Vincular --</option>
                                                <?php
                                                $sql_compras = "SELECT f.id_factura, f.numero_factura, c.nombre_cliente, f.fecha_factura 
                                                                FROM facturas f, clientes c 
                                                                WHERE f.id_cliente=c.id_cliente AND f.ven_com=2 
                                                                ORDER BY f.id_factura DESC LIMIT 50";
                                                $rs_compras = mysqli_query($con, $sql_compras);
                                                while($rw_c = mysqli_fetch_array($rs_compras)){
                                                    $fecha_c = date("d/m", strtotime($rw_c['fecha_factura']));
                                                    echo "<option value='".$rw_c['id_factura']."'>Doc: ".$rw_c['numero_factura']." - ".$rw_c['nombre_cliente']." ($fecha_c)</option>";
                                                }
                                                ?>
                                            </select>
                                        </div>
                                    </div>
                                    
                                    <div class="row form-group">
                                        <div class="col-md-12">
                                            <label>Referencia / Motivo</label>
                                            <input type="text" class="form-control-sc" name="referencia" placeholder="Ej: Bonificación, Ajuste de inventario, etc.">
                                        </div>
                                    </div>

                                    <div class="row" style="margin-top:20px;">
                                        <div class="col-md-12 text-right">
                                            <a href="listado_entradas.php" class="btn btn-default" style="border-radius:20px;">Ver Historial</a>
                                            <button type="submit" class="btn btn-success" id="btn_guardar" style="border-radius:20px; padding: 8px 30px; background:#10b981; border-color:#10b981;">
                                                <i class="fa fa-save"></i> Guardar Entrada y Precios
                                            </button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="js/jquery.min.js"></script>
    <script src="js/bootstrap.min.js"></script>
    <script src="js/nicescroll/jquery.nicescroll.min.js"></script>
    <script src="js/custom.js"></script>
    <script src="//code.jquery.com/ui/1.11.4/jquery-ui.js"></script>
    <script src="js/select/select2.full.js"></script>

    <script>
        var stocks_producto = {};

        $(document).ready(function() {
            $(".select2").select2();

            $("#nombre_producto").autocomplete({
                source: "./ajax/autocomplete/productos1.php",
                minLength: 1,
                select: function(event, ui) {
                    event.preventDefault();
                    $('#id_producto').val(ui.item.id_producto);
                    $('#nombre_producto').val(ui.item.nombre_producto);
                    obtener_datos_producto(ui.item.id_producto);
                }
            });
        });

        function obtener_datos_producto(id_prod) {
            $.ajax({
                url: "ajax/obtener_stock_producto.php",
                type: "GET",
                dataType: "json",
                data: {id: id_prod},
                success: function(data){
                    stocks_producto = data;
                    actualizar_stock();
                    
                    // Llenar los precios automáticamente
                    $("#precio_venta").val(data.precio_venta);
                    
                    // Si el costo viene 0, ponemos el precio de venta como referencia o dejamos 0
                    if(data.costo > 0){
                        $("#precio_costo").val(data.costo);
                    } else {
                        $("#precio_costo").val(data.precio_venta); // Sugerencia visual
                    }
                }
            });
        }

        function actualizar_stock(){
            var tienda = $("#tienda").val();
            if(tienda && stocks_producto[tienda] !== undefined){
                $("#stock_actual").text(stocks_producto[tienda]);
            } else {
                $("#stock_actual").text("---");
            }
        }

        $("#guardar_entrada").submit(function(e) {
            e.preventDefault();
            
            $("#btn_guardar").attr("disabled", true);
            var parametros = $(this).serialize();
            
            $.ajax({
                type: "POST",
                url: "ajax/guardar_entrada.php",
                data: parametros,
                beforeSend: function(objeto){
                    $("#resultados_ajax").html("Procesando...");
                },
                success: function(datos){
                    $("#resultados_ajax").html(datos);
                    $("#btn_guardar").attr("disabled", false);
                    
                    if(datos.includes("alert-success")){
                        $("#cantidad").val("");
                        $("#nombre_producto").val("");
                        $("#id_producto").val("");
                        $("#stock_actual").text("---");
                        $("#precio_costo").val("");
                        $("#precio_venta").val("");
                        $("#id_compra").val("").trigger("change");
                        stocks_producto = {};
                    }
                }
            });
        });
    </script>
</body>
</html>