<?php
session_start();
include('menu.php');
require_once ("config/db.php");
require_once ("config/conexion.php");

if (!isset($_SESSION['user_login_status']) AND $_SESSION['user_login_status'] != 1) { header("location: login.php"); exit; }

$sql1="select * from users where user_id='".$_SESSION['user_id']."'";
$rw1=mysqli_query($con,$sql1);
$rs1=mysqli_fetch_array($rw1);
$modulo=$rs1["accesos"];
$a = explode(".", $modulo); 
if($a[15]==0){ header("location:error.php"); exit; }
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Nuevo Traslado | SoundCrow</title>
    <link rel="icon" href="logo.ico">
    <link href="css/bootstrap.min.css" rel="stylesheet">
    <link href="fonts/css/font-awesome.min.css" rel="stylesheet">
    <link href="css/custom.min.css" rel="stylesheet">
    <link href="css/select/select2.min.css" rel="stylesheet">
    <link rel="stylesheet" href="//code.jquery.com/ui/1.11.4/themes/smoothness/jquery-ui.css">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">

    <style>
        body { font-family: 'Poppins', sans-serif !important; background-color: #F0F2F5; color: #334155; }
        .sc-card { background: #ffffff; border-radius: 12px; box-shadow: 0 4px 20px rgba(0,0,0,0.05); border: none; overflow: hidden; margin-bottom: 30px; }
        .sc-header { background: linear-gradient(90deg, #0a2463 0%, #2473f2 100%); padding: 20px 30px; color: white; display: flex; align-items: center; justify-content: space-between; }
        .sc-title { margin: 0; font-size: 18px; font-weight: 700; text-transform: uppercase; color: white; }
        .sc-body { padding: 30px; }
        
        .form-control-sc { border-radius: 8px; border: 1px solid #e2e8f0; padding: 10px; height: 40px; background-color: #f8fafc; width: 100%; transition: 0.3s; }
        .form-control-sc:focus { background-color: #fff; border-color: #2473f2; outline: none; }
        
        .stock-display {
            background: #f1f5f9; padding: 10px; border-radius: 8px; text-align: center;
            font-weight: 700; color: #0a2463; margin-top: 5px; font-size: 16px;
        }

        /* --- ESTILO NUEVO PARA LIMITAR LA LISTA --- */
        .ui-autocomplete {
            max-height: 200px; /* Altura máxima de la lista */
            overflow-y: auto;  /* Activa el scroll vertical si pasa la altura */
            overflow-x: hidden; /* Oculta scroll horizontal */
            z-index: 9999 !important; /* Asegura que se vea encima de todo */
            border-radius: 0 0 8px 8px; /* Bordes redondeados abajo */
            box-shadow: 0 4px 10px rgba(0,0,0,0.1);
        }
        /* ------------------------------------------ */
    </style>
</head>

<body class="nav-md">
    <div class="container body">
        <div class="main_container">
            <div class="col-md-3 left_col"><div class="left_col scroll-view"><div class="clearfix"></div><?php menu2(); menu1(); ?></div></div>
            <?php menu3(); ?>

            <div class="right_col" role="main">
                <div class="row">
                    <div class="col-md-8 col-md-offset-2" style="padding-top: 15px;">
                        <div class="sc-card">
                            <div class="sc-header">
                                <h3 class="sc-title"><i class="fa fa-exchange"></i> Realizar Traslado Interno</h3>
                            </div>
                            <div class="sc-body">
                                <form id="guardar_traslado" name="guardar_traslado" method="post">
                                    <div id="resultados_ajax"></div>
                                    
                                    <div class="row form-group">
                                        <div class="col-md-12">
                                            <label>Buscar Producto</label>
                                            <input type="text" class="form-control-sc" id="nombre_producto" placeholder="Escribe para buscar el producto..." required>
                                            <input type="hidden" id="id_producto" name="id_producto">
                                        </div>
                                    </div>

                                    <div class="row form-group">
                                        <div class="col-md-6">
                                            <label>Origen (Sale de:)</label>
                                            <select class="form-control-sc" name="origen" id="origen" required onchange="actualizar_stock()">
                                                <option value="">Seleccionar Origen</option>
                                                <?php
                                                $sql_s = "SELECT * FROM sucursal ORDER BY tienda ASC";
                                                $res_s = mysqli_query($con, $sql_s);
                                                while($row_s=mysqli_fetch_array($res_s)){
                                                    $nom = !empty($row_s['nombre_stand']) ? $row_s['nombre_stand'] : $row_s['nombre'];
                                                    echo "<option value='".$row_s['tienda']."'>$nom</option>";
                                                }
                                                ?>
                                            </select>
                                        </div>
                                        <div class="col-md-6">
                                            <label>Stock Actual en Origen</label>
                                            <div class="stock-display" id="stock_actual">---</div>
                                            <input type="hidden" id="stock_oculto">
                                        </div>
                                    </div>

                                    <div class="row form-group">
                                        <div class="col-md-6">
                                            <label>Destino (Entra a:)</label>
                                            <select class="form-control-sc" name="destino" id="destino" required>
                                                <option value="">Seleccionar Destino</option>
                                                <?php
                                                $res_s = mysqli_query($con, "SELECT * FROM sucursal ORDER BY tienda ASC");
                                                while($row_s=mysqli_fetch_array($res_s)){
                                                    $nom = !empty($row_s['nombre_stand']) ? $row_s['nombre_stand'] : $row_s['nombre'];
                                                    echo "<option value='".$row_s['tienda']."'>$nom</option>";
                                                }
                                                ?>
                                            </select>
                                        </div>
                                        <div class="col-md-6">
                                            <label>Cantidad a Mover</label>
                                            <input type="number" class="form-control-sc" name="cantidad" id="cantidad" min="1" placeholder="0" required>
                                        </div>
                                    </div>
                                    
                                    <div class="row form-group">
                                        <div class="col-md-12">
                                            <label>Referencia / Motivo (Opcional)</label>
                                            <input type="text" class="form-control-sc" name="referencia" placeholder="Ej: Reposición de stock">
                                        </div>
                                    </div>

                                    <div class="row" style="margin-top:20px;">
                                        <div class="col-md-12 text-right">
                                            <a href="listado_traslados.php" class="btn btn-default" style="border-radius:20px;">Ver Historial</a>
                                            <button type="submit" class="btn btn-primary" id="btn_guardar" style="border-radius:20px; padding: 8px 30px;">
                                                <i class="fa fa-paper-plane"></i> Procesar Traslado
                                            </button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="js/jquery.min.js"></script>
    <script src="js/bootstrap.min.js"></script>
    
    <script src="js/nicescroll/jquery.nicescroll.min.js"></script>
    
    <script src="js/custom.js"></script>
    <script src="//code.jquery.com/ui/1.11.4/jquery-ui.js"></script>
    <script src="js/select/select2.full.js"></script>

    <script>
        var stocks_producto = {};

        $(document).ready(function() {
            $("#nombre_producto").autocomplete({
                source: "./ajax/autocomplete/productos1.php",
                minLength: 1,
                select: function(event, ui) {
                    event.preventDefault();
                    $('#id_producto').val(ui.item.id_producto);
                    $('#nombre_producto').val(ui.item.nombre_producto);
                    obtener_stock_real(ui.item.id_producto);
                }
            });
        });

        function obtener_stock_real(id_prod) {
            $.ajax({
                url: "ajax/obtener_stock_producto.php",
                type: "GET",
                dataType: "json",
                data: {id: id_prod},
                success: function(data){
                    stocks_producto = data;
                    actualizar_stock();
                }
            });
        }

        function actualizar_stock(){
            var origen = $("#origen").val();
            if(origen && stocks_producto[origen] !== undefined){
                $("#stock_actual").text(stocks_producto[origen]);
                $("#stock_oculto").val(stocks_producto[origen]);
            } else {
                $("#stock_actual").text("---");
                $("#stock_oculto").val(0);
            }
        }

        $("#guardar_traslado").submit(function(e) {
            e.preventDefault();
            
            var origen = $("#origen").val();
            var destino = $("#destino").val();
            var stock = parseFloat($("#stock_oculto").val());
            var cantidad = parseFloat($("#cantidad").val());

            if(origen == destino){
                alert("El origen y destino no pueden ser iguales.");
                return false;
            }
            if(cantidad > stock){
                alert("No hay suficiente stock en la tienda de origen.");
                return false;
            }

            $("#btn_guardar").attr("disabled", true);
            var parametros = $(this).serialize();
            
            $.ajax({
                type: "POST",
                url: "ajax/guardar_traslado.php",
                data: parametros,
                beforeSend: function(objeto){
                    $("#resultados_ajax").html("Procesando...");
                },
                success: function(datos){
                    $("#resultados_ajax").html(datos);
                    $("#btn_guardar").attr("disabled", false);
                    
                    if(datos.includes("alert-success")){
                        $("#cantidad").val("");
                        $("#nombre_producto").val("");
                        $("#id_producto").val("");
                        $("#stock_actual").text("---");
                        stocks_producto = {};
                    }
                }
            });
        });
    </script>
</body>
</html>