<?php
session_start();
if (!isset($_SESSION['user_login_status']) || $_SESSION['user_login_status'] != 1) { 
    header("location: login.php"); 
    exit; 
}

require_once ("config/db.php");
require_once ("config/conexion.php");

// LÓGICA DE PERMISOS DEL SISTEMA (ACCESOS)
   $sql1="select * from users where user_id=$_SESSION[user_id]";
    $rw1=mysqli_query($con,$sql1);
    $rs1=mysqli_fetch_array($rw1);
    $modulo=$rs1["accesos"];
    $a = explode(".", $modulo); 
    
    if($a[28]==0){ header("location:error.php"); }

include('menu.php');
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Pagos a Trabajadores | SoundCrow</title>
    
    <link rel="icon" href="logo.ico">
    <link href="css/bootstrap.min.css" rel="stylesheet">
    <link href="fonts/css/font-awesome.min.css" rel="stylesheet">
    <link href="css/custom.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">

    <style>
        body { font-family: 'Poppins', sans-serif !important; background-color: #F0F2F5; color: #334155; }
        .sc-card { background: #ffffff; border-radius: 12px; box-shadow: 0 4px 20px rgba(0,0,0,0.05); border: none; overflow: hidden; margin-bottom: 30px; }
        .sc-header { background: linear-gradient(90deg, #0a2463 0%, #2473f2 100%); padding: 20px 30px; color: white; display: flex; align-items: center; justify-content: space-between; }
        .sc-title { margin: 0; font-size: 18px; font-weight: 700; text-transform: uppercase; letter-spacing: 0.5px; color: white; }
        .sc-body { padding: 25px; }
        
        .form-control-sc { border-radius: 8px; border: 1px solid #e2e8f0; padding: 10px 15px; height: 45px; background-color: #f8fafc; width: 100%; transition: 0.3s; color: #334155; font-weight: 500; }
        .form-control-sc:focus { background-color: #fff; border-color: #2473f2; box-shadow: 0 0 0 3px rgba(36, 115, 242, 0.1); outline: none; }
        .form-label-sc { font-weight: 600; color: #64748b; font-size: 12px; text-transform: uppercase; margin-bottom: 8px; display: block; }

        .btn-action { background: #10b981; color: white; border-radius: 8px; padding: 12px 20px; border: none; font-weight: 700; transition: all 0.3s; }
        .btn-action:hover { background: #059669; transform: translateY(-2px); color: white; }
        .btn-print { background: #f59e0b; color: white; border: none; border-radius: 5px; padding: 5px 12px; font-weight: bold; transition: 0.3s; }
        .btn-print:hover { background: #d97706; }
    </style>
</head>

<body class="nav-md">
    <div class="container body">
        <div class="main_container">
            <div class="col-md-3 left_col">
                <div class="left_col scroll-view">
                    <div class="clearfix"></div>
                    <?php menu2(); menu1(); ?>
                </div>
            </div>
            <?php menu3(); ?>

            <div class="right_col" role="main" style="background-color: #F0F2F5;">
                
                <div class="modal fade" id="nuevoPago" tabindex="-1" role="dialog">
                    <div class="modal-dialog" role="document">
                        <div class="modal-content sc-card">
                            <div class="sc-header" style="background: linear-gradient(90deg, #10b981 0%, #059669 100%);">
                                <h4 class="sc-title"><i class="fa fa-money"></i> Registrar Nuevo Pago</h4>
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close" style="color:white; opacity:1;">&times;</button>
                            </div>
                            <div class="sc-body">
                                <form id="guardar_pago" method="POST">
                                    <div class="form-group" style="margin-bottom: 20px;">
                                        <label class="form-label-sc">Trabajador</label>
                                        <select class="form-control-sc" name="id_trabajador" id="id_trabajador" required>
                                            <option value="">-- Selecciona --</option>
                                            <?php
                                            // SE CORRIGIÓ AQUÍ (Quitamos apellidos)
                                            $q_users = mysqli_query($con, "SELECT user_id, nombres FROM users ORDER BY nombres ASC");
                                            while($rw = mysqli_fetch_array($q_users)){
                                                echo "<option value='".$rw['user_id']."'>".$rw['nombres']."</option>";
                                            }
                                            ?>
                                        </select>
                                    </div>
                                    <div class="form-group" style="margin-bottom: 20px;">
                                        <label class="form-label-sc">Monto (S/)</label>
                                        <input type="number" step="0.01" class="form-control-sc" name="monto" id="monto" placeholder="Ej. 500.00" required>
                                    </div>
                                    <div class="form-group" style="margin-bottom: 25px;">
                                        <label class="form-label-sc">Concepto o Descripción</label>
                                        <input type="text" class="form-control-sc" name="concepto" id="concepto" placeholder="Ej. Adelanto de sueldo, Quincena, Bono..." required>
                                    </div>
                                    <div id="resultados_ajax"></div>
                                    <div class="text-right">
                                        <button type="submit" class="btn-action" id="btn_guardar"><i class="fa fa-save"></i> Guardar y Generar Recibo</button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12" style="padding-top: 15px;">
                        
                        <div class="sc-card">
                            <div class="sc-header">
                                <h3 class="sc-title"><i class="fa fa-users"></i> Historial de Pagos a Trabajadores</h3>
                                <button type="button" class="btn btn-default" data-toggle="modal" data-target="#nuevoPago" style="border-radius: 30px; font-weight:bold; border:none; color:#0a2463;">
                                    <i class="fa fa-plus"></i> Nuevo Pago
                                </button>
                            </div>
                            
                            <div class="sc-body">
                                <form class="form-horizontal" role="form" id="datos_cotizacion" style="margin-bottom: 20px;">
                                    <div class="row">
                                        <div class="col-md-4">
                                            <input type="text" class="form-control-sc" id="q" placeholder="Buscar por nombre de trabajador..." onkeyup='load(1);'>
                                        </div>
                                        <div class="col-md-3">
                                            <button type="button" class="btn btn-default" onclick='load(1);' style="height: 45px; border-radius: 8px; border: 1px solid #e2e8f0;"><i class='fa fa-search'></i> Buscar</button>
                                            <span id="loader"></span>
                                        </div>
                                    </div>
                                </form>
                                <div id="resultados"></div></div>
                        </div>

                    </div>
                </div>
            </div>
            <?php footer(); ?>
        </div>
    </div>

<script src="js/jquery.min.js"></script>
    <script src="js/bootstrap.min.js"></script>
    <script src="js/nicescroll/jquery.nicescroll.min.js"></script>
    <script src="js/custom.js"></script>

    <script>
        $(document).ready(function(){
            load(1);
        });

        function load(page){
            var q = $("#q").val();
            $("#loader").fadeIn('fast');
            $.ajax({
                url:'./ajax/buscar_pagos_trabajador.php?action=ajax&page='+page+'&q='+q,
                success: function(data){
                    $("#resultados").html(data).fadeIn('fast');
                    $("#loader").fadeOut('fast');
                }
            })
        }

        // Enviar formulario de pago
        $( "#guardar_pago" ).submit(function( event ) {
            $('#btn_guardar').attr("disabled", true);
            var parametros = $(this).serialize();
            $.ajax({
                type: "POST",
                url: "ajax/nuevo_pago_trabajador.php",
                data: parametros,
                beforeSend: function(objeto){
                    $("#resultados_ajax").html("Enviando...");
                },
                success: function(datos){
                    $("#resultados_ajax").html(datos);
                    $('#btn_guardar').attr("disabled", false);
                    load(1);
                    $('#monto').val('');
                    $('#concepto').val('');
                }
            });
            event.preventDefault();
        });

        function imprimir_recibo(id_pago){
            window.open('tick_trabajador.php?id='+id_pago, '_blank');
        }
    </script>
</body>
</html>