<?php
// Sin session_start() para permitir acceso pblico desde la consulta
include("../../config/db.php");
include("../../config/conexion.php");
include("funciones.php");
require_once(dirname(__FILE__).'/../html2pdf.class.php');

$id_factura = intval($_GET['id_factura']);
$tipo = intval($_GET['tipo']);

// 1. Obtener datos de la factura
$sql_factura = mysqli_query($con, "SELECT * FROM facturas WHERE id_factura='$id_factura'");
$rw_factura = mysqli_fetch_array($sql_factura);
$numero_factura = $rw_factura['numero_factura'];
$folio = $rw_factura['folio'];
$id_cliente = $rw_factura['id_cliente'];
$tienda = $rw_factura['tienda'];

// 2. Obtener datos de la empresa y sucursal
$sql_sucursal = mysqli_query($con, "SELECT * FROM sucursal WHERE tienda='$tienda'");
$rw_sucursal = mysqli_fetch_array($sql_sucursal);

// 3. Obtener datos del cliente
$sql_cliente = mysqli_query($con, "SELECT * FROM clientes WHERE id_cliente='$id_cliente'");
$rw_cliente = mysqli_fetch_array($sql_cliente);

// Iniciar captura de HTML para el PDF A4
ob_start();
?>
<style>
    table { width: 100%; border-collapse: collapse; font-family: Arial, sans-serif; }
    .header { background: #f1f5f9; padding: 20px; border-bottom: 2px solid #0a2463; }
    .box { border: 1px solid #e2e8f0; padding: 15px; border-radius: 10px; margin-top: 20px; }
    th { background: #0a2463; color: white; padding: 10px; font-size: 12px; }
    td { padding: 10px; border-bottom: 1px solid #f1f5f9; font-size: 11px; }
</style>

<page backtop="10mm" backbottom="10mm" backleft="10mm" backright="10mm">
    <div class="header">
        <table style="width: 100%;">
            <tr>
                <td style="width: 50%; border:none;">
                    <span style="font-size: 20px; font-weight: bold; color: #0a2463;"><?php echo $rw_sucursal['nombre']; ?></span><br>
                    RUC: <?php echo $rw_sucursal['ruc']; ?><br>
                    <?php echo $rw_sucursal['direccion']; ?>
                </td>
                <td style="width: 50%; text-align: right; border:none;">
                    <div style="border: 2px solid #0a2463; padding: 10px; border-radius: 10px;">
                        <span style="font-size: 14px; font-weight: bold;">COMPROBANTE ELECTR07NICO</span><br>
                        <span style="font-size: 18px;"><?php echo $folio; ?>-<?php echo str_pad($numero_factura, 8, "0", STR_PAD_LEFT); ?></span>
                    </div>
                </td>
            </tr>
        </table>
    </div>

    <div class="box">
        <table style="width: 100%;">
            <tr>
                <td style="width: 100%; border:none;">
                    <strong>CLIENTE:</strong> <?php echo $rw_cliente['nombre_cliente']; ?><br>
                    <strong>RUC/DNI:</strong> <?php echo ($rw_cliente['doc'] != '0') ? $rw_cliente['doc'] : $rw_cliente['dni']; ?><br>
                    <strong>DIRECCI07N:</strong> <?php echo $rw_cliente['direccion_cliente']; ?>
                </td>
            </tr>
        </table>
    </div>

    <table style="margin-top: 30px;">
        <thead>
            <tr>
                <th style="width: 10%;">CANT.</th>
                <th style="width: 60%;">DESCRIPCI07N</th>
                <th style="width: 15%;">PRECIO UNIT.</th>
                <th style="width: 15%;">TOTAL</th>
            </tr>
        </thead>
        <tbody>
            <?php
            $sql_detalle = mysqli_query($con, "SELECT * FROM detalle_factura WHERE numero_factura='$numero_factura' AND folio='$folio'");
            while ($row = mysqli_fetch_array($sql_detalle)) {
                $id_pro = $row['id_producto'];
                // Obtener nombre del producto
                $q_p = mysqli_query($con, "SELECT nombre_producto FROM products WHERE id_producto='$id_pro'");
                $r_p = mysqli_fetch_array($q_p);
            ?>
            <tr>
                <td style="text-align:center;"><?php echo $row['cantidad']; ?></td>
                <td><?php echo $r_p['nombre_producto']; ?></td>
                <td style="text-align:right;"><?php echo number_format($row['precio_venta'], 2); ?></td>
                <td style="text-align:right;"><?php echo number_format($row['cantidad'] * $row['precio_venta'], 2); ?></td>
            </tr>
            <?php } ?>
        </tbody>
    </table>

    <div style="margin-top: 30px; text-align: right;">
        <span style="font-size: 16px; font-weight: bold;">TOTAL: S/ <?php echo number_format($rw_factura['total_venta'], 2); ?></span>
    </div>
</page>

<?php
$content = ob_get_clean();
try {
    // Generar PDF en formato A4
    $html2pdf = new HTML2PDF('P', 'A4', 'es', true, 'UTF-8', array(0, 0, 0, 0));
    $html2pdf->pdf->SetDisplayMode('fullpage');
    $html2pdf->writeHTML($content);
    $html2pdf->Output('Comprobante_'.$folio.'_'.$numero_factura.'.pdf');
} catch (HTML2PDF_exception $e) { echo $e; exit; }
?>